/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.AppSearchBatchResult;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.OpenBlobForWriteResponseCreator;
import android.app.appsearch.aidl.AppSearchBatchResultParcelV2;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

@FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
@SafeParcelable.Class(creator="OpenBlobForWriteResponseCreator")
public class OpenBlobForWriteResponse
extends AbstractSafeParcelable
implements Closeable {
    @NonNull
    public static final Parcelable.Creator<OpenBlobForWriteResponse> CREATOR = new OpenBlobForWriteResponseCreator();
    @SafeParcelable.Field(id=1)
    final AppSearchBatchResultParcelV2<AppSearchBlobHandle, ParcelFileDescriptor> mResultParcel;

    public OpenBlobForWriteResponse(@NonNull AppSearchBatchResult<AppSearchBlobHandle, ParcelFileDescriptor> result) {
        this(AppSearchBatchResultParcelV2.fromBlobHandleToPfd(result));
    }

    @SafeParcelable.Constructor
    OpenBlobForWriteResponse(@SafeParcelable.Param(id=1) @NonNull AppSearchBatchResultParcelV2<AppSearchBlobHandle, ParcelFileDescriptor> resultParcel) {
        this.mResultParcel = Objects.requireNonNull(resultParcel);
    }

    @NonNull
    public AppSearchBatchResult<AppSearchBlobHandle, ParcelFileDescriptor> getResult() {
        return this.mResultParcel.getResult();
    }

    @Override
    public void close() {
        AppSearchBatchResult<AppSearchBlobHandle, ParcelFileDescriptor> batchResult = this.mResultParcel.getResult();
        for (ParcelFileDescriptor pfd : batchResult.getSuccesses().values()) {
            try {
                pfd.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        OpenBlobForWriteResponseCreator.writeToParcel(this, dest, flags);
    }
}

