/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.GetByDocumentIdRequestCreator;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="GetByDocumentIdRequestCreator")
public class GetByDocumentIdRequest
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<GetByDocumentIdRequest> CREATOR = new GetByDocumentIdRequestCreator();
    public static final String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";
    @SafeParcelable.Field(id=1, getter="getNamespace")
    @NonNull
    private final String mNamespace;
    @SafeParcelable.Field(id=2)
    @NonNull
    final List<String> mIds;
    @SafeParcelable.Field(id=3)
    @NonNull
    final Bundle mTypePropertyPaths;
    @Nullable
    private Set<String> mIdsCached;

    @SafeParcelable.Constructor
    GetByDocumentIdRequest(@SafeParcelable.Param(id=1) @NonNull String namespace, @SafeParcelable.Param(id=2) @NonNull List<String> ids, @SafeParcelable.Param(id=3) @NonNull Bundle typePropertyPaths) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mIds = Objects.requireNonNull(ids);
        this.mTypePropertyPaths = Objects.requireNonNull(typePropertyPaths);
    }

    @NonNull
    public String getNamespace() {
        return this.mNamespace;
    }

    @NonNull
    public Set<String> getIds() {
        if (this.mIdsCached == null) {
            this.mIdsCached = Collections.unmodifiableSet(new ArraySet<String>(this.mIds));
        }
        return this.mIdsCached;
    }

    @NonNull
    public Map<String, List<String>> getProjections() {
        Set<String> schemas = this.mTypePropertyPaths.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            ArrayList<String> propertyPaths = this.mTypePropertyPaths.getStringArrayList(schema);
            if (propertyPaths == null) continue;
            typePropertyPathsMap.put(schema, Collections.unmodifiableList(propertyPaths));
        }
        return typePropertyPathsMap;
    }

    @NonNull
    public Map<String, List<PropertyPath>> getProjectionPaths() {
        Set<String> schemas = this.mTypePropertyPaths.keySet();
        ArrayMap<String, List<PropertyPath>> typePropertyPathsMap = new ArrayMap<String, List<PropertyPath>>(schemas.size());
        for (String schema : schemas) {
            ArrayList<String> paths = this.mTypePropertyPaths.getStringArrayList(schema);
            if (paths == null) continue;
            int pathsSize = paths.size();
            ArrayList<PropertyPath> propertyPathList = new ArrayList<PropertyPath>(pathsSize);
            for (int i = 0; i < pathsSize; ++i) {
                propertyPathList.add(new PropertyPath((String)paths.get(i)));
            }
            typePropertyPathsMap.put(schema, Collections.unmodifiableList(propertyPathList));
        }
        return typePropertyPathsMap;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        GetByDocumentIdRequestCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private final String mNamespace;
        private List<String> mIds = new ArrayList<String>();
        private Bundle mProjectionTypePropertyPaths = new Bundle();
        private boolean mBuilt = false;

        public Builder(@NonNull String namespace) {
            this.mNamespace = Objects.requireNonNull(namespace);
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIds(String ... ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            return this.addIds(Arrays.asList(ids));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIds(@NonNull Collection<String> ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            this.mIds.addAll(ids);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addProjection(@NonNull String schemaType, @NonNull Collection<String> propertyPaths) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsList.add(propertyPath);
            }
            this.mProjectionTypePropertyPaths.putStringArrayList(schemaType, propertyPathsList);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addProjectionPaths(@NonNull String schemaType, @NonNull Collection<PropertyPath> propertyPaths) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(propertyPaths);
            ArrayList<String> propertyPathsList = new ArrayList<String>(propertyPaths.size());
            for (PropertyPath propertyPath : propertyPaths) {
                propertyPathsList.add(propertyPath.toString());
            }
            return this.addProjection(schemaType, propertyPathsList);
        }

        @NonNull
        public GetByDocumentIdRequest build() {
            this.mBuilt = true;
            return new GetByDocumentIdRequest(this.mNamespace, this.mIds, this.mProjectionTypePropertyPaths);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mIds = new ArrayList<String>(this.mIds);
                this.mProjectionTypePropertyPaths = BundleUtil.deepCopy(this.mProjectionTypePropertyPaths);
                this.mBuilt = false;
            }
        }
    }
}

