/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.EmbeddingVector;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.safeparcel.PropertyParcel;
import android.app.appsearch.util.IndentingStringBuilder;
import android.os.Parcel;
import android.os._Original_Build;
import android.util.Log;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GenericDocument {
    private static final String TAG = "AppSearchGenericDocumen";
    private static final int MAX_INDEXED_PROPERTIES = 16;
    public static final String PARENT_TYPES_SYNTHETIC_PROPERTY = "$$__AppSearch__parentTypes";
    public static final GenericDocument EMPTY = new Builder("", "", "").build();
    private final GenericDocumentParcel mDocumentParcel;

    public static int getMaxIndexedProperties() {
        return 16;
    }

    public GenericDocument(@NonNull GenericDocumentParcel documentParcel) {
        this.mDocumentParcel = Objects.requireNonNull(documentParcel);
    }

    protected GenericDocument(@NonNull GenericDocument document) {
        this(document.mDocumentParcel);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_over_ipc")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeParcelable(this.mDocumentParcel, flags);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_over_ipc")
    @NonNull
    public static GenericDocument createFromParcel(@NonNull Parcel parcel) {
        Objects.requireNonNull(parcel);
        GenericDocumentParcel documentParcel = _Original_Build.VERSION.SDK_INT >= 34 ? parcel.readParcelable(GenericDocumentParcel.class.getClassLoader(), GenericDocumentParcel.class) : (GenericDocumentParcel)parcel.readParcelable(GenericDocumentParcel.class.getClassLoader());
        return new GenericDocument(documentParcel);
    }

    @NonNull
    public GenericDocumentParcel getDocumentParcel() {
        return this.mDocumentParcel;
    }

    @NonNull
    public String getId() {
        return this.mDocumentParcel.getId();
    }

    @NonNull
    public String getNamespace() {
        return this.mDocumentParcel.getNamespace();
    }

    @NonNull
    public String getSchemaType() {
        return this.mDocumentParcel.getSchemaType();
    }

    @Deprecated
    @Nullable
    public List<String> getParentTypes() {
        List<String> result = this.mDocumentParcel.getParentTypes();
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableList(result);
    }

    public long getCreationTimestampMillis() {
        return this.mDocumentParcel.getCreationTimestampMillis();
    }

    public long getTtlMillis() {
        return this.mDocumentParcel.getTtlMillis();
    }

    public int getScore() {
        return this.mDocumentParcel.getScore();
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.mDocumentParcel.getPropertyNames());
    }

    @Nullable
    public Object getProperty(@NonNull String path) {
        Objects.requireNonNull(path);
        Object rawValue = GenericDocument.getRawPropertyFromRawDocument(new PropertyPath(path), 0, this.mDocumentParcel.getPropertyMap());
        if (rawValue instanceof GenericDocumentParcel) {
            GenericDocument document = new GenericDocument((GenericDocumentParcel)rawValue);
            return new GenericDocument[]{document};
        }
        if (rawValue instanceof GenericDocumentParcel[]) {
            GenericDocumentParcel[] docParcels = (GenericDocumentParcel[])rawValue;
            GenericDocument[] documents = new GenericDocument[docParcels.length];
            for (int i = 0; i < docParcels.length; ++i) {
                if (docParcels[i] == null) {
                    Log.e(TAG, "The inner parcel is null at " + i + ", for path: " + path);
                    continue;
                }
                documents[i] = new GenericDocument(docParcels[i]);
            }
            return documents;
        }
        return rawValue;
    }

    @Nullable
    private static Object getRawPropertyFromRawDocument(@NonNull PropertyPath path, int pathIndex, @NonNull Map<String, PropertyParcel> propertyMap) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(propertyMap);
        for (int i = pathIndex; i < path.size(); ++i) {
            PropertyPath.PathSegment segment = path.get(i);
            Object currentElementValue = propertyMap.get(segment.getPropertyName());
            if (currentElementValue == null) {
                return null;
            }
            int index = segment.getPropertyIndex();
            if (index != -1) {
                PropertyParcel propertyParcel = currentElementValue;
                Object extractedValue = null;
                if (propertyParcel.getStringValues() != null) {
                    String[] stringValues = propertyParcel.getStringValues();
                    if (stringValues != null && index < stringValues.length) {
                        extractedValue = Arrays.copyOfRange(stringValues, index, index + 1);
                    }
                } else if (propertyParcel.getLongValues() != null) {
                    long[] longValues = propertyParcel.getLongValues();
                    if (longValues != null && index < longValues.length) {
                        extractedValue = Arrays.copyOfRange(longValues, index, index + 1);
                    }
                } else if (propertyParcel.getDoubleValues() != null) {
                    double[] doubleValues = propertyParcel.getDoubleValues();
                    if (doubleValues != null && index < doubleValues.length) {
                        extractedValue = Arrays.copyOfRange(doubleValues, index, index + 1);
                    }
                } else if (propertyParcel.getBooleanValues() != null) {
                    boolean[] booleanValues = propertyParcel.getBooleanValues();
                    if (booleanValues != null && index < booleanValues.length) {
                        extractedValue = Arrays.copyOfRange(booleanValues, index, index + 1);
                    }
                } else if (propertyParcel.getBytesValues() != null) {
                    byte[][] bytesValues = propertyParcel.getBytesValues();
                    if (bytesValues != null && index < bytesValues.length) {
                        extractedValue = Arrays.copyOfRange(bytesValues, index, index + 1);
                    }
                } else if (propertyParcel.getDocumentValues() != null) {
                    GenericDocumentParcel[] docValues = propertyParcel.getDocumentValues();
                    if (docValues != null && index < docValues.length) {
                        extractedValue = docValues[index];
                    }
                } else if (propertyParcel.getEmbeddingValues() != null) {
                    EmbeddingVector[] embeddingValues = propertyParcel.getEmbeddingValues();
                    if (embeddingValues != null && index < embeddingValues.length) {
                        extractedValue = Arrays.copyOfRange(embeddingValues, index, index + 1);
                    }
                } else if (propertyParcel.getBlobHandleValues() != null) {
                    AppSearchBlobHandle[] blobHandlesValues = propertyParcel.getBlobHandleValues();
                    if (blobHandlesValues != null && index < blobHandlesValues.length) {
                        extractedValue = Arrays.copyOfRange(blobHandlesValues, index, index + 1);
                    }
                } else {
                    throw new IllegalStateException("Unsupported value type: " + currentElementValue);
                }
                currentElementValue = extractedValue;
            }
            if (currentElementValue == null || i == path.size() - 1) {
                if (currentElementValue != null && currentElementValue instanceof PropertyParcel) {
                    currentElementValue = ((PropertyParcel)currentElementValue).getValues();
                }
                return currentElementValue;
            }
            if (currentElementValue instanceof GenericDocumentParcel) {
                propertyMap = ((GenericDocumentParcel)currentElementValue).getPropertyMap();
                continue;
            }
            if (currentElementValue instanceof PropertyParcel && ((PropertyParcel)currentElementValue).getDocumentValues() != null) {
                GenericDocumentParcel[] docParcels = ((PropertyParcel)currentElementValue).getDocumentValues();
                if (docParcels != null && docParcels.length == 1) {
                    propertyMap = docParcels[0].getPropertyMap();
                    continue;
                }
                if (docParcels == null) continue;
                ArrayList<Object> accumulator = new ArrayList<Object>(docParcels.length);
                for (GenericDocumentParcel docParcel : docParcels) {
                    Object value = GenericDocument.getRawPropertyFromRawDocument(path, i + 1, docParcel.getPropertyMap());
                    if (value == null) continue;
                    accumulator.add(value);
                }
                return GenericDocument.flattenAccumulator(accumulator);
            }
            Log.e(TAG, "Failed to apply path to document; no nested value found: " + path);
            return null;
        }
        return null;
    }

    @Nullable
    private static Object flattenAccumulator(@NonNull List<Object> accumulator) {
        if (accumulator.isEmpty()) {
            return null;
        }
        Object first = accumulator.get(0);
        if (first instanceof String[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((String[])accumulator.get(i)).length;
            }
            String[] result = new String[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                String[] castValue = (String[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof long[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((long[])accumulator.get(i)).length;
            }
            long[] result = new long[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                long[] castValue = (long[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof double[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((double[])accumulator.get(i)).length;
            }
            double[] result = new double[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                double[] castValue = (double[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof boolean[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((boolean[])accumulator.get(i)).length;
            }
            boolean[] result = new boolean[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                boolean[] castValue = (boolean[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof byte[][]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((byte[][])accumulator.get(i)).length;
            }
            byte[][] result = new byte[length][];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                byte[][] castValue = (byte[][])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof GenericDocumentParcel[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((GenericDocumentParcel[])accumulator.get(i)).length;
            }
            GenericDocumentParcel[] result = new GenericDocumentParcel[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                GenericDocumentParcel[] castValue = (GenericDocumentParcel[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        throw new IllegalStateException("Unexpected property type: " + first);
    }

    @Nullable
    public String getPropertyString(@NonNull String path) {
        Objects.requireNonNull(path);
        String[] propertyArray = this.getPropertyStringArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("String", path, propertyArray.length);
        return propertyArray[0];
    }

    public long getPropertyLong(@NonNull String path) {
        Objects.requireNonNull(path);
        long[] propertyArray = this.getPropertyLongArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return 0L;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Long", path, propertyArray.length);
        return propertyArray[0];
    }

    public double getPropertyDouble(@NonNull String path) {
        Objects.requireNonNull(path);
        double[] propertyArray = this.getPropertyDoubleArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return 0.0;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Double", path, propertyArray.length);
        return propertyArray[0];
    }

    public boolean getPropertyBoolean(@NonNull String path) {
        Objects.requireNonNull(path);
        boolean[] propertyArray = this.getPropertyBooleanArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return false;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Boolean", path, propertyArray.length);
        return propertyArray[0];
    }

    @Nullable
    public byte[] getPropertyBytes(@NonNull String path) {
        Objects.requireNonNull(path);
        byte[][] propertyArray = this.getPropertyBytesArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("ByteArray", path, propertyArray.length);
        return propertyArray[0];
    }

    @Nullable
    public GenericDocument getPropertyDocument(@NonNull String path) {
        Objects.requireNonNull(path);
        GenericDocument[] propertyArray = this.getPropertyDocumentArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Document", path, propertyArray.length);
        return propertyArray[0];
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    @Nullable
    public EmbeddingVector getPropertyEmbedding(@NonNull String path) {
        Objects.requireNonNull(path);
        EmbeddingVector[] propertyArray = this.getPropertyEmbeddingArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Embedding", path, propertyArray.length);
        return propertyArray[0];
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    @Nullable
    public AppSearchBlobHandle getPropertyBlobHandle(@NonNull String path) {
        Objects.requireNonNull(path);
        AppSearchBlobHandle[] propertyArray = this.getPropertyBlobHandleArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("BlobHandle", path, propertyArray.length);
        return propertyArray[0];
    }

    private static void warnIfSinglePropertyTooLong(@NonNull String propertyType, @NonNull String path, int propertyLength) {
        if (propertyLength > 1) {
            Log.w(TAG, "The value for \"" + path + "\" contains " + propertyLength + " elements. Only the first one will be returned from getProperty" + propertyType + "(). Try getProperty" + propertyType + "Array().");
        }
    }

    @Nullable
    public String[] getPropertyStringArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, String[].class);
    }

    @Nullable
    public long[] getPropertyLongArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, long[].class);
    }

    @Nullable
    public double[] getPropertyDoubleArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, double[].class);
    }

    @Nullable
    public boolean[] getPropertyBooleanArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, boolean[].class);
    }

    @SuppressLint(value={"ArrayReturn"})
    @Nullable
    public byte[][] getPropertyBytesArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, byte[][].class);
    }

    @SuppressLint(value={"ArrayReturn"})
    @Nullable
    public GenericDocument[] getPropertyDocumentArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, GenericDocument[].class);
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
    @Nullable
    public EmbeddingVector[] getPropertyEmbeddingArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, EmbeddingVector[].class);
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    @Nullable
    public AppSearchBlobHandle[] getPropertyBlobHandleArray(@NonNull String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, AppSearchBlobHandle[].class);
    }

    @Nullable
    private static <T> T safeCastProperty(@NonNull String path, @Nullable Object value, @NonNull Class<T> tClass) {
        if (value == null) {
            return null;
        }
        try {
            return tClass.cast(value);
        }
        catch (ClassCastException e) {
            Log.w(TAG, "Error casting to requested type for path \"" + path + "\"", e);
            return null;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericDocument)) {
            return false;
        }
        GenericDocument otherDocument = (GenericDocument)other;
        return this.mDocumentParcel.equals(otherDocument.mDocumentParcel);
    }

    public int hashCode() {
        return this.mDocumentParcel.hashCode();
    }

    @NonNull
    public String toString() {
        IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
        this.appendGenericDocumentString(stringBuilder);
        return stringBuilder.toString();
    }

    void appendGenericDocumentString(@NonNull IndentingStringBuilder builder) {
        Objects.requireNonNull(builder);
        builder.append("{\n");
        builder.increaseIndentLevel();
        builder.append("namespace: \"").append(this.getNamespace()).append("\",\n");
        builder.append("id: \"").append(this.getId()).append("\",\n");
        builder.append("score: ").append(this.getScore()).append(",\n");
        builder.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        List<String> parentTypes = this.getParentTypes();
        if (parentTypes != null) {
            builder.append("parentTypes: ").append(parentTypes).append("\n");
        }
        builder.append("creationTimestampMillis: ").append(this.getCreationTimestampMillis()).append(",\n");
        builder.append("timeToLiveMillis: ").append(this.getTtlMillis()).append(",\n");
        builder.append("properties: {\n");
        Object[] sortedProperties = this.getPropertyNames().toArray(new String[0]);
        Arrays.sort(sortedProperties);
        for (int i = 0; i < sortedProperties.length; ++i) {
            Object property = Objects.requireNonNull(this.getProperty((String)sortedProperties[i]));
            builder.increaseIndentLevel();
            this.appendPropertyString((String)sortedProperties[i], property, builder);
            if (i != sortedProperties.length - 1) {
                builder.append(",\n");
            }
            builder.decreaseIndentLevel();
        }
        builder.append("\n");
        builder.append("}");
        builder.decreaseIndentLevel();
        builder.append("\n");
        builder.append("}");
    }

    private void appendPropertyString(@NonNull String propertyName, @NonNull Object property, @NonNull IndentingStringBuilder builder) {
        Objects.requireNonNull(propertyName);
        Objects.requireNonNull(property);
        Objects.requireNonNull(builder);
        builder.append("\"").append(propertyName).append("\": [");
        if (property instanceof GenericDocument[]) {
            GenericDocument[] documentValues = (GenericDocument[])property;
            for (int i = 0; i < documentValues.length; ++i) {
                builder.append("\n");
                builder.increaseIndentLevel();
                documentValues[i].appendGenericDocumentString(builder);
                if (i != documentValues.length - 1) {
                    builder.append(",");
                }
                builder.append("\n");
                builder.decreaseIndentLevel();
            }
        } else {
            int propertyArrLength = Array.getLength(property);
            for (int i = 0; i < propertyArrLength; ++i) {
                Object propertyElement = Array.get(property, i);
                if (propertyElement instanceof String) {
                    builder.append("\"").append((String)propertyElement).append("\"");
                } else if (propertyElement instanceof byte[]) {
                    builder.append(Arrays.toString((byte[])propertyElement));
                } else if (propertyElement != null) {
                    builder.append(propertyElement.toString());
                }
                if (i == propertyArrLength - 1) continue;
                builder.append(", ");
            }
        }
        builder.append("]");
    }

    @SuppressLint(value={"StaticFinalBuilder"})
    public static class Builder<BuilderType extends Builder> {
        private final GenericDocumentParcel.Builder mDocumentParcelBuilder;
        private final BuilderType mBuilderTypeInstance;

        public Builder(@NonNull String namespace, @NonNull String id2, @NonNull String schemaType) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(id2);
            Objects.requireNonNull(schemaType);
            this.mBuilderTypeInstance = this;
            this.mDocumentParcelBuilder = new GenericDocumentParcel.Builder(namespace, id2, schemaType);
        }

        Builder(@NonNull GenericDocumentParcel.Builder documentParcelBuilder) {
            this.mDocumentParcelBuilder = Objects.requireNonNull(documentParcelBuilder);
            this.mBuilderTypeInstance = this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_copy_constructor")
        public Builder(@NonNull GenericDocument document) {
            this(new GenericDocumentParcel.Builder(document.mDocumentParcel));
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_builder_hidden_methods")
        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setNamespace(@NonNull String namespace) {
            Objects.requireNonNull(namespace);
            this.mDocumentParcelBuilder.setNamespace(namespace);
            return this.mBuilderTypeInstance;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_builder_hidden_methods")
        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setId(@NonNull String id2) {
            Objects.requireNonNull(id2);
            this.mDocumentParcelBuilder.setId(id2);
            return this.mBuilderTypeInstance;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_builder_hidden_methods")
        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setSchemaType(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.mDocumentParcelBuilder.setSchemaType(schemaType);
            return this.mBuilderTypeInstance;
        }

        @Deprecated
        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setParentTypes(@Nullable List<String> parentTypes) {
            this.mDocumentParcelBuilder.setParentTypes(parentTypes);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setScore(int score) {
            if (score < 0) {
                throw new IllegalArgumentException("Document score cannot be negative.");
            }
            this.mDocumentParcelBuilder.setScore(score);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setCreationTimestampMillis(long creationTimestampMillis) {
            this.mDocumentParcelBuilder.setCreationTimestampMillis(creationTimestampMillis);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setTtlMillis(long ttlMillis) {
            if (ttlMillis < 0L) {
                throw new IllegalArgumentException("Document ttlMillis cannot be negative.");
            }
            this.mDocumentParcelBuilder.setTtlMillis(ttlMillis);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyString(@NonNull String name, String ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("The String at " + i + " is null.");
            }
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyBoolean(@NonNull String name, boolean ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyLong(@NonNull String name, long ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyDouble(@NonNull String name, double ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyBytes(@NonNull String name, byte[] ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("The byte[] at " + i + " is null.");
            }
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @NonNull
        public BuilderType setPropertyDocument(@NonNull String name, GenericDocument ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            GenericDocumentParcel[] documentParcels = new GenericDocumentParcel[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    throw new IllegalArgumentException("The document at " + i + " is null.");
                }
                documentParcels[i] = values[i].getDocumentParcel();
            }
            this.mDocumentParcelBuilder.putInPropertyMap(name, documentParcels);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
        @NonNull
        public BuilderType setPropertyEmbedding(@NonNull String name, EmbeddingVector ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("The EmbeddingVector at " + i + " is null.");
            }
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
        @NonNull
        public BuilderType setPropertyBlobHandle(@NonNull String name, AppSearchBlobHandle ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.validatePropertyName(name);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("The BlobHandle at " + i + " is null.");
            }
            this.mDocumentParcelBuilder.putInPropertyMap(name, values);
            return this.mBuilderTypeInstance;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_generic_document_builder_hidden_methods")
        @CanIgnoreReturnValue
        @NonNull
        public BuilderType clearProperty(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mDocumentParcelBuilder.clearProperty(name);
            return this.mBuilderTypeInstance;
        }

        @NonNull
        public GenericDocument build() {
            return new GenericDocument(this.mDocumentParcelBuilder.build());
        }

        private void validatePropertyName(@NonNull String name) {
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Property name cannot be blank.");
            }
        }
    }
}

