/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchBlobHandleCreator;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.IndentingStringBuilder;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
@SafeParcelable.Class(creator="AppSearchBlobHandleCreator")
public class AppSearchBlobHandle
extends AbstractSafeParcelable {
    private static final int SHA_256_DIGEST_BYTE_LENGTH = 32;
    @NonNull
    public static final Parcelable.Creator<AppSearchBlobHandle> CREATOR = new AppSearchBlobHandleCreator();
    @SafeParcelable.Field(id=1, getter="getSha256Digest")
    @NonNull
    private final byte[] mSha256Digest;
    @SafeParcelable.Field(id=2, getter="getPackageName")
    @NonNull
    private final String mPackageName;
    @SafeParcelable.Field(id=3, getter="getDatabaseName")
    @NonNull
    private final String mDatabaseName;
    @SafeParcelable.Field(id=4, getter="getNamespace")
    @NonNull
    private final String mNamespace;
    @Nullable
    private Integer mHashCode;

    @SafeParcelable.Constructor
    AppSearchBlobHandle(@SafeParcelable.Param(id=1) @NonNull byte[] sha256Digest, @SafeParcelable.Param(id=2) @NonNull String packageName, @SafeParcelable.Param(id=3) @NonNull String databaseName, @SafeParcelable.Param(id=4) @NonNull String namespace) {
        this.mSha256Digest = Objects.requireNonNull(sha256Digest);
        Preconditions.checkState(sha256Digest.length == 32, "The input digest isn't a sha-256 digest.");
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mNamespace = Objects.requireNonNull(namespace);
    }

    @NonNull
    public byte[] getSha256Digest() {
        return this.mSha256Digest;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    @NonNull
    public String getNamespace() {
        return this.mNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppSearchBlobHandle)) {
            return false;
        }
        AppSearchBlobHandle that = (AppSearchBlobHandle)o;
        if (!Arrays.equals(this.mSha256Digest, that.mSha256Digest)) {
            return false;
        }
        return this.mPackageName.equals(that.mPackageName) && this.mDatabaseName.equals(that.mDatabaseName) && this.mNamespace.equals(that.mNamespace);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = Objects.hash(Arrays.hashCode(this.mSha256Digest), this.mPackageName, this.mDatabaseName, this.mNamespace);
        }
        return this.mHashCode;
    }

    @NonNull
    public String toString() {
        IndentingStringBuilder builder = new IndentingStringBuilder();
        builder.append("{\n");
        builder.increaseIndentLevel();
        builder.append("packageName: \"").append(this.mPackageName).append("\",\n");
        builder.append("databaseName: \"").append(this.mDatabaseName).append("\",\n");
        builder.append("namespace: \"").append(this.mNamespace).append("\",\n");
        builder.append("digest: \"");
        for (byte b : this.mSha256Digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                builder.append(Character.valueOf('0'));
            }
            builder.append(hex);
        }
        builder.append("\",\n").decreaseIndentLevel();
        builder.append("}");
        return builder.toString();
    }

    @NonNull
    public static AppSearchBlobHandle createWithSha256(@NonNull byte[] digest, @NonNull String packageName, @NonNull String databaseName, @NonNull String namespace) {
        Objects.requireNonNull(digest);
        Preconditions.checkArgument(digest.length == 32, "The digest is not a SHA-256 digest");
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(namespace);
        return new AppSearchBlobHandle(digest, packageName, databaseName, namespace);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        AppSearchBlobHandleCreator.writeToParcel(this, dest, flags);
    }
}

