/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.ambientcontext.AmbientContextEvent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@SystemApi
public class AmbientContextEventRequest
implements Parcelable {
    @NonNull
    private final Set<Integer> mEventTypes;
    @NonNull
    private final PersistableBundle mOptions;
    @NonNull
    public static final Parcelable.Creator<AmbientContextEventRequest> CREATOR = new Parcelable.Creator<AmbientContextEventRequest>(){

        public AmbientContextEventRequest[] newArray(int size) {
            return new AmbientContextEventRequest[size];
        }

        @Override
        public AmbientContextEventRequest createFromParcel(@NonNull Parcel in) {
            return new AmbientContextEventRequest(in);
        }
    };

    private AmbientContextEventRequest(@NonNull Set<Integer> eventTypes, @NonNull PersistableBundle options) {
        this.mEventTypes = eventTypes;
        AnnotationValidations.validate(NonNull.class, null, this.mEventTypes);
        Preconditions.checkArgument(!eventTypes.isEmpty(), "eventTypes cannot be empty");
        for (int eventType : eventTypes) {
            AnnotationValidations.validate(AmbientContextEvent.EventCode.class, null, eventType);
        }
        this.mOptions = options;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOptions);
    }

    @NonNull
    public Set<Integer> getEventTypes() {
        return this.mEventTypes;
    }

    @NonNull
    public PersistableBundle getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return "AmbientContextEventRequest { eventTypes = " + this.mEventTypes + ", options = " + this.mOptions + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeArraySet(new ArraySet<Integer>(this.mEventTypes));
        dest.writeTypedObject(this.mOptions, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private AmbientContextEventRequest(@NonNull Parcel in) {
        ArraySet<? extends Object> eventTypes = in.readArraySet(Integer.class.getClassLoader());
        PersistableBundle options = in.readTypedObject(PersistableBundle.CREATOR);
        this.mEventTypes = eventTypes;
        AnnotationValidations.validate(NonNull.class, null, this.mEventTypes);
        Preconditions.checkArgument(!eventTypes.isEmpty(), "eventTypes cannot be empty");
        Iterator iterator = eventTypes.iterator();
        while (iterator.hasNext()) {
            int eventType = (Integer)iterator.next();
            AnnotationValidations.validate(AmbientContextEvent.EventCode.class, null, eventType);
        }
        this.mOptions = options;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOptions);
    }

    public static class Builder {
        @NonNull
        private Set<Integer> mEventTypes;
        @NonNull
        private PersistableBundle mOptions;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder addEventType(int value) {
            this.checkNotUsed();
            if (this.mEventTypes == null) {
                this.mBuilderFieldsSet |= 1L;
                this.mEventTypes = new HashSet<Integer>();
            }
            this.mEventTypes.add(value);
            return this;
        }

        @NonNull
        public Builder setOptions(@NonNull PersistableBundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mOptions = value;
            return this;
        }

        @NonNull
        public AmbientContextEventRequest build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mEventTypes = new HashSet<Integer>();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mOptions = new PersistableBundle();
            }
            AmbientContextEventRequest o = new AmbientContextEventRequest(this.mEventTypes, this.mOptions);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

