/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.PasswordValidationError;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PasswordMetrics
implements Parcelable {
    private static final String TAG = "PasswordMetrics";
    public static final int MAX_ALLOWED_SEQUENCE = 3;
    public int credType;
    public int length = 0;
    public int letters = 0;
    public int upperCase = 0;
    public int lowerCase = 0;
    public int numeric = 0;
    public int symbols = 0;
    public int nonLetter = 0;
    public int nonNumeric = 0;
    public int seqLength = Integer.MAX_VALUE;
    @NonNull
    public static final Parcelable.Creator<PasswordMetrics> CREATOR = new Parcelable.Creator<PasswordMetrics>(){

        @Override
        public PasswordMetrics createFromParcel(Parcel in) {
            int credType = in.readInt();
            int length = in.readInt();
            int letters = in.readInt();
            int upperCase = in.readInt();
            int lowerCase = in.readInt();
            int numeric = in.readInt();
            int symbols = in.readInt();
            int nonLetter = in.readInt();
            int nonNumeric = in.readInt();
            int seqLength = in.readInt();
            return new PasswordMetrics(credType, length, letters, upperCase, lowerCase, numeric, symbols, nonLetter, nonNumeric, seqLength);
        }

        public PasswordMetrics[] newArray(int size) {
            return new PasswordMetrics[size];
        }
    };
    private static final int CHAR_LOWER_CASE = 0;
    private static final int CHAR_UPPER_CASE = 1;
    private static final int CHAR_DIGIT = 2;
    private static final int CHAR_SYMBOL = 3;

    public PasswordMetrics(int credType) {
        this.credType = credType;
    }

    public PasswordMetrics(int credType, int length, int letters, int upperCase, int lowerCase, int numeric, int symbols, int nonLetter, int nonNumeric, int seqLength) {
        this.credType = credType;
        this.length = length;
        this.letters = letters;
        this.upperCase = upperCase;
        this.lowerCase = lowerCase;
        this.numeric = numeric;
        this.symbols = symbols;
        this.nonLetter = nonLetter;
        this.nonNumeric = nonNumeric;
        this.seqLength = seqLength;
    }

    private PasswordMetrics(PasswordMetrics other) {
        this(other.credType, other.length, other.letters, other.upperCase, other.lowerCase, other.numeric, other.symbols, other.nonLetter, other.nonNumeric, other.seqLength);
    }

    public static int sanitizeComplexityLevel(int complexityLevel) {
        switch (complexityLevel) {
            case 0: 
            case 65536: 
            case 196608: 
            case 327680: {
                return complexityLevel;
            }
        }
        Log.w(TAG, "Invalid password complexity used: " + complexityLevel);
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.credType);
        dest.writeInt(this.length);
        dest.writeInt(this.letters);
        dest.writeInt(this.upperCase);
        dest.writeInt(this.lowerCase);
        dest.writeInt(this.numeric);
        dest.writeInt(this.symbols);
        dest.writeInt(this.nonLetter);
        dest.writeInt(this.nonNumeric);
        dest.writeInt(this.seqLength);
    }

    public static PasswordMetrics computeForCredential(LockscreenCredential credential) {
        if (credential.isPassword() || credential.isPin()) {
            return PasswordMetrics.computeForPasswordOrPin(credential.getCredential(), credential.isPin());
        }
        if (credential.isPattern()) {
            PasswordMetrics metrics = new PasswordMetrics(1);
            metrics.length = credential.size();
            return metrics;
        }
        if (credential.isNone()) {
            return new PasswordMetrics(-1);
        }
        throw new IllegalArgumentException("Unknown credential type " + credential.getType());
    }

    private static PasswordMetrics computeForPasswordOrPin(byte[] credential, boolean isPin) {
        int letters = 0;
        int upperCase = 0;
        int lowerCase = 0;
        int numeric = 0;
        int symbols = 0;
        int nonLetter = 0;
        int nonNumeric = 0;
        int length = credential.length;
        block6: for (byte b : credential) {
            switch (PasswordMetrics.categoryChar((char)b)) {
                case 0: {
                    ++letters;
                    ++lowerCase;
                    ++nonNumeric;
                    continue block6;
                }
                case 1: {
                    ++letters;
                    ++upperCase;
                    ++nonNumeric;
                    continue block6;
                }
                case 2: {
                    ++numeric;
                    ++nonLetter;
                    continue block6;
                }
                case 3: {
                    ++symbols;
                    ++nonLetter;
                    ++nonNumeric;
                }
            }
        }
        int credType = isPin ? 3 : 4;
        int seqLength = PasswordMetrics.maxLengthSequence(credential);
        return new PasswordMetrics(credType, length, letters, upperCase, lowerCase, numeric, symbols, nonLetter, nonNumeric, seqLength);
    }

    public static int maxLengthSequence(@NonNull byte[] bytes) {
        if (bytes.length == 0) {
            return 0;
        }
        char previousChar = (char)bytes[0];
        int category = PasswordMetrics.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < bytes.length; ++current) {
            char currentChar = (char)bytes[current];
            int categoryCurrent = PasswordMetrics.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > PasswordMetrics.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, bytes.length - startSequence);
        return maxLength;
    }

    private static int categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static int maxDiffCategory(int category) {
        switch (category) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: {
                return 10;
            }
        }
        return 0;
    }

    public static PasswordMetrics merge(List<PasswordMetrics> metrics) {
        PasswordMetrics result = new PasswordMetrics(-1);
        for (PasswordMetrics m : metrics) {
            result.maxWith(m);
        }
        return result;
    }

    public void maxWith(PasswordMetrics other) {
        this.credType = Math.max(this.credType, other.credType);
        if (this.credType != 4 && this.credType != 3) {
            return;
        }
        this.length = Math.max(this.length, other.length);
        this.letters = Math.max(this.letters, other.letters);
        this.upperCase = Math.max(this.upperCase, other.upperCase);
        this.lowerCase = Math.max(this.lowerCase, other.lowerCase);
        this.numeric = Math.max(this.numeric, other.numeric);
        this.symbols = Math.max(this.symbols, other.symbols);
        this.nonLetter = Math.max(this.nonLetter, other.nonLetter);
        this.nonNumeric = Math.max(this.nonNumeric, other.nonNumeric);
        this.seqLength = Math.min(this.seqLength, other.seqLength);
    }

    public static int complexityLevelToMinQuality(int complexity) {
        switch (complexity) {
            case 196608: 
            case 327680: {
                return 196608;
            }
            case 65536: {
                return 65536;
            }
        }
        return 0;
    }

    private boolean satisfiesBucket(ComplexityBucket bucket) {
        if (!bucket.allowsCredType(this.credType)) {
            return false;
        }
        if (this.credType != 4 && this.credType != 3) {
            return true;
        }
        return (bucket.canHaveSequence() || this.seqLength <= 3) && this.length >= bucket.getMinimumLength(this.nonNumeric > 0);
    }

    public int determineComplexity() {
        for (ComplexityBucket bucket : ComplexityBucket.values()) {
            if (!this.satisfiesBucket(bucket)) continue;
            return bucket.mComplexityLevel;
        }
        throw new IllegalStateException("Failed to figure out complexity for a given metrics");
    }

    public static List<PasswordValidationError> validateCredential(PasswordMetrics adminMetrics, int minComplexity, LockscreenCredential credential) {
        if (credential.hasInvalidChars()) {
            return Collections.singletonList(new PasswordValidationError(2, 0));
        }
        PasswordMetrics actualMetrics = PasswordMetrics.computeForCredential(credential);
        return PasswordMetrics.validatePasswordMetrics(adminMetrics, minComplexity, actualMetrics);
    }

    public static List<PasswordValidationError> validatePasswordMetrics(PasswordMetrics adminMetrics, int minComplexity, PasswordMetrics actualMetrics) {
        ComplexityBucket bucket = ComplexityBucket.forComplexity(minComplexity);
        if (actualMetrics.credType < adminMetrics.credType || !bucket.allowsCredType(actualMetrics.credType)) {
            return Collections.singletonList(new PasswordValidationError(1, 0));
        }
        if (actualMetrics.credType == 1) {
            if (actualMetrics.length != 0 && actualMetrics.length < 4) {
                return Collections.singletonList(new PasswordValidationError(3, 4));
            }
            return Collections.emptyList();
        }
        if (actualMetrics.credType == -1) {
            return Collections.emptyList();
        }
        if (actualMetrics.credType == 3 && actualMetrics.nonNumeric > 0) {
            return Collections.singletonList(new PasswordValidationError(2, 0));
        }
        ArrayList<PasswordValidationError> result = new ArrayList<PasswordValidationError>();
        if (actualMetrics.length > 16) {
            result.add(new PasswordValidationError(5, 16));
        }
        PasswordMetrics minMetrics = PasswordMetrics.applyComplexity(adminMetrics, actualMetrics.credType == 3, bucket);
        minMetrics.length = Math.min(16, Math.max(minMetrics.length, 4));
        minMetrics.removeOverlapping();
        PasswordMetrics.comparePasswordMetrics(minMetrics, bucket, actualMetrics, result);
        return result;
    }

    private static void comparePasswordMetrics(PasswordMetrics minMetrics, ComplexityBucket bucket, PasswordMetrics actualMetrics, ArrayList<PasswordValidationError> result) {
        int allNumericMinimumLength;
        if (actualMetrics.length < minMetrics.length) {
            result.add(new PasswordValidationError(3, minMetrics.length));
        }
        if (actualMetrics.nonNumeric == 0 && minMetrics.nonNumeric == 0 && minMetrics.letters == 0 && minMetrics.lowerCase == 0 && minMetrics.upperCase == 0 && minMetrics.symbols == 0 && (allNumericMinimumLength = bucket.getMinimumLength(false)) > minMetrics.length && allNumericMinimumLength > minMetrics.numeric && actualMetrics.length < allNumericMinimumLength) {
            result.add(new PasswordValidationError(4, allNumericMinimumLength));
        }
        if (actualMetrics.letters < minMetrics.letters) {
            result.add(new PasswordValidationError(7, minMetrics.letters));
        }
        if (actualMetrics.upperCase < minMetrics.upperCase) {
            result.add(new PasswordValidationError(8, minMetrics.upperCase));
        }
        if (actualMetrics.lowerCase < minMetrics.lowerCase) {
            result.add(new PasswordValidationError(9, minMetrics.lowerCase));
        }
        if (actualMetrics.numeric < minMetrics.numeric) {
            result.add(new PasswordValidationError(10, minMetrics.numeric));
        }
        if (actualMetrics.symbols < minMetrics.symbols) {
            result.add(new PasswordValidationError(11, minMetrics.symbols));
        }
        if (actualMetrics.nonLetter < minMetrics.nonLetter) {
            result.add(new PasswordValidationError(12, minMetrics.nonLetter));
        }
        if (actualMetrics.nonNumeric < minMetrics.nonNumeric) {
            result.add(new PasswordValidationError(13, minMetrics.nonNumeric));
        }
        if (actualMetrics.seqLength > minMetrics.seqLength) {
            result.add(new PasswordValidationError(6, 0));
        }
    }

    private void removeOverlapping() {
        int indirectLetters = this.upperCase + this.lowerCase;
        int indirectNonLetter = this.numeric + this.symbols;
        int effectiveLetters = Math.max(this.letters, indirectLetters);
        int indirectNonNumeric = effectiveLetters + this.symbols;
        int effectiveNonLetter = Math.max(this.nonLetter, indirectNonLetter);
        int effectiveNonNumeric = Math.max(this.nonNumeric, indirectNonNumeric);
        int indirectLength = Math.max(effectiveLetters + effectiveNonLetter, this.numeric + effectiveNonNumeric);
        if (indirectLetters >= this.letters) {
            this.letters = 0;
        }
        if (indirectNonLetter >= this.nonLetter) {
            this.nonLetter = 0;
        }
        if (indirectNonNumeric >= this.nonNumeric) {
            this.nonNumeric = 0;
        }
        if (indirectLength >= this.length) {
            this.length = 0;
        }
    }

    public static PasswordMetrics applyComplexity(PasswordMetrics adminMetrics, boolean isPin, int complexity) {
        return PasswordMetrics.applyComplexity(adminMetrics, isPin, ComplexityBucket.forComplexity(complexity));
    }

    private static PasswordMetrics applyComplexity(PasswordMetrics adminMetrics, boolean isPin, ComplexityBucket bucket) {
        PasswordMetrics minMetrics = new PasswordMetrics(adminMetrics);
        if (!bucket.canHaveSequence()) {
            minMetrics.seqLength = Math.min(minMetrics.seqLength, 3);
        }
        minMetrics.length = Math.max(minMetrics.length, bucket.getMinimumLength(!isPin));
        return minMetrics;
    }

    public static boolean isNumericOnly(@NonNull String password) {
        if (password.length() == 0) {
            return false;
        }
        for (int i = 0; i < password.length(); ++i) {
            if (PasswordMetrics.categoryChar(password.charAt(i)) == 2) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordMetrics that = (PasswordMetrics)o;
        return this.credType == that.credType && this.length == that.length && this.letters == that.letters && this.upperCase == that.upperCase && this.lowerCase == that.lowerCase && this.numeric == that.numeric && this.symbols == that.symbols && this.nonLetter == that.nonLetter && this.nonNumeric == that.nonNumeric && this.seqLength == that.seqLength;
    }

    public int hashCode() {
        return Objects.hash(this.credType, this.length, this.letters, this.upperCase, this.lowerCase, this.numeric, this.symbols, this.nonLetter, this.nonNumeric, this.seqLength);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ComplexityBucket {
        BUCKET_HIGH(327680){

            @Override
            boolean canHaveSequence() {
                return false;
            }

            @Override
            int getMinimumLength(boolean containsNonNumeric) {
                return containsNonNumeric ? 6 : 8;
            }

            @Override
            boolean allowsCredType(int credType) {
                return credType == 4 || credType == 3;
            }
        }
        ,
        BUCKET_MEDIUM(196608){

            @Override
            boolean canHaveSequence() {
                return false;
            }

            @Override
            int getMinimumLength(boolean containsNonNumeric) {
                return 4;
            }

            @Override
            boolean allowsCredType(int credType) {
                return credType == 4 || credType == 3;
            }
        }
        ,
        BUCKET_LOW(65536){

            @Override
            boolean canHaveSequence() {
                return true;
            }

            @Override
            int getMinimumLength(boolean containsNonNumeric) {
                return 0;
            }

            @Override
            boolean allowsCredType(int credType) {
                return credType != -1;
            }
        }
        ,
        BUCKET_NONE(0){

            @Override
            boolean canHaveSequence() {
                return true;
            }

            @Override
            int getMinimumLength(boolean containsNonNumeric) {
                return 0;
            }

            @Override
            boolean allowsCredType(int credType) {
                return true;
            }
        };

        int mComplexityLevel;

        abstract boolean canHaveSequence();

        abstract int getMinimumLength(boolean var1);

        abstract boolean allowsCredType(int var1);

        private ComplexityBucket(int complexityLevel) {
            this.mComplexityLevel = complexityLevel;
        }

        static ComplexityBucket forComplexity(int complexityLevel) {
            for (ComplexityBucket bucket : ComplexityBucket.values()) {
                if (bucket.mComplexityLevel != complexityLevel) continue;
                return bucket;
            }
            throw new IllegalArgumentException("Invalid complexity level: " + complexityLevel);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface CharacterCatagory {
    }
}

