/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityGestureEvent;
import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.accessibilityservice.MagnificationConfig;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.IUiAutomationConnection;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.HardwareBuffer;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.inputmethod.EditorInfo;
import android.window.ScreenCapture;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.IAccessibilityInputMethodSessionCallback;
import com.android.internal.inputmethod.RemoteAccessibilityInputConnection;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

@RavenwoodKeepPartialClass
@RavenwoodRedirectionClass(value="UiAutomation_ravenwood")
public class UiAutomation {
    private static final String LOG_TAG = UiAutomation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private static final int CONNECTION_ID_UNDEFINED = -1;
    private static final long CONNECT_TIMEOUT_MILLIS = 5000L;
    public static final int ROTATION_UNFREEZE = -2;
    public static final int ROTATION_FREEZE_CURRENT = -1;
    public static final int ROTATION_FREEZE_0 = 0;
    public static final int ROTATION_FREEZE_90 = 1;
    public static final int ROTATION_FREEZE_180 = 2;
    public static final int ROTATION_FREEZE_270 = 3;
    public static final int FLAG_DONT_SUPPRESS_ACCESSIBILITY_SERVICES = 1;
    public static final int FLAG_DONT_USE_ACCESSIBILITY = 2;
    public static final int FLAG_NOT_ACCESSIBILITY_TOOL = 4;
    @NonNull
    public static final Set<String> ALL_PERMISSIONS = Set.of("_ALL_PERMISSIONS_");
    private final Object mLock = new Object();
    private final ArrayList<AccessibilityEvent> mEventQueue = new ArrayList();
    private final Handler mLocalCallbackHandler;
    private final IUiAutomationConnection mUiAutomationConnection;
    private final int mDisplayId;
    private HandlerThread mRemoteCallbackThread;
    private IAccessibilityServiceClient mClient;
    private int mConnectionId = -1;
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private int mCurrentEventWatchersCount = 0;
    private long mLastEventTimeMillis;
    private int mConnectionState = 0;
    private boolean mIsDestroyed;
    private int mFlags;
    private int mGenerationId = 0;

    @RavenwoodKeep
    public UiAutomation(Context context, IUiAutomationConnection connection) {
        this(UiAutomation.getDisplayId(context), context.getMainLooper(), connection);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UiAutomation(Looper looper, IUiAutomationConnection connection) {
        this(0, looper, connection);
        Log.w(LOG_TAG, "Created with deprecatead constructor, assumes DEFAULT_DISPLAY");
    }

    @RavenwoodKeep
    private UiAutomation(int displayId, Looper looper, IUiAutomationConnection connection) {
        Preconditions.checkArgument(looper != null, "Looper cannot be null!");
        Preconditions.checkArgument(connection != null, "Connection cannot be null!");
        this.mLocalCallbackHandler = new Handler(looper);
        this.mUiAutomationConnection = connection;
        this.mDisplayId = displayId;
        Log.i(LOG_TAG, "Initialized for user " + Process.myUserHandle().getIdentifier() + " on display " + this.mDisplayId);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void connect() {
        try {
            this.connectWithTimeout(0, 5000L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(int flags) {
        try {
            this.connectWithTimeout(flags, 5000L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWithTimeout(int flags, long timeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfConnectedLocked();
            if (this.mConnectionState == 1) {
                return;
            }
            this.mConnectionState = 1;
            this.mRemoteCallbackThread = new HandlerThread("UiAutomation");
            this.mRemoteCallbackThread.start();
            this.mClient = new IAccessibilityServiceClientImpl(this, this.mRemoteCallbackThread.getLooper(), ++this.mGenerationId);
        }
        try {
            this.mUiAutomationConnection.connect(this.mClient, flags);
            this.mFlags = flags;
            if (!this.useAccessibility()) {
                this.mConnectionState = 0;
                return;
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while connecting " + this, re);
        }
        object = this.mLock;
        synchronized (object) {
            long startTimeMillis = SystemClock.uptimeMillis();
            while (this.mConnectionState != 2) {
                long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                long remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
                if (remainingTimeMillis <= 0L) {
                    this.mConnectionState = 3;
                    throw new TimeoutException("Timeout while connecting " + this);
                }
                try {
                    this.mLock.wait(remainingTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionState == 1) {
                throw new IllegalStateException("Cannot call disconnect() while connecting " + this);
            }
            if (this.useAccessibility() && this.mConnectionState == 0) {
                return;
            }
            this.mConnectionState = 0;
            this.mConnectionId = -1;
            ++this.mGenerationId;
        }
        try {
            this.mUiAutomationConnection.disconnect();
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while disconnecting " + this, re);
        }
        finally {
            if (this.mRemoteCallbackThread != null) {
                this.mRemoteCallbackThread.quit();
                this.mRemoteCallbackThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnAccessibilityEventListener(OnAccessibilityEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            this.mOnAccessibilityEventListener = listener;
        }
    }

    public void destroy() {
        this.disconnect();
        this.mIsDestroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearCache() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
        if (cache == null) {
            return false;
        }
        cache.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNodeInCache(@NonNull AccessibilityNodeInfo node) {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        AccessibilityCache cache = AccessibilityInteractionClient.getCache(connectionId);
        if (cache == null) {
            return false;
        }
        return cache.isNodeInCache(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AccessibilityCache getCache() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getCache(connectionId);
    }

    @RavenwoodRedirect
    public void adoptShellPermissionIdentity() {
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RavenwoodRedirect
    public void adoptShellPermissionIdentity(String ... permissions) {
        try {
            this.mUiAutomationConnection.adoptShellPermissionIdentity(Process.myUid(), permissions);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RavenwoodRedirect
    public void dropShellPermissionIdentity() {
        try {
            this.mUiAutomationConnection.dropShellPermissionIdentity();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RavenwoodRedirect
    public Set<String> getAdoptedShellPermissions() {
        try {
            List<String> permissions = this.mUiAutomationConnection.getAdoptedShellPermissions();
            return permissions == null ? ALL_PERMISSIONS : new ArraySet<String>(permissions);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void addOverridePermissionState(int uid, @NonNull String permission2, int result) {
        try {
            this.mUiAutomationConnection.addOverridePermissionState(uid, permission2, result);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void removeOverridePermissionState(int uid, @NonNull String permission2) {
        try {
            this.mUiAutomationConnection.removeOverridePermissionState(uid, permission2);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void clearOverridePermissionStates(int uid) {
        try {
            this.mUiAutomationConnection.clearOverridePermissionStates(uid);
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public void clearAllOverridePermissionStates() {
        try {
            this.mUiAutomationConnection.clearAllOverridePermissionStates();
        }
        catch (RemoteException re) {
            re.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performGlobalAction(int action) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo findFocus(int focus) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceInfo(AccessibilityServiceInfo info) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance().clearCache(this.mConnectionId);
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                connection.setServiceInfo(info);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindowsOnDisplay(connectionId, this.mDisplayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SparseArray<List<AccessibilityWindowInfo>> getWindowsOnAllDisplays() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindowsOnAllDisplays(connectionId);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return this.getRootInActiveWindow(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AccessibilityNodeInfo getRootInActiveWindow(int prefetchingStrategy) {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId, prefetchingStrategy);
    }

    public boolean injectInputEvent(InputEvent event, boolean sync) {
        return this.injectInputEvent(event, sync, true);
    }

    @Deprecated
    @SuppressLint(value={"UnflaggedApi"})
    public boolean injectInputEvent(@NonNull InputEvent event, boolean sync, boolean waitForAnimations) {
        try {
            return this.mUiAutomationConnection.injectInputEvent(event, sync, waitForAnimations);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event!", re);
            return false;
        }
    }

    @Deprecated
    @SuppressLint(value={"UnflaggedApi"})
    public void injectInputEventToInputFilter(@NonNull InputEvent event) {
        try {
            this.mUiAutomationConnection.injectInputEventToInputFilter(event);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event to input filter", re);
        }
    }

    public void setAnimationScale(float scale) {
        AccessibilityInteractionClient.getInstance();
        IAccessibilityServiceConnection connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        if (connection != null) {
            try {
                connection.setAnimationScale(scale);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re);
            }
        }
    }

    public void syncInputTransactions() {
        try {
            this.mUiAutomationConnection.syncInputTransactions(true);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while syncing input transactions!", re);
        }
    }

    public void syncInputTransactions(boolean waitForAnimations) {
        try {
            this.mUiAutomationConnection.syncInputTransactions(waitForAnimations);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while syncing input transactions!", re);
        }
    }

    public boolean setRotation(int rotation) {
        switch (rotation) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.mUiAutomationConnection.setRotation(rotation);
                    return true;
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error while setting rotation!", re);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid rotation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityEvent executeAndWaitForEvent(Runnable command, AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        int eventQueueStartIndex;
        long executionStartTimeMillis;
        int watchersDepth;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            ++this.mCurrentEventWatchersCount;
            watchersDepth = this.mCurrentEventWatchersCount--;
            executionStartTimeMillis = SystemClock.uptimeMillis();
            eventQueueStartIndex = this.mEventQueue.size();
        }
        try {
            command.run();
            object = this.mLock;
            synchronized (object) {
                if (watchersDepth != this.mCurrentEventWatchersCount) {
                    throw new IllegalStateException("Unexpected event watchers count, expected: " + watchersDepth + ", actual: " + this.mCurrentEventWatchersCount);
                }
            }
            long startTimeMillis = SystemClock.uptimeMillis();
            ArrayList<AccessibilityEvent> receivedEvents = new ArrayList<AccessibilityEvent>();
            long elapsedTimeMillis = 0L;
            int currentQueueSize = 0;
            while (timeoutMillis > elapsedTimeMillis) {
                AccessibilityEvent event = null;
                Object object2 = this.mLock;
                synchronized (object2) {
                    currentQueueSize = this.mEventQueue.size();
                    if (eventQueueStartIndex < currentQueueSize) {
                        event = this.mEventQueue.get(eventQueueStartIndex++);
                    } else {
                        try {
                            this.mLock.wait(timeoutMillis - elapsedTimeMillis);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                if (event == null || event.getEventTime() < executionStartTimeMillis) continue;
                if (filter.accept(event)) {
                    object2 = event;
                    return object2;
                }
                receivedEvents.add(event);
            }
            if (eventQueueStartIndex < currentQueueSize) {
                Log.w(LOG_TAG, "Timed out before reading all events from the queue");
            }
            throw new TimeoutException("Expected event not received before timeout, events: " + receivedEvents);
        }
        finally {
            Object object3 = this.mLock;
            synchronized (object3) {
                if (this.mCurrentEventWatchersCount == 0) {
                    this.mEventQueue.clear();
                }
                this.mLock.notifyAll();
            }
        }
    }

    public void waitForIdle(long idleTimeoutMillis, long globalTimeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long startTimeMillis = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = startTimeMillis;
            }
            while (true) {
                long currentTimeMillis;
                long elapsedGlobalTimeMillis;
                long remainingGlobalTimeMillis;
                if ((remainingGlobalTimeMillis = globalTimeoutMillis - (elapsedGlobalTimeMillis = (currentTimeMillis = SystemClock.uptimeMillis()) - startTimeMillis)) <= 0L) {
                    throw new TimeoutException("No idle state with idle timeout: " + idleTimeoutMillis + " within global timeout: " + globalTimeoutMillis);
                }
                long elapsedIdleTimeMillis = currentTimeMillis - this.mLastEventTimeMillis;
                long remainingIdleTimeMillis = idleTimeoutMillis - elapsedIdleTimeMillis;
                if (remainingIdleTimeMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainingIdleTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Bitmap takeScreenshot() {
        Bitmap swBitmap;
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(this.mDisplayId);
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        ScreenCapture.SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        try {
            if (!this.mUiAutomationConnection.takeScreenshot(new Rect(0, 0, displaySize.x, displaySize.y), syncScreenCapture, this.mDisplayId)) {
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screenshot of display " + this.mDisplayId, re);
            return null;
        }
        ScreenCapture.ScreenshotHardwareBuffer screenshotBuffer = syncScreenCapture.getBuffer();
        if (screenshotBuffer == null) {
            Log.e(LOG_TAG, "Failed to take screenshot for display=" + this.mDisplayId);
            return null;
        }
        Bitmap screenShot = screenshotBuffer.asBitmap();
        if (screenShot == null) {
            Log.e(LOG_TAG, "Failed to take screenshot for display=" + this.mDisplayId);
            return null;
        }
        try (HardwareBuffer buffer = screenshotBuffer.getHardwareBuffer();){
            swBitmap = screenShot.copy(Bitmap.Config.ARGB_8888, false);
        }
        screenShot.recycle();
        swBitmap.setHasAlpha(false);
        return swBitmap;
    }

    @NonNull
    @SuppressLint(value={"UnflaggedApi"})
    public Bitmap takeScreenshot(int displayId) throws IOException {
        Bitmap swBitmap;
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(displayId);
        if (display == null) {
            throw new IllegalArgumentException("Error finding the display " + displayId);
        }
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        ScreenCapture.SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        try {
            if (!this.mUiAutomationConnection.takeScreenshot(new Rect(0, 0, displaySize.x, displaySize.y), syncScreenCapture, displayId)) {
                throw new IOException("Fail to capture screenshot for display=" + displayId + " due to remote error.");
            }
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        ScreenCapture.ScreenshotHardwareBuffer screenshotBuffer = syncScreenCapture.getBuffer();
        if (screenshotBuffer == null) {
            throw new IOException("Empty screenshot buffer for display=" + displayId);
        }
        Bitmap screenShot = screenshotBuffer.asBitmap();
        if (screenShot == null) {
            throw new IOException("Fail to create screenshot bitmap for display=" + displayId);
        }
        try (HardwareBuffer buffer = screenshotBuffer.getHardwareBuffer();){
            swBitmap = screenShot.copy(Bitmap.Config.ARGB_8888, false);
        }
        screenShot.recycle();
        swBitmap.setHasAlpha(false);
        return swBitmap;
    }

    @Nullable
    public Bitmap takeScreenshot(@NonNull Window window) {
        Bitmap swBitmap;
        if (window == null) {
            Log.e(LOG_TAG, "Window is null");
            return null;
        }
        View decorView = window.peekDecorView();
        if (decorView == null) {
            Log.e(LOG_TAG, "Decor view is null");
            return null;
        }
        ViewRootImpl viewRoot = decorView.getViewRootImpl();
        if (viewRoot == null) {
            Log.e(LOG_TAG, "View root is null");
            return null;
        }
        SurfaceControl sc = viewRoot.getSurfaceControl();
        if (!sc.isValid()) {
            Log.e(LOG_TAG, "ViewRootImpl SurfaceControl is not valid");
            return null;
        }
        new SurfaceControl.Transaction().apply(true);
        ScreenCapture.SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        try {
            if (!this.mUiAutomationConnection.takeSurfaceControlScreenshot(sc, syncScreenCapture)) {
                Log.e(LOG_TAG, "Failed to take screenshot for window=" + window);
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screenshot!", re);
            return null;
        }
        ScreenCapture.ScreenshotHardwareBuffer captureBuffer = syncScreenCapture.getBuffer();
        if (captureBuffer == null) {
            Log.e(LOG_TAG, "Failed to take screenshot for window=" + window);
            return null;
        }
        Bitmap screenShot = captureBuffer.asBitmap();
        if (screenShot == null) {
            Log.e(LOG_TAG, "Failed to take screenshot for window=" + window);
            return null;
        }
        try (HardwareBuffer buffer = captureBuffer.getHardwareBuffer();){
            swBitmap = screenShot.copy(Bitmap.Config.ARGB_8888, false);
        }
        screenShot.recycle();
        return swBitmap;
    }

    public void setRunAsMonkey(boolean enable) {
        try {
            ActivityManager.getService().setUserIsMonkey(enable);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowContentFrameStats getWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", re);
            return null;
        }
    }

    @Deprecated
    public void clearWindowAnimationFrameStats() {
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", re);
        }
    }

    @Deprecated
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", re);
            return null;
        }
    }

    public void grantRuntimePermission(String packageName, String permission2) {
        this.grantRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean grantRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.grantRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    public void grantRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        try {
            this.mUiAutomationConnection.grantRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    public void revokeRuntimePermission(String packageName, String permission2) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    public boolean revokeRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    public void revokeRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        try {
            this.mUiAutomationConnection.revokeRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    /*
     * Loose catch block
     */
    public ParcelFileDescriptor executeShellCommand(String command) {
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            source = pipe[0];
            sink = pipe[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink, null);
        }
        catch (RemoteException | IOException e) {
            Log.e(LOG_TAG, "Error executing shell command!", e);
            IoUtils.closeQuietly(sink);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e2) {
            IoUtils.closeQuietly(source);
            throw e2;
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink);
                    throw throwable;
                }
            }
        }
        IoUtils.closeQuietly(sink);
        return source;
    }

    @SuppressLint(value={"ArrayReturn"})
    @NonNull
    public ParcelFileDescriptor[] executeShellCommandRw(@NonNull String command) {
        return this.executeShellCommandInternal(command, false);
    }

    @SuppressLint(value={"ArrayReturn"})
    @NonNull
    public ParcelFileDescriptor[] executeShellCommandRwe(@NonNull String command) {
        return this.executeShellCommandInternal(command, true);
    }

    @VisibleForTesting
    public int getDisplayId() {
        return this.mDisplayId;
    }

    /*
     * Loose catch block
     */
    private ParcelFileDescriptor[] executeShellCommandInternal(String command, boolean includeStderr) {
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source_read = null;
        ParcelFileDescriptor sink_read = null;
        ParcelFileDescriptor source_write = null;
        ParcelFileDescriptor sink_write = null;
        ParcelFileDescriptor stderr_source_read = null;
        ParcelFileDescriptor stderr_sink_read = null;
        try {
            ParcelFileDescriptor[] pipe_read = ParcelFileDescriptor.createPipe();
            source_read = pipe_read[0];
            sink_read = pipe_read[1];
            ParcelFileDescriptor[] pipe_write = ParcelFileDescriptor.createPipe();
            source_write = pipe_write[0];
            sink_write = pipe_write[1];
            if (includeStderr) {
                ParcelFileDescriptor[] stderr_read = ParcelFileDescriptor.createPipe();
                stderr_source_read = stderr_read[0];
                stderr_sink_read = stderr_read[1];
            }
            this.mUiAutomationConnection.executeShellCommandWithStderr(command, sink_read, source_write, stderr_sink_read);
        }
        catch (RemoteException | IOException e) {
            Log.e(LOG_TAG, "Error executing shell command!", e);
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
            IoUtils.closeQuietly(stderr_sink_read);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e2) {
            IoUtils.closeQuietly(sink_write);
            IoUtils.closeQuietly(source_read);
            IoUtils.closeQuietly(stderr_source_read);
            throw e2;
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink_read);
                    IoUtils.closeQuietly(source_write);
                    IoUtils.closeQuietly(stderr_sink_read);
                    throw throwable;
                }
            }
        }
        IoUtils.closeQuietly(sink_read);
        IoUtils.closeQuietly(source_write);
        IoUtils.closeQuietly(stderr_sink_read);
        ParcelFileDescriptor[] result = new ParcelFileDescriptor[includeStderr ? 3 : 2];
        result[0] = source_read;
        result[1] = sink_write;
        if (includeStderr) {
            result[2] = stderr_source_read;
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UiAutomation@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[id=").append(this.mConnectionId);
        stringBuilder.append(", displayId=").append(this.mDisplayId);
        stringBuilder.append(", flags=").append(this.mFlags);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @GuardedBy(value={"mLock"})
    private void throwIfConnectedLocked() {
        if (this.mConnectionState == 2) {
            throw new IllegalStateException("UiAutomation connected, " + this);
        }
    }

    @GuardedBy(value={"mLock"})
    private void throwIfNotConnectedLocked() {
        if (this.mConnectionState != 2) {
            String msg = this.useAccessibility() ? "UiAutomation not connected, " : "UiAutomation not connected: Accessibility-dependent method called with FLAG_DONT_USE_ACCESSIBILITY set, ";
            throw new IllegalStateException(msg + this);
        }
    }

    private void warnIfBetterCommand(String cmd) {
        if (cmd.startsWith("pm grant ")) {
            Log.w(LOG_TAG, "UiAutomation.grantRuntimePermission() is more robust and should be used instead of 'pm grant'");
        } else if (cmd.startsWith("pm revoke ")) {
            Log.w(LOG_TAG, "UiAutomation.revokeRuntimePermission() is more robust and should be used instead of 'pm revoke'");
        }
    }

    private boolean useAccessibility() {
        return (this.mFlags & 2) == 0;
    }

    @RavenwoodReplace(reason="Always use DEFAULT_DISPLAY")
    private static int getDisplayId(Context context) {
        Preconditions.checkArgument(context != null, "Context cannot be null!");
        UserManager userManager = context.getSystemService(UserManager.class);
        if (!userManager.isVisibleBackgroundUsersSupported()) {
            return 0;
        }
        int displayId = context.getDisplayId();
        if (displayId == -1) {
            Log.e(LOG_TAG, "UiAutomation created UI context with invalid display id, assuming it's running in the display assigned to the user");
            return UiAutomation.getMainDisplayIdAssignedToUser(context, userManager);
        }
        if (displayId != 0) {
            return displayId;
        }
        int userDisplayId = UiAutomation.getMainDisplayIdAssignedToUser(context, userManager);
        return userDisplayId;
    }

    private static int getDisplayId$ravenwood(Context context) {
        return 0;
    }

    private static int getMainDisplayIdAssignedToUser(Context context, UserManager userManager) {
        if (!userManager.isUserVisible()) {
            Log.e(LOG_TAG, "User (" + context.getUserId() + ") is not visible, using DEFAULT_DISPLAY");
            return 0;
        }
        return userManager.getMainDisplayIdAssignedToUser();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int FAILED = 3;
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper {
        public IAccessibilityServiceClientImpl(UiAutomation uiAutomation, Looper looper, final int generationId) {
            super(null, looper, new AccessibilityService.Callbacks(){
                private final int mGenerationId;
                {
                    this.mGenerationId = generationId;
                }

                private boolean isGenerationChangedLocked() {
                    return this.mGenerationId != UiAutomation.this.mGenerationId;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void init(int connectionId, IBinder windowToken) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        if (this.isGenerationChangedLocked()) {
                            return;
                        }
                        UiAutomation.this.mConnectionState = 2;
                        UiAutomation.this.mConnectionId = connectionId;
                        UiAutomation.this.mLock.notifyAll();
                    }
                    if (_Original_Build.IS_DEBUGGABLE) {
                        Log.v(LOG_TAG, "Init " + UiAutomation.this);
                    }
                }

                @Override
                public void onServiceConnected() {
                }

                @Override
                public void onInterrupt() {
                }

                @Override
                public void onSystemActionsChanged() {
                }

                @Override
                public void createImeSession(IAccessibilityInputMethodSessionCallback callback) {
                }

                @Override
                public void startInput(@Nullable RemoteAccessibilityInputConnection inputConnection, @NonNull EditorInfo editorInfo, boolean restarting) {
                }

                @Override
                public boolean onGesture(AccessibilityGestureEvent gestureEvent) {
                    return false;
                }

                @Override
                public void onMotionEvent(MotionEvent event) {
                }

                @Override
                public void onTouchStateChanged(int displayId, int state) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onAccessibilityEvent(AccessibilityEvent event) {
                    OnAccessibilityEventListener listener;
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        if (this.isGenerationChangedLocked()) {
                            return;
                        }
                        UiAutomation.this.mLastEventTimeMillis = Math.max(UiAutomation.this.mLastEventTimeMillis, event.getEventTime());
                        if (UiAutomation.this.mCurrentEventWatchersCount > 0) {
                            UiAutomation.this.mEventQueue.add(AccessibilityEvent.obtain(event));
                        }
                        UiAutomation.this.mLock.notifyAll();
                        listener = UiAutomation.this.mOnAccessibilityEventListener;
                    }
                    if (listener != null) {
                        UiAutomation.this.mLocalCallbackHandler.sendMessage(PooledLambda.obtainMessage(OnAccessibilityEventListener::onAccessibilityEvent, listener, AccessibilityEvent.obtain(event)));
                    }
                }

                @Override
                public boolean onKeyEvent(KeyEvent event) {
                    return false;
                }

                @Override
                public void onMagnificationChanged(int displayId, @NonNull Region region, MagnificationConfig config) {
                }

                @Override
                public void onSoftKeyboardShowModeChanged(int showMode) {
                }

                @Override
                public void onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                }

                @Override
                public void onFingerprintCapturingGesturesChanged(boolean active) {
                }

                @Override
                public void onFingerprintGesture(int gesture) {
                }

                @Override
                public void onAccessibilityButtonClicked(int displayId) {
                }

                @Override
                public void onAccessibilityButtonAvailabilityChanged(boolean available) {
                }
            });
        }
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }
}

