/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.AutomaticZenRule;
import android.app.ICallNotificationEventCallback;
import android.app.ITransientNotification;
import android.app.ITransientNotificationCallback;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationHistory;
import android.app.NotificationManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.notification.Adjustment;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.INotificationListener;
import android.service.notification.NotificationListenerFilter;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenDeviceEffects;
import android.service.notification.ZenModeConfig;
import android.service.notification.ZenPolicy;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface INotificationManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:50:1:50:25")
    public void cancelAllNotifications(String var1, int var2) throws RemoteException;

    public void clearData(String var1, int var2, boolean var3) throws RemoteException;

    public boolean enqueueTextToast(String var1, IBinder var2, CharSequence var3, int var4, boolean var5, int var6, ITransientNotificationCallback var7) throws RemoteException;

    public boolean enqueueToast(String var1, IBinder var2, ITransientNotification var3, int var4, boolean var5, int var6) throws RemoteException;

    public void cancelToast(String var1, IBinder var2) throws RemoteException;

    public void finishToken(String var1, IBinder var2) throws RemoteException;

    public void enqueueNotificationWithTag(String var1, String var2, String var3, int var4, Notification var5, int var6) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:61:1:61:25")
    public void cancelNotificationWithTag(String var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public boolean isInCall(String var1, int var2) throws RemoteException;

    public void setShowBadge(String var1, int var2, boolean var3) throws RemoteException;

    public boolean canShowBadge(String var1, int var2) throws RemoteException;

    public boolean hasSentValidMsg(String var1, int var2) throws RemoteException;

    public boolean isInInvalidMsgState(String var1, int var2) throws RemoteException;

    public boolean hasUserDemotedInvalidMsgApp(String var1, int var2) throws RemoteException;

    public void setInvalidMsgAppDemoted(String var1, int var2, boolean var3) throws RemoteException;

    public boolean hasSentValidBubble(String var1, int var2) throws RemoteException;

    public void setNotificationsEnabledForPackage(String var1, int var2, boolean var3) throws RemoteException;

    public void setNotificationsEnabledWithImportanceLockForPackage(String var1, int var2, boolean var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:80:1:80:25")
    public boolean areNotificationsEnabledForPackage(String var1, int var2) throws RemoteException;

    public boolean areNotificationsEnabled(String var1) throws RemoteException;

    public int getPackageImportance(String var1) throws RemoteException;

    public boolean isImportanceLocked(String var1, int var2) throws RemoteException;

    public List<String> getAllowedAssistantAdjustments(String var1) throws RemoteException;

    public List<String> getAllowedAssistantAdjustmentsForUser(int var1) throws RemoteException;

    public void allowAssistantAdjustment(int var1, String var2) throws RemoteException;

    public void disallowAssistantAdjustment(int var1, String var2) throws RemoteException;

    public boolean shouldHideSilentStatusIcons(String var1) throws RemoteException;

    public void setHideSilentStatusIcons(boolean var1) throws RemoteException;

    public void setBubblesAllowed(String var1, int var2, int var3) throws RemoteException;

    public boolean areBubblesAllowed(String var1) throws RemoteException;

    public boolean areBubblesEnabled(UserHandle var1) throws RemoteException;

    public int getBubblePreferenceForPackage(String var1, int var2) throws RemoteException;

    public void createNotificationChannelGroups(String var1, ParceledListSlice var2) throws RemoteException;

    public void createNotificationChannels(String var1, ParceledListSlice var2) throws RemoteException;

    public void createNotificationChannelsForPackage(String var1, int var2, ParceledListSlice var3) throws RemoteException;

    public ParceledListSlice getConversations(boolean var1) throws RemoteException;

    public ParceledListSlice getConversationsForPackage(String var1, int var2) throws RemoteException;

    public ParceledListSlice getNotificationChannelGroupsForPackage(String var1, int var2, boolean var3) throws RemoteException;

    public NotificationChannelGroup getNotificationChannelGroupForPackage(String var1, String var2, int var3) throws RemoteException;

    public NotificationChannelGroup getPopulatedNotificationChannelGroupForPackage(String var1, int var2, String var3, boolean var4) throws RemoteException;

    public ParceledListSlice getRecentBlockedNotificationChannelGroupsForPackage(String var1, int var2) throws RemoteException;

    public void updateNotificationChannelGroupForPackage(String var1, int var2, NotificationChannelGroup var3) throws RemoteException;

    public void updateNotificationChannelForPackage(String var1, int var2, NotificationChannel var3) throws RemoteException;

    public void unlockNotificationChannel(String var1, int var2, String var3) throws RemoteException;

    public void unlockAllNotificationChannels() throws RemoteException;

    public NotificationChannel getNotificationChannel(String var1, int var2, String var3, String var4) throws RemoteException;

    public NotificationChannel getConversationNotificationChannel(String var1, int var2, String var3, String var4, boolean var5, String var6) throws RemoteException;

    public void createConversationNotificationChannelForPackage(String var1, int var2, NotificationChannel var3, String var4) throws RemoteException;

    public NotificationChannel getNotificationChannelForPackage(String var1, int var2, String var3, String var4, boolean var5) throws RemoteException;

    public void deleteNotificationChannel(String var1, String var2) throws RemoteException;

    public ParceledListSlice getNotificationChannels(String var1, String var2, int var3) throws RemoteException;

    public ParceledListSlice getNotificationChannelsForPackage(String var1, int var2, boolean var3) throws RemoteException;

    public int getNumNotificationChannelsForPackage(String var1, int var2, boolean var3) throws RemoteException;

    public int getDeletedChannelCount(String var1, int var2) throws RemoteException;

    public int getBlockedChannelCount(String var1, int var2) throws RemoteException;

    public void deleteNotificationChannelGroup(String var1, String var2) throws RemoteException;

    public NotificationChannelGroup getNotificationChannelGroup(String var1, String var2) throws RemoteException;

    public ParceledListSlice getNotificationChannelGroups(String var1) throws RemoteException;

    public ParceledListSlice getNotificationChannelGroupsWithoutChannels(String var1) throws RemoteException;

    public boolean onlyHasDefaultChannel(String var1, int var2) throws RemoteException;

    public boolean areChannelsBypassingDnd() throws RemoteException;

    public ParceledListSlice getNotificationChannelsBypassingDnd(String var1, int var2) throws RemoteException;

    public ParceledListSlice getPackagesBypassingDnd(int var1) throws RemoteException;

    public List<String> getPackagesWithAnyChannels(int var1) throws RemoteException;

    public boolean isPackagePaused(String var1) throws RemoteException;

    public void deleteNotificationHistoryItem(String var1, int var2, long var3) throws RemoteException;

    public boolean isPermissionFixed(String var1, int var2) throws RemoteException;

    public void silenceNotificationSound() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:139:1:139:25")
    public StatusBarNotification[] getActiveNotifications(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_NOTIFICATIONS")
    public StatusBarNotification[] getActiveNotificationsWithAttribution(String var1, String var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:144:1:144:69")
    public StatusBarNotification[] getHistoricalNotifications(String var1, int var2, boolean var3) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_NOTIFICATIONS")
    public StatusBarNotification[] getHistoricalNotificationsWithAttribution(String var1, String var2, int var3, boolean var4) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_NOTIFICATIONS")
    public NotificationHistory getNotificationHistory(String var1, String var2) throws RemoteException;

    public void registerListener(INotificationListener var1, ComponentName var2, int var3) throws RemoteException;

    public void unregisterListener(INotificationListener var1, int var2) throws RemoteException;

    public void cancelNotificationFromListener(INotificationListener var1, String var2, String var3, int var4) throws RemoteException;

    public void cancelNotificationsFromListener(INotificationListener var1, String[] var2) throws RemoteException;

    public void snoozeNotificationUntilContextFromListener(INotificationListener var1, String var2, String var3) throws RemoteException;

    public void snoozeNotificationUntilFromListener(INotificationListener var1, String var2, long var3) throws RemoteException;

    public void requestBindListener(ComponentName var1) throws RemoteException;

    public void requestUnbindListener(INotificationListener var1) throws RemoteException;

    public void requestUnbindListenerComponent(ComponentName var1) throws RemoteException;

    public void requestBindProvider(ComponentName var1) throws RemoteException;

    public void requestUnbindProvider(IConditionProvider var1) throws RemoteException;

    public void setNotificationsShownFromListener(INotificationListener var1, String[] var2) throws RemoteException;

    public ParceledListSlice getActiveNotificationsFromListener(INotificationListener var1, String[] var2, int var3) throws RemoteException;

    public ParceledListSlice getSnoozedNotificationsFromListener(INotificationListener var1, int var2) throws RemoteException;

    public void clearRequestedListenerHints(INotificationListener var1) throws RemoteException;

    public void requestHintsFromListener(INotificationListener var1, int var2) throws RemoteException;

    public int getHintsFromListener(INotificationListener var1) throws RemoteException;

    public int getHintsFromListenerNoToken() throws RemoteException;

    public void requestInterruptionFilterFromListener(INotificationListener var1, int var2) throws RemoteException;

    public int getInterruptionFilterFromListener(INotificationListener var1) throws RemoteException;

    public void setOnNotificationPostedTrimFromListener(INotificationListener var1, int var2) throws RemoteException;

    public void setInterruptionFilter(String var1, int var2, boolean var3) throws RemoteException;

    public NotificationChannel createConversationNotificationChannelForPackageFromPrivilegedListener(INotificationListener var1, String var2, UserHandle var3, String var4, String var5) throws RemoteException;

    public void updateNotificationChannelGroupFromPrivilegedListener(INotificationListener var1, String var2, UserHandle var3, NotificationChannelGroup var4) throws RemoteException;

    public void updateNotificationChannelFromPrivilegedListener(INotificationListener var1, String var2, UserHandle var3, NotificationChannel var4) throws RemoteException;

    public ParceledListSlice getNotificationChannelsFromPrivilegedListener(INotificationListener var1, String var2, UserHandle var3) throws RemoteException;

    public ParceledListSlice getNotificationChannelGroupsFromPrivilegedListener(INotificationListener var1, String var2, UserHandle var3) throws RemoteException;

    public void applyEnqueuedAdjustmentFromAssistant(INotificationListener var1, Adjustment var2) throws RemoteException;

    public void applyAdjustmentFromAssistant(INotificationListener var1, Adjustment var2) throws RemoteException;

    public void applyAdjustmentsFromAssistant(INotificationListener var1, List<Adjustment> var2) throws RemoteException;

    public void unsnoozeNotificationFromAssistant(INotificationListener var1, String var2) throws RemoteException;

    public void unsnoozeNotificationFromSystemListener(INotificationListener var1, String var2) throws RemoteException;

    public ComponentName getEffectsSuppressor() throws RemoteException;

    public boolean matchesCallFilter(Bundle var1) throws RemoteException;

    public void cleanUpCallersAfter(long var1) throws RemoteException;

    public boolean isSystemConditionProviderEnabled(String var1) throws RemoteException;

    public boolean isNotificationListenerAccessGranted(ComponentName var1) throws RemoteException;

    public boolean isNotificationListenerAccessGrantedForUser(ComponentName var1, int var2) throws RemoteException;

    public boolean isNotificationAssistantAccessGranted(ComponentName var1) throws RemoteException;

    public void setNotificationListenerAccessGranted(ComponentName var1, boolean var2, boolean var3) throws RemoteException;

    public void setNotificationAssistantAccessGranted(ComponentName var1, boolean var2) throws RemoteException;

    public void setNotificationListenerAccessGrantedForUser(ComponentName var1, int var2, boolean var3, boolean var4) throws RemoteException;

    public void setNotificationAssistantAccessGrantedForUser(ComponentName var1, int var2, boolean var3) throws RemoteException;

    public List<String> getEnabledNotificationListenerPackages() throws RemoteException;

    public List<ComponentName> getEnabledNotificationListeners(int var1) throws RemoteException;

    public ComponentName getAllowedNotificationAssistantForUser(int var1) throws RemoteException;

    public ComponentName getAllowedNotificationAssistant() throws RemoteException;

    public ComponentName getDefaultNotificationAssistant() throws RemoteException;

    public void setNASMigrationDoneAndResetDefault(int var1, boolean var2) throws RemoteException;

    public boolean hasEnabledNotificationListener(String var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:213:1:213:25")
    public int getZenMode() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/INotificationManager.aidl:215:1:215:25")
    public ZenModeConfig getZenModeConfig() throws RemoteException;

    public NotificationManager.Policy getConsolidatedNotificationPolicy() throws RemoteException;

    public void setZenMode(int var1, Uri var2, String var3, boolean var4) throws RemoteException;

    public void notifyConditions(String var1, IConditionProvider var2, Condition[] var3) throws RemoteException;

    public boolean isNotificationPolicyAccessGranted(String var1) throws RemoteException;

    public NotificationManager.Policy getNotificationPolicy(String var1) throws RemoteException;

    public void setNotificationPolicy(String var1, NotificationManager.Policy var2, boolean var3) throws RemoteException;

    public boolean isNotificationPolicyAccessGrantedForPackage(String var1) throws RemoteException;

    public void setNotificationPolicyAccessGranted(String var1, boolean var2) throws RemoteException;

    public void setNotificationPolicyAccessGrantedForUser(String var1, int var2, boolean var3) throws RemoteException;

    public ZenPolicy getDefaultZenPolicy() throws RemoteException;

    public AutomaticZenRule getAutomaticZenRule(String var1) throws RemoteException;

    public ParceledListSlice getAutomaticZenRules() throws RemoteException;

    public String addAutomaticZenRule(AutomaticZenRule var1, String var2, boolean var3) throws RemoteException;

    public boolean updateAutomaticZenRule(String var1, AutomaticZenRule var2, boolean var3) throws RemoteException;

    public boolean removeAutomaticZenRule(String var1, boolean var2) throws RemoteException;

    public boolean removeAutomaticZenRules(String var1, boolean var2) throws RemoteException;

    public int getRuleInstanceCount(ComponentName var1) throws RemoteException;

    public int getAutomaticZenRuleState(String var1) throws RemoteException;

    public void setAutomaticZenRuleState(String var1, Condition var2) throws RemoteException;

    public void setManualZenRuleDeviceEffects(ZenDeviceEffects var1) throws RemoteException;

    public byte[] getBackupPayload(int var1) throws RemoteException;

    public void applyRestore(byte[] var1, int var2) throws RemoteException;

    public ParceledListSlice getAppActiveNotifications(String var1, int var2) throws RemoteException;

    public void setNotificationDelegate(String var1, String var2) throws RemoteException;

    public String getNotificationDelegate(String var1) throws RemoteException;

    public boolean canNotifyAsPackage(String var1, String var2, int var3) throws RemoteException;

    public boolean canUseFullScreenIntent(AttributionSource var1) throws RemoteException;

    public void setPrivateNotificationsAllowed(boolean var1) throws RemoteException;

    public boolean getPrivateNotificationsAllowed() throws RemoteException;

    public long pullStats(long var1, int var3, boolean var4, List<ParcelFileDescriptor> var5) throws RemoteException;

    public NotificationListenerFilter getListenerFilter(ComponentName var1, int var2) throws RemoteException;

    public void setListenerFilter(ComponentName var1, int var2, NotificationListenerFilter var3) throws RemoteException;

    public void migrateNotificationFilter(INotificationListener var1, int var2, List<String> var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_TOAST_RATE_LIMITING")
    public void setToastRateLimitingEnabled(boolean var1) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"})
    public void registerCallNotificationEventListener(String var1, UserHandle var2, ICallNotificationEventCallback var3) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"})
    public void unregisterCallNotificationEventListener(String var1, UserHandle var2, ICallNotificationEventCallback var3) throws RemoteException;

    public void setCanBePromoted(String var1, int var2, boolean var3, boolean var4) throws RemoteException;

    public boolean appCanBePromoted(String var1, int var2) throws RemoteException;

    public boolean canBePromoted(String var1) throws RemoteException;

    public void setAdjustmentTypeSupportedState(INotificationListener var1, String var2, boolean var3) throws RemoteException;

    public List<String> getUnsupportedAdjustmentTypes() throws RemoteException;

    public int[] getAllowedClassificationTypes() throws RemoteException;

    public void setAssistantClassificationTypeState(int var1, boolean var2) throws RemoteException;

    public String[] getAdjustmentDeniedPackages(int var1, String var2) throws RemoteException;

    public boolean isAdjustmentSupportedForPackage(int var1, String var2, String var3) throws RemoteException;

    public void setAdjustmentSupportedForPackage(int var1, String var2, String var3, boolean var4) throws RemoteException;

    public void incrementCounter(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.app.INotificationManager";
        static final int TRANSACTION_cancelAllNotifications = 1;
        static final int TRANSACTION_clearData = 2;
        static final int TRANSACTION_enqueueTextToast = 3;
        static final int TRANSACTION_enqueueToast = 4;
        static final int TRANSACTION_cancelToast = 5;
        static final int TRANSACTION_finishToken = 6;
        static final int TRANSACTION_enqueueNotificationWithTag = 7;
        static final int TRANSACTION_cancelNotificationWithTag = 8;
        static final int TRANSACTION_isInCall = 9;
        static final int TRANSACTION_setShowBadge = 10;
        static final int TRANSACTION_canShowBadge = 11;
        static final int TRANSACTION_hasSentValidMsg = 12;
        static final int TRANSACTION_isInInvalidMsgState = 13;
        static final int TRANSACTION_hasUserDemotedInvalidMsgApp = 14;
        static final int TRANSACTION_setInvalidMsgAppDemoted = 15;
        static final int TRANSACTION_hasSentValidBubble = 16;
        static final int TRANSACTION_setNotificationsEnabledForPackage = 17;
        static final int TRANSACTION_setNotificationsEnabledWithImportanceLockForPackage = 18;
        static final int TRANSACTION_areNotificationsEnabledForPackage = 19;
        static final int TRANSACTION_areNotificationsEnabled = 20;
        static final int TRANSACTION_getPackageImportance = 21;
        static final int TRANSACTION_isImportanceLocked = 22;
        static final int TRANSACTION_getAllowedAssistantAdjustments = 23;
        static final int TRANSACTION_getAllowedAssistantAdjustmentsForUser = 24;
        static final int TRANSACTION_allowAssistantAdjustment = 25;
        static final int TRANSACTION_disallowAssistantAdjustment = 26;
        static final int TRANSACTION_shouldHideSilentStatusIcons = 27;
        static final int TRANSACTION_setHideSilentStatusIcons = 28;
        static final int TRANSACTION_setBubblesAllowed = 29;
        static final int TRANSACTION_areBubblesAllowed = 30;
        static final int TRANSACTION_areBubblesEnabled = 31;
        static final int TRANSACTION_getBubblePreferenceForPackage = 32;
        static final int TRANSACTION_createNotificationChannelGroups = 33;
        static final int TRANSACTION_createNotificationChannels = 34;
        static final int TRANSACTION_createNotificationChannelsForPackage = 35;
        static final int TRANSACTION_getConversations = 36;
        static final int TRANSACTION_getConversationsForPackage = 37;
        static final int TRANSACTION_getNotificationChannelGroupsForPackage = 38;
        static final int TRANSACTION_getNotificationChannelGroupForPackage = 39;
        static final int TRANSACTION_getPopulatedNotificationChannelGroupForPackage = 40;
        static final int TRANSACTION_getRecentBlockedNotificationChannelGroupsForPackage = 41;
        static final int TRANSACTION_updateNotificationChannelGroupForPackage = 42;
        static final int TRANSACTION_updateNotificationChannelForPackage = 43;
        static final int TRANSACTION_unlockNotificationChannel = 44;
        static final int TRANSACTION_unlockAllNotificationChannels = 45;
        static final int TRANSACTION_getNotificationChannel = 46;
        static final int TRANSACTION_getConversationNotificationChannel = 47;
        static final int TRANSACTION_createConversationNotificationChannelForPackage = 48;
        static final int TRANSACTION_getNotificationChannelForPackage = 49;
        static final int TRANSACTION_deleteNotificationChannel = 50;
        static final int TRANSACTION_getNotificationChannels = 51;
        static final int TRANSACTION_getNotificationChannelsForPackage = 52;
        static final int TRANSACTION_getNumNotificationChannelsForPackage = 53;
        static final int TRANSACTION_getDeletedChannelCount = 54;
        static final int TRANSACTION_getBlockedChannelCount = 55;
        static final int TRANSACTION_deleteNotificationChannelGroup = 56;
        static final int TRANSACTION_getNotificationChannelGroup = 57;
        static final int TRANSACTION_getNotificationChannelGroups = 58;
        static final int TRANSACTION_getNotificationChannelGroupsWithoutChannels = 59;
        static final int TRANSACTION_onlyHasDefaultChannel = 60;
        static final int TRANSACTION_areChannelsBypassingDnd = 61;
        static final int TRANSACTION_getNotificationChannelsBypassingDnd = 62;
        static final int TRANSACTION_getPackagesBypassingDnd = 63;
        static final int TRANSACTION_getPackagesWithAnyChannels = 64;
        static final int TRANSACTION_isPackagePaused = 65;
        static final int TRANSACTION_deleteNotificationHistoryItem = 66;
        static final int TRANSACTION_isPermissionFixed = 67;
        static final int TRANSACTION_silenceNotificationSound = 68;
        static final int TRANSACTION_getActiveNotifications = 69;
        static final int TRANSACTION_getActiveNotificationsWithAttribution = 70;
        static final int TRANSACTION_getHistoricalNotifications = 71;
        static final int TRANSACTION_getHistoricalNotificationsWithAttribution = 72;
        static final int TRANSACTION_getNotificationHistory = 73;
        static final int TRANSACTION_registerListener = 74;
        static final int TRANSACTION_unregisterListener = 75;
        static final int TRANSACTION_cancelNotificationFromListener = 76;
        static final int TRANSACTION_cancelNotificationsFromListener = 77;
        static final int TRANSACTION_snoozeNotificationUntilContextFromListener = 78;
        static final int TRANSACTION_snoozeNotificationUntilFromListener = 79;
        static final int TRANSACTION_requestBindListener = 80;
        static final int TRANSACTION_requestUnbindListener = 81;
        static final int TRANSACTION_requestUnbindListenerComponent = 82;
        static final int TRANSACTION_requestBindProvider = 83;
        static final int TRANSACTION_requestUnbindProvider = 84;
        static final int TRANSACTION_setNotificationsShownFromListener = 85;
        static final int TRANSACTION_getActiveNotificationsFromListener = 86;
        static final int TRANSACTION_getSnoozedNotificationsFromListener = 87;
        static final int TRANSACTION_clearRequestedListenerHints = 88;
        static final int TRANSACTION_requestHintsFromListener = 89;
        static final int TRANSACTION_getHintsFromListener = 90;
        static final int TRANSACTION_getHintsFromListenerNoToken = 91;
        static final int TRANSACTION_requestInterruptionFilterFromListener = 92;
        static final int TRANSACTION_getInterruptionFilterFromListener = 93;
        static final int TRANSACTION_setOnNotificationPostedTrimFromListener = 94;
        static final int TRANSACTION_setInterruptionFilter = 95;
        static final int TRANSACTION_createConversationNotificationChannelForPackageFromPrivilegedListener = 96;
        static final int TRANSACTION_updateNotificationChannelGroupFromPrivilegedListener = 97;
        static final int TRANSACTION_updateNotificationChannelFromPrivilegedListener = 98;
        static final int TRANSACTION_getNotificationChannelsFromPrivilegedListener = 99;
        static final int TRANSACTION_getNotificationChannelGroupsFromPrivilegedListener = 100;
        static final int TRANSACTION_applyEnqueuedAdjustmentFromAssistant = 101;
        static final int TRANSACTION_applyAdjustmentFromAssistant = 102;
        static final int TRANSACTION_applyAdjustmentsFromAssistant = 103;
        static final int TRANSACTION_unsnoozeNotificationFromAssistant = 104;
        static final int TRANSACTION_unsnoozeNotificationFromSystemListener = 105;
        static final int TRANSACTION_getEffectsSuppressor = 106;
        static final int TRANSACTION_matchesCallFilter = 107;
        static final int TRANSACTION_cleanUpCallersAfter = 108;
        static final int TRANSACTION_isSystemConditionProviderEnabled = 109;
        static final int TRANSACTION_isNotificationListenerAccessGranted = 110;
        static final int TRANSACTION_isNotificationListenerAccessGrantedForUser = 111;
        static final int TRANSACTION_isNotificationAssistantAccessGranted = 112;
        static final int TRANSACTION_setNotificationListenerAccessGranted = 113;
        static final int TRANSACTION_setNotificationAssistantAccessGranted = 114;
        static final int TRANSACTION_setNotificationListenerAccessGrantedForUser = 115;
        static final int TRANSACTION_setNotificationAssistantAccessGrantedForUser = 116;
        static final int TRANSACTION_getEnabledNotificationListenerPackages = 117;
        static final int TRANSACTION_getEnabledNotificationListeners = 118;
        static final int TRANSACTION_getAllowedNotificationAssistantForUser = 119;
        static final int TRANSACTION_getAllowedNotificationAssistant = 120;
        static final int TRANSACTION_getDefaultNotificationAssistant = 121;
        static final int TRANSACTION_setNASMigrationDoneAndResetDefault = 122;
        static final int TRANSACTION_hasEnabledNotificationListener = 123;
        static final int TRANSACTION_getZenMode = 124;
        static final int TRANSACTION_getZenModeConfig = 125;
        static final int TRANSACTION_getConsolidatedNotificationPolicy = 126;
        static final int TRANSACTION_setZenMode = 127;
        static final int TRANSACTION_notifyConditions = 128;
        static final int TRANSACTION_isNotificationPolicyAccessGranted = 129;
        static final int TRANSACTION_getNotificationPolicy = 130;
        static final int TRANSACTION_setNotificationPolicy = 131;
        static final int TRANSACTION_isNotificationPolicyAccessGrantedForPackage = 132;
        static final int TRANSACTION_setNotificationPolicyAccessGranted = 133;
        static final int TRANSACTION_setNotificationPolicyAccessGrantedForUser = 134;
        static final int TRANSACTION_getDefaultZenPolicy = 135;
        static final int TRANSACTION_getAutomaticZenRule = 136;
        static final int TRANSACTION_getAutomaticZenRules = 137;
        static final int TRANSACTION_addAutomaticZenRule = 138;
        static final int TRANSACTION_updateAutomaticZenRule = 139;
        static final int TRANSACTION_removeAutomaticZenRule = 140;
        static final int TRANSACTION_removeAutomaticZenRules = 141;
        static final int TRANSACTION_getRuleInstanceCount = 142;
        static final int TRANSACTION_getAutomaticZenRuleState = 143;
        static final int TRANSACTION_setAutomaticZenRuleState = 144;
        static final int TRANSACTION_setManualZenRuleDeviceEffects = 145;
        static final int TRANSACTION_getBackupPayload = 146;
        static final int TRANSACTION_applyRestore = 147;
        static final int TRANSACTION_getAppActiveNotifications = 148;
        static final int TRANSACTION_setNotificationDelegate = 149;
        static final int TRANSACTION_getNotificationDelegate = 150;
        static final int TRANSACTION_canNotifyAsPackage = 151;
        static final int TRANSACTION_canUseFullScreenIntent = 152;
        static final int TRANSACTION_setPrivateNotificationsAllowed = 153;
        static final int TRANSACTION_getPrivateNotificationsAllowed = 154;
        static final int TRANSACTION_pullStats = 155;
        static final int TRANSACTION_getListenerFilter = 156;
        static final int TRANSACTION_setListenerFilter = 157;
        static final int TRANSACTION_migrateNotificationFilter = 158;
        static final int TRANSACTION_setToastRateLimitingEnabled = 159;
        static final int TRANSACTION_registerCallNotificationEventListener = 160;
        static final String[] PERMISSIONS_registerCallNotificationEventListener = new String[]{"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"};
        static final int TRANSACTION_unregisterCallNotificationEventListener = 161;
        static final String[] PERMISSIONS_unregisterCallNotificationEventListener = new String[]{"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"};
        static final int TRANSACTION_setCanBePromoted = 162;
        static final int TRANSACTION_appCanBePromoted = 163;
        static final int TRANSACTION_canBePromoted = 164;
        static final int TRANSACTION_setAdjustmentTypeSupportedState = 165;
        static final int TRANSACTION_getUnsupportedAdjustmentTypes = 166;
        static final int TRANSACTION_getAllowedClassificationTypes = 167;
        static final int TRANSACTION_setAssistantClassificationTypeState = 168;
        static final int TRANSACTION_getAdjustmentDeniedPackages = 169;
        static final int TRANSACTION_isAdjustmentSupportedForPackage = 170;
        static final int TRANSACTION_setAdjustmentSupportedForPackage = 171;
        static final int TRANSACTION_incrementCounter = 172;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static INotificationManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INotificationManager) {
                return (INotificationManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "cancelAllNotifications";
                }
                case 2: {
                    return "clearData";
                }
                case 3: {
                    return "enqueueTextToast";
                }
                case 4: {
                    return "enqueueToast";
                }
                case 5: {
                    return "cancelToast";
                }
                case 6: {
                    return "finishToken";
                }
                case 7: {
                    return "enqueueNotificationWithTag";
                }
                case 8: {
                    return "cancelNotificationWithTag";
                }
                case 9: {
                    return "isInCall";
                }
                case 10: {
                    return "setShowBadge";
                }
                case 11: {
                    return "canShowBadge";
                }
                case 12: {
                    return "hasSentValidMsg";
                }
                case 13: {
                    return "isInInvalidMsgState";
                }
                case 14: {
                    return "hasUserDemotedInvalidMsgApp";
                }
                case 15: {
                    return "setInvalidMsgAppDemoted";
                }
                case 16: {
                    return "hasSentValidBubble";
                }
                case 17: {
                    return "setNotificationsEnabledForPackage";
                }
                case 18: {
                    return "setNotificationsEnabledWithImportanceLockForPackage";
                }
                case 19: {
                    return "areNotificationsEnabledForPackage";
                }
                case 20: {
                    return "areNotificationsEnabled";
                }
                case 21: {
                    return "getPackageImportance";
                }
                case 22: {
                    return "isImportanceLocked";
                }
                case 23: {
                    return "getAllowedAssistantAdjustments";
                }
                case 24: {
                    return "getAllowedAssistantAdjustmentsForUser";
                }
                case 25: {
                    return "allowAssistantAdjustment";
                }
                case 26: {
                    return "disallowAssistantAdjustment";
                }
                case 27: {
                    return "shouldHideSilentStatusIcons";
                }
                case 28: {
                    return "setHideSilentStatusIcons";
                }
                case 29: {
                    return "setBubblesAllowed";
                }
                case 30: {
                    return "areBubblesAllowed";
                }
                case 31: {
                    return "areBubblesEnabled";
                }
                case 32: {
                    return "getBubblePreferenceForPackage";
                }
                case 33: {
                    return "createNotificationChannelGroups";
                }
                case 34: {
                    return "createNotificationChannels";
                }
                case 35: {
                    return "createNotificationChannelsForPackage";
                }
                case 36: {
                    return "getConversations";
                }
                case 37: {
                    return "getConversationsForPackage";
                }
                case 38: {
                    return "getNotificationChannelGroupsForPackage";
                }
                case 39: {
                    return "getNotificationChannelGroupForPackage";
                }
                case 40: {
                    return "getPopulatedNotificationChannelGroupForPackage";
                }
                case 41: {
                    return "getRecentBlockedNotificationChannelGroupsForPackage";
                }
                case 42: {
                    return "updateNotificationChannelGroupForPackage";
                }
                case 43: {
                    return "updateNotificationChannelForPackage";
                }
                case 44: {
                    return "unlockNotificationChannel";
                }
                case 45: {
                    return "unlockAllNotificationChannels";
                }
                case 46: {
                    return "getNotificationChannel";
                }
                case 47: {
                    return "getConversationNotificationChannel";
                }
                case 48: {
                    return "createConversationNotificationChannelForPackage";
                }
                case 49: {
                    return "getNotificationChannelForPackage";
                }
                case 50: {
                    return "deleteNotificationChannel";
                }
                case 51: {
                    return "getNotificationChannels";
                }
                case 52: {
                    return "getNotificationChannelsForPackage";
                }
                case 53: {
                    return "getNumNotificationChannelsForPackage";
                }
                case 54: {
                    return "getDeletedChannelCount";
                }
                case 55: {
                    return "getBlockedChannelCount";
                }
                case 56: {
                    return "deleteNotificationChannelGroup";
                }
                case 57: {
                    return "getNotificationChannelGroup";
                }
                case 58: {
                    return "getNotificationChannelGroups";
                }
                case 59: {
                    return "getNotificationChannelGroupsWithoutChannels";
                }
                case 60: {
                    return "onlyHasDefaultChannel";
                }
                case 61: {
                    return "areChannelsBypassingDnd";
                }
                case 62: {
                    return "getNotificationChannelsBypassingDnd";
                }
                case 63: {
                    return "getPackagesBypassingDnd";
                }
                case 64: {
                    return "getPackagesWithAnyChannels";
                }
                case 65: {
                    return "isPackagePaused";
                }
                case 66: {
                    return "deleteNotificationHistoryItem";
                }
                case 67: {
                    return "isPermissionFixed";
                }
                case 68: {
                    return "silenceNotificationSound";
                }
                case 69: {
                    return "getActiveNotifications";
                }
                case 70: {
                    return "getActiveNotificationsWithAttribution";
                }
                case 71: {
                    return "getHistoricalNotifications";
                }
                case 72: {
                    return "getHistoricalNotificationsWithAttribution";
                }
                case 73: {
                    return "getNotificationHistory";
                }
                case 74: {
                    return "registerListener";
                }
                case 75: {
                    return "unregisterListener";
                }
                case 76: {
                    return "cancelNotificationFromListener";
                }
                case 77: {
                    return "cancelNotificationsFromListener";
                }
                case 78: {
                    return "snoozeNotificationUntilContextFromListener";
                }
                case 79: {
                    return "snoozeNotificationUntilFromListener";
                }
                case 80: {
                    return "requestBindListener";
                }
                case 81: {
                    return "requestUnbindListener";
                }
                case 82: {
                    return "requestUnbindListenerComponent";
                }
                case 83: {
                    return "requestBindProvider";
                }
                case 84: {
                    return "requestUnbindProvider";
                }
                case 85: {
                    return "setNotificationsShownFromListener";
                }
                case 86: {
                    return "getActiveNotificationsFromListener";
                }
                case 87: {
                    return "getSnoozedNotificationsFromListener";
                }
                case 88: {
                    return "clearRequestedListenerHints";
                }
                case 89: {
                    return "requestHintsFromListener";
                }
                case 90: {
                    return "getHintsFromListener";
                }
                case 91: {
                    return "getHintsFromListenerNoToken";
                }
                case 92: {
                    return "requestInterruptionFilterFromListener";
                }
                case 93: {
                    return "getInterruptionFilterFromListener";
                }
                case 94: {
                    return "setOnNotificationPostedTrimFromListener";
                }
                case 95: {
                    return "setInterruptionFilter";
                }
                case 96: {
                    return "createConversationNotificationChannelForPackageFromPrivilegedListener";
                }
                case 97: {
                    return "updateNotificationChannelGroupFromPrivilegedListener";
                }
                case 98: {
                    return "updateNotificationChannelFromPrivilegedListener";
                }
                case 99: {
                    return "getNotificationChannelsFromPrivilegedListener";
                }
                case 100: {
                    return "getNotificationChannelGroupsFromPrivilegedListener";
                }
                case 101: {
                    return "applyEnqueuedAdjustmentFromAssistant";
                }
                case 102: {
                    return "applyAdjustmentFromAssistant";
                }
                case 103: {
                    return "applyAdjustmentsFromAssistant";
                }
                case 104: {
                    return "unsnoozeNotificationFromAssistant";
                }
                case 105: {
                    return "unsnoozeNotificationFromSystemListener";
                }
                case 106: {
                    return "getEffectsSuppressor";
                }
                case 107: {
                    return "matchesCallFilter";
                }
                case 108: {
                    return "cleanUpCallersAfter";
                }
                case 109: {
                    return "isSystemConditionProviderEnabled";
                }
                case 110: {
                    return "isNotificationListenerAccessGranted";
                }
                case 111: {
                    return "isNotificationListenerAccessGrantedForUser";
                }
                case 112: {
                    return "isNotificationAssistantAccessGranted";
                }
                case 113: {
                    return "setNotificationListenerAccessGranted";
                }
                case 114: {
                    return "setNotificationAssistantAccessGranted";
                }
                case 115: {
                    return "setNotificationListenerAccessGrantedForUser";
                }
                case 116: {
                    return "setNotificationAssistantAccessGrantedForUser";
                }
                case 117: {
                    return "getEnabledNotificationListenerPackages";
                }
                case 118: {
                    return "getEnabledNotificationListeners";
                }
                case 119: {
                    return "getAllowedNotificationAssistantForUser";
                }
                case 120: {
                    return "getAllowedNotificationAssistant";
                }
                case 121: {
                    return "getDefaultNotificationAssistant";
                }
                case 122: {
                    return "setNASMigrationDoneAndResetDefault";
                }
                case 123: {
                    return "hasEnabledNotificationListener";
                }
                case 124: {
                    return "getZenMode";
                }
                case 125: {
                    return "getZenModeConfig";
                }
                case 126: {
                    return "getConsolidatedNotificationPolicy";
                }
                case 127: {
                    return "setZenMode";
                }
                case 128: {
                    return "notifyConditions";
                }
                case 129: {
                    return "isNotificationPolicyAccessGranted";
                }
                case 130: {
                    return "getNotificationPolicy";
                }
                case 131: {
                    return "setNotificationPolicy";
                }
                case 132: {
                    return "isNotificationPolicyAccessGrantedForPackage";
                }
                case 133: {
                    return "setNotificationPolicyAccessGranted";
                }
                case 134: {
                    return "setNotificationPolicyAccessGrantedForUser";
                }
                case 135: {
                    return "getDefaultZenPolicy";
                }
                case 136: {
                    return "getAutomaticZenRule";
                }
                case 137: {
                    return "getAutomaticZenRules";
                }
                case 138: {
                    return "addAutomaticZenRule";
                }
                case 139: {
                    return "updateAutomaticZenRule";
                }
                case 140: {
                    return "removeAutomaticZenRule";
                }
                case 141: {
                    return "removeAutomaticZenRules";
                }
                case 142: {
                    return "getRuleInstanceCount";
                }
                case 143: {
                    return "getAutomaticZenRuleState";
                }
                case 144: {
                    return "setAutomaticZenRuleState";
                }
                case 145: {
                    return "setManualZenRuleDeviceEffects";
                }
                case 146: {
                    return "getBackupPayload";
                }
                case 147: {
                    return "applyRestore";
                }
                case 148: {
                    return "getAppActiveNotifications";
                }
                case 149: {
                    return "setNotificationDelegate";
                }
                case 150: {
                    return "getNotificationDelegate";
                }
                case 151: {
                    return "canNotifyAsPackage";
                }
                case 152: {
                    return "canUseFullScreenIntent";
                }
                case 153: {
                    return "setPrivateNotificationsAllowed";
                }
                case 154: {
                    return "getPrivateNotificationsAllowed";
                }
                case 155: {
                    return "pullStats";
                }
                case 156: {
                    return "getListenerFilter";
                }
                case 157: {
                    return "setListenerFilter";
                }
                case 158: {
                    return "migrateNotificationFilter";
                }
                case 159: {
                    return "setToastRateLimitingEnabled";
                }
                case 160: {
                    return "registerCallNotificationEventListener";
                }
                case 161: {
                    return "unregisterCallNotificationEventListener";
                }
                case 162: {
                    return "setCanBePromoted";
                }
                case 163: {
                    return "appCanBePromoted";
                }
                case 164: {
                    return "canBePromoted";
                }
                case 165: {
                    return "setAdjustmentTypeSupportedState";
                }
                case 166: {
                    return "getUnsupportedAdjustmentTypes";
                }
                case 167: {
                    return "getAllowedClassificationTypes";
                }
                case 168: {
                    return "setAssistantClassificationTypeState";
                }
                case 169: {
                    return "getAdjustmentDeniedPackages";
                }
                case 170: {
                    return "isAdjustmentSupportedForPackage";
                }
                case 171: {
                    return "setAdjustmentSupportedForPackage";
                }
                case 172: {
                    return "incrementCounter";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelAllNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.clearData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    ITransientNotificationCallback _arg6 = ITransientNotificationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.enqueueTextToast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    ITransientNotification _arg2 = ITransientNotification.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.enqueueToast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.cancelToast(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.finishToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    Notification _arg4 = data.readTypedObject(Notification.CREATOR);
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enqueueNotificationWithTag(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelNotificationWithTag(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInCall(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShowBadge(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.canShowBadge(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasSentValidMsg(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInInvalidMsgState(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasUserDemotedInvalidMsgApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInvalidMsgAppDemoted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasSentValidBubble(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationsEnabledForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationsEnabledWithImportanceLockForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.areNotificationsEnabledForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.areNotificationsEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getPackageImportance(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isImportanceLocked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAllowedAssistantAdjustments(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAllowedAssistantAdjustmentsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.allowAssistantAdjustment(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.disallowAssistantAdjustment(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldHideSilentStatusIcons(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHideSilentStatusIcons(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setBubblesAllowed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.areBubblesAllowed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.areBubblesEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBubblePreferenceForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 33: {
                    String _arg0 = data.readString();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.createNotificationChannelGroups(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    ParceledListSlice _arg1 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.createNotificationChannels(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ParceledListSlice _arg2 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.createNotificationChannelsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getConversations(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getConversationsForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelGroupsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    NotificationChannelGroup _result = this.getNotificationChannelGroupForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    NotificationChannelGroup _result = this.getPopulatedNotificationChannelGroupForPackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getRecentBlockedNotificationChannelGroupsForPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 42: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    NotificationChannelGroup _arg2 = data.readTypedObject(NotificationChannelGroup.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateNotificationChannelGroupForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    NotificationChannel _arg2 = data.readTypedObject(NotificationChannel.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateNotificationChannelForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.unlockNotificationChannel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    this.unlockAllNotificationChannels();
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationChannel _result = this.getNotificationChannel(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 47: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = data.readBoolean();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationChannel _result = this.getConversationNotificationChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    NotificationChannel _arg2 = data.readTypedObject(NotificationChannel.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.createConversationNotificationChannelForPackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    NotificationChannel _result = this.getNotificationChannelForPackage(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteNotificationChannel(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannels(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 52: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 53: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.getNumNotificationChannelsForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeletedChannelCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBlockedChannelCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.deleteNotificationChannelGroup(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationChannelGroup _result = this.getNotificationChannelGroup(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 58: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelGroups(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 59: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelGroupsWithoutChannels(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 60: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.onlyHasDefaultChannel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 61: {
                    boolean _result = this.areChannelsBypassingDnd();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 62: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelsBypassingDnd(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getPackagesBypassingDnd(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 64: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getPackagesWithAnyChannels(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 65: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPackagePaused(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 66: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.deleteNotificationHistoryItem(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPermissionFixed(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 68: {
                    this.silenceNotificationSound();
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getActiveNotifications(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 70: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getActiveNotificationsWithAttribution(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 71: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getHistoricalNotifications(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 72: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getHistoricalNotificationsWithAttribution(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 73: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationHistory _result = this.getNotificationHistory(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 74: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 76: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelNotificationFromListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 77: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.cancelNotificationsFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 78: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.snoozeNotificationUntilContextFromListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 79: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.snoozeNotificationUntilFromListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestBindListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestUnbindListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 82: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestUnbindListenerComponent(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestBindProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 84: {
                    IConditionProvider _arg0 = IConditionProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestUnbindProvider(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 85: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.setNotificationsShownFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 86: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String[] _arg1 = data.createStringArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getActiveNotificationsFromListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 87: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getSnoozedNotificationsFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 88: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.clearRequestedListenerHints(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 89: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestHintsFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.getHintsFromListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 91: {
                    int _result = this.getHintsFromListenerNoToken();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 92: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestInterruptionFilterFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 93: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.getInterruptionFilterFromListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 94: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setOnNotificationPostedTrimFromListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInterruptionFilter(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationChannel _result = this.createConversationNotificationChannelForPackageFromPrivilegedListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 97: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    NotificationChannelGroup _arg3 = data.readTypedObject(NotificationChannelGroup.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateNotificationChannelGroupFromPrivilegedListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    NotificationChannel _arg3 = data.readTypedObject(NotificationChannel.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateNotificationChannelFromPrivilegedListener(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 99: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelsFromPrivilegedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 100: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getNotificationChannelGroupsFromPrivilegedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 101: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    Adjustment _arg1 = data.readTypedObject(Adjustment.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyEnqueuedAdjustmentFromAssistant(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 102: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    Adjustment _arg1 = data.readTypedObject(Adjustment.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyAdjustmentFromAssistant(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 103: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Adjustment> _arg1 = data.createTypedArrayList(Adjustment.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyAdjustmentsFromAssistant(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 104: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unsnoozeNotificationFromAssistant(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 105: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unsnoozeNotificationFromSystemListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 106: {
                    ComponentName _result = this.getEffectsSuppressor();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 107: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.matchesCallFilter(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 108: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.cleanUpCallersAfter(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 109: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSystemConditionProviderEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 110: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isNotificationListenerAccessGranted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 111: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isNotificationListenerAccessGrantedForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 112: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isNotificationAssistantAccessGranted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 113: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationListenerAccessGranted(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 114: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationAssistantAccessGranted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 115: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationListenerAccessGrantedForUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 116: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationAssistantAccessGrantedForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 117: {
                    List<String> _result = this.getEnabledNotificationListenerPackages();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 118: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<ComponentName> _result = this.getEnabledNotificationListeners(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 119: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ComponentName _result = this.getAllowedNotificationAssistantForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 120: {
                    ComponentName _result = this.getAllowedNotificationAssistant();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 121: {
                    ComponentName _result = this.getDefaultNotificationAssistant();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 122: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNASMigrationDoneAndResetDefault(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasEnabledNotificationListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 124: {
                    int _result = this.getZenMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 125: {
                    ZenModeConfig _result = this.getZenModeConfig();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 126: {
                    NotificationManager.Policy _result = this.getConsolidatedNotificationPolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 127: {
                    int _arg0 = data.readInt();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setZenMode(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 128: {
                    String _arg0 = data.readString();
                    IConditionProvider _arg1 = IConditionProvider.Stub.asInterface(data.readStrongBinder());
                    Condition[] _arg2 = data.createTypedArray(Condition.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyConditions(_arg0, _arg1, _arg2);
                    break;
                }
                case 129: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isNotificationPolicyAccessGranted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 130: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    NotificationManager.Policy _result = this.getNotificationPolicy(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 131: {
                    String _arg0 = data.readString();
                    NotificationManager.Policy _arg1 = data.readTypedObject(NotificationManager.Policy.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationPolicy(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 132: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isNotificationPolicyAccessGrantedForPackage(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 133: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationPolicyAccessGranted(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 134: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNotificationPolicyAccessGrantedForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 135: {
                    ZenPolicy _result = this.getDefaultZenPolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 136: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    AutomaticZenRule _result = this.getAutomaticZenRule(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 137: {
                    ParceledListSlice _result = this.getAutomaticZenRules();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 138: {
                    AutomaticZenRule _arg0 = data.readTypedObject(AutomaticZenRule.CREATOR);
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    String _result = this.addAutomaticZenRule(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 139: {
                    String _arg0 = data.readString();
                    AutomaticZenRule _arg1 = data.readTypedObject(AutomaticZenRule.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.updateAutomaticZenRule(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 140: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeAutomaticZenRule(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 141: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeAutomaticZenRules(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 142: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getRuleInstanceCount(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 143: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getAutomaticZenRuleState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 144: {
                    String _arg0 = data.readString();
                    Condition _arg1 = data.readTypedObject(Condition.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAutomaticZenRuleState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 145: {
                    ZenDeviceEffects _arg0 = data.readTypedObject(ZenDeviceEffects.CREATOR);
                    data.enforceNoDataAvail();
                    this.setManualZenRuleDeviceEffects(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 146: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getBackupPayload(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 147: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.applyRestore(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 148: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getAppActiveNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 149: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setNotificationDelegate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 150: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getNotificationDelegate(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 151: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.canNotifyAsPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 152: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.canUseFullScreenIntent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 153: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setPrivateNotificationsAllowed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 154: {
                    boolean _result = this.getPrivateNotificationsAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 155: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    ArrayList<ParcelFileDescriptor> _arg3 = new ArrayList<ParcelFileDescriptor>();
                    data.enforceNoDataAvail();
                    long _result = this.pullStats(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    reply.writeTypedList(_arg3, 1);
                    break;
                }
                case 156: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    NotificationListenerFilter _result = this.getListenerFilter(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 157: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    NotificationListenerFilter _arg2 = data.readTypedObject(NotificationListenerFilter.CREATOR);
                    data.enforceNoDataAvail();
                    this.setListenerFilter(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 158: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.migrateNotificationFilter(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 159: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setToastRateLimitingEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 160: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    ICallNotificationEventCallback _arg2 = ICallNotificationEventCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallNotificationEventListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 161: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    ICallNotificationEventCallback _arg2 = ICallNotificationEventCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCallNotificationEventListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 162: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setCanBePromoted(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 163: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.appCanBePromoted(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 164: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.canBePromoted(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 165: {
                    INotificationListener _arg0 = INotificationListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAdjustmentTypeSupportedState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 166: {
                    List<String> _result = this.getUnsupportedAdjustmentTypes();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 167: {
                    int[] _result = this.getAllowedClassificationTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 168: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAssistantClassificationTypeState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 169: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    String[] _result = this.getAdjustmentDeniedPackages(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 170: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAdjustmentSupportedForPackage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 171: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAdjustmentSupportedForPackage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 172: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.incrementCounter(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getActiveNotificationsWithAttribution_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_NOTIFICATIONS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getHistoricalNotificationsWithAttribution_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_NOTIFICATIONS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getNotificationHistory_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_NOTIFICATIONS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setToastRateLimitingEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_TOAST_RATE_LIMITING", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerCallNotificationEventListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_registerCallNotificationEventListener, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterCallNotificationEventListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_unregisterCallNotificationEventListener, Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 171;
        }

        private static class Proxy
        implements INotificationManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAllNotifications(String pkg, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearData(String pkg, int uid, boolean fromApp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(fromApp);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enqueueTextToast(String pkg, IBinder token, CharSequence text, int duration, boolean isUiContext, int displayId, ITransientNotificationCallback callback) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongBinder(token);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(duration);
                    _data.writeBoolean(isUiContext);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enqueueToast(String pkg, IBinder token, ITransientNotification callback, int duration, boolean isUiContext, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(duration);
                    _data.writeBoolean(isUiContext);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelToast(String pkg, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishToken(String pkg, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enqueueNotificationWithTag(String pkg, String opPkg, String tag, int id2, Notification notification, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(opPkg);
                    _data.writeString(tag);
                    _data.writeInt(id2);
                    _data.writeTypedObject(notification, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelNotificationWithTag(String pkg, String opPkg, String tag, int id2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(opPkg);
                    _data.writeString(tag);
                    _data.writeInt(id2);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInCall(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowBadge(String pkg, int uid, boolean showBadge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(showBadge);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canShowBadge(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSentValidMsg(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInInvalidMsgState(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasUserDemotedInvalidMsgApp(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInvalidMsgAppDemoted(String pkg, int uid, boolean isDemoted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(isDemoted);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasSentValidBubble(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationsEnabledWithImportanceLockForPackage(String pkg, int uid, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areNotificationsEnabledForPackage(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areNotificationsEnabled(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPackageImportance(String pkg) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isImportanceLocked(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllowedAssistantAdjustments(String pkg) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllowedAssistantAdjustmentsForUser(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAssistantAdjustment(int userId, String adjustmentType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(adjustmentType);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disallowAssistantAdjustment(int userId, String adjustmentType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(adjustmentType);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldHideSilentStatusIcons(String callingPkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHideSilentStatusIcons(boolean hide) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(hide);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBubblesAllowed(String pkg, int uid, int bubblePreference) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeInt(bubblePreference);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areBubblesAllowed(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areBubblesEnabled(UserHandle user) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBubblePreferenceForPackage(String pkg, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createNotificationChannelGroups(String pkg, ParceledListSlice channelGroupList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeTypedObject(channelGroupList, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createNotificationChannels(String pkg, ParceledListSlice channelsList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeTypedObject(channelsList, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createNotificationChannelsForPackage(String pkg, int uid, ParceledListSlice channelsList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeTypedObject(channelsList, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getConversations(boolean onlyImportant) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(onlyImportant);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getConversationsForPackage(String pkg, int uid) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(includeDeleted);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannelGroup getNotificationChannelGroupForPackage(String groupId, String pkg, int uid) throws RemoteException {
                NotificationChannelGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(groupId);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannelGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannelGroup getPopulatedNotificationChannelGroupForPackage(String pkg, int uid, String groupId, boolean includeDeleted) throws RemoteException {
                NotificationChannelGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeString(groupId);
                    _data.writeBoolean(includeDeleted);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannelGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getRecentBlockedNotificationChannelGroupsForPackage(String pkg, int uid) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateNotificationChannelGroupForPackage(String pkg, int uid, NotificationChannelGroup group) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeTypedObject(group, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateNotificationChannelForPackage(String pkg, int uid, NotificationChannel channel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeTypedObject(channel, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockNotificationChannel(String pkg, int uid, String channelId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeString(channelId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockAllNotificationChannels() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannel getNotificationChannel(String callingPkg, int userId, String pkg, String channelId) throws RemoteException {
                NotificationChannel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeInt(userId);
                    _data.writeString(pkg);
                    _data.writeString(channelId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannel getConversationNotificationChannel(String callingPkg, int userId, String pkg, String channelId, boolean returnParentIfNoConversationChannel, String conversationId) throws RemoteException {
                NotificationChannel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeInt(userId);
                    _data.writeString(pkg);
                    _data.writeString(channelId);
                    _data.writeBoolean(returnParentIfNoConversationChannel);
                    _data.writeString(conversationId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createConversationNotificationChannelForPackage(String pkg, int uid, NotificationChannel parentChannel, String conversationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeTypedObject(parentChannel, 0);
                    _data.writeString(conversationId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, String conversationId, boolean includeDeleted) throws RemoteException {
                NotificationChannel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeString(channelId);
                    _data.writeString(conversationId);
                    _data.writeBoolean(includeDeleted);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteNotificationChannel(String pkg, String channelId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(channelId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannels(String callingPkg, String targetPkg, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(targetPkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(includeDeleted);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNumNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(includeDeleted);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeletedChannelCount(String pkg, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBlockedChannelCount(String pkg, int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteNotificationChannelGroup(String pkg, String channelGroupId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(channelGroupId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannelGroup getNotificationChannelGroup(String pkg, String channelGroupId) throws RemoteException {
                NotificationChannelGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(channelGroupId);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannelGroup.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelGroups(String pkg) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelGroupsWithoutChannels(String pkg) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onlyHasDefaultChannel(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areChannelsBypassingDnd() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelsBypassingDnd(String pkg, int uid) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPackagesBypassingDnd(int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getPackagesWithAnyChannels(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackagePaused(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteNotificationHistoryItem(String pkg, int uid, long postedTime) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeLong(postedTime);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPermissionFixed(String pkg, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void silenceNotificationSound() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StatusBarNotification[] getActiveNotifications(String callingPkg) throws RemoteException {
                StatusBarNotification[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StatusBarNotification.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StatusBarNotification[] getActiveNotificationsWithAttribution(String callingPkg, String callingAttributionTag) throws RemoteException {
                StatusBarNotification[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StatusBarNotification.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count, boolean includeSnoozed) throws RemoteException {
                StatusBarNotification[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeInt(count);
                    _data.writeBoolean(includeSnoozed);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StatusBarNotification.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StatusBarNotification[] getHistoricalNotificationsWithAttribution(String callingPkg, String callingAttributionTag, int count, boolean includeSnoozed) throws RemoteException {
                StatusBarNotification[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(callingAttributionTag);
                    _data.writeInt(count);
                    _data.writeBoolean(includeSnoozed);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StatusBarNotification.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationHistory getNotificationHistory(String callingPkg, String callingAttributionTag) throws RemoteException {
                NotificationHistory _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(callingAttributionTag);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationHistory.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(INotificationListener listener, ComponentName component, int userid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeTypedObject(component, 0);
                    _data.writeInt(userid);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(INotificationListener listener, int userid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userid);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeString(tag);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelNotificationsFromListener(INotificationListener token, String[] keys) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeStringArray(keys);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snoozeNotificationUntilContextFromListener(INotificationListener token, String key, String snoozeCriterionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(key);
                    _data.writeString(snoozeCriterionId);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snoozeNotificationUntilFromListener(INotificationListener token, String key, long until) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(key);
                    _data.writeLong(until);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestBindListener(ComponentName component) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUnbindListener(INotificationListener token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUnbindListenerComponent(ComponentName component) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestBindProvider(ComponentName component) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUnbindProvider(IConditionProvider token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationsShownFromListener(INotificationListener token, String[] keys) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeStringArray(keys);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getActiveNotificationsFromListener(INotificationListener token, String[] keys, int trim) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeStringArray(keys);
                    _data.writeInt(trim);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getSnoozedNotificationsFromListener(INotificationListener token, int trim) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(trim);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearRequestedListenerHints(INotificationListener token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHintsFromListener(INotificationListener token, int hints) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(hints);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getHintsFromListener(INotificationListener token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getHintsFromListenerNoToken() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestInterruptionFilterFromListener(INotificationListener token, int interruptionFilter) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(interruptionFilter);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterruptionFilterFromListener(INotificationListener token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnNotificationPostedTrimFromListener(INotificationListener token, int trim) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(trim);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInterruptionFilter(String pkg, int interruptionFilter, boolean fromUser) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(interruptionFilter);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationChannel createConversationNotificationChannelForPackageFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, String parentChannelId, String conversationId) throws RemoteException {
                NotificationChannel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeTypedObject(user, 0);
                    _data.writeString(parentChannelId);
                    _data.writeString(conversationId);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateNotificationChannelGroupFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannelGroup group) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(group, 0);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateNotificationChannelFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannel channel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(channel, 0);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getNotificationChannelGroupsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(pkg);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyEnqueuedAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeTypedObject(adjustment, 0);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeTypedObject(adjustment, 0);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyAdjustmentsFromAssistant(INotificationListener token, List<Adjustment> adjustments) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeTypedList(adjustments, 0);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsnoozeNotificationFromAssistant(INotificationListener token, String key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsnoozeNotificationFromSystemListener(INotificationListener token, String key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getEffectsSuppressor() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean matchesCallFilter(Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanUpCallersAfter(long timeThreshold) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeThreshold);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSystemConditionProviderEnabled(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNotificationListenerAccessGranted(ComponentName listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(listener, 0);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNotificationListenerAccessGrantedForUser(ComponentName listener, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(listener, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNotificationAssistantAccessGranted(ComponentName assistant) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(assistant, 0);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationListenerAccessGranted(ComponentName listener, boolean enabled, boolean userSet) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(listener, 0);
                    _data.writeBoolean(enabled);
                    _data.writeBoolean(userSet);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationAssistantAccessGranted(ComponentName assistant, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(assistant, 0);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean enabled, boolean userSet) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(listener, 0);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    _data.writeBoolean(userSet);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationAssistantAccessGrantedForUser(ComponentName assistant, int userId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(assistant, 0);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getEnabledNotificationListenerPackages() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ComponentName> getEnabledNotificationListeners(int userId) throws RemoteException {
                ArrayList<ComponentName> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getAllowedNotificationAssistantForUser(int userId) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getAllowedNotificationAssistant() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getDefaultNotificationAssistant() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNASMigrationDoneAndResetDefault(int userId, boolean loadFromConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(loadFromConfig);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasEnabledNotificationListener(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getZenMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZenModeConfig getZenModeConfig() throws RemoteException {
                ZenModeConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ZenModeConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationManager.Policy getConsolidatedNotificationPolicy() throws RemoteException {
                NotificationManager.Policy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationManager.Policy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setZenMode(int mode, Uri conditionId, String reason, boolean fromUser) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeTypedObject(conditionId, 0);
                    _data.writeString(reason);
                    _data.writeBoolean(fromUser);
                    boolean bl = this.mRemote.transact(127, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyConditions(String pkg, IConditionProvider provider, Condition[] conditions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeStrongInterface(provider);
                    _data.writeTypedArray(conditions, 0);
                    boolean bl = this.mRemote.transact(128, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNotificationPolicyAccessGranted(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationManager.Policy getNotificationPolicy(String pkg) throws RemoteException {
                NotificationManager.Policy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationManager.Policy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationPolicy(String pkg, NotificationManager.Policy policy, boolean fromUser) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeTypedObject(policy, 0);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationPolicyAccessGranted(String pkg, boolean granted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeBoolean(granted);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationPolicyAccessGrantedForUser(String pkg, int userId, boolean granted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(userId);
                    _data.writeBoolean(granted);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ZenPolicy getDefaultZenPolicy() throws RemoteException {
                ZenPolicy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ZenPolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AutomaticZenRule getAutomaticZenRule(String id2) throws RemoteException {
                AutomaticZenRule _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AutomaticZenRule.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAutomaticZenRules() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String addAutomaticZenRule(AutomaticZenRule automaticZenRule, String pkg, boolean fromUser) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(automaticZenRule, 0);
                    _data.writeString(pkg);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule, boolean fromUser) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(automaticZenRule, 0);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeAutomaticZenRule(String id2, boolean fromUser) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(140, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeAutomaticZenRules(String packageName, boolean fromUser) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRuleInstanceCount(ComponentName owner) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(owner, 0);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAutomaticZenRuleState(String id2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(143, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutomaticZenRuleState(String id2, Condition condition) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(condition, 0);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setManualZenRuleDeviceEffects(ZenDeviceEffects effects) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(effects, 0);
                    boolean _status = this.mRemote.transact(145, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getBackupPayload(int user) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(user);
                    boolean _status = this.mRemote.transact(146, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyRestore(byte[] payload, int user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(payload);
                    _data.writeInt(user);
                    boolean _status = this.mRemote.transact(147, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAppActiveNotifications(String callingPkg, int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(148, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNotificationDelegate(String callingPkg, String delegate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(delegate);
                    boolean _status = this.mRemote.transact(149, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getNotificationDelegate(String callingPkg) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    boolean _status = this.mRemote.transact(150, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canNotifyAsPackage(String callingPkg, String targetPkg, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPkg);
                    _data.writeString(targetPkg);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(151, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canUseFullScreenIntent(AttributionSource attributionSource) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(152, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrivateNotificationsAllowed(boolean allow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(allow);
                    boolean _status = this.mRemote.transact(153, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getPrivateNotificationsAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(154, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long pullStats(long startNs, int report, boolean doAgg, List<ParcelFileDescriptor> stats) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(startNs);
                    _data.writeInt(report);
                    _data.writeBoolean(doAgg);
                    boolean _status = this.mRemote.transact(155, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                    _reply.readTypedList(stats, ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NotificationListenerFilter getListenerFilter(ComponentName cn, int userId) throws RemoteException {
                NotificationListenerFilter _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(cn, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(156, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NotificationListenerFilter.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListenerFilter(ComponentName cn, int userId, NotificationListenerFilter nlf) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(cn, 0);
                    _data.writeInt(userId);
                    _data.writeTypedObject(nlf, 0);
                    boolean _status = this.mRemote.transact(157, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void migrateNotificationFilter(INotificationListener token, int defaultTypes, List<String> disallowedPkgs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(defaultTypes);
                    _data.writeStringList(disallowedPkgs);
                    boolean _status = this.mRemote.transact(158, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setToastRateLimitingEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(159, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallNotificationEventListener(String packageName, UserHandle userHandle, ICallNotificationEventCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(160, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallNotificationEventListener(String packageName, UserHandle userHandle, ICallNotificationEventCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(161, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCanBePromoted(String pkg, int uid, boolean promote, boolean fromUser) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    _data.writeBoolean(promote);
                    _data.writeBoolean(fromUser);
                    boolean _status = this.mRemote.transact(162, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean appCanBePromoted(String pkg, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(163, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canBePromoted(String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(164, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdjustmentTypeSupportedState(INotificationListener token, String key, boolean supported) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeString(key);
                    _data.writeBoolean(supported);
                    boolean _status = this.mRemote.transact(165, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getUnsupportedAdjustmentTypes() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(166, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAllowedClassificationTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(167, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAssistantClassificationTypeState(int type, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(168, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getAdjustmentDeniedPackages(int userId, String key) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(key);
                    boolean _status = this.mRemote.transact(169, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAdjustmentSupportedForPackage(int userId, String key, String pkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(key);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(170, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdjustmentSupportedForPackage(int userId, String key, String pkg, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(key);
                    _data.writeString(pkg);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(171, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incrementCounter(String metricId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(metricId);
                    boolean _status = this.mRemote.transact(172, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INotificationManager {
        @Override
        public void cancelAllNotifications(String pkg, int userId) throws RemoteException {
        }

        @Override
        public void clearData(String pkg, int uid, boolean fromApp) throws RemoteException {
        }

        @Override
        public boolean enqueueTextToast(String pkg, IBinder token, CharSequence text, int duration, boolean isUiContext, int displayId, ITransientNotificationCallback callback) throws RemoteException {
            return false;
        }

        @Override
        public boolean enqueueToast(String pkg, IBinder token, ITransientNotification callback, int duration, boolean isUiContext, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void cancelToast(String pkg, IBinder token) throws RemoteException {
        }

        @Override
        public void finishToken(String pkg, IBinder token) throws RemoteException {
        }

        @Override
        public void enqueueNotificationWithTag(String pkg, String opPkg, String tag, int id2, Notification notification, int userId) throws RemoteException {
        }

        @Override
        public void cancelNotificationWithTag(String pkg, String opPkg, String tag, int id2, int userId) throws RemoteException {
        }

        @Override
        public boolean isInCall(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void setShowBadge(String pkg, int uid, boolean showBadge) throws RemoteException {
        }

        @Override
        public boolean canShowBadge(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasSentValidMsg(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean isInInvalidMsgState(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasUserDemotedInvalidMsgApp(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void setInvalidMsgAppDemoted(String pkg, int uid, boolean isDemoted) throws RemoteException {
        }

        @Override
        public boolean hasSentValidBubble(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) throws RemoteException {
        }

        @Override
        public void setNotificationsEnabledWithImportanceLockForPackage(String pkg, int uid, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean areNotificationsEnabledForPackage(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean areNotificationsEnabled(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public int getPackageImportance(String pkg) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isImportanceLocked(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getAllowedAssistantAdjustments(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getAllowedAssistantAdjustmentsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void allowAssistantAdjustment(int userId, String adjustmentType) throws RemoteException {
        }

        @Override
        public void disallowAssistantAdjustment(int userId, String adjustmentType) throws RemoteException {
        }

        @Override
        public boolean shouldHideSilentStatusIcons(String callingPkg) throws RemoteException {
            return false;
        }

        @Override
        public void setHideSilentStatusIcons(boolean hide) throws RemoteException {
        }

        @Override
        public void setBubblesAllowed(String pkg, int uid, int bubblePreference) throws RemoteException {
        }

        @Override
        public boolean areBubblesAllowed(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean areBubblesEnabled(UserHandle user) throws RemoteException {
            return false;
        }

        @Override
        public int getBubblePreferenceForPackage(String pkg, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public void createNotificationChannelGroups(String pkg, ParceledListSlice channelGroupList) throws RemoteException {
        }

        @Override
        public void createNotificationChannels(String pkg, ParceledListSlice channelsList) throws RemoteException {
        }

        @Override
        public void createNotificationChannelsForPackage(String pkg, int uid, ParceledListSlice channelsList) throws RemoteException {
        }

        @Override
        public ParceledListSlice getConversations(boolean onlyImportant) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getConversationsForPackage(String pkg, int uid) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
            return null;
        }

        @Override
        public NotificationChannelGroup getNotificationChannelGroupForPackage(String groupId, String pkg, int uid) throws RemoteException {
            return null;
        }

        @Override
        public NotificationChannelGroup getPopulatedNotificationChannelGroupForPackage(String pkg, int uid, String groupId, boolean includeDeleted) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getRecentBlockedNotificationChannelGroupsForPackage(String pkg, int uid) throws RemoteException {
            return null;
        }

        @Override
        public void updateNotificationChannelGroupForPackage(String pkg, int uid, NotificationChannelGroup group) throws RemoteException {
        }

        @Override
        public void updateNotificationChannelForPackage(String pkg, int uid, NotificationChannel channel) throws RemoteException {
        }

        @Override
        public void unlockNotificationChannel(String pkg, int uid, String channelId) throws RemoteException {
        }

        @Override
        public void unlockAllNotificationChannels() throws RemoteException {
        }

        @Override
        public NotificationChannel getNotificationChannel(String callingPkg, int userId, String pkg, String channelId) throws RemoteException {
            return null;
        }

        @Override
        public NotificationChannel getConversationNotificationChannel(String callingPkg, int userId, String pkg, String channelId, boolean returnParentIfNoConversationChannel, String conversationId) throws RemoteException {
            return null;
        }

        @Override
        public void createConversationNotificationChannelForPackage(String pkg, int uid, NotificationChannel parentChannel, String conversationId) throws RemoteException {
        }

        @Override
        public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, String conversationId, boolean includeDeleted) throws RemoteException {
            return null;
        }

        @Override
        public void deleteNotificationChannel(String pkg, String channelId) throws RemoteException {
        }

        @Override
        public ParceledListSlice getNotificationChannels(String callingPkg, String targetPkg, int userId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
            return null;
        }

        @Override
        public int getNumNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) throws RemoteException {
            return 0;
        }

        @Override
        public int getDeletedChannelCount(String pkg, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int getBlockedChannelCount(String pkg, int uid) throws RemoteException {
            return 0;
        }

        @Override
        public void deleteNotificationChannelGroup(String pkg, String channelGroupId) throws RemoteException {
        }

        @Override
        public NotificationChannelGroup getNotificationChannelGroup(String pkg, String channelGroupId) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getNotificationChannelGroups(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getNotificationChannelGroupsWithoutChannels(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public boolean onlyHasDefaultChannel(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean areChannelsBypassingDnd() throws RemoteException {
            return false;
        }

        @Override
        public ParceledListSlice getNotificationChannelsBypassingDnd(String pkg, int uid) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPackagesBypassingDnd(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getPackagesWithAnyChannels(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPackagePaused(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public void deleteNotificationHistoryItem(String pkg, int uid, long postedTime) throws RemoteException {
        }

        @Override
        public boolean isPermissionFixed(String pkg, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void silenceNotificationSound() throws RemoteException {
        }

        @Override
        public StatusBarNotification[] getActiveNotifications(String callingPkg) throws RemoteException {
            return null;
        }

        @Override
        public StatusBarNotification[] getActiveNotificationsWithAttribution(String callingPkg, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count, boolean includeSnoozed) throws RemoteException {
            return null;
        }

        @Override
        public StatusBarNotification[] getHistoricalNotificationsWithAttribution(String callingPkg, String callingAttributionTag, int count, boolean includeSnoozed) throws RemoteException {
            return null;
        }

        @Override
        public NotificationHistory getNotificationHistory(String callingPkg, String callingAttributionTag) throws RemoteException {
            return null;
        }

        @Override
        public void registerListener(INotificationListener listener, ComponentName component, int userid) throws RemoteException {
        }

        @Override
        public void unregisterListener(INotificationListener listener, int userid) throws RemoteException {
        }

        @Override
        public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) throws RemoteException {
        }

        @Override
        public void cancelNotificationsFromListener(INotificationListener token, String[] keys) throws RemoteException {
        }

        @Override
        public void snoozeNotificationUntilContextFromListener(INotificationListener token, String key, String snoozeCriterionId) throws RemoteException {
        }

        @Override
        public void snoozeNotificationUntilFromListener(INotificationListener token, String key, long until) throws RemoteException {
        }

        @Override
        public void requestBindListener(ComponentName component) throws RemoteException {
        }

        @Override
        public void requestUnbindListener(INotificationListener token) throws RemoteException {
        }

        @Override
        public void requestUnbindListenerComponent(ComponentName component) throws RemoteException {
        }

        @Override
        public void requestBindProvider(ComponentName component) throws RemoteException {
        }

        @Override
        public void requestUnbindProvider(IConditionProvider token) throws RemoteException {
        }

        @Override
        public void setNotificationsShownFromListener(INotificationListener token, String[] keys) throws RemoteException {
        }

        @Override
        public ParceledListSlice getActiveNotificationsFromListener(INotificationListener token, String[] keys, int trim) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getSnoozedNotificationsFromListener(INotificationListener token, int trim) throws RemoteException {
            return null;
        }

        @Override
        public void clearRequestedListenerHints(INotificationListener token) throws RemoteException {
        }

        @Override
        public void requestHintsFromListener(INotificationListener token, int hints) throws RemoteException {
        }

        @Override
        public int getHintsFromListener(INotificationListener token) throws RemoteException {
            return 0;
        }

        @Override
        public int getHintsFromListenerNoToken() throws RemoteException {
            return 0;
        }

        @Override
        public void requestInterruptionFilterFromListener(INotificationListener token, int interruptionFilter) throws RemoteException {
        }

        @Override
        public int getInterruptionFilterFromListener(INotificationListener token) throws RemoteException {
            return 0;
        }

        @Override
        public void setOnNotificationPostedTrimFromListener(INotificationListener token, int trim) throws RemoteException {
        }

        @Override
        public void setInterruptionFilter(String pkg, int interruptionFilter, boolean fromUser) throws RemoteException {
        }

        @Override
        public NotificationChannel createConversationNotificationChannelForPackageFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, String parentChannelId, String conversationId) throws RemoteException {
            return null;
        }

        @Override
        public void updateNotificationChannelGroupFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannelGroup group) throws RemoteException {
        }

        @Override
        public void updateNotificationChannelFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannel channel) throws RemoteException {
        }

        @Override
        public ParceledListSlice getNotificationChannelsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getNotificationChannelGroupsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            return null;
        }

        @Override
        public void applyEnqueuedAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
        }

        @Override
        public void applyAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
        }

        @Override
        public void applyAdjustmentsFromAssistant(INotificationListener token, List<Adjustment> adjustments) throws RemoteException {
        }

        @Override
        public void unsnoozeNotificationFromAssistant(INotificationListener token, String key) throws RemoteException {
        }

        @Override
        public void unsnoozeNotificationFromSystemListener(INotificationListener token, String key) throws RemoteException {
        }

        @Override
        public ComponentName getEffectsSuppressor() throws RemoteException {
            return null;
        }

        @Override
        public boolean matchesCallFilter(Bundle extras) throws RemoteException {
            return false;
        }

        @Override
        public void cleanUpCallersAfter(long timeThreshold) throws RemoteException {
        }

        @Override
        public boolean isSystemConditionProviderEnabled(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean isNotificationListenerAccessGranted(ComponentName listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean isNotificationListenerAccessGrantedForUser(ComponentName listener, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isNotificationAssistantAccessGranted(ComponentName assistant) throws RemoteException {
            return false;
        }

        @Override
        public void setNotificationListenerAccessGranted(ComponentName listener, boolean enabled, boolean userSet) throws RemoteException {
        }

        @Override
        public void setNotificationAssistantAccessGranted(ComponentName assistant, boolean enabled) throws RemoteException {
        }

        @Override
        public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean enabled, boolean userSet) throws RemoteException {
        }

        @Override
        public void setNotificationAssistantAccessGrantedForUser(ComponentName assistant, int userId, boolean enabled) throws RemoteException {
        }

        @Override
        public List<String> getEnabledNotificationListenerPackages() throws RemoteException {
            return null;
        }

        @Override
        public List<ComponentName> getEnabledNotificationListeners(int userId) throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getAllowedNotificationAssistantForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getAllowedNotificationAssistant() throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getDefaultNotificationAssistant() throws RemoteException {
            return null;
        }

        @Override
        public void setNASMigrationDoneAndResetDefault(int userId, boolean loadFromConfig) throws RemoteException {
        }

        @Override
        public boolean hasEnabledNotificationListener(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public int getZenMode() throws RemoteException {
            return 0;
        }

        @Override
        public ZenModeConfig getZenModeConfig() throws RemoteException {
            return null;
        }

        @Override
        public NotificationManager.Policy getConsolidatedNotificationPolicy() throws RemoteException {
            return null;
        }

        @Override
        public void setZenMode(int mode, Uri conditionId, String reason, boolean fromUser) throws RemoteException {
        }

        @Override
        public void notifyConditions(String pkg, IConditionProvider provider, Condition[] conditions) throws RemoteException {
        }

        @Override
        public boolean isNotificationPolicyAccessGranted(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public NotificationManager.Policy getNotificationPolicy(String pkg) throws RemoteException {
            return null;
        }

        @Override
        public void setNotificationPolicy(String pkg, NotificationManager.Policy policy, boolean fromUser) throws RemoteException {
        }

        @Override
        public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public void setNotificationPolicyAccessGranted(String pkg, boolean granted) throws RemoteException {
        }

        @Override
        public void setNotificationPolicyAccessGrantedForUser(String pkg, int userId, boolean granted) throws RemoteException {
        }

        @Override
        public ZenPolicy getDefaultZenPolicy() throws RemoteException {
            return null;
        }

        @Override
        public AutomaticZenRule getAutomaticZenRule(String id2) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAutomaticZenRules() throws RemoteException {
            return null;
        }

        @Override
        public String addAutomaticZenRule(AutomaticZenRule automaticZenRule, String pkg, boolean fromUser) throws RemoteException {
            return null;
        }

        @Override
        public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule, boolean fromUser) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeAutomaticZenRule(String id2, boolean fromUser) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeAutomaticZenRules(String packageName, boolean fromUser) throws RemoteException {
            return false;
        }

        @Override
        public int getRuleInstanceCount(ComponentName owner) throws RemoteException {
            return 0;
        }

        @Override
        public int getAutomaticZenRuleState(String id2) throws RemoteException {
            return 0;
        }

        @Override
        public void setAutomaticZenRuleState(String id2, Condition condition) throws RemoteException {
        }

        @Override
        public void setManualZenRuleDeviceEffects(ZenDeviceEffects effects) throws RemoteException {
        }

        @Override
        public byte[] getBackupPayload(int user) throws RemoteException {
            return null;
        }

        @Override
        public void applyRestore(byte[] payload, int user) throws RemoteException {
        }

        @Override
        public ParceledListSlice getAppActiveNotifications(String callingPkg, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setNotificationDelegate(String callingPkg, String delegate) throws RemoteException {
        }

        @Override
        public String getNotificationDelegate(String callingPkg) throws RemoteException {
            return null;
        }

        @Override
        public boolean canNotifyAsPackage(String callingPkg, String targetPkg, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean canUseFullScreenIntent(AttributionSource attributionSource) throws RemoteException {
            return false;
        }

        @Override
        public void setPrivateNotificationsAllowed(boolean allow) throws RemoteException {
        }

        @Override
        public boolean getPrivateNotificationsAllowed() throws RemoteException {
            return false;
        }

        @Override
        public long pullStats(long startNs, int report, boolean doAgg, List<ParcelFileDescriptor> stats) throws RemoteException {
            return 0L;
        }

        @Override
        public NotificationListenerFilter getListenerFilter(ComponentName cn, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setListenerFilter(ComponentName cn, int userId, NotificationListenerFilter nlf) throws RemoteException {
        }

        @Override
        public void migrateNotificationFilter(INotificationListener token, int defaultTypes, List<String> disallowedPkgs) throws RemoteException {
        }

        @Override
        public void setToastRateLimitingEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public void registerCallNotificationEventListener(String packageName, UserHandle userHandle, ICallNotificationEventCallback listener) throws RemoteException {
        }

        @Override
        public void unregisterCallNotificationEventListener(String packageName, UserHandle userHandle, ICallNotificationEventCallback listener) throws RemoteException {
        }

        @Override
        public void setCanBePromoted(String pkg, int uid, boolean promote, boolean fromUser) throws RemoteException {
        }

        @Override
        public boolean appCanBePromoted(String pkg, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean canBePromoted(String pkg) throws RemoteException {
            return false;
        }

        @Override
        public void setAdjustmentTypeSupportedState(INotificationListener token, String key, boolean supported) throws RemoteException {
        }

        @Override
        public List<String> getUnsupportedAdjustmentTypes() throws RemoteException {
            return null;
        }

        @Override
        public int[] getAllowedClassificationTypes() throws RemoteException {
            return null;
        }

        @Override
        public void setAssistantClassificationTypeState(int type, boolean enabled) throws RemoteException {
        }

        @Override
        public String[] getAdjustmentDeniedPackages(int userId, String key) throws RemoteException {
            return null;
        }

        @Override
        public boolean isAdjustmentSupportedForPackage(int userId, String key, String pkg) throws RemoteException {
            return false;
        }

        @Override
        public void setAdjustmentSupportedForPackage(int userId, String key, String pkg, boolean enabled) throws RemoteException {
        }

        @Override
        public void incrementCounter(String metricId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

