/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.GameModeConfiguration;
import android.app.GameModeInfo;
import android.app.GameState;
import android.app.IGameManagerService;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GameManager {
    private static final String TAG = "GameManager";
    @Nullable
    private final Context mContext;
    @Nullable
    private final IGameManagerService mService;
    public static final int GAME_MODE_UNSUPPORTED = 0;
    public static final int GAME_MODE_STANDARD = 1;
    public static final int GAME_MODE_PERFORMANCE = 2;
    public static final int GAME_MODE_BATTERY = 3;
    public static final int GAME_MODE_CUSTOM = 4;

    GameManager(Context context, @Nullable IGameManagerService service) {
        this.mContext = context;
        this.mService = service;
    }

    public int getGameMode() {
        return this.getGameModeImpl(this.mContext.getPackageName(), this.mContext.getApplicationInfo().targetSdkVersion);
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int getGameMode(@NonNull String packageName) {
        int targetSdkVersion;
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfo(packageName, PackageManager.ApplicationInfoFlags.of(0L));
            targetSdkVersion = applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException ex) {
            return 0;
        }
        return this.getGameModeImpl(packageName, targetSdkVersion);
    }

    private int getGameModeImpl(@NonNull String packageName, int targetSdkVersion) {
        int gameMode;
        if (this.mService == null) {
            return 0;
        }
        try {
            gameMode = this.mService.getGameMode(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (gameMode == 4 && targetSdkVersion <= 33) {
            return 1;
        }
        return gameMode;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    @Nullable
    public GameModeInfo getGameModeInfo(@NonNull String packageName) {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getGameModeInfo(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void setGameMode(@NonNull String packageName, int gameMode) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setGameMode(packageName, gameMode, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public int[] getAvailableGameModes(@NonNull String packageName) {
        if (this.mService == null) {
            return new int[0];
        }
        try {
            return this.mService.getAvailableGameModes(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public boolean isAngleEnabled(@NonNull String packageName) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isAngleEnabled(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void notifyGraphicsEnvironmentSetup() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.notifyGraphicsEnvironmentSetup(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setGameState(@NonNull GameState gameState) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setGameState(this.mContext.getPackageName(), gameState, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setGameServiceProvider(@Nullable String packageName) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setGameServiceProvider(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_GAME_MODE")
    public void updateCustomGameModeConfiguration(@NonNull String packageName, @NonNull GameModeConfiguration gameModeConfig) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.updateCustomGameModeConfiguration(packageName, gameModeConfig, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GameMode {
    }
}

