/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ActivityThreadInternal;
import android.app.Application;
import android.app.ResourcesManager;
import android.app.servertransaction.ClientTransactionListenerController;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.os.LocaleList;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.view.ContextThemeWrapper;
import android.view.WindowManagerGlobal;
import android.window.ConfigurationHelper;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Locale;

class ConfigurationController {
    private static final String TAG = "ConfigurationController";
    private final ActivityThreadInternal mActivityThread;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();
    @GuardedBy(value={"mResourcesManager"})
    @Nullable
    private Configuration mPendingConfiguration;
    @Nullable
    private Configuration mCompatConfiguration;
    @Nullable
    private Configuration mConfiguration;

    ConfigurationController(@NonNull ActivityThreadInternal activityThread) {
        this.mActivityThread = activityThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration updatePendingConfiguration(@NonNull Configuration config) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration == null || this.mPendingConfiguration.isOtherSeqNewer(config)) {
                this.mPendingConfiguration = config;
                return this.mPendingConfiguration;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration getPendingConfiguration(boolean clearPending) {
        Configuration outConfig = null;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration != null) {
                outConfig = this.mPendingConfiguration;
                if (clearPending) {
                    this.mPendingConfiguration = null;
                }
            }
        }
        return outConfig;
    }

    void setCompatConfiguration(@NonNull Configuration config) {
        this.mCompatConfiguration = new Configuration(config);
    }

    Configuration getCompatConfiguration() {
        return this.mCompatConfiguration;
    }

    Configuration applyCompatConfiguration() {
        Configuration config = this.mConfiguration;
        int displayDensity = config.densityDpi;
        if (this.mCompatConfiguration == null) {
            this.mCompatConfiguration = new Configuration();
        }
        this.mCompatConfiguration.setTo(this.mConfiguration);
        if (this.mResourcesManager.applyCompatConfiguration(displayDensity, this.mCompatConfiguration)) {
            config = this.mCompatConfiguration;
        }
        return config;
    }

    void setConfiguration(@NonNull Configuration config) {
        this.mConfiguration = new Configuration(config);
    }

    Configuration getConfiguration() {
        return this.mConfiguration;
    }

    void handleConfigurationChanged(@NonNull Configuration config) {
        Trace.traceBegin(64L, "configChanged");
        this.handleConfigurationChanged(config, null);
        Trace.traceEnd(64L);
    }

    void handleConfigurationChanged(@NonNull CompatibilityInfo compat) {
        this.handleConfigurationChanged(this.mConfiguration, compat);
        WindowManagerGlobal.getInstance().reportNewConfiguration(this.mConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConfigurationChanged(@Nullable Configuration config, @Nullable CompatibilityInfo compat) {
        ClientTransactionListenerController controller = ClientTransactionListenerController.getInstance();
        Application contextToUpdate = ActivityThread.currentApplication();
        controller.onContextConfigurationPreChanged(contextToUpdate);
        try {
            this.handleConfigurationChangedInner(config, compat);
        }
        finally {
            controller.onContextConfigurationPostChanged(contextToUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfigurationChangedInner(@Nullable Configuration config, @Nullable CompatibilityInfo compat) {
        int configDiff;
        boolean equivalent;
        Resources.Theme systemTheme = this.mActivityThread.getSystemContext().getTheme();
        Context systemUiContext = this.mActivityThread.getSystemUiContextNoCreate();
        Resources.Theme systemUiTheme = systemUiContext != null ? systemUiContext.getTheme() : null;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration != null) {
                if (!this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    config = this.mPendingConfiguration;
                    this.updateDefaultDensity(config.densityDpi);
                }
                this.mPendingConfiguration = null;
            }
            if (config == null) {
                return;
            }
            equivalent = this.mConfiguration != null && 0 == this.mConfiguration.diffPublicOnly(config);
            Application app = this.mActivityThread.getApplication();
            Resources appResources = app.getResources();
            this.mResourcesManager.applyConfigurationToResources(config, compat);
            this.updateLocaleListFromAppContext(app.getApplicationContext());
            if (this.mConfiguration == null) {
                this.mConfiguration = new Configuration();
            }
            if (!this.mConfiguration.isOtherSeqNewer(config) && compat == null) {
                return;
            }
            configDiff = this.mConfiguration.updateFrom(config);
            config = this.applyCompatConfiguration();
            HardwareRenderer.sendDeviceConfigurationForDebugging(config);
            if ((systemTheme.getChangingConfigurations() & configDiff) != 0) {
                systemTheme.rebase();
            }
            if (systemUiTheme != null && (systemUiTheme.getChangingConfigurations() & configDiff) != 0) {
                systemUiTheme.rebase();
            }
        }
        ArrayList<ComponentCallbacks2> callbacks = this.mActivityThread.collectComponentCallbacks(false);
        ConfigurationHelper.freeTextLayoutCachesIfNeeded(configDiff);
        if (callbacks != null) {
            int size = callbacks.size();
            for (int i = 0; i < size; ++i) {
                ComponentCallbacks2 cb = callbacks.get(i);
                if (equivalent) continue;
                this.performConfigurationChanged(cb, config);
            }
        }
    }

    void performConfigurationChanged(@NonNull ComponentCallbacks2 cb, @NonNull Configuration newConfig) {
        Configuration contextThemeWrapperOverrideConfig = null;
        if (cb instanceof ContextThemeWrapper) {
            ContextThemeWrapper contextThemeWrapper = (ContextThemeWrapper)((Object)cb);
            contextThemeWrapperOverrideConfig = contextThemeWrapper.getOverrideConfiguration();
        }
        Configuration configToReport = ConfigurationController.createNewConfigAndUpdateIfNotNull(newConfig, contextThemeWrapperOverrideConfig);
        cb.onConfigurationChanged(configToReport);
    }

    void updateDefaultDensity(int densityDpi) {
        if (!this.mActivityThread.isInDensityCompatMode() && densityDpi != 0 && densityDpi != DisplayMetrics.DENSITY_DEVICE) {
            DisplayMetrics.DENSITY_DEVICE = densityDpi;
            Bitmap.setDefaultDensity(densityDpi);
        }
    }

    int getCurDefaultDisplayDpi() {
        return this.mConfiguration.densityDpi;
    }

    void updateLocaleListFromAppContext(@NonNull Context context) {
        Locale bestLocale = context.getResources().getConfiguration().getLocales().get(0);
        LocaleList newLocaleList = this.mResourcesManager.getConfiguration().getLocales();
        int newLocaleListSize = newLocaleList.size();
        for (int i = 0; i < newLocaleListSize; ++i) {
            if (!((Object)bestLocale).equals(newLocaleList.get(i))) continue;
            LocaleList.setDefault(newLocaleList, i);
            return;
        }
        LocaleList.setDefault(new LocaleList(bestLocale, newLocaleList));
    }

    static Configuration createNewConfigAndUpdateIfNotNull(@NonNull Configuration base, @Nullable Configuration override) {
        if (override == null) {
            return base;
        }
        Configuration newConfig = new Configuration(base);
        newConfig.updateFrom(override);
        return newConfig;
    }
}

