/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.os.IBinder;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

class ConfigurationChangedListenerController {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final List<ListenerContainer> mListenerContainers = new ArrayList<ListenerContainer>();

    ConfigurationChangedListenerController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(@NonNull Executor executor, @NonNull Consumer<IBinder> consumer) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.indexOf(consumer) > -1) {
                return;
            }
            this.mListenerContainers.add(new ListenerContainer(executor, consumer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(@NonNull Consumer<IBinder> consumer) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.indexOf(consumer);
            if (index > -1) {
                this.mListenerContainers.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchOnConfigurationChanged(@NonNull IBinder activityToken) {
        ArrayList<ListenerContainer> consumers;
        Object object = this.mLock;
        synchronized (object) {
            consumers = new ArrayList<ListenerContainer>(this.mListenerContainers);
        }
        for (int i = 0; i < consumers.size(); ++i) {
            ((ListenerContainer)consumers.get(i)).accept(activityToken);
        }
    }

    @GuardedBy(value={"mLock"})
    private int indexOf(Consumer<IBinder> consumer) {
        for (int i = 0; i < this.mListenerContainers.size(); ++i) {
            if (!this.mListenerContainers.get(i).isMatch(consumer)) continue;
            return i;
        }
        return -1;
    }

    private static class ListenerContainer {
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final Consumer<IBinder> mConsumer;

        ListenerContainer(@NonNull Executor executor, @NonNull Consumer<IBinder> consumer) {
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        public boolean isMatch(@NonNull Consumer<IBinder> consumer) {
            return this.mConsumer.equals(consumer);
        }

        public void accept(@NonNull IBinder activityToken) {
            this.mExecutor.execute(() -> this.mConsumer.accept(activityToken));
        }
    }
}

