/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityClient;
import android.net.Uri;
import android.os.IBinder;
import java.util.Objects;

@FlaggedApi(value="android.security.content_uri_permission_apis")
public class ComponentCaller {
    private final IBinder mActivityToken;
    private final IBinder mCallerToken;

    public ComponentCaller(@Nullable IBinder activityToken, @Nullable IBinder callerToken) {
        this.mActivityToken = activityToken;
        this.mCallerToken = callerToken;
    }

    public int getUid() {
        return ActivityClient.getInstance().getActivityCallerUid(this.mActivityToken, this.mCallerToken);
    }

    @Nullable
    public String getPackage() {
        return ActivityClient.getInstance().getActivityCallerPackage(this.mActivityToken, this.mCallerToken);
    }

    public int checkContentUriPermission(@NonNull Uri uri, int modeFlags) {
        return ActivityClient.getInstance().checkActivityCallerContentUriPermission(this.mActivityToken, this.mCallerToken, uri, modeFlags);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof ComponentCaller)) {
            return false;
        }
        ComponentCaller other = (ComponentCaller)obj;
        return this.mActivityToken == other.mActivityToken && this.mCallerToken == other.mCallerToken;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mActivityToken);
        result = 31 * result + Objects.hashCode(this.mCallerToken);
        return result;
    }
}

