/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.LoadedApk;
import android.app.PictureInPictureUiState;
import android.app.ResultInfo;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.DestroyActivityItem;
import android.app.servertransaction.PendingTransactionActions;
import android.app.servertransaction.TransactionExecutor;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.os.IBinder;
import android.util.MergedConfiguration;
import android.view.SurfaceControl;
import android.window.ActivityWindowInfo;
import android.window.SplashScreenView;
import android.window.WindowContextInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.ReferrerIntent;
import java.util.List;
import java.util.Map;

public abstract class ClientTransactionHandler {
    private boolean mIsExecutingLocalTransaction;

    void scheduleTransaction(ClientTransaction transaction) {
        transaction.preExecute(this);
        this.sendMessage(159, transaction);
    }

    @VisibleForTesting
    public void executeTransaction(ClientTransaction transaction) {
        this.mIsExecutingLocalTransaction = true;
        try {
            transaction.preExecute(this);
            this.getTransactionExecutor().execute(transaction);
        }
        finally {
            this.mIsExecutingLocalTransaction = false;
        }
    }

    public boolean isExecutingLocalTransaction() {
        return this.mIsExecutingLocalTransaction;
    }

    abstract TransactionExecutor getTransactionExecutor();

    abstract void sendMessage(int var1, Object var2);

    public abstract Activity getActivity(IBinder var1);

    public abstract void updatePendingConfiguration(Configuration var1);

    public abstract void updateProcessState(int var1, boolean var2);

    public abstract void countLaunchingActivities(int var1);

    public abstract Map<IBinder, DestroyActivityItem> getActivitiesToBeDestroyed();

    public abstract void handleDestroyActivity(@NonNull ActivityThread.ActivityClientRecord var1, boolean var2, boolean var3, String var4);

    public abstract void handlePauseActivity(@NonNull ActivityThread.ActivityClientRecord var1, boolean var2, boolean var3, boolean var4, PendingTransactionActions var5, String var6);

    public abstract void handleResumeActivity(@NonNull ActivityThread.ActivityClientRecord var1, boolean var2, boolean var3, boolean var4, String var5);

    public abstract void handleTopResumedActivityChanged(@NonNull ActivityThread.ActivityClientRecord var1, boolean var2, String var3);

    public abstract void handleStopActivity(@NonNull ActivityThread.ActivityClientRecord var1, PendingTransactionActions var2, boolean var3, String var4);

    public abstract void reportStop(PendingTransactionActions var1);

    public abstract void performRestartActivity(@NonNull ActivityThread.ActivityClientRecord var1, boolean var2);

    public abstract void reportRefresh(@NonNull ActivityThread.ActivityClientRecord var1);

    public abstract void updatePendingActivityConfiguration(@NonNull IBinder var1, @NonNull Configuration var2);

    public abstract void handleActivityConfigurationChanged(@NonNull ActivityThread.ActivityClientRecord var1, @NonNull Configuration var2, int var3, @NonNull ActivityWindowInfo var4);

    public abstract void handleWindowContextInfoChanged(@NonNull IBinder var1, @NonNull WindowContextInfo var2);

    public abstract void handleWindowContextWindowRemoval(@NonNull IBinder var1);

    public abstract void handleSendResult(@NonNull ActivityThread.ActivityClientRecord var1, List<ResultInfo> var2, String var3);

    public abstract void handleNewIntent(@NonNull ActivityThread.ActivityClientRecord var1, List<ReferrerIntent> var2);

    public abstract void handlePictureInPictureRequested(@NonNull ActivityThread.ActivityClientRecord var1);

    public abstract void handlePictureInPictureStateChanged(@NonNull ActivityThread.ActivityClientRecord var1, PictureInPictureUiState var2);

    public abstract boolean isHandleSplashScreenExit(@NonNull IBinder var1);

    public abstract void handleAttachSplashScreenView(@NonNull ActivityThread.ActivityClientRecord var1, @NonNull SplashScreenView.SplashScreenViewParcelable var2, @NonNull SurfaceControl var3);

    public abstract Activity handleLaunchActivity(@NonNull ActivityThread.ActivityClientRecord var1, PendingTransactionActions var2, int var3, Intent var4);

    public abstract void handleStartActivity(@NonNull ActivityThread.ActivityClientRecord var1, PendingTransactionActions var2, ActivityOptions.SceneTransitionInfo var3);

    public abstract LoadedApk getPackageInfoNoCheck(ApplicationInfo var1);

    public abstract void handleConfigurationChanged(Configuration var1, int var2);

    public abstract ActivityThread.ActivityClientRecord getActivityClient(IBinder var1);

    public abstract ActivityThread.ActivityClientRecord prepareRelaunchActivity(@NonNull IBinder var1, @Nullable List<ResultInfo> var2, @Nullable List<ReferrerIntent> var3, int var4, @NonNull MergedConfiguration var5, boolean var6, @NonNull ActivityWindowInfo var7);

    public abstract void handleRelaunchActivity(@NonNull ActivityThread.ActivityClientRecord var1, @NonNull PendingTransactionActions var2);

    public abstract void reportRelaunch(@NonNull ActivityThread.ActivityClientRecord var1);
}

