/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TimeInterpolator;

public abstract class Keyframe
implements Cloneable {
    boolean mHasValue;
    boolean mValueWasSetOnStart;
    float mFraction;
    Class mValueType;
    private TimeInterpolator mInterpolator = null;

    public static Keyframe ofInt(float fraction2, int value) {
        return new IntKeyframe(fraction2, value);
    }

    public static Keyframe ofInt(float fraction2) {
        return new IntKeyframe(fraction2);
    }

    public static Keyframe ofFloat(float fraction2, float value) {
        return new FloatKeyframe(fraction2, value);
    }

    public static Keyframe ofFloat(float fraction2) {
        return new FloatKeyframe(fraction2);
    }

    public static Keyframe ofObject(float fraction2, Object value) {
        return new ObjectKeyframe(fraction2, value);
    }

    public static Keyframe ofObject(float fraction2) {
        return new ObjectKeyframe(fraction2, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    boolean valueWasSetOnStart() {
        return this.mValueWasSetOnStart;
    }

    void setValueWasSetOnStart(boolean valueWasSetOnStart) {
        this.mValueWasSetOnStart = valueWasSetOnStart;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float fraction2) {
        this.mFraction = fraction2;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public Class getType() {
        return this.mValueType;
    }

    public abstract Keyframe clone();

    static class IntKeyframe
    extends Keyframe {
        int mValue;

        IntKeyframe(float fraction2, int value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mValueType = Integer.TYPE;
            this.mHasValue = true;
        }

        IntKeyframe(float fraction2) {
            this.mFraction = fraction2;
            this.mValueType = Integer.TYPE;
        }

        public int getIntValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object value) {
            if (value != null && value.getClass() == Integer.class) {
                this.mValue = (Integer)value;
                this.mHasValue = true;
            }
        }

        @Override
        public IntKeyframe clone() {
            IntKeyframe kfClone = this.mHasValue ? new IntKeyframe(this.getFraction(), this.mValue) : new IntKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static class FloatKeyframe
    extends Keyframe {
        float mValue;

        FloatKeyframe(float fraction2, float value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mValueType = Float.TYPE;
            this.mHasValue = true;
        }

        FloatKeyframe(float fraction2) {
            this.mFraction = fraction2;
            this.mValueType = Float.TYPE;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.mValue);
        }

        @Override
        public void setValue(Object value) {
            if (value != null && value.getClass() == Float.class) {
                this.mValue = ((Float)value).floatValue();
                this.mHasValue = true;
            }
        }

        @Override
        public FloatKeyframe clone() {
            FloatKeyframe kfClone = this.mHasValue ? new FloatKeyframe(this.getFraction(), this.mValue) : new FloatKeyframe(this.getFraction());
            kfClone.setInterpolator(this.getInterpolator());
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            return kfClone;
        }
    }

    static class ObjectKeyframe
    extends Keyframe {
        Object mValue;

        ObjectKeyframe(float fraction2, Object value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mHasValue = value != null;
            this.mValueType = this.mHasValue ? value.getClass() : Object.class;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object value) {
            this.mValue = value;
            this.mHasValue = value != null;
        }

        @Override
        public ObjectKeyframe clone() {
            ObjectKeyframe kfClone = new ObjectKeyframe(this.getFraction(), this.hasValue() ? this.mValue : null);
            kfClone.mValueWasSetOnStart = this.mValueWasSetOnStart;
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }
}

