/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.adservices.ondevicepersonalization.ExecuteInIsolatedServiceRequest;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;

public class ExecuteOptionsParcel
implements Parcelable {
    private final int mOutputType;
    private final int mMaxIntValue;
    public static ExecuteOptionsParcel DEFAULT = new ExecuteOptionsParcel();
    @NonNull
    public static final Parcelable.Creator<ExecuteOptionsParcel> CREATOR = new Parcelable.Creator<ExecuteOptionsParcel>(){

        public ExecuteOptionsParcel[] newArray(int size) {
            return new ExecuteOptionsParcel[size];
        }

        @Override
        public ExecuteOptionsParcel createFromParcel(@NonNull Parcel in) {
            return new ExecuteOptionsParcel(in);
        }
    };

    public ExecuteOptionsParcel(@NonNull ExecuteInIsolatedServiceRequest.OutputSpec options) {
        this(options.getOutputType(), options.getMaxIntValue());
    }

    private ExecuteOptionsParcel() {
        this(0, -1);
    }

    public ExecuteOptionsParcel(int outputType, int maxIntValue) {
        this.mOutputType = outputType;
        AnnotationValidations.validate(ExecuteInIsolatedServiceRequest.OutputSpec.OutputType.class, null, this.mOutputType);
        this.mMaxIntValue = maxIntValue;
    }

    public int getOutputType() {
        return this.mOutputType;
    }

    public int getMaxIntValue() {
        return this.mMaxIntValue;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mOutputType);
        dest.writeInt(this.mMaxIntValue);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ExecuteOptionsParcel(@NonNull Parcel in) {
        int outputType = in.readInt();
        int maxIntValue = in.readInt();
        this.mOutputType = outputType;
        AnnotationValidations.validate(ExecuteInIsolatedServiceRequest.OutputSpec.OutputType.class, null, this.mOutputType);
        this.mMaxIntValue = maxIntValue;
    }
}

