/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.WebSourceRegistrationRequest;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class WebSourceRegistrationRequestInternal
implements Parcelable {
    public static final Parcelable.Creator<WebSourceRegistrationRequestInternal> CREATOR = new Parcelable.Creator<WebSourceRegistrationRequestInternal>(){

        @Override
        public WebSourceRegistrationRequestInternal createFromParcel(Parcel in) {
            return new WebSourceRegistrationRequestInternal(in);
        }

        public WebSourceRegistrationRequestInternal[] newArray(int size) {
            return new WebSourceRegistrationRequestInternal[size];
        }
    };
    @NonNull
    private final WebSourceRegistrationRequest mSourceRegistrationRequest;
    @NonNull
    private final String mAppPackageName;
    @NonNull
    private final String mSdkPackageName;
    private final long mRequestTime;
    private final boolean mIsAdIdPermissionGranted;

    private WebSourceRegistrationRequestInternal(@NonNull Builder builder) {
        this.mSourceRegistrationRequest = builder.mSourceRegistrationRequest;
        this.mAppPackageName = builder.mAppPackageName;
        this.mSdkPackageName = builder.mSdkPackageName;
        this.mRequestTime = builder.mRequestTime;
        this.mIsAdIdPermissionGranted = builder.mIsAdIdPermissionGranted;
    }

    private WebSourceRegistrationRequestInternal(Parcel in) {
        Objects.requireNonNull(in);
        this.mSourceRegistrationRequest = WebSourceRegistrationRequest.CREATOR.createFromParcel(in);
        this.mAppPackageName = in.readString();
        this.mSdkPackageName = in.readString();
        this.mRequestTime = in.readLong();
        this.mIsAdIdPermissionGranted = in.readBoolean();
    }

    public WebSourceRegistrationRequest getSourceRegistrationRequest() {
        return this.mSourceRegistrationRequest;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getSdkPackageName() {
        return this.mSdkPackageName;
    }

    public long getRequestTime() {
        return this.mRequestTime;
    }

    public boolean isAdIdPermissionGranted() {
        return this.mIsAdIdPermissionGranted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSourceRegistrationRequestInternal)) {
            return false;
        }
        WebSourceRegistrationRequestInternal that = (WebSourceRegistrationRequestInternal)o;
        return Objects.equals(this.mSourceRegistrationRequest, that.mSourceRegistrationRequest) && Objects.equals(this.mAppPackageName, that.mAppPackageName) && Objects.equals(this.mSdkPackageName, that.mSdkPackageName) && this.mRequestTime == that.mRequestTime && this.mIsAdIdPermissionGranted == that.mIsAdIdPermissionGranted;
    }

    public int hashCode() {
        return Objects.hash(this.mSourceRegistrationRequest, this.mAppPackageName, this.mSdkPackageName, this.mIsAdIdPermissionGranted);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        this.mSourceRegistrationRequest.writeToParcel(out, flags);
        out.writeString(this.mAppPackageName);
        out.writeString(this.mSdkPackageName);
        out.writeLong(this.mRequestTime);
        out.writeBoolean(this.mIsAdIdPermissionGranted);
    }

    public static class Builder {
        @NonNull
        private final WebSourceRegistrationRequest mSourceRegistrationRequest;
        @NonNull
        private final String mAppPackageName;
        @NonNull
        private final String mSdkPackageName;
        private final long mRequestTime;
        private boolean mIsAdIdPermissionGranted;

        public Builder(@NonNull WebSourceRegistrationRequest sourceRegistrationRequest, @NonNull String appPackageName, @NonNull String sdkPackageName, long requestTime) {
            Objects.requireNonNull(sourceRegistrationRequest);
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(sdkPackageName);
            this.mSourceRegistrationRequest = sourceRegistrationRequest;
            this.mAppPackageName = appPackageName;
            this.mSdkPackageName = sdkPackageName;
            this.mRequestTime = requestTime;
        }

        @NonNull
        public WebSourceRegistrationRequestInternal build() {
            return new WebSourceRegistrationRequestInternal(this);
        }

        public Builder setAdIdPermissionGranted(boolean isAdIdPermissionGranted) {
            this.mIsAdIdPermissionGranted = isAdIdPermissionGranted;
            return this;
        }
    }
}

