/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.measurement.SourceRegistrationRequest;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Objects;

public class SourceRegistrationRequestInternal
implements Parcelable {
    @NonNull
    private final SourceRegistrationRequest mSourceRegistrationRequest;
    @NonNull
    private final String mAppPackageName;
    @NonNull
    private final String mSdkPackageName;
    private final long mBootRelativeRequestTime;
    @Nullable
    private final String mAdIdValue;
    public static final Parcelable.Creator<SourceRegistrationRequestInternal> CREATOR = new Parcelable.Creator<SourceRegistrationRequestInternal>(){

        @Override
        public SourceRegistrationRequestInternal createFromParcel(Parcel in) {
            return new SourceRegistrationRequestInternal(in);
        }

        public SourceRegistrationRequestInternal[] newArray(int size) {
            return new SourceRegistrationRequestInternal[size];
        }
    };

    private SourceRegistrationRequestInternal(@NonNull Builder builder) {
        this.mSourceRegistrationRequest = builder.mRegistrationRequest;
        this.mAppPackageName = builder.mAppPackageName;
        this.mSdkPackageName = builder.mSdkPackageName;
        this.mBootRelativeRequestTime = builder.mBootRelativeRequestTime;
        this.mAdIdValue = builder.mAdIdValue;
    }

    private SourceRegistrationRequestInternal(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mSourceRegistrationRequest = SourceRegistrationRequest.CREATOR.createFromParcel(in);
        this.mAppPackageName = in.readString();
        this.mSdkPackageName = in.readString();
        this.mBootRelativeRequestTime = in.readLong();
        this.mAdIdValue = AdServicesParcelableUtil.readNullableFromParcel(in, Parcel::readString);
    }

    @NonNull
    public SourceRegistrationRequest getSourceRegistrationRequest() {
        return this.mSourceRegistrationRequest;
    }

    @NonNull
    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    @NonNull
    public String getSdkPackageName() {
        return this.mSdkPackageName;
    }

    @NonNull
    public long getBootRelativeRequestTime() {
        return this.mBootRelativeRequestTime;
    }

    @Nullable
    public String getAdIdValue() {
        return this.mAdIdValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceRegistrationRequestInternal)) {
            return false;
        }
        SourceRegistrationRequestInternal that = (SourceRegistrationRequestInternal)o;
        return Objects.equals(this.mSourceRegistrationRequest, that.mSourceRegistrationRequest) && Objects.equals(this.mAppPackageName, that.mAppPackageName) && Objects.equals(this.mSdkPackageName, that.mSdkPackageName) && this.mBootRelativeRequestTime == that.mBootRelativeRequestTime && Objects.equals(this.mAdIdValue, that.mAdIdValue);
    }

    public int hashCode() {
        return Objects.hash(this.mSourceRegistrationRequest, this.mAppPackageName, this.mSdkPackageName, this.mBootRelativeRequestTime, this.mAdIdValue);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        this.mSourceRegistrationRequest.writeToParcel(out, flags);
        out.writeString(this.mAppPackageName);
        out.writeString(this.mSdkPackageName);
        out.writeLong(this.mBootRelativeRequestTime);
        AdServicesParcelableUtil.writeNullableToParcel(out, this.mAdIdValue, Parcel::writeString);
    }

    public static class Builder {
        @NonNull
        private final SourceRegistrationRequest mRegistrationRequest;
        @NonNull
        private final String mAppPackageName;
        @NonNull
        private final String mSdkPackageName;
        private final long mBootRelativeRequestTime;
        @Nullable
        private String mAdIdValue;

        public Builder(@NonNull SourceRegistrationRequest registrationRequest, @NonNull String appPackageName, @NonNull String sdkPackageName, long bootRelativeRequestTime) {
            Objects.requireNonNull(registrationRequest);
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(sdkPackageName);
            this.mRegistrationRequest = registrationRequest;
            this.mAppPackageName = appPackageName;
            this.mSdkPackageName = sdkPackageName;
            this.mBootRelativeRequestTime = bootRelativeRequestTime;
        }

        @NonNull
        public SourceRegistrationRequestInternal build() {
            return new SourceRegistrationRequestInternal(this);
        }

        public Builder setAdIdValue(@Nullable String adIdValue) {
            this.mAdIdValue = adIdValue;
            return this;
        }
    }
}

