/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdSelectionSignals;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import java.time.Instant;
import java.util.Objects;

public class FetchAndJoinCustomAudienceRequest {
    @NonNull
    private final Uri mFetchUri;
    @Nullable
    private final String mName;
    @Nullable
    private final Instant mActivationTime;
    @Nullable
    private final Instant mExpirationTime;
    @Nullable
    private final AdSelectionSignals mUserBiddingSignals;

    private FetchAndJoinCustomAudienceRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder.mFetchUri);
        this.mFetchUri = builder.mFetchUri;
        this.mName = builder.mName;
        this.mActivationTime = builder.mActivationTime;
        this.mExpirationTime = builder.mExpirationTime;
        this.mUserBiddingSignals = builder.mUserBiddingSignals;
    }

    @NonNull
    public Uri getFetchUri() {
        return this.mFetchUri;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Instant getActivationTime() {
        return this.mActivationTime;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.mExpirationTime;
    }

    @Nullable
    public AdSelectionSignals getUserBiddingSignals() {
        return this.mUserBiddingSignals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchAndJoinCustomAudienceRequest)) {
            return false;
        }
        FetchAndJoinCustomAudienceRequest that = (FetchAndJoinCustomAudienceRequest)o;
        return ((Object)this.mFetchUri).equals(that.mFetchUri) && Objects.equals(this.mName, that.mName) && Objects.equals(this.mActivationTime, that.mActivationTime) && Objects.equals(this.mExpirationTime, that.mExpirationTime) && Objects.equals(this.mUserBiddingSignals, that.mUserBiddingSignals);
    }

    public int hashCode() {
        return Objects.hash(this.mFetchUri, this.mName, this.mActivationTime, this.mExpirationTime, this.mUserBiddingSignals);
    }

    public String toString() {
        return "FetchAndJoinCustomAudienceRequest{fetchUri=" + this.mFetchUri + ", name=" + this.mName + ", activationTime=" + this.mActivationTime + ", expirationTime=" + this.mExpirationTime + ", userBiddingSignals=" + this.mUserBiddingSignals + '}';
    }

    public static class Builder {
        @NonNull
        private Uri mFetchUri;
        @Nullable
        private String mName;
        @Nullable
        private Instant mActivationTime;
        @Nullable
        private Instant mExpirationTime;
        @Nullable
        private AdSelectionSignals mUserBiddingSignals;

        public Builder(@NonNull Uri fetchUri) {
            Objects.requireNonNull(fetchUri);
            this.mFetchUri = fetchUri;
        }

        @NonNull
        public Builder setFetchUri(@NonNull Uri fetchUri) {
            Objects.requireNonNull(fetchUri);
            this.mFetchUri = fetchUri;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setActivationTime(@Nullable Instant activationTime) {
            this.mActivationTime = activationTime;
            return this;
        }

        @NonNull
        public Builder setExpirationTime(@Nullable Instant expirationTime) {
            this.mExpirationTime = expirationTime;
            return this;
        }

        @NonNull
        public Builder setUserBiddingSignals(@Nullable AdSelectionSignals userBiddingSignals) {
            this.mUserBiddingSignals = userBiddingSignals;
            return this;
        }

        @NonNull
        public FetchAndJoinCustomAudienceRequest build() {
            Objects.requireNonNull(this.mFetchUri);
            return new FetchAndJoinCustomAudienceRequest(this);
        }
    }
}

