/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.NonNull;
import android.content.res.AssetFileDescriptor;
import android.os.ParcelFileDescriptor;
import com.android.adservices.LoggerFactory;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class AssetFileDescriptorUtil {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();

    private AssetFileDescriptorUtil() {
    }

    public static AssetFileDescriptor setupAssetFileDescriptorResponse(@NonNull byte[] buffer, @NonNull ExecutorService executorService) throws IOException {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(executorService);
        ParcelFileDescriptor[] descriptors = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor writeDescriptor = descriptors[1];
        executorService.execute(() -> {
            try (FileOutputStream outputStream = new FileOutputStream(writeDescriptor.getFileDescriptor());){
                outputStream.write(buffer);
            }
            catch (IOException e) {
                sLogger.e(e, "Encountered IO Exception while writing byte array to stream.");
            }
        });
        return new AssetFileDescriptor(descriptors[0], 0L, buffer.length);
    }

    public static byte[] readAssetFileDescriptorIntoBuffer(@NonNull AssetFileDescriptor assetFileDescriptor) throws IOException {
        Objects.requireNonNull(assetFileDescriptor);
        byte[] result = new byte[(int)assetFileDescriptor.getLength()];
        try (DataInputStream inputStream = new DataInputStream(assetFileDescriptor.createInputStream());){
            inputStream.readFully(result);
        }
        return result;
    }
}

