/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import com.android.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;

public class AdSelectionOutcome {
    @NonNull
    public static final AdSelectionOutcome NO_OUTCOME = new AdSelectionOutcome();
    public static final String UNSET_AD_SELECTION_ID_MESSAGE = "Non-zero ad selection ID must be set";
    public static final int UNSET_AD_SELECTION_ID = 0;
    private final long mAdSelectionId;
    @NonNull
    private final Uri mRenderUri;
    @NonNull
    private final AdTechIdentifier mWinningSeller;
    @NonNull
    private final List<Uri> mComponentAdUris;

    private AdSelectionOutcome() {
        this.mAdSelectionId = 0L;
        this.mRenderUri = Uri.EMPTY;
        this.mWinningSeller = AdTechIdentifier.UNSET_AD_TECH_IDENTIFIER;
        this.mComponentAdUris = List.of();
    }

    private AdSelectionOutcome(long adSelectionId, @NonNull Uri renderUri, @NonNull AdTechIdentifier winningSeller, @NonNull List<Uri> componentAdUris) {
        this.mAdSelectionId = adSelectionId;
        this.mRenderUri = Objects.requireNonNull(renderUri, "Render uri cannot be null");
        this.mWinningSeller = Objects.requireNonNull(winningSeller, "Winning seller cannot be null");
        this.mComponentAdUris = Objects.requireNonNull(componentAdUris, "Component ad uris cannot be null");
    }

    @NonNull
    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    @NonNull
    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_enable_winning_seller_id_in_ad_selection_outcome")
    @NonNull
    public AdTechIdentifier getWinningSeller() {
        return this.mWinningSeller;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_enable_custom_audience_component_ads")
    @NonNull
    public List<Uri> getComponentAdUris() {
        return this.mComponentAdUris;
    }

    public boolean hasOutcome() {
        return !this.equals(NO_OUTCOME);
    }

    public boolean equals(Object o) {
        if (o instanceof AdSelectionOutcome) {
            AdSelectionOutcome adSelectionOutcome = (AdSelectionOutcome)o;
            return this.mAdSelectionId == adSelectionOutcome.mAdSelectionId && Objects.equals(this.mRenderUri, adSelectionOutcome.mRenderUri) && Objects.equals(this.mWinningSeller, adSelectionOutcome.mWinningSeller) && Objects.equals(this.mComponentAdUris, adSelectionOutcome.mComponentAdUris);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mRenderUri, this.mWinningSeller, this.mComponentAdUris);
    }

    public static class Builder {
        private long mAdSelectionId = 0L;
        @Nullable
        private Uri mRenderUri;
        @NonNull
        private List<Uri> mComponentAdUris;
        @NonNull
        private AdTechIdentifier mWinningSeller = AdTechIdentifier.UNSET_AD_TECH_IDENTIFIER;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setRenderUri(@NonNull Uri renderUri) {
            this.mRenderUri = Objects.requireNonNull(renderUri, "Render uri cannot be null");
            return this;
        }

        @NonNull
        public Builder setWinningSeller(@NonNull AdTechIdentifier winningSeller) {
            this.mWinningSeller = Objects.requireNonNull(winningSeller, "Winning seller cannot be null");
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_enable_custom_audience_component_ads")
        @NonNull
        public Builder setComponentAdUris(@NonNull List<Uri> componentAdUris) {
            this.mComponentAdUris = Objects.requireNonNull(componentAdUris, "Component ad Uris cannot be null!");
            return this;
        }

        @NonNull
        public AdSelectionOutcome build() {
            Objects.requireNonNull(this.mRenderUri);
            Objects.requireNonNull(this.mWinningSeller);
            if (Objects.isNull(this.mComponentAdUris)) {
                this.mComponentAdUris = List.of();
            }
            Preconditions.checkArgument(this.mAdSelectionId != 0L, AdSelectionOutcome.UNSET_AD_SELECTION_ID_MESSAGE);
            return new AdSelectionOutcome(this.mAdSelectionId, this.mRenderUri, this.mWinningSeller, this.mComponentAdUris);
        }
    }
}

