/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adid.AdId;
import android.adservices.adid.AdIdManager;
import android.adservices.adselection.AdSelectionCallback;
import android.adservices.adselection.AdSelectionConfig;
import android.adservices.adselection.AdSelectionFromOutcomesConfig;
import android.adservices.adselection.AdSelectionFromOutcomesInput;
import android.adservices.adselection.AdSelectionInput;
import android.adservices.adselection.AdSelectionOutcome;
import android.adservices.adselection.AdSelectionResponse;
import android.adservices.adselection.AdSelectionService;
import android.adservices.adselection.GetAdSelectionDataCallback;
import android.adservices.adselection.GetAdSelectionDataInput;
import android.adservices.adselection.GetAdSelectionDataOutcome;
import android.adservices.adselection.GetAdSelectionDataRequest;
import android.adservices.adselection.GetAdSelectionDataResponse;
import android.adservices.adselection.PersistAdSelectionResultCallback;
import android.adservices.adselection.PersistAdSelectionResultInput;
import android.adservices.adselection.PersistAdSelectionResultRequest;
import android.adservices.adselection.PersistAdSelectionResultResponse;
import android.adservices.adselection.ReportEventRequest;
import android.adservices.adselection.ReportImpressionCallback;
import android.adservices.adselection.ReportImpressionInput;
import android.adservices.adselection.ReportImpressionRequest;
import android.adservices.adselection.ReportInteractionCallback;
import android.adservices.adselection.ReportInteractionInput;
import android.adservices.adselection.SetAppInstallAdvertisersCallback;
import android.adservices.adselection.SetAppInstallAdvertisersInput;
import android.adservices.adselection.SetAppInstallAdvertisersRequest;
import android.adservices.adselection.TestAdSelectionManager;
import android.adservices.adselection.UpdateAdCounterHistogramCallback;
import android.adservices.adselection.UpdateAdCounterHistogramInput;
import android.adservices.adselection.UpdateAdCounterHistogramRequest;
import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.AssetFileDescriptorUtil;
import android.adservices.common.CallerMetadata;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.common.SandboxedSdkContextUtils;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=31)
public class AdSelectionManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    public static final String AD_SELECTION_SERVICE = "ad_selection_service";
    private static final long AD_ID_TIMEOUT_MS = 400L;
    private static final String DEBUG_API_WARNING_MESSAGE = "To enable debug api, include ACCESS_ADSERVICES_AD_ID permission and enable advertising ID under device settings";
    private final Executor mAdIdExecutor = Executors.newCachedThreadPool();
    @NonNull
    private Context mContext;
    @NonNull
    private ServiceBinder<AdSelectionService> mServiceBinder;
    @NonNull
    private AdIdManager mAdIdManager;
    @NonNull
    private ServiceProvider mServiceProvider;

    @NonNull
    public static AdSelectionManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdSelectionManager.class) : new AdSelectionManager(context);
    }

    @VisibleForTesting
    @NonNull
    public static AdSelectionManager get(@NonNull Context context, @NonNull AdIdManager adIdManager, @NonNull AdSelectionService adSelectionService) {
        AdSelectionManager adSelectionManager = AdSelectionManager.get(context);
        adSelectionManager.mAdIdManager = adIdManager;
        adSelectionManager.mServiceProvider = () -> adSelectionService;
        return adSelectionManager;
    }

    public AdSelectionManager(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mServiceProvider = this::doGetService;
        this.initialize(context);
    }

    public AdSelectionManager initialize(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.adselection.AD_SELECTION_SERVICE", AdSelectionService.Stub::asInterface);
        this.mAdIdManager = AdIdManager.get(context);
        return this;
    }

    @NonNull
    public TestAdSelectionManager getTestAdSelectionManager() {
        return new TestAdSelectionManager(this);
    }

    @NonNull
    ServiceProvider getServiceProvider() {
        return this.mServiceProvider;
    }

    @NonNull
    AdSelectionService doGetService() {
        return this.mServiceBinder.getService();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void getAdSelectionData(@NonNull GetAdSelectionDataRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<GetAdSelectionDataOutcome, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.getAdSelectionData(new GetAdSelectionDataInput.Builder().setSeller(request.getSeller()).setCallerPackageName(this.getCallerPackageName()).setCoordinatorOriginUri(request.getCoordinatorOriginUri()).setSellerConfiguration(request.getSellerConfiguration()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new GetAdSelectionDataCallback.Stub(){

                @Override
                public void onSuccess(GetAdSelectionDataResponse resultParcel) {
                    executor.execute(() -> {
                        byte[] adSelectionData;
                        try {
                            adSelectionData = AdSelectionManager.this.getAdSelectionData(resultParcel);
                        }
                        catch (IOException e) {
                            receiver.onError(new IllegalStateException("Unable to return the AdSelectionData", e));
                            return;
                        }
                        receiver.onResult(new GetAdSelectionDataOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setAdSelectionData(adSelectionData).build());
                    });
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void persistAdSelectionResult(@NonNull PersistAdSelectionResultRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<AdSelectionOutcome, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.persistAdSelectionResult(new PersistAdSelectionResultInput.Builder().setSeller(request.getSeller()).setAdSelectionId(request.getAdSelectionId()).setAdSelectionResult(request.getAdSelectionResult()).setCallerPackageName(this.getCallerPackageName()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new PersistAdSelectionResultCallback.Stub(this){

                @Override
                public void onSuccess(PersistAdSelectionResultResponse resultParcel) {
                    executor.execute(() -> receiver.onResult(new AdSelectionOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setRenderUri(resultParcel.getAdRenderUri()).setWinningSeller(resultParcel.getWinningSeller()).setComponentAdUris(resultParcel.getComponentAdUris()).build()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void selectAds(@NonNull AdSelectionConfig adSelectionConfig, final @NonNull Executor executor, final @NonNull OutcomeReceiver<AdSelectionOutcome, Exception> receiver) {
        Objects.requireNonNull(adSelectionConfig);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.selectAds(new AdSelectionInput.Builder().setAdSelectionConfig(adSelectionConfig).setCallerPackageName(this.getCallerPackageName()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new AdSelectionCallback.Stub(this){

                @Override
                public void onSuccess(AdSelectionResponse resultParcel) {
                    executor.execute(() -> receiver.onResult(new AdSelectionOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setRenderUri(resultParcel.getRenderUri()).setWinningSeller(resultParcel.getWinningSeller()).build()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void selectAds(@NonNull AdSelectionFromOutcomesConfig adSelectionFromOutcomesConfig, final @NonNull Executor executor, final @NonNull OutcomeReceiver<AdSelectionOutcome, Exception> receiver) {
        Objects.requireNonNull(adSelectionFromOutcomesConfig);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.selectAdsFromOutcomes(new AdSelectionFromOutcomesInput.Builder().setAdSelectionFromOutcomesConfig(adSelectionFromOutcomesConfig).setCallerPackageName(this.getCallerPackageName()).build(), new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build(), new AdSelectionCallback.Stub(this){

                @Override
                public void onSuccess(AdSelectionResponse resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel == null) {
                            receiver.onResult(AdSelectionOutcome.NO_OUTCOME);
                        } else {
                            receiver.onResult(new AdSelectionOutcome.Builder().setAdSelectionId(resultParcel.getAdSelectionId()).setRenderUri(resultParcel.getRenderUri()).setWinningSeller(resultParcel.getWinningSeller()).build());
                        }
                    });
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Failure of AdSelection service.");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void reportImpression(@NonNull ReportImpressionRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.reportImpression(new ReportImpressionInput.Builder().setAdSelectionId(request.getAdSelectionId()).setAdSelectionConfig(request.getAdSelectionConfig()).setCallerPackageName(this.getCallerPackageName()).build(), new ReportImpressionCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void reportEvent(@NonNull ReportEventRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ReportInteractionInput.Builder inputBuilder = new ReportInteractionInput.Builder().setAdSelectionId(request.getAdSelectionId()).setInteractionKey(request.getKey()).setInteractionData(request.getData()).setReportingDestinations(request.getReportingDestinations()).setCallerPackageName(this.getCallerPackageName()).setCallerSdkName(this.getCallerSdkName()).setInputEvent(request.getInputEvent());
            this.getAdId(adIdValue -> inputBuilder.setAdId(adIdValue));
            AdSelectionService service = this.getServiceProvider().getService();
            service.reportInteraction(inputBuilder.build(), new ReportInteractionCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void setAppInstallAdvertisers(@NonNull SetAppInstallAdvertisersRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            service.setAppInstallAdvertisers(new SetAppInstallAdvertisersInput.Builder().setAdvertisers(request.getAdvertisers()).setCallerPackageName(this.getCallerPackageName()).build(), new SetAppInstallAdvertisersCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service.");
            receiver.onError(new IllegalStateException("Unable to find the AdSelection service.", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Failure of AdSelection service.", e));
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE", "android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS", "android.permission.ACCESS_ADSERVICES_AD_SELECTION"})
    public void updateAdCounterHistogram(@NonNull UpdateAdCounterHistogramRequest updateAdCounterHistogramRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> outcomeReceiver) {
        Objects.requireNonNull(updateAdCounterHistogramRequest, "Request must not be null");
        Objects.requireNonNull(executor, "Executor must not be null");
        Objects.requireNonNull(outcomeReceiver, "Outcome receiver must not be null");
        try {
            AdSelectionService service = this.getServiceProvider().getService();
            Objects.requireNonNull(service);
            service.updateAdCounterHistogram(new UpdateAdCounterHistogramInput.Builder(updateAdCounterHistogramRequest.getAdSelectionId(), updateAdCounterHistogramRequest.getAdEventType(), updateAdCounterHistogramRequest.getCallerAdTech(), this.getCallerPackageName()).build(), new UpdateAdCounterHistogramCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> outcomeReceiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> outcomeReceiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (NullPointerException e) {
            sLogger.e(e, "Unable to find the AdSelection service");
            outcomeReceiver.onError(new IllegalStateException("Unable to find the AdSelection service", e));
        }
        catch (RemoteException e) {
            sLogger.e(e, "Remote exception encountered while updating ad counter histogram");
            outcomeReceiver.onError(new IllegalStateException("Failure of AdSelection service", e));
        }
    }

    private String getCallerPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }

    private byte[] getAdSelectionData(GetAdSelectionDataResponse response) throws IOException {
        if (Objects.nonNull(response.getAssetFileDescriptor())) {
            AssetFileDescriptor assetFileDescriptor = response.getAssetFileDescriptor();
            return AssetFileDescriptorUtil.readAssetFileDescriptorIntoBuffer(assetFileDescriptor);
        }
        return response.getAdSelectionData();
    }

    private String getCallerSdkName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? "" : sandboxedSdkContext.getSdkPackageName();
    }

    @SuppressLint(value={"MissingPermission"})
    private void getAdId(AdSelectionAdIdCallback adSelectionAdIdCallback) {
        try {
            final CountDownLatch timer = new CountDownLatch(1);
            final AtomicReference adIdValue = new AtomicReference();
            this.mAdIdManager.getAdId(this.mAdIdExecutor, new AdServicesOutcomeReceiver<AdId, Exception>(this){

                @Override
                public void onResult(AdId adId) {
                    String id2 = adId.getAdId();
                    adIdValue.set(!"00000000-0000-0000-0000-000000000000".equals(id2) ? id2 : null);
                    sLogger.v("AdId permission enabled: %b.", !"00000000-0000-0000-0000-000000000000".equals(id2));
                    timer.countDown();
                }

                @Override
                public void onError(Exception e) {
                    if (e instanceof IllegalStateException || e instanceof SecurityException) {
                        sLogger.w(AdSelectionManager.DEBUG_API_WARNING_MESSAGE);
                    } else {
                        sLogger.w(e, AdSelectionManager.DEBUG_API_WARNING_MESSAGE, new Object[0]);
                    }
                    timer.countDown();
                }
            });
            boolean timedOut = false;
            try {
                timedOut = !timer.await(400L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                sLogger.w(e, "Interrupted while getting the AdId.", new Object[0]);
            }
            if (timedOut) {
                sLogger.w("AdId call timed out.");
            }
            adSelectionAdIdCallback.onResult((String)adIdValue.get());
        }
        catch (Exception e) {
            sLogger.d(e, "Could not get AdId.", new Object[0]);
            adSelectionAdIdCallback.onResult(null);
        }
    }

    static interface ServiceProvider {
        @NonNull
        public AdSelectionService getService();
    }

    private static interface AdSelectionAdIdCallback {
        public void onResult(@Nullable String var1);
    }
}

