/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adid;

import android.adservices.adid.AdId;
import android.adservices.adid.GetAdIdParam;
import android.adservices.adid.GetAdIdResult;
import android.adservices.adid.IAdIdService;
import android.adservices.adid.IGetAdIdCallback;
import android.adservices.adid.RecreateAdIdResult;
import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.AndroidRCommonUtil;
import android.adservices.common.CallerMetadata;
import android.adservices.common.OutcomeReceiverConverter;
import android.adservices.common.SandboxedSdkContextUtils;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.adservices.shared.common.exception.ServiceUnavailableException;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Objects;
import java.util.concurrent.Executor;

public class AdIdManager {
    public static final String ADID_SERVICE = "adid_service";
    static final String EMPTY_SDK = "";
    private Context mContext;
    private ServiceBinder<IAdIdService> mServiceBinder;

    @NonNull
    public static AdIdManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(AdIdManager.class) : new AdIdManager(context);
    }

    public AdIdManager(Context context) {
        this.initialize(context);
    }

    public AdIdManager initialize(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.ADID_SERVICE", IAdIdService.Stub::asInterface);
        return this;
    }

    private IAdIdService getService(Executor executor, OutcomeReceiver<AdId, Exception> callback) {
        IAdIdService service = null;
        try {
            service = this.mServiceBinder.getService();
            if (service == null) {
                throw new ServiceUnavailableException("Service is not available.");
            }
        }
        catch (RuntimeException e) {
            LogUtil.e(e, "Failed binding to AdId service");
            executor.execute(() -> callback.onError(e));
        }
        return service;
    }

    private Context getContext() {
        return this.mContext;
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_AD_ID")
    @NonNull
    public void getAdId(final @NonNull Executor executor, final @NonNull OutcomeReceiver<AdId, Exception> callback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        CallerMetadata callerMetadata = new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
        String appPackageName = EMPTY_SDK;
        String sdkPackageName = EMPTY_SDK;
        Context getAdIdRequestContext = this.getContext();
        SandboxedSdkContext requestContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(getAdIdRequestContext);
        if (requestContext != null) {
            sdkPackageName = requestContext.getSdkPackageName();
            appPackageName = requestContext.getClientPackageName();
        } else {
            appPackageName = getAdIdRequestContext.getPackageName();
        }
        try {
            IAdIdService service = this.getService(executor, callback);
            if (service == null) {
                LogUtil.w("Unable to find AdId service");
                return;
            }
            service.getAdId(new GetAdIdParam.Builder().setAppPackageName(appPackageName).setSdkPackageName(sdkPackageName).build(), callerMetadata, new IGetAdIdCallback.Stub(this){

                @Override
                public void onResult(GetAdIdResult resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel.isSuccess()) {
                            callback.onResult(new AdId(resultParcel.getAdId(), resultParcel.isLatEnabled()));
                        } else {
                            callback.onError(AdServicesStatusUtils.asException(resultParcel));
                        }
                    });
                }

                @Override
                public void onError(int resultCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(resultCode)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            callback.onError(e);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_AD_ID")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    @NonNull
    public void getAdId(@NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<AdId, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.getAdId(executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @FlaggedApi(value="com.android.adservices.flags.adid_enable_synchronous_ad_id_api")
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_AD_ID")
    @Nullable
    public AdId getAdId() {
        IAdIdService service = null;
        try {
            service = this.mServiceBinder.getService();
            if (service == null) {
                return null;
            }
            GetAdIdResult getAdIdResult = service.getAdIdSync();
            if (getAdIdResult == null) {
                return null;
            }
            return new AdId(getAdIdResult.getAdId(), getAdIdResult.isLatEnabled());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }

    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adid_enable_synchronous_ad_id_api")
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.UPDATE_PRIVILEGED_AD_ID")
    @NonNull
    public AdId recreateAdId() {
        try {
            IAdIdService service = this.mServiceBinder.getService();
            if (service == null) {
                throw new ServiceUnavailableException();
            }
            RecreateAdIdResult result = service.recreateAdId();
            if (result == null) {
                throw new IllegalStateException();
            }
            return new AdId(result.getAdId(), result.isLimitAdTrackingEnabled());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.adservices.flags.adid_enable_synchronous_ad_id_api")
    @RequiresApi(value=33)
    @RequiresPermission(value="android.permission.UPDATE_PRIVILEGED_AD_ID")
    public void deleteAdId() {
        try {
            IAdIdService service = this.mServiceBinder.getService();
            if (service == null) {
                throw new ServiceUnavailableException();
            }
            service.deleteAdId();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

