/*
 * Decompiled with CFR 0.152.
 */
package android.aconfig;

import android.aconfig.nano.Aconfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeviceProtos {
    public static final String[] PATHS = new String[]{"/system/etc/aconfig_flags.pb", "/system_ext/etc/aconfig_flags.pb", "/product/etc/aconfig_flags.pb", "/vendor/etc/aconfig_flags.pb"};
    private static final String APEX_DIR = "/apex";
    private static final String APEX_ACONFIG_PATH_SUFFIX = "/etc/aconfig_flags.pb";

    public static List<Aconfig.parsed_flag> loadAndParseFlagProtos() throws IOException {
        ArrayList<Aconfig.parsed_flag> result = new ArrayList<Aconfig.parsed_flag>();
        for (String path : DeviceProtos.parsedFlagsProtoPaths()) {
            try (FileInputStream inputStream = new FileInputStream(path);){
                Aconfig.parsed_flags parsedFlags = Aconfig.parsed_flags.parseFrom(inputStream.readAllBytes());
                for (Aconfig.parsed_flag flag : parsedFlags.parsedFlag) {
                    result.add(flag);
                }
            }
        }
        return result;
    }

    public static List<String> parsedFlagsProtoPaths() {
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(PATHS));
        File apexDirectory = new File(APEX_DIR);
        if (!apexDirectory.isDirectory()) {
            return paths;
        }
        File[] subdirs = apexDirectory.listFiles();
        if (subdirs == null) {
            return paths;
        }
        for (File prefix : subdirs) {
            File protoPath;
            if (prefix.getAbsolutePath().contains("@") || !(protoPath = new File(prefix + APEX_ACONFIG_PATH_SUFFIX)).exists()) continue;
            paths.add(protoPath.getAbsolutePath());
        }
        return paths;
    }
}

