/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBrailleDisplayConnection
extends IInterface {
    public static final String DESCRIPTOR = "android.accessibilityservice.IBrailleDisplayConnection";

    public void disconnect() throws RemoteException;

    public void write(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBrailleDisplayConnection {
        static final int TRANSACTION_disconnect = 1;
        static final int TRANSACTION_write = 2;

        public Stub() {
            this.attachInterface(this, IBrailleDisplayConnection.DESCRIPTOR);
        }

        public static IBrailleDisplayConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBrailleDisplayConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IBrailleDisplayConnection) {
                return (IBrailleDisplayConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "disconnect";
                }
                case 2: {
                    return "write";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBrailleDisplayConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.disconnect();
                    break;
                }
                case 2: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.write(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IBrailleDisplayConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBrailleDisplayConnection.DESCRIPTOR;
            }

            @Override
            public void disconnect() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayConnection.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] output) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayConnection.DESCRIPTOR);
                    _data.writeByteArray(output);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBrailleDisplayConnection {
        @Override
        public void disconnect() throws RemoteException {
        }

        @Override
        public void write(byte[] output) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

