/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.SdkConstants;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.legacy.LegacyRepoUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.Library;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddonTarget
implements IAndroidTarget {
    private final LocalPackage mPackage;
    private final DetailsTypes.AddonDetailsType mDetails;
    private final IAndroidTarget mBasePlatform;
    private final List<Path> mSkins;
    private final Path mDefaultSkin;
    private final List<OptionalLibrary> mAdditionalLibraries;

    public AddonTarget(LocalPackage p, IAndroidTarget baseTarget, ProgressIndicator progress2) {
        this.mPackage = p;
        this.mBasePlatform = baseTarget;
        TypeDetails details = p.getTypeDetails();
        assert (details instanceof DetailsTypes.AddonDetailsType);
        this.mDetails = (DetailsTypes.AddonDetailsType)details;
        HashMap skins = Maps.newHashMap();
        for (Path skin : baseTarget.getSkins()) {
            skins.put(skin.getFileName().toString(), skin);
        }
        for (Path skin : PackageParserUtils.parseSkinFolder(p.getLocation().resolve("skins"))) {
            skins.put(skin.getFileName().toString(), skin);
        }
        this.mSkins = ImmutableList.copyOf(skins.values());
        String defaultSkinName = this.mDetails.getDefaultSkin();
        this.mDefaultSkin = defaultSkinName != null ? this.getPath(5).resolve(defaultSkinName) : (this.getSkins().size() == 1 ? this.getSkins().get(0) : this.mBasePlatform.getDefaultSkin());
        this.mAdditionalLibraries = AddonTarget.parseAdditionalLibraries(p, progress2);
    }

    private static List<OptionalLibrary> parseAdditionalLibraries(LocalPackage p, ProgressIndicator progress2) {
        DetailsTypes.AddonDetailsType.Libraries libraries = ((DetailsTypes.AddonDetailsType)p.getTypeDetails()).getLibraries();
        ArrayList result = Lists.newArrayList();
        if (libraries != null) {
            for (Library library : libraries.getLibrary()) {
                if (library.getLocalJarPath() == null) {
                    return LegacyRepoUtils.parseLegacyAdditionalLibraries(p.getLocation(), progress2);
                }
                library.setPackagePath(p.getLocation());
                result.add(library);
            }
        }
        return result;
    }

    @Override
    public String getLocation() {
        return this.mPackage.getLocation().toString() + File.separator;
    }

    @Override
    public String getVendor() {
        return this.mDetails.getVendor().getDisplay();
    }

    @Override
    public String getName() {
        return this.mDetails.getTag().getDisplay();
    }

    @Override
    public String getFullName() {
        return this.mPackage.getDisplayName();
    }

    @Override
    public String getClasspathName() {
        return String.format("%1$s [%2$s]", this.getName(), this.mBasePlatform.getClasspathName());
    }

    @Override
    public String getShortClasspathName() {
        return String.format("%1$s [%2$s]", this.getName(), this.mBasePlatform.getVersionName());
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mDetails.getAndroidVersion();
    }

    @Override
    public String getVersionName() {
        return this.mBasePlatform.getVersionName();
    }

    @Override
    public int getRevision() {
        return this.mPackage.getVersion().getMajor();
    }

    @Override
    public boolean isPlatform() {
        return false;
    }

    @Override
    public IAndroidTarget getParent() {
        return this.mBasePlatform;
    }

    @Override
    public Path getPath(int pathId) {
        Path installPath = this.mPackage.getLocation();
        switch (pathId) {
            case 5: {
                return installPath.resolve(SdkConstants.OS_SKINS_FOLDER);
            }
            case 19: {
                return installPath.resolve("docs").resolve("reference");
            }
        }
        return this.mBasePlatform.getPath(pathId);
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return this.mBasePlatform.getBuildToolInfo();
    }

    @Override
    public List<String> getBootClasspath() {
        return this.mBasePlatform.getBootClasspath();
    }

    @Override
    public List<OptionalLibrary> getOptionalLibraries() {
        return this.mBasePlatform.getOptionalLibraries();
    }

    @Override
    public List<OptionalLibrary> getAdditionalLibraries() {
        return this.mAdditionalLibraries;
    }

    @Override
    public boolean hasRenderingLibrary() {
        return false;
    }

    @Override
    public List<Path> getSkins() {
        return this.mSkins;
    }

    @Override
    public Path getDefaultSkin() {
        return this.mDefaultSkin;
    }

    @Override
    public String[] getPlatformLibraries() {
        return this.mBasePlatform.getPlatformLibraries();
    }

    @Override
    public String getProperty(String name) {
        return this.mBasePlatform.getProperty(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mBasePlatform.getProperties();
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (target == this) {
            return true;
        }
        if (!(this.getAdditionalLibraries().isEmpty() || this.getVendor().equals(target.getVendor()) && this.getName().equals(target.getName()))) {
            return false;
        }
        return this.mBasePlatform.canRunOn(target);
    }

    @Override
    public String hashString() {
        return this.getVendor() + ":" + this.getName() + ":" + this.mBasePlatform.getVersion().getApiString();
    }

    @Override
    public int compareTo(IAndroidTarget target) {
        if (this == target) {
            return 0;
        }
        int versionDiff = this.getVersion().compareTo(target.getVersion());
        if (versionDiff == 0) {
            if (target.isPlatform()) {
                return 1;
            }
            AddonTarget targetAddOn = (AddonTarget)target;
            int vendorDiff = this.getVendor().compareTo(targetAddOn.getVendor());
            if (vendorDiff == 0) {
                return this.getName().compareTo(targetAddOn.getName());
            }
            return vendorDiff;
        }
        return versionDiff;
    }

    public boolean equals(Object obj) {
        return obj instanceof AddonTarget && this.compareTo((AddonTarget)obj) == 0;
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }
}

