/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy;

import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.Dependency;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.legacy.FileOp;
import com.android.sdklib.repository.legacy.LegacyRepoUtils;
import com.android.sdklib.repository.legacy.descriptors.PkgType;
import com.android.sdklib.repository.legacy.io.FileOpImpl;
import com.android.sdklib.repository.legacy.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.legacy.local.LocalSdk;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LegacyLocalRepoLoader
implements FallbackLocalRepoLoader {
    private final LocalSdk mLocalSdk;
    private Map<File, LocalPkgInfo> mPkgs = null;
    private final FileOp mFop;

    public LegacyLocalRepoLoader(Path root) {
        FileOp fop = this.createFileOp(root);
        this.mLocalSdk = new LocalSdk(fop);
        this.mLocalSdk.setLocation(FileOpUtils.toFile((Path)root));
        this.mFop = fop;
    }

    @Deprecated
    private FileOp createFileOp(Path path) {
        if (path != null) {
            try {
                FileSystem desiredFs = path.getFileSystem();
                if (desiredFs != FileSystems.getDefault()) {
                    Class<?> mockFileOp = FileOp.class.getClassLoader().loadClass("com.android.sdklib.repository.legacy.MockFileOp");
                    return (FileOp)mockFileOp.getConstructor(FileSystem.class).newInstance(desiredFs);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new FileOpImpl();
    }

    public LocalPackage parseLegacyLocalPackage(Path dirPath, ProgressIndicator progress2) {
        LocalPkgInfo info;
        File dir = FileOpUtils.toFile((Path)dirPath);
        if (!this.mFop.exists(new File(dir, "source.properties"))) {
            return null;
        }
        progress2.logVerbose(String.format("Parsing legacy package: %s", dir));
        if (this.mPkgs == null) {
            HashMap result = Maps.newHashMap();
            this.mLocalSdk.clearLocalPkg(PkgType.PKG_ALL);
            for (LocalPkgInfo local : this.mLocalSdk.getPkgsInfos(PkgType.PKG_ALL)) {
                result.put(local.getLocalDir(), local);
            }
            this.mPkgs = result;
        }
        if ((info = this.mPkgs.get(dir)) == null) {
            return null;
        }
        return new LegacyLocalPackage(info, progress2);
    }

    public void refresh() {
        this.mPkgs = null;
    }

    public boolean shouldParse(Path root) {
        return CancellableFileIo.exists((Path)root.resolve("source.properties"), (LinkOption[])new LinkOption[0]);
    }

    class LegacyLocalPackage
    implements LocalPackage {
        private final ProgressIndicator mProgress;
        private final LocalPkgInfo mWrapped;

        LegacyLocalPackage(LocalPkgInfo wrapped, ProgressIndicator progress2) {
            this.mWrapped = wrapped;
            this.mProgress = progress2;
        }

        public TypeDetails getTypeDetails() {
            int layoutVersion = 0;
            if (this.mWrapped instanceof LocalPlatformPkgInfo) {
                layoutVersion = ((LocalPlatformPkgInfo)this.mWrapped).getLayoutlibApi();
            }
            List<Object> addonLibraries = Lists.newArrayList();
            if (this.mWrapped instanceof LocalAddonPkgInfo) {
                addonLibraries = LegacyRepoUtils.parseLegacyAdditionalLibraries(LegacyLocalRepoLoader.this.mFop.toPath(this.mWrapped.getLocalDir()), this.mProgress);
            }
            return LegacyRepoUtils.createTypeDetails(this.mWrapped.getDesc(), layoutVersion, addonLibraries, this.getLocation());
        }

        public Revision getVersion() {
            return this.mWrapped.getDesc().getRevision();
        }

        public String getDisplayName() {
            return LegacyRepoUtils.getDisplayName(this.mWrapped.getDesc());
        }

        public License getLicense() {
            License res = this.mWrapped.getDesc().getLicense();
            CommonFactory factory = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
            if (res == null) {
                res = factory.createLicenseType();
                res.setValue(this.mWrapped.getSourceProperties().getProperty("Pkg.License"));
                res.setId(String.format(Locale.US, "license-%X", this.mWrapped.getSourceProperties().hashCode()));
                res.setType("text");
            }
            return res;
        }

        public Collection<Dependency> getAllDependencies() {
            ArrayList result = Lists.newArrayList();
            Revision rev = this.mWrapped.getDesc().getMinPlatformToolsRev();
            CommonFactory factory = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
            if (rev != null) {
                result.add(factory.createDependencyType(rev, "platform-tools"));
            }
            if ((rev = this.mWrapped.getDesc().getMinToolsRev()) != null) {
                result.add(factory.createDependencyType(rev, "tools"));
            }
            return result;
        }

        public String getPath() {
            File sourcePropsFile = new File(this.mWrapped.getLocalDir(), "source.properties");
            try {
                Properties sourceProps = new Properties();
                sourceProps.load(LegacyLocalRepoLoader.this.mFop.newFileInputStream(sourcePropsFile));
                String newPath = sourceProps.getProperty("Pkg.Path");
                if (newPath != null) {
                    return newPath;
                }
            }
            catch (IOException sourceProps) {
                // empty catch block
            }
            String relativePath = null;
            try {
                relativePath = FileOpUtils.makeRelative((File)this.mWrapped.getLocalSdk().getLocation(), (File)this.mWrapped.getLocalDir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return LegacyRepoUtils.getLegacyPath(this.mWrapped.getDesc(), relativePath);
        }

        public boolean obsolete() {
            return this.mWrapped.getDesc().isObsolete() || this.mWrapped.getDesc().getType() == PkgType.PKG_SAMPLE;
        }

        public CommonFactory createFactory() {
            return (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
        }

        public RepoPackageImpl asMarshallable() {
            return LocalPackageImpl.create((RepoPackage)this);
        }

        public int compareTo(RepoPackage o) {
            int result = ComparisonChain.start().compare((Comparable)((Object)this.getPath()), (Comparable)((Object)o.getPath())).compare((Comparable)this.getVersion(), (Comparable)o.getVersion()).result();
            if (result != 0) {
                return result;
            }
            if (!(o instanceof LocalPackage)) {
                return this.getClass().getName().compareTo(o.getClass().getName());
            }
            return 0;
        }

        public Path getLocation() {
            return LegacyLocalRepoLoader.this.mFop.toPath(this.mWrapped.getLocalDir());
        }

        public void setInstalledPath(Path root) {
        }
    }
}

