/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocationsException;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdBuilder;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManagerException;
import com.android.sdklib.internal.avd.AvdNames;
import com.android.sdklib.internal.avd.AvdNamesKt;
import com.android.sdklib.internal.avd.EmulatorPackage;
import com.android.sdklib.internal.avd.EmulatorPackages;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.InternalSdCard;
import com.android.sdklib.internal.avd.OnDiskSkin;
import com.android.sdklib.internal.avd.SdCard;
import com.android.sdklib.internal.avd.SdCards;
import com.android.sdklib.internal.avd.Skin;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 y2\u00020\u0001:\u0001yB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\u001bJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0010H\u0007J\u0018\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001bH\u0007J\b\u0010*\u001a\u00020'H\u0007J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0007J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020.H\u0007J\u0018\u00103\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u00102\u001a\u00020.H\u0007J\u0018\u00104\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u00102\u001a\u00020.H\u0007J\u0010\u00105\u001a\u00020\u00102\u0006\u00102\u001a\u00020.H\u0002J\u00b6\u0001\u00101\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u0002082\n\b\u0002\u00109\u001a\u0004\u0018\u00010:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\u0016\b\u0002\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010>2\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010>2\u0016\b\u0002\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010>2\u0016\b\u0002\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010>2\b\b\u0002\u0010B\u001a\u00020\u001d2\b\b\u0002\u0010C\u001a\u00020\u001d2\b\b\u0002\u0010D\u001a\u00020\u001dH\u0007J\u001e\u0010E\u001a\u00020'2\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010>H\u0002J,\u0010F\u001a\u00020'2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0G2\u0006\u0010H\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0016\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0010J(\u00104\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u001b2\u0006\u00107\u001a\u000208H\u0002J>\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010G2\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001bH\u0002J\u0010\u0010S\u001a\u00020\u001b2\u0006\u00107\u001a\u000208H\u0002J(\u0010T\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u001d2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u0010H\u0002J\u0010\u0010X\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0010H\u0007J$\u0010Y\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00102\b\u0010L\u001a\u0004\u0018\u00010\u001b2\b\u0010Z\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010[\u001a\u00020\u001d2\u0006\u0010\\\u001a\u00020\u0005H\u0002J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\u0016\u0010^\u001a\u00020'2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010`\u001a\u00020\u00102\u0006\u0010a\u001a\u00020\u0005H\u0007J\u0010\u0010b\u001a\u00020\u001d2\u0006\u0010c\u001a\u00020\u001bH\u0002J,\u0010d\u001a\u00020'2\u0006\u0010N\u001a\u00020\u00052\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0>2\u0006\u0010f\u001a\u00020\u001dH\u0002J\u000e\u0010g\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0010J$\u0010h\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0>H\u0007J\u0012\u0010j\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\u0010H\u0007J$\u0010k\u001a\u00020'2\u0006\u0010l\u001a\u0002082\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0GH\u0002J\u001a\u0010n\u001a\u00020'2\u0006\u0010o\u001a\u00020\u00102\b\u0010p\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010q\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0006\u0010!\u001a\u00020\u0005H\u0002J$\u0010r\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0GH\u0002J$\u0010s\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0GH\u0002J \u0010t\u001a\u00020'2\u0006\u0010;\u001a\u00020u2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0005H\u0002J$\u0010v\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0GH\u0002Jv\u0010w\u001a\u00020\u00102\u0006\u00107\u001a\u0002082\u0006\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\b\u0010x\u001a\u0004\u0018\u00010\u00102\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0>2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0>2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006z"}, d2={"Lcom/android/sdklib/internal/avd/AvdManager;", "", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "baseAvdFolder", "Ljava/nio/file/Path;", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "log", "Lcom/android/utils/ILogger;", "<init>", "(Lcom/android/sdklib/repository/AndroidSdkHandler;Ljava/nio/file/Path;Lcom/android/sdklib/devices/DeviceManager;Lcom/android/utils/ILogger;)V", "getBaseAvdFolder", "()Ljava/nio/file/Path;", "allAvdList", "", "Lcom/android/sdklib/internal/avd/AvdInfo;", "validAvdList", "", "sdkLocation", "allAvds", "getAllAvds", "()Ljava/util/List;", "validAvds", "getValidAvds", "getAvd", "name", "", "validAvdOnly", "", "findAvdWithDisplayName", "displayName", "findAvdWithFolder", "avdFolder", "getPid", "", "avd", "element", "deleteLockFiles", "", "deleteLockFile", "resolveLockFile", "reloadAvds", "reloadAvd", "avdInfo", "createAvdBuilder", "Lcom/android/sdklib/internal/avd/AvdBuilder;", "device", "Lcom/android/sdklib/devices/Device;", "createAvd", "builder", "editAvd", "duplicateAvd", "createOrEditAvd", "avdName", "systemImage", "Lcom/android/sdklib/ISystemImage;", "skin", "Lcom/android/sdklib/internal/avd/Skin;", "sdcard", "Lcom/android/sdklib/internal/avd/SdCard;", "hardwareConfig", "", "userSettings", "bootProps", "environment", "deviceHasPlayStore", "removePrevious", "editExisting", "validateEnvironment", "copyEnvironment", "", "key", "isFoundationalAvdFile", "file", "destAvdFolder", "newAvdName", "updateNameAndIniPaths", "iniFile", "oldName", "oldPath", "newName", "newPath", "getImageRelativePath", "createAvdIniFile", "version", "Lcom/android/sdklib/AndroidVersion;", "info", "deleteAvd", "moveAvd", "newAvdFolder", "deleteContentOf", "folder", "buildAvdFilesList", "buildAvdList", "allList", "parseAvdInfo", "metadataIniFile", "isDirectoryOutsideSdkDirectory", "imageSysDir", "writeIniFile", "values", "addEncoding", "removeAvd", "updateAvd", "newProperties", "updateDeviceChanged", "setImagePathProperties", "image", "properties", "replaceAvd", "oldAvd", "newAvd", "createAvdUserdata", "addCpuArch", "addSkin", "createAvdSdCard", "Lcom/android/sdklib/internal/avd/InternalSdCard;", "addSystemImageHardwareConfig", "createAvdInfoObject", "oldAvdInfo", "Companion", "android.sdktools.sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdManager.kt\ncom/android/sdklib/internal/avd/AvdManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1746:1\n1#2:1747\n774#3:1748\n865#3,2:1749\n295#3,2:1751\n295#3,2:1753\n295#3,2:1755\n1788#3,4:1757\n*S KotlinDebug\n*F\n+ 1 AvdManager.kt\ncom/android/sdklib/internal/avd/AvdManager\n*L\n117#1:1748\n117#1:1749,2\n135#1:1751,2\n144#1:1753,2\n149#1:1755,2\n559#1:1757,4\n*E\n"})
public final class AvdManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final Path baseAvdFolder;
    @NotNull
    private final DeviceManager deviceManager;
    @NotNull
    private final ILogger log;
    @NotNull
    private final List<AvdInfo> allAvdList;
    @Nullable
    private List<AvdInfo> validAvdList;
    @NotNull
    private final Path sdkLocation;
    @NotNull
    private static final Pattern INI_LINE_PATTERN;
    @NotNull
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    @NotNull
    private static final Pattern NUMERIC_SKIN_SIZE;
    @NotNull
    public static final String DATA_FOLDER = "data";
    @NotNull
    public static final String USERDATA_IMG = "userdata.img";
    @NotNull
    public static final String USERDATA_QEMU_IMG = "userdata-qemu.img";
    @NotNull
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    @NotNull
    public static final String USER_SETTINGS_INI = "user-settings.ini";
    @NotNull
    private static final String BOOT_PROP = "boot.prop";
    @NotNull
    public static final String ENVIRONMENT_INI = "environment.ini";
    @NotNull
    public static final String CONFIG_INI = "config.ini";
    @NotNull
    private static final String HARDWARE_QEMU_INI = "hardware-qemu.ini";
    @NotNull
    private static final String SDCARD_IMG = "sdcard.img";
    @NotNull
    public static final String INI_EXTENSION = ".ini";
    @NotNull
    private static final Pattern INI_NAME_PATTERN;
    @NotNull
    private static final Pattern IMAGE_NAME_PATTERN;
    @NotNull
    public static final String HARDWARE_INI = "hardware.ini";

    private AvdManager(AndroidSdkHandler sdkHandler, Path baseAvdFolder, DeviceManager deviceManager, ILogger log) {
        this.sdkHandler = sdkHandler;
        this.baseAvdFolder = baseAvdFolder;
        this.deviceManager = deviceManager;
        this.log = log;
        this.allAvdList = new ArrayList();
        Path path = this.sdkHandler.getLocation();
        if (path == null) {
            AvdManager avdManager = this;
            boolean bl = false;
            AvdManager avdManager2 = avdManager;
            String string = "Local SDK path not set!";
            throw new IllegalStateException(string.toString());
        }
        this.sdkLocation = path;
        try {
            this.buildAvdList(this.allAvdList);
        }
        catch (AndroidLocationsException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            this.log.warning("Constructing AvdManager: %s", objectArray);
        }
    }

    @NotNull
    public final Path getBaseAvdFolder() {
        return this.baseAvdFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<AvdInfo> getAllAvds() {
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            List list2 = CollectionsKt.toMutableList((Collection)this.allAvdList);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AvdInfo> getValidAvds() {
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            if (this.validAvdList == null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = this.allAvdList;
                AvdManager avdManager = this;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AvdInfo it = (AvdInfo)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getStatus() == AvdInfo.AvdStatus.OK)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                avdManager.validAvdList = (List)destination$iv$iv;
            }
            List<AvdInfo> list2 = this.validAvdList;
            Intrinsics.checkNotNull(list2);
            List<AvdInfo> list3 = list2;
            return list3;
        }
    }

    @Nullable
    public final AvdInfo getAvd(@NotNull String name, boolean validAvdOnly) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            boolean ignoreCase = SdkConstants.currentPlatform() == 2;
            List<AvdInfo> list = validAvdOnly ? this.getValidAvds() : this.getAllAvds();
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvdInfo it = (AvdInfo)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)name, (boolean)ignoreCase)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final AvdInfo findAvdWithDisplayName(@NotNull String displayName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Iterable $this$firstOrNull$iv = this.getAllAvds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvdInfo it = (AvdInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)displayName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final AvdInfo findAvdWithFolder(@NotNull Path avdFolder) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
            Iterable $this$firstOrNull$iv = this.getAllAvds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvdInfo it = (AvdInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDataFolderPath(), (Object)avdFolder)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Slow
    public final long getPid(@NotNull AvdInfo avd) {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        long pid = this.getPid(avd, "hardware-qemu.ini.lock");
        if (pid != 0L) {
            return pid;
        }
        return this.getPid(avd, "userdata-qemu.img.lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getPid(AvdInfo avd, String element) {
        Path file = this.resolveLockFile(avd, element);
        try {
            long l;
            Closeable closeable = new Scanner(file);
            Throwable throwable = null;
            try {
                Scanner scanner = (Scanner)closeable;
                boolean bl = false;
                scanner.useDelimiter("\u0000");
                l = scanner.nextLong();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return l;
        }
        catch (NoSuchFileException noSuchFileException) {
            Object[] objectArray = new Object[]{file, avd.getName()};
            this.log.info("%s not found for %s", objectArray);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{avd.getName(), file};
            this.log.error((Throwable)e, "avd = %s, file = %s", objectArray);
        }
        catch (NoSuchElementException e) {
            Object[] objectArray = new Object[]{avd.getName(), file};
            this.log.error((Throwable)e, "avd = %s, file = %s", objectArray);
        }
        return 0L;
    }

    @Slow
    public final void deleteLockFiles(@NotNull AvdInfo avd) {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        this.deleteLockFile(avd, "hardware-qemu.ini.lock");
        this.deleteLockFile(avd, "userdata-qemu.img.lock");
    }

    private final void deleteLockFile(AvdInfo avd, String element) {
        Path file = this.resolveLockFile(avd, element);
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{file};
            this.log.error((Throwable)e, "Unable to delete %s", objectArray);
        }
    }

    @VisibleForTesting
    @NotNull
    public final Path resolveLockFile(@NotNull AvdInfo avd, @NotNull String element) {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Path path = this.baseAvdFolder.resolve(avd.getDataFolderPath()).resolve(element);
        if (SdkConstants.currentPlatform() == 2) {
            Path path2 = path.resolve("pid");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            return path2;
        }
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public final void reloadAvds() throws AndroidLocationsException {
        this.sdkHandler.clearSystemImageManagerCache();
        List allList = new ArrayList();
        this.buildAvdList(allList);
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            this.allAvdList.clear();
            this.allAvdList.addAll(allList);
            this.validAvdList = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @NotNull
    public final AvdInfo reloadAvd(@NotNull AvdInfo avdInfo) {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        AvdInfo newInfo = this.parseAvdInfo(avdInfo.getIniFile());
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            int index = this.allAvdList.indexOf(avdInfo);
            if (index >= 0) {
                this.replaceAvd(avdInfo, newInfo);
            }
            Unit unit = Unit.INSTANCE;
        }
        return newInfo;
    }

    @NotNull
    public final AvdBuilder createAvdBuilder(@NotNull Device device) {
        AvdBuilder avdBuilder;
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String avdName = AvdNamesKt.uniquifyAvdName(this, AvdNames.cleanAvdName(string));
        Path avdFolder = AvdInfo.Companion.getDefaultAvdFolder(this, avdName, true);
        Path path = this.baseAvdFolder.resolve(avdName + INI_EXTENSION);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        AvdBuilder $this$createAvdBuilder_u24lambda_u2410 = avdBuilder = new AvdBuilder(path, avdFolder, device);
        boolean bl = false;
        $this$createAvdBuilder_u24lambda_u2410.initializeFromDevice();
        String string2 = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        $this$createAvdBuilder_u24lambda_u2410.setDisplayName(AvdNamesKt.uniquifyDisplayName(this, string2));
        return avdBuilder;
    }

    @Slow
    @NotNull
    public final AvdInfo createAvd(@NotNull AvdBuilder builder) throws AvdManagerException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!Files.notExists(builder.getAvdFolder(), new LinkOption[0])) {
            boolean bl = false;
            String string = "AVD already exists";
            throw new IllegalArgumentException(string.toString());
        }
        return this.createOrEditAvd(builder);
    }

    @Slow
    @NotNull
    public final AvdInfo editAvd(@NotNull AvdInfo avdInfo, @NotNull AvdBuilder builder) throws AvdManagerException {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!Intrinsics.areEqual((Object)avdInfo.getName(), (Object)builder.getAvdName()) || !Intrinsics.areEqual((Object)avdInfo.getDataFolderPath(), (Object)builder.getAvdFolder())) {
            this.moveAvd(avdInfo, builder.getAvdName(), builder.getAvdFolder());
        }
        return this.createOrEditAvd(builder);
    }

    @Slow
    @NotNull
    public final AvdInfo duplicateAvd(@NotNull AvdInfo avdInfo, @NotNull AvdBuilder builder) throws AvdManagerException {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!(!Intrinsics.areEqual((Object)avdInfo.getName(), (Object)builder.getAvdName()))) {
            boolean $i$a$-require-AvdManager$duplicateAvd$32 = false;
            String $i$a$-require-AvdManager$duplicateAvd$32 = "Old and new name are the same";
            throw new IllegalArgumentException($i$a$-require-AvdManager$duplicateAvd$32.toString());
        }
        if (!(!Intrinsics.areEqual((Object)avdInfo.getDataFolderPath(), (Object)builder.getAvdFolder()))) {
            boolean $i$a$-require-AvdManager$duplicateAvd$42 = false;
            String $i$a$-require-AvdManager$duplicateAvd$42 = "Old and new path are the same";
            throw new IllegalArgumentException($i$a$-require-AvdManager$duplicateAvd$42.toString());
        }
        if (builder.getSystemImage() == null) {
            boolean bl = false;
            String string = "systemImage is required";
            throw new IllegalStateException(string.toString());
        }
        Path path = avdInfo.getDataFolderPath();
        Path path2 = builder.getAvdFolder();
        String string = builder.getAvdName();
        ISystemImage iSystemImage = builder.getSystemImage();
        Intrinsics.checkNotNull((Object)iSystemImage);
        this.duplicateAvd(path, path2, string, iSystemImage);
        return this.createOrEditAvd(builder);
    }

    private final AvdInfo createOrEditAvd(AvdBuilder builder) throws AvdManagerException {
        String string = builder.getAvdName();
        if (string == null) {
            boolean $i$a$-checkNotNull-AvdManager$createOrEditAvd$avdName$22 = false;
            String $i$a$-checkNotNull-AvdManager$createOrEditAvd$avdName$22 = "avdName is required";
            throw new IllegalStateException($i$a$-checkNotNull-AvdManager$createOrEditAvd$avdName$22.toString());
        }
        String avdName = string;
        if (!Intrinsics.areEqual((Object)avdName, (Object)AvdNames.cleanAvdName(avdName))) {
            boolean $i$a$-require-AvdManager$createOrEditAvd$22 = false;
            String $i$a$-require-AvdManager$createOrEditAvd$22 = "AVD name \"" + avdName + "\" contains invalid characters";
            throw new IllegalArgumentException($i$a$-require-AvdManager$createOrEditAvd$22.toString());
        }
        AvdManager avdManager = this;
        Path path = builder.getAvdFolder();
        if (path == null) {
            AvdManager avdManager2 = avdManager;
            boolean $i$a$-checkNotNull-AvdManager$createOrEditAvd$42 = false;
            AvdManager avdManager3 = avdManager2;
            String $i$a$-checkNotNull-AvdManager$createOrEditAvd$42 = "avdFolder is required";
            throw new IllegalStateException($i$a$-checkNotNull-AvdManager$createOrEditAvd$42.toString());
        }
        String string2 = avdName;
        ISystemImage iSystemImage = builder.getSystemImage();
        if (iSystemImage == null) {
            String string3 = string2;
            Path path2 = path;
            AvdManager avdManager4 = avdManager;
            boolean bl = false;
            String string4 = "systemImage is required";
            AvdManager avdManager5 = avdManager4;
            Path path3 = path2;
            String string5 = string3;
            String string6 = string4;
            throw new IllegalStateException(string6.toString());
        }
        return avdManager.createAvd(path, string2, iSystemImage, builder.getSkin(), builder.getSdCard(), builder.configProperties(), builder.getUserSettings(), builder.getDevice().getBootProps(), builder.environment(), builder.getDevice().hasPlayStore(), false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @NotNull
    public final AvdInfo createAvd(@NotNull Path avdFolder, @NotNull String avdName, @NotNull ISystemImage systemImage, @Nullable Skin skin, @Nullable SdCard sdcard, @Nullable Map<String, String> hardwareConfig, @Nullable Map<String, String> userSettings, @Nullable Map<String, String> bootProps, @Nullable Map<String, String> environment, boolean deviceHasPlayStore, boolean removePrevious, boolean editExisting) throws AvdManagerException {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)systemImage, (String)"systemImage");
        this.validateEnvironment(environment);
        Map map = hardwareConfig;
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map hardwareConfig2 = map;
        Path avdFolder2 = avdFolder;
        boolean editExisting2 = editExisting;
        Path iniFile = null;
        boolean needCleanup = false;
        try {
            Object[] oldSdCardPath;
            Object destAvdFolder;
            Object[] newAvdInfo = null;
            Map configValues = new LinkedHashMap();
            if (!CancellableFileIo.exists((Path)avdFolder2, (LinkOption[])new LinkOption[0])) {
                Files.createDirectories(avdFolder2, new FileAttribute[0]);
                AvdManager.Companion.inhibitCopyOnWrite(avdFolder2, this.log);
                editExisting2 = false;
            } else if (removePrevious) {
                try {
                    this.deleteContentOf(avdFolder2);
                    AvdManager.Companion.inhibitCopyOnWrite(avdFolder2, this.log);
                }
                catch (SecurityException e) {
                    Object[] objectArray2 = new Object[]{avdFolder2.toAbsolutePath(), e};
                    this.log.warning("Failed to delete %1$s: %2$s", objectArray2);
                }
            } else if (!editExisting2) {
                String oldAvdFolderPath = ((Object)avdFolder2.toAbsolutePath()).toString();
                destAvdFolder = avdFolder2.getParent().resolve(avdName + AVD_FOLDER_EXTENSION);
                Intrinsics.checkNotNull((Object)destAvdFolder);
                newAvdInfo = this.duplicateAvd(avdFolder2, (Path)destAvdFolder, avdName, systemImage);
                Path path = this.baseAvdFolder.resolve(newAvdInfo.getDataFolderPath());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                avdFolder2 = path;
                configValues.putAll(newAvdInfo.getProperties());
                oldSdCardPath = (String)hardwareConfig2.get("sdcard.path");
                if (oldSdCardPath != null && StringsKt.startsWith$default((String)oldSdCardPath, (String)oldAvdFolderPath, (boolean)false, (int)2, null)) {
                    hardwareConfig2.put("sdcard.path", StringsKt.replace$default((String)oldSdCardPath, (String)oldAvdFolderPath, (String)((Object)newAvdInfo.getDataFolderPath()).toString(), (boolean)false, (int)4, null));
                }
            }
            this.setImagePathProperties(systemImage, configValues);
            IdDisplay idDisplay = systemImage.getTag();
            Intrinsics.checkNotNullExpressionValue((Object)idDisplay, (String)"getTag(...)");
            IdDisplay tag = idDisplay;
            configValues.put("tag.id", tag.getId());
            configValues.put("tag.display", tag.getDisplay());
            destAvdFolder = configValues;
            oldSdCardPath = "tag.ids";
            List<IdDisplay> list = systemImage.getTags();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTags(...)");
            String string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, AvdManager::createAvd$lambda$19, (int)30, null);
            destAvdFolder.put(oldSdCardPath, string);
            destAvdFolder = configValues;
            oldSdCardPath = "tag.displaynames";
            List<IdDisplay> list2 = systemImage.getTags();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTags(...)");
            string = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, AvdManager::createAvd$lambda$20, (int)30, null);
            destAvdFolder.put(oldSdCardPath, string);
            configValues.put("abi.type", systemImage.getPrimaryAbiType());
            configValues.put("PlayStore.enabled", String.valueOf(deviceHasPlayStore && systemImage.hasPlayStore()));
            configValues.put("hw.arc", String.valueOf(Intrinsics.areEqual((Object)SystemImageTags.CHROMEOS_TAG, (Object)tag)));
            this.addSystemImageHardwareConfig(systemImage, configValues);
            if (skin != null) {
                this.addSkin(skin, configValues);
            }
            configValues.putAll(hardwareConfig2);
            this.addCpuArch(systemImage, configValues);
            configValues.put("target", systemImage.getAndroidVersion().getPlatformHashString());
            AndroidVersion androidVersion = systemImage.getAndroidVersion();
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"getAndroidVersion(...)");
            iniFile = this.createAvdIniFile(avdName, avdFolder2, removePrevious, androidVersion);
            needCleanup = true;
            this.createAvdUserdata(systemImage, avdFolder2);
            if (sdcard != null) {
                configValues.putAll(sdcard.configEntries());
            }
            if (sdcard instanceof InternalSdCard) {
                this.createAvdSdCard((InternalSdCard)sdcard, editExisting2, avdFolder2);
            }
            Path path = avdFolder2.resolve(CONFIG_INI);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            this.writeIniFile(path, configValues, true);
            if (userSettings != null) {
                try {
                    Path path2 = avdFolder2.resolve(USER_SETTINGS_INI);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    this.writeIniFile(path2, userSettings, true);
                }
                catch (IOException e) {
                    oldSdCardPath = new Object[]{((Object)avdFolder2.resolve(USER_SETTINGS_INI)).toString(), e};
                    this.log.warning("Could not write user settings file (at %1$s): %2$s", oldSdCardPath);
                }
            }
            if (bootProps != null && !bootProps.isEmpty()) {
                Path path3 = avdFolder2.resolve(BOOT_PROP);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path bootPropsFile = path3;
                this.writeIniFile(bootPropsFile, bootProps, false);
            }
            Map updatedEnvironment = null;
            Path path4 = avdFolder2.resolve(ENVIRONMENT_INI);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Path environmentIniPath = path4;
            if (environment != null && !environment.isEmpty()) {
                updatedEnvironment = MapsKt.toMutableMap(environment);
                this.copyEnvironment(updatedEnvironment, "background.image.filename", avdFolder2);
                this.copyEnvironment(updatedEnvironment, "background.video.filename", avdFolder2);
                this.writeIniFile(environmentIniPath, updatedEnvironment, false);
            } else {
                updatedEnvironment = new LinkedHashMap();
                Files.deleteIfExists(environmentIniPath);
            }
            AvdInfo oldAvdInfo = this.getAvd(avdName, false);
            if (newAvdInfo == null) {
                Map map2 = userSettings;
                if (map2 == null) {
                    map2 = new LinkedHashMap();
                }
                newAvdInfo = this.createAvdInfoObject(systemImage, removePrevious, editExisting2, iniFile, avdFolder2, oldAvdInfo, configValues, map2, updatedEnvironment);
            }
            if ((removePrevious || editExisting2) && oldAvdInfo != null && !Intrinsics.areEqual((Object)oldAvdInfo.getDataFolderPath(), (Object)newAvdInfo.getDataFolderPath())) {
                objectArray = new Object[]{oldAvdInfo.getDataFolderPath()};
                this.log.warning("Removing previous AVD directory at %s", objectArray);
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)this.baseAvdFolder.resolve(oldAvdInfo.getDataFolderPath()));
                }
                catch (IOException iOException) {
                    Object[] objectArray3 = new Object[]{oldAvdInfo.getDataFolderPath()};
                    this.log.warning("Failed to delete %1$s: %2$s", objectArray3);
                }
            }
            needCleanup = false;
            objectArray = newAvdInfo;
        }
        catch (Exception e) {
            try {
                Exception tag = e;
                if (tag instanceof SecurityException || tag instanceof AndroidLocationsException || tag instanceof IOException) {
                    throw new AvdManagerException("An error occurred while creating AVD: " + e.getMessage(), e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                if (needCleanup) {
                    if (iniFile != null) {
                        try {
                            PathUtils.deleteRecursivelyIfExists(iniFile);
                        }
                        catch (IOException tag) {
                            // empty catch block
                        }
                    }
                    try {
                        PathUtils.deleteRecursivelyIfExists((Path)avdFolder2);
                    }
                    catch (Exception e2) {
                        Object[] objectArray4 = new Object[]{avdFolder2.toAbsolutePath(), e2};
                        this.log.warning("Failed to delete %1$s: %2$s", objectArray4);
                    }
                }
                throw throwable;
            }
        }
        return objectArray;
    }

    public static /* synthetic */ AvdInfo createAvd$default(AvdManager avdManager, Path path, String string, ISystemImage iSystemImage, Skin skin, SdCard sdCard, Map map, Map map2, Map map3, Map map4, boolean bl, boolean bl2, boolean bl3, int n, Object object) throws AvdManagerException {
        if ((n & 8) != 0) {
            skin = null;
        }
        if ((n & 0x10) != 0) {
            sdCard = null;
        }
        if ((n & 0x20) != 0) {
            map = null;
        }
        if ((n & 0x40) != 0) {
            map2 = null;
        }
        if ((n & 0x80) != 0) {
            map3 = null;
        }
        if ((n & 0x100) != 0) {
            map4 = null;
        }
        if ((n & 0x200) != 0) {
            bl = false;
        }
        if ((n & 0x400) != 0) {
            bl2 = false;
        }
        if ((n & 0x800) != 0) {
            bl3 = false;
        }
        return avdManager.createAvd(path, string, iSystemImage, skin, sdCard, map, map2, map3, map4, bl, bl2, bl3);
    }

    private final void validateEnvironment(Map<String, String> environment) {
        int n;
        if (environment == null) {
            return;
        }
        Object[] objectArray = new String[]{"background.image.filename", "background.video.filename"};
        List keys = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$count$iv = keys;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                if (!environment.containsKey(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (!(n <= 1)) {
            boolean bl = false;
            String string = "Expected at most one of " + CollectionsKt.joinToString$default((Iterable)keys, null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void copyEnvironment(Map<String, String> environment, String key, Path avdFolder) throws AvdManagerException {
        String value = environment.get(key);
        if (value != null) {
            Path source = avdFolder.getFileSystem().getPath(value, new String[0]);
            Path destination = avdFolder.resolve(source.getFileName());
            try {
                if (!Intrinsics.areEqual((Object)source, (Object)destination)) {
                    FileUtils.copyFile((Path)source, (Path)destination);
                }
                environment.put(key, ((Object)avdFolder.relativize(destination)).toString());
            }
            catch (IOException e) {
                throw new AvdManagerException("Unable to copy background to AVD directory", e);
            }
        }
    }

    public final boolean isFoundationalAvdFile(@NotNull Path file, @NotNull AvdInfo avd) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        Path avdFolder = avd.getDataFolderPath();
        if (!file.startsWith(avdFolder)) {
            return false;
        }
        String relative = ((Object)avdFolder.relativize(file)).toString();
        return Intrinsics.areEqual((Object)relative, (Object)CONFIG_INI) || Intrinsics.areEqual((Object)relative, (Object)SDCARD_IMG) || Intrinsics.areEqual((Object)relative, (Object)USER_SETTINGS_INI) || Intrinsics.areEqual((Object)relative, (Object)BOOT_PROP) || Intrinsics.areEqual((Object)relative, (Object)ENVIRONMENT_INI) || Intrinsics.areEqual((Object)relative, (Object)USERDATA_IMG) || Intrinsics.areEqual((Object)relative, (Object)avd.getEnvironment().get("background.image.filename")) || Intrinsics.areEqual((Object)relative, (Object)avd.getEnvironment().get("background.video.filename"));
    }

    private final AvdInfo duplicateAvd(Path avdFolder, Path destAvdFolder, String newAvdName, ISystemImage systemImage) throws AvdManagerException {
        try {
            AvdManager.Companion.inhibitCopyOnWrite(destAvdFolder, this.log);
            ProgressIndicator progInd = (ProgressIndicator)new ConsoleProgressIndicator(null, null, false, 7, null);
            progInd.setText("Copying files");
            progInd.setIndeterminate(true);
            FileOpUtils.recursiveCopy((Path)avdFolder, (Path)destAvdFolder, (boolean)false, AvdManager::duplicateAvd$lambda$22, (ProgressIndicator)progInd);
            Path path = destAvdFolder.resolve(CONFIG_INI);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path configIni = path;
            Map<String, String> configVals = null;
            Map<String, String> map = Companion.parseIniFile(new PathFileWrapper(configIni), this.log);
            if (map == null) {
                map = new LinkedHashMap();
            }
            configVals = map;
            Map<String, String> userSettingsVals = AvdInfo.Companion.parseUserSettingsFile(destAvdFolder, this.log);
            Map<String, String> environment = Companion.parseEnvironmentFile(destAvdFolder, this.log);
            configVals.put("AvdId", newAvdName);
            configVals.put("avd.ini.displayname", newAvdName);
            this.writeIniFile(configIni, configVals, true);
            String origAvdName = StringsKt.replace$default((String)((Object)avdFolder.getFileName()).toString(), (String)AVD_FOLDER_EXTENSION, (String)"", (boolean)false, (int)4, null);
            String origAvdFolder = ((Object)avdFolder.toAbsolutePath()).toString();
            String newAvdFolder = ((Object)destAvdFolder.toAbsolutePath()).toString();
            Map<String, String> map2 = this.updateNameAndIniPaths(configIni, origAvdName, origAvdFolder, newAvdName, newAvdFolder);
            if (map2 != null) {
                Map<String, String> it = map2;
                boolean bl = false;
                configVals = it;
            }
            Path path2 = destAvdFolder.resolve(HARDWARE_QEMU_INI);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path hwQemu = path2;
            this.updateNameAndIniPaths(hwQemu, origAvdName, origAvdFolder, newAvdName, newAvdFolder);
            AndroidVersion androidVersion = systemImage.getAndroidVersion();
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"getAndroidVersion(...)");
            Path metadataIniFile = this.createAvdIniFile(newAvdName, destAvdFolder, false, androidVersion);
            return new AvdInfo(metadataIniFile, destAvdFolder, systemImage, configVals, userSettingsVals, environment, AvdInfo.AvdStatus.OK);
        }
        catch (AndroidLocationsException e) {
            throw new AvdManagerException("An error occurred while duplicating an AVD: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AvdManagerException("An error occurred while duplicating an AVD: " + e.getMessage(), e);
        }
    }

    private final Map<String, String> updateNameAndIniPaths(Path iniFile, String oldName, String oldPath, String newName, String newPath) throws IOException {
        Map<String, String> iniVals = Companion.parseIniFile(new PathFileWrapper(iniFile), this.log);
        if (iniVals != null) {
            for (Map.Entry<String, String> entry : iniVals.entrySet()) {
                String key = entry.getKey();
                String origIniValue = entry.getValue();
                if (Intrinsics.areEqual((Object)origIniValue, (Object)oldName)) {
                    iniVals.put(key, newName);
                }
                if (!StringsKt.startsWith$default((String)origIniValue, (String)oldPath, (boolean)false, (int)2, null)) continue;
                String newIniValue = StringsKt.replace$default((String)origIniValue, (String)oldPath, (String)newPath, (boolean)false, (int)4, null);
                iniVals.put(key, newIniValue);
            }
            this.writeIniFile(iniFile, iniVals, true);
        }
        return iniVals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getImageRelativePath(ISystemImage systemImage) throws AvdManagerException {
        Path path = systemImage.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLocation(...)");
        Path folder = path;
        String imageFullPath = ((Object)folder.toAbsolutePath()).toString();
        String sdkLocation = ((Object)this.sdkLocation.toAbsolutePath()).toString();
        if (!StringsKt.startsWith$default((String)imageFullPath, (String)sdkLocation, (boolean)false, (int)2, null)) {
            throw new AvdManagerException("The selected system image (" + imageFullPath + ") is not inside the SDK.");
        }
        List list = null;
        try {
            AutoCloseable autoCloseable = CancellableFileIo.list((Path)folder);
            Throwable throwable = null;
            try {
                Stream contents = (Stream)autoCloseable;
                boolean bl = false;
                List list2 = contents.map(arg_0 -> AvdManager.getImageRelativePath$lambda$28$lambda$25(AvdManager::getImageRelativePath$lambda$28$lambda$24, arg_0)).filter(arg_0 -> AvdManager.getImageRelativePath$lambda$28$lambda$27(AvdManager::getImageRelativePath$lambda$28$lambda$26, arg_0)).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list2, (String)"collect(...)");
                list = list2;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new AvdManagerException("Unable to read contents of system image at " + folder + '.', e);
        }
        if (!((Collection)list).isEmpty()) {
            String string = imageFullPath.substring(sdkLocation.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            imageFullPath = string;
            String separator = folder.getFileSystem().getSeparator();
            Intrinsics.checkNotNull((Object)separator);
            if (StringsKt.startsWith$default((String)imageFullPath, (String)separator, (boolean)false, (int)2, null)) {
                String string2 = imageFullPath.substring(separator.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                imageFullPath = string2;
            }
            if (!StringsKt.endsWith$default((String)imageFullPath, (String)separator, (boolean)false, (int)2, null)) {
                imageFullPath = imageFullPath + separator;
            }
            return imageFullPath;
        }
        throw new AvdManagerException("System image not found in " + folder + '.');
    }

    private final Path createAvdIniFile(String avdName, Path avdFolder, boolean removePrevious, AndroidVersion version) throws AndroidLocationsException, IOException {
        Path iniFile = AvdInfo.Companion.getDefaultIniFile(this, avdName);
        if (removePrevious) {
            if (CancellableFileIo.isRegularFile((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                Files.delete(iniFile);
            } else if (CancellableFileIo.isDirectory((Path)iniFile, (LinkOption[])new LinkOption[0])) {
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)iniFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        String absPath = ((Object)avdFolder.toAbsolutePath()).toString();
        String relPath = null;
        Path path = this.sdkHandler.getAndroidFolder();
        if (path == null) {
            throw new AndroidLocationsException("Can't locate Android SDK installation directory for the AVD .ini file.", null, 2, null);
        }
        Path androidFolder = path;
        String androidPath = androidFolder.toAbsolutePath() + File.separator;
        if (StringsKt.startsWith$default((String)absPath, (String)androidPath, (boolean)false, (int)2, null)) {
            String string = absPath.substring(androidPath.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            relPath = string;
        }
        Map values = new LinkedHashMap();
        if (relPath != null) {
            values.put("path.rel", relPath);
        }
        values.put("path", absPath);
        values.put("target", version.getPlatformHashString());
        this.writeIniFile(iniFile, values, true);
        return iniFile;
    }

    private final Path createAvdIniFile(AvdInfo info) throws AndroidLocationsException, IOException {
        String string = info.getName();
        Path path = this.baseAvdFolder.resolve(info.getDataFolderPath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return this.createAvdIniFile(string, path, false, info.getAndroidVersion());
    }

    @Slow
    public final boolean deleteAvd(@NotNull AvdInfo avdInfo) {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        try {
            Object[] objectArray;
            Object[] objectArray2;
            boolean error = false;
            Path f = avdInfo.getIniFile();
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException iOException) {
                objectArray2 = new Object[]{f};
                this.log.warning("Failed to delete %1$s", objectArray2);
                error = true;
            }
            Path path = avdInfo.getDataFolderPath();
            Path path2 = this.baseAvdFolder.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            f = path2;
            try {
                PathUtils.deleteRecursivelyIfExists((Path)f);
            }
            catch (IOException exception) {
                objectArray2 = new Object[]{f};
                this.log.warning("Failed to delete %1$s", objectArray2);
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                this.log.warning(writer.toString(), new Object[0]);
                error = true;
            }
            this.removeAvd(avdInfo);
            if (!error) {
                objectArray = new Object[]{avdInfo.getName()};
                this.log.info("\nAVD '%1$s' deleted.", objectArray);
                return true;
            }
            objectArray = new Object[]{avdInfo.getName()};
            this.log.info("\nAVD '%1$s' deleted with errors. See errors above.", objectArray);
        }
        catch (SecurityException e) {
            Object[] objectArray = new Object[]{e};
            this.log.warning("Failed to delete AVD: %1$s", objectArray);
        }
        return false;
    }

    @Slow
    public final void moveAvd(@NotNull AvdInfo avdInfo, @Nullable String newAvdName, @Nullable Path newAvdFolder) throws AvdManagerException {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        try {
            Object[] oldMetadataIniFile;
            Object e2;
            if (newAvdFolder != null) {
                Path f = this.baseAvdFolder.resolve(avdInfo.getDataFolderPath());
                Object[] objectArray = new Object[]{avdInfo.getDataFolderPath(), newAvdFolder};
                this.log.info("Moving '%1$s' to '%2$s'.\n", objectArray);
                try {
                    Files.move(f, this.baseAvdFolder.resolve(newAvdFolder), new CopyOption[0]);
                }
                catch (IOException e2) {
                    throw new AvdManagerException("Failed to move '" + avdInfo.getDataFolderPath() + "' to '" + newAvdFolder + "'.", e2);
                }
                AvdInfo info = new AvdInfo(avdInfo.getIniFile(), newAvdFolder, avdInfo.getSystemImage(), avdInfo.getProperties(), avdInfo.getUserSettings(), avdInfo.getEnvironment(), AvdInfo.AvdStatus.OK);
                this.replaceAvd(avdInfo, info);
                try {
                    e2 = this.createAvdIniFile(info);
                }
                catch (IOException e3) {
                    throw new AvdManagerException("Failed to create '" + avdInfo.getIniFile() + "'.", e3);
                }
            }
            if (newAvdName != null) {
                oldMetadataIniFile = avdInfo.getIniFile();
                Path newMetadataIniFile = AvdInfo.Companion.getDefaultIniFile(this, newAvdName);
                e2 = new Object[]{oldMetadataIniFile, newMetadataIniFile};
                this.log.warning("Moving '%1$s' to '%2$s'.", e2);
                try {
                    Files.move((Path)oldMetadataIniFile, newMetadataIniFile, new CopyOption[0]);
                }
                catch (IOException exception) {
                    throw new AvdManagerException("Failed to move '" + oldMetadataIniFile + "' to '" + newMetadataIniFile + "'.", exception);
                }
                AvdInfo info = new AvdInfo(avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getSystemImage(), avdInfo.getProperties(), avdInfo.getUserSettings(), avdInfo.getEnvironment(), AvdInfo.AvdStatus.OK);
                this.replaceAvd(avdInfo, info);
            }
            oldMetadataIniFile = new Object[]{avdInfo.getName()};
            this.log.info("AVD '%1$s' moved.\n", oldMetadataIniFile);
        }
        catch (AndroidLocationsException e) {
            throw new AvdManagerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean deleteContentOf(Path folder) throws SecurityException {
        boolean success = false;
        success = true;
        try {
            Closeable closeable = Files.newDirectoryStream(folder);
            Throwable throwable = null;
            try {
                DirectoryStream entries = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = entries.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path entry = (Path)iterator2.next();
                    try {
                        PathUtils.deleteRecursivelyIfExists((Path)entry);
                    }
                    catch (IOException iOException) {
                        success = false;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> buildAvdFilesList() throws AndroidLocationsException {
        List list;
        if (CancellableFileIo.isRegularFile((Path)this.baseAvdFolder, (LinkOption[])new LinkOption[0])) {
            throw new AndroidLocationsException(this.baseAvdFolder.toAbsolutePath() + " is a regular file; expected a directory.", null, 2, null);
        }
        if (CancellableFileIo.notExists((Path)this.baseAvdFolder, (LinkOption[])new LinkOption[0])) {
            try {
                Files.createDirectories(this.baseAvdFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new AndroidLocationsException("Unable to create AVD home directory: " + this.baseAvdFolder.toAbsolutePath(), (Throwable)e);
            }
            return CollectionsKt.emptyList();
        }
        try {
            List list2;
            AutoCloseable e = CancellableFileIo.list((Path)this.baseAvdFolder);
            Throwable throwable = null;
            try {
                Stream contents = (Stream)e;
                boolean bl = false;
                list2 = contents.filter(arg_0 -> AvdManager.buildAvdFilesList$lambda$32$lambda$31(AvdManager::buildAvdFilesList$lambda$32$lambda$30, arg_0)).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)e, (Throwable)throwable);
            }
            list = list2;
            Intrinsics.checkNotNull(list);
        }
        catch (IOException iOException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void buildAvdList(List<AvdInfo> allList) throws AndroidLocationsException {
        List<Path> avds = this.buildAvdFilesList();
        for (Path avd : avds) {
            AvdInfo info = this.parseAvdInfo(avd);
            if (allList.contains(info)) continue;
            allList.add(info);
        }
    }

    @VisibleForTesting
    @Slow
    @NotNull
    public final AvdInfo parseAvdInfo(@NotNull Path metadataIniFile) {
        String tagId;
        AvdInfo.AvdStatus status2;
        Object device;
        ISystemImage iSystemImage;
        String imageSysDir;
        Map properties;
        Map map;
        Object[] configIniFile;
        Object[] objectArray2;
        Object f;
        Intrinsics.checkNotNullParameter((Object)metadataIniFile, (String)"metadataIniFile");
        Map<String, String> metadata = Companion.parseIniFile(new PathFileWrapper(metadataIniFile), this.log);
        Path avdFolder = null;
        if (metadata != null) {
            String relPath;
            Path path;
            String string = metadata.get("path");
            if (string != null) {
                String it = string;
                boolean objectArray2 = false;
                path = metadataIniFile.resolve(it);
            } else {
                path = avdFolder = null;
            }
            if (!(avdFolder != null && CancellableFileIo.isDirectory((Path)this.baseAvdFolder.resolve(avdFolder), (LinkOption[])new LinkOption[0]) || (relPath = metadata.get("path.rel")) == null)) {
                Path path2 = this.sdkHandler.getAndroidFolder();
                if (path2 == null || (path2 = path2.resolve(relPath)) == null) {
                    path2 = this.sdkHandler.toCompatiblePath(relPath);
                }
                if (CancellableFileIo.isDirectory((Path)(f = path2), (LinkOption[])new LinkOption[0])) {
                    avdFolder = f;
                }
            }
        }
        if (avdFolder == null || !CancellableFileIo.isDirectory((Path)this.baseAvdFolder.resolve(avdFolder), (LinkOption[])new LinkOption[0])) {
            return new AvdInfo(metadataIniFile, metadataIniFile, null, null, null, null, AvdInfo.AvdStatus.ERROR_CORRUPTED_INI, 56, null);
        }
        f = this.log;
        LoggerProgressIndicatorWrapper progress2 = new LoggerProgressIndicatorWrapper((ILogger)f){

            public void logVerbose(String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }
        };
        Path configIniPath = this.baseAvdFolder.resolve(avdFolder).resolve(CONFIG_INI);
        Object[] it = objectArray2 = new PathFileWrapper(configIniPath);
        boolean bl = false;
        Object object = configIniFile = it.exists() ? objectArray2 : null;
        if (configIniFile == null) {
            objectArray2 = new Object[]{((Object)configIniPath.toAbsolutePath()).toString()};
            this.log.warning("Missing file '%1$s'.", objectArray2);
        }
        if (configIniFile != null) {
            Object[] it2 = configIniFile;
            boolean bl2 = false;
            map = Companion.parseIniFile((IAbstractFile)it2, this.log);
        } else {
            map = null;
        }
        Map map2 = properties = map;
        String string = imageSysDir = map2 != null ? (String)map2.get("image.sysdir.1") : null;
        if (string != null) {
            String it3 = string;
            boolean bl3 = false;
            iSystemImage = this.sdkHandler.getSystemImageManager((ProgressIndicator)progress2).getImageAt(this.sdkLocation.resolve(it3));
        } else {
            iSystemImage = null;
        }
        ISystemImage sysImage = iSystemImage;
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get("hw.device.name");
            String deviceManufacturer = properties.get("hw.device.manufacturer");
            if (deviceName != null && deviceManufacturer != null) {
                device = this.deviceManager.getDevice(deviceName, deviceManufacturer);
                if (device == null) {
                    deviceStatus = DeviceManager.DeviceStatus.MISSING;
                } else {
                    deviceStatus = DeviceManager.DeviceStatus.EXISTS;
                    String hashV2 = (String)properties.get("hw.device.hash2");
                    if (hashV2 == null) {
                        updateHashV2 = true;
                    } else {
                        String newHashV2 = DeviceManager.hasHardwarePropHashChanged((Device)device, hashV2);
                        if (newHashV2 != null) {
                            properties.put("hw.device.hash2", newHashV2);
                            updateHashV2 = true;
                        }
                    }
                    String hashV1 = (String)properties.get("hw.device.hash");
                    if (hashV1 != null) {
                        properties.remove("hw.device.hash");
                    }
                }
            }
        }
        AvdInfo.AvdStatus avdStatus = configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (properties == null || imageSysDir == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : (status2 = sysImage == null && !this.isDirectoryOutsideSdkDirectory(imageSysDir) ? AvdInfo.AvdStatus.ERROR_IMAGE_MISSING : AvdInfo.AvdStatus.OK)));
        if (properties == null) {
            properties = new LinkedHashMap();
        }
        if (!properties.containsKey("target")) {
            String target;
            Map<String, String> map3 = metadata;
            String string2 = target = map3 != null ? map3.get("target") : null;
            if (target != null) {
                properties.put("target", target);
            }
        }
        if (!properties.containsKey("tag.ids") && !((device = (CharSequence)(tagId = (String)properties.get("tag.id"))) == null || device.length() == 0)) {
            properties.put("tag.ids", tagId);
        }
        if (!properties.containsKey("avd.ini.displayname")) {
            String avdName = AvdInfo.Companion.getAvdNameFromFile(metadataIniFile);
            String displayName = AvdInfo.Companion.avdNameToDisplayName(avdName);
            properties.put("avd.ini.displayname", displayName);
        }
        Map<String, String> userSettings = AvdInfo.Companion.parseUserSettingsFile(avdFolder, this.log);
        Map<String, String> environment = Companion.parseEnvironmentFile(avdFolder, this.log);
        AvdInfo info = new AvdInfo(metadataIniFile, avdFolder, sysImage, properties, userSettings, environment, status2);
        if (updateHashV2) {
            try {
                AvdInfo avdInfo = this.updateDeviceChanged(info);
                if (avdInfo == null) {
                    avdInfo = info;
                }
                return avdInfo;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    private final boolean isDirectoryOutsideSdkDirectory(String imageSysDir) {
        Path dir = Paths.get(imageSysDir, new String[0]);
        if (!dir.isAbsolute()) {
            return false;
        }
        return !dir.startsWith(this.sdkLocation) && Files.isDirectory(dir, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeIniFile(Path iniFile, Map<String, String> values, boolean addEncoding) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        Closeable closeable = new OutputStreamWriter(Files.newOutputStream(iniFile, new OpenOption[0]), charset);
        Throwable throwable = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            Map finalValues = addEncoding ? MapsKt.plus(values, (Pair)TuplesKt.to((Object)"avd.ini.encoding", (Object)charset.name())) : values;
            for (String key : CollectionsKt.sorted((Iterable)finalValues.keySet())) {
                String value = (String)finalValues.get(key);
                if (value == null) continue;
                writer.write(key + '=' + value + '\n');
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeAvd(@NotNull AvdInfo avdInfo) {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            block4: {
                boolean bl = false;
                if (!this.allAvdList.remove(avdInfo)) break block4;
                this.validAvdList = null;
                boolean bl2 = true;
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    @Slow
    @NotNull
    public final AvdInfo updateAvd(@NotNull AvdInfo avd, @NotNull Map<String, String> newProperties) throws IOException {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        Intrinsics.checkNotNullParameter(newProperties, (String)"newProperties");
        Path path = this.baseAvdFolder.resolve(avd.getDataFolderPath()).resolve(CONFIG_INI);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.writeIniFile(path, newProperties, true);
        AvdInfo newAvd = AvdInfo.copy$default(avd, null, null, null, newProperties, null, null, null, 119, null);
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    @Slow
    @Nullable
    public final AvdInfo updateDeviceChanged(@NotNull AvdInfo avd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
        Map properties = MapsKt.toMutableMap(avd.getProperties());
        Device d = this.deviceManager.getDevice(avd);
        if (d == null) {
            this.log.warning("Base device information incomplete or missing.", new Object[0]);
            return null;
        }
        Map<String, String> map = DeviceManager.getHardwareProperties(d);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHardwareProperties(...)");
        Map<String, String> deviceHwProperties = map;
        deviceHwProperties.remove("hw.ramSize");
        properties.putAll(deviceHwProperties);
        try {
            return this.updateAvd(avd, properties);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e};
            this.log.warning("Failed to update AVD device profile: %1$s", objectArray);
            return null;
        }
    }

    private final void setImagePathProperties(ISystemImage image, Map<String, String> properties) throws AvdManagerException {
        properties.put("image.sysdir.1", this.getImageRelativePath(image));
        properties.remove("image.sysdir.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            this.allAvdList.remove(oldAvd);
            AvdInfo avdInfo = newAvd;
            Intrinsics.checkNotNull((Object)avdInfo);
            this.allAvdList.add(avdInfo);
            this.validAvdList = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void createAvdUserdata(ISystemImage systemImage, Path avdFolder) throws IOException, AvdManagerException {
        Path path = systemImage.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLocation(...)");
        Path imageFolder = path;
        Path path2 = imageFolder.resolve(USERDATA_IMG);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path userdataSrc = path2;
        if (CancellableFileIo.notExists((Path)userdataSrc, (LinkOption[])new LinkOption[0])) {
            if (CancellableFileIo.isDirectory((Path)imageFolder.resolve(DATA_FOLDER), (LinkOption[])new LinkOption[0])) {
                return;
            }
            throw new AvdManagerException("Unable to find a 'userdata.img' file for ABI " + systemImage.getPrimaryAbiType() + " to copy into the AVD folder.");
        }
        Path path3 = avdFolder.resolve(USERDATA_IMG);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path userdataDest = path3;
        if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
            FileUtils.copyFile((Path)userdataSrc, (Path)userdataDest);
            if (CancellableFileIo.notExists((Path)userdataDest, (LinkOption[])new LinkOption[0])) {
                throw new AvdManagerException("Unable to create '" + userdataDest + "' file in the AVD folder.");
            }
        }
    }

    private final void addCpuArch(ISystemImage systemImage, Map<String, String> values) throws AvdManagerException {
        block2: {
            String string = systemImage.getPrimaryAbiType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrimaryAbiType(...)");
            String abiType = string;
            Abi abi = Abi.getEnum(abiType);
            if (abi == null) {
                throw new AvdManagerException("ABI " + abiType + " is not supported by this version of the SDK Tools");
            }
            Abi abi2 = abi;
            String string2 = abi2.getCpuArch();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCpuArch(...)");
            String arch = string2;
            if (Intrinsics.areEqual((Object)arch, (Object)"x86") && Intrinsics.areEqual((Object)SystemImageTags.CHROMEOS_TAG, (Object)systemImage.getTag())) {
                arch = "x86_64";
            }
            values.put("hw.cpu.arch", arch);
            values.put("hw.cpu.arch", Intrinsics.areEqual((Object)arch, (Object)"x86") && Intrinsics.areEqual((Object)SystemImageTags.CHROMEOS_TAG, (Object)systemImage.getTag()) ? "x86_64" : arch);
            String string3 = abi2.getCpuModel();
            if (string3 == null) break block2;
            String it = string3;
            boolean bl = false;
            values.put("hw.cpu.model", it);
        }
    }

    private final void addSkin(Skin skin, Map<String, String> values) throws AvdManagerException {
        String skinName = skin.getName();
        String skinPath = null;
        Skin skin2 = skin;
        if (skin2 instanceof OnDiskSkin) {
            Map<String, String> skinHardwareConfig;
            Path path = ((OnDiskSkin)skin).getPath();
            if (CancellableFileIo.notExists((Path)path, (LinkOption[])new LinkOption[0])) {
                throw new AvdManagerException("Skin '" + skinName + "' does not exist at " + path + '.');
            }
            skinPath = ((Object)path).toString();
            PathFileWrapper skinHardwareFile = new PathFileWrapper(path.resolve(HARDWARE_INI));
            if (skinHardwareFile.exists() && (skinHardwareConfig = ProjectProperties.parsePropertyFile(skinHardwareFile, this.log)) != null) {
                values.putAll(skinHardwareConfig);
            }
        } else if (skin2 instanceof GenericSkin) {
            skinPath = skinName;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        values.put("skin.name", skinName);
        values.put("skin.path", skinPath);
    }

    private final void createAvdSdCard(InternalSdCard sdcard, boolean editExisting, Path avdFolder) throws AvdManagerException {
        if (!Intrinsics.areEqual((Object)this.baseAvdFolder.getFileSystem(), (Object)FileSystems.getDefault())) {
            return;
        }
        Path path = avdFolder.resolve(SDCARD_IMG);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path sdcardFile = path;
        try {
            if (CancellableFileIo.size((Path)sdcardFile) == sdcard.getSize() && editExisting) {
                this.log.info("SD Card already present with same size, was not changed.\n", new Object[0]);
                return;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException exception) {
            throw new AvdManagerException("An error occurred reading the SD card image.", exception);
        }
        String path2 = ((Object)sdcardFile.toAbsolutePath()).toString();
        ILogger iLogger = this.log;
        LoggerProgressIndicatorWrapper progress2 = new LoggerProgressIndicatorWrapper(iLogger){

            public void logVerbose(String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            }
        };
        EmulatorPackage emulatorPackage = EmulatorPackages.getEmulatorPackage(this.sdkHandler, (ProgressIndicator)progress2);
        if (emulatorPackage == null) {
            throw new AvdManagerException("The Android Emulator is not installed.");
        }
        EmulatorPackage p = emulatorPackage;
        Path path3 = p.getMkSdCardBinary();
        if (path3 == null) {
            throw new AvdManagerException("Unable to find \"" + SdkConstants.mkSdCardCmdName() + "\" in the Android Emulator at \"" + p.getLocation() + "\".");
        }
        Path mkSdCard = path3;
        if (!SdCards.createSdCard(this.log, ((Object)mkSdCard.toAbsolutePath()).toString(), sdcard.sizeSpec(), path2)) {
            throw new AvdManagerException("Failed to create SD card in the AVD folder.");
        }
    }

    private final void addSystemImageHardwareConfig(ISystemImage systemImage, Map<String, String> values) {
        block1: {
            PathFileWrapper sysImgHardwareFile = new PathFileWrapper(systemImage.getLocation().resolve(HARDWARE_INI));
            if (!sysImgHardwareFile.exists()) break block1;
            Map<String, String> map = ProjectProperties.parsePropertyFile(sysImgHardwareFile, this.log);
            if (map != null) {
                Map<String, String> it = map;
                boolean bl = false;
                values.putAll(it);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AvdInfo createAvdInfoObject(ISystemImage systemImage, boolean removePrevious, boolean editExisting, Path metadataIniFile, Path avdFolder, AvdInfo oldAvdInfo, Map<String, String> values, Map<String, String> userSettings, Map<String, String> environment) {
        AvdInfo theAvdInfo = new AvdInfo(metadataIniFile, avdFolder, systemImage, values, userSettings, environment, AvdInfo.AvdStatus.OK);
        List<AvdInfo> list = this.allAvdList;
        synchronized (list) {
            boolean bl = false;
            if (oldAvdInfo != null && (removePrevious || editExisting)) {
                this.allAvdList.remove(oldAvdInfo);
            }
            this.allAvdList.add(theAvdInfo);
            this.validAvdList = null;
            Unit unit = Unit.INSTANCE;
        }
        return theAvdInfo;
    }

    private static final CharSequence createAvd$lambda$19(IdDisplay it) {
        String string = it.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    private static final CharSequence createAvd$lambda$20(IdDisplay it) {
        String string = it.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplay(...)");
        return string;
    }

    private static final boolean duplicateAvd$lambda$22(Path path) {
        return !path.getFileName().endsWith(".lock");
    }

    private static final String getImageRelativePath$lambda$28$lambda$24(Path it) {
        return ((Object)it.getFileName()).toString();
    }

    private static final String getImageRelativePath$lambda$28$lambda$25(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean getImageRelativePath$lambda$28$lambda$26(String it) {
        return IMAGE_NAME_PATTERN.matcher(it).matches();
    }

    private static final boolean getImageRelativePath$lambda$28$lambda$27(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean buildAvdFilesList$lambda$32$lambda$30(Path path) {
        return INI_NAME_PATTERN.matcher(((Object)path.getFileName()).toString()).matches() && Files.isRegularFile(path, new LinkOption[0]);
    }

    private static final boolean buildAvdFilesList$lambda$32$lambda$31(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final AvdManager createInstance(@NotNull AndroidSdkHandler sdkHandler, @NotNull Path baseAvdFolder, @NotNull DeviceManager deviceManager, @NotNull ILogger log) {
        return Companion.createInstance(sdkHandler, baseAvdFolder, deviceManager, log);
    }

    @JvmStatic
    @Slow
    @Nullable
    public static final Map<String, String> parseIniFile(@NotNull IAbstractFile propFile, @Nullable ILogger logger) {
        return Companion.parseIniFile(propFile, logger);
    }

    public /* synthetic */ AvdManager(AndroidSdkHandler sdkHandler, Path baseAvdFolder, DeviceManager deviceManager, ILogger log, DefaultConstructorMarker $constructor_marker) {
        this(sdkHandler, baseAvdFolder, deviceManager, log);
    }

    static {
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        INI_LINE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        NUMERIC_SKIN_SIZE = pattern2;
        Pattern pattern3 = Pattern.compile("(.+)\\.ini$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        INI_NAME_PATTERN = pattern3;
        Pattern pattern4 = Pattern.compile("(.+)\\.img$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        IMAGE_NAME_PATTERN = pattern4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J$\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070$2\u0006\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010\"J(\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\b\u0010&\u001a\u0004\u0018\u00010\"H\u0007J2\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/sdklib/internal/avd/AvdManager$Companion;", "", "<init>", "()V", "INI_LINE_PATTERN", "Ljava/util/regex/Pattern;", "AVD_FOLDER_EXTENSION", "", "NUMERIC_SKIN_SIZE", "getNUMERIC_SKIN_SIZE", "()Ljava/util/regex/Pattern;", "DATA_FOLDER", "USERDATA_IMG", "USERDATA_QEMU_IMG", "SNAPSHOTS_DIRECTORY", "USER_SETTINGS_INI", "BOOT_PROP", "ENVIRONMENT_INI", "CONFIG_INI", "HARDWARE_QEMU_INI", "SDCARD_IMG", "INI_EXTENSION", "INI_NAME_PATTERN", "IMAGE_NAME_PATTERN", "HARDWARE_INI", "createInstance", "Lcom/android/sdklib/internal/avd/AvdManager;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "baseAvdFolder", "Ljava/nio/file/Path;", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "log", "Lcom/android/utils/ILogger;", "parseEnvironmentFile", "", "dataFolder", "logger", "parseIniFile", "", "propFile", "Lcom/android/io/IAbstractFile;", "parseIniFileImpl", "charset", "Ljava/nio/charset/Charset;", "inhibitCopyOnWrite", "", "avdFolder", "android.sdktools.sdklib"})
    @SourceDebugExtension(value={"SMAP\nAvdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdManager.kt\ncom/android/sdklib/internal/avd/AvdManager$Companion\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1746:1\n57#2:1747\n1#3:1748\n*S KotlinDebug\n*F\n+ 1 AvdManager.kt\ncom/android/sdklib/internal/avd/AvdManager$Companion\n*L\n1638#1:1747\n1638#1:1748\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getNUMERIC_SKIN_SIZE() {
            return NUMERIC_SKIN_SIZE;
        }

        @JvmStatic
        @NotNull
        public final AvdManager createInstance(@NotNull AndroidSdkHandler sdkHandler, @NotNull Path baseAvdFolder, @NotNull DeviceManager deviceManager, @NotNull ILogger log) {
            Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
            Intrinsics.checkNotNullParameter((Object)baseAvdFolder, (String)"baseAvdFolder");
            Intrinsics.checkNotNullParameter((Object)deviceManager, (String)"deviceManager");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            return new AvdManager(sdkHandler, baseAvdFolder, deviceManager, log, null);
        }

        @NotNull
        public final Map<String, String> parseEnvironmentFile(@NotNull Path dataFolder, @Nullable ILogger logger) {
            Map<String, String> map;
            Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
            PathFileWrapper environmentPath = new PathFileWrapper(dataFolder.resolve(AvdManager.ENVIRONMENT_INI));
            if (environmentPath.exists() && (map = this.parseIniFileImpl(environmentPath, logger, Charsets.UTF_8)) != null) {
                Map<String, String> it = map;
                boolean bl = false;
                return it;
            }
            return new LinkedHashMap();
        }

        @JvmStatic
        @Slow
        @Nullable
        public final Map<String, String> parseIniFile(@NotNull IAbstractFile propFile, @Nullable ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)propFile, (String)"propFile");
            return this.parseIniFileImpl(propFile, logger, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Map<String, String> parseIniFileImpl(IAbstractFile propFile, ILogger log, Charset charset) {
            Charset currentCharset = null;
            currentCharset = charset;
            try {
                boolean canChangeCharset;
                boolean bl = canChangeCharset = currentCharset == null;
                if (currentCharset == null) {
                    currentCharset = StandardCharsets.ISO_8859_1;
                }
                Closeable closeable = new BufferedReader(new InputStreamReader(propFile.getContents(), currentCharset));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl2 = false;
                    Map map = new LinkedHashMap();
                    Reader $this$useLines$iv = reader;
                    boolean $i$f$useLines = false;
                    Closeable closeable2 = $this$useLines$iv;
                    closeable2 = (BufferedReader)closeable2;
                    Throwable throwable2 = null;
                    try {
                        BufferedReader it$iv = (BufferedReader)closeable2;
                        boolean bl3 = false;
                        Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                        boolean bl4 = false;
                        for (String line : lines) {
                            Matcher m;
                            String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
                            if (!(((CharSequence)trimmedLine).length() > 0) || trimmedLine.charAt(0) == '#') continue;
                            Intrinsics.checkNotNullExpressionValue((Object)INI_LINE_PATTERN.matcher(trimmedLine), (String)"matcher(...)");
                            if (m.matches()) {
                                String key = m.group(1);
                                String value = m.group(2);
                                if (canChangeCharset && Intrinsics.areEqual((Object)"avd.ini.encoding", (Object)key) && !Intrinsics.areEqual((Object)currentCharset.name(), (Object)value) && Charset.isSupported(value)) {
                                    Map<String, String> map2 = Companion.parseIniFileImpl(propFile, log, Charset.forName(value));
                                    Map<String, String> map3 = map2;
                                    return map3;
                                }
                                map.put(key, value);
                                continue;
                            }
                            ILogger iLogger = log;
                            if (iLogger != null) {
                                Object[] objectArray = new Object[]{propFile.getOsLocation(), trimmedLine};
                                iLogger.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", objectArray);
                            }
                            Map<String, String> map4 = null;
                            Map<String, String> map5 = map4;
                            return map5;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Map map6 = map;
                    return map6;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof FileNotFoundException) return null;
                if (!(exception instanceof IOException)) {
                    if (!(exception instanceof StreamException)) throw e;
                }
                ILogger iLogger = log;
                if (iLogger == null) return null;
                Object[] objectArray = new Object[]{propFile.getOsLocation(), e.getMessage()};
                iLogger.warning("Error parsing '%1$s': %2$s.", objectArray);
                return null;
            }
        }

        private final void inhibitCopyOnWrite(Path avdFolder, ILogger log) {
            if (SdkConstants.CURRENT_PLATFORM != 1) {
                return;
            }
            try {
                String[] stringArray = new String[]{"chattr", "+C", ((Object)avdFolder.toAbsolutePath()).toString()};
                Process chattrProcess = Runtime.getRuntime().exec(stringArray);
                List errorOutput = new ArrayList();
                GrabProcessOutput.grabProcessOutput((Process)chattrProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(errorOutput){
                    final /* synthetic */ List<String> $errorOutput;
                    {
                        this.$errorOutput = $errorOutput;
                    }

                    public void out(String line) {
                    }

                    public void err(String line) {
                        if (line != null && !StringsKt.startsWith$default((String)line, (String)"chattr: Operation not supported", (boolean)false, (int)2, null)) {
                            this.$errorOutput.add(line);
                        }
                    }
                }, null, null);
                if (!((Collection)errorOutput).isEmpty()) {
                    Object[] objectArray = new Object[]{((Object)avdFolder.toAbsolutePath()).toString()};
                    log.warning("Failed 'chattr' for %1$s:", objectArray);
                    for (String error : errorOutput) {
                        Object[] objectArray2 = new Object[]{error};
                        log.warning(" -- %1$s", objectArray2);
                    }
                }
            }
            catch (InterruptedException e) {
                Object[] objectArray = new Object[]{((Object)avdFolder.toAbsolutePath()).toString(), e};
                log.warning("Failed 'chattr' for %1$s: %2$s", objectArray);
            }
            catch (TimeoutException e) {
                Object[] objectArray = new Object[]{((Object)avdFolder.toAbsolutePath()).toString(), e};
                log.warning("Failed 'chattr' for %1$s: %2$s", objectArray);
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{((Object)avdFolder.toAbsolutePath()).toString(), e};
                log.warning("Failed 'chattr' for %1$s: %2$s", objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

