/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdBuilder;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdNetworkLatency;
import com.android.sdklib.internal.avd.AvdNetworkSpeed;
import com.android.sdklib.internal.avd.BootMode;
import com.android.sdklib.internal.avd.CompositeBinding;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.EnumConverter;
import com.android.sdklib.internal.avd.ExternalSdCard;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.MapBinding;
import com.android.sdklib.internal.avd.MapBindingKt;
import com.android.sdklib.internal.avd.PropertyMapBinding;
import com.android.sdklib.internal.avd.QuickBoot;
import com.android.sdklib.internal.avd.SdCard;
import com.android.sdklib.internal.avd.SdCards;
import com.android.sdklib.internal.avd.Skin;
import com.android.sdklib.internal.avd.Skins;
import com.android.sdklib.internal.avd.StorageConverter;
import com.android.sdklib.internal.avd.ValueConverter;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u0084\u00012\u00020\u0001:\u0002\u0084\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010}\u001a\u00020~J\u0013\u0010\u007f\u001a\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0080\u0001J\u0013\u00100\u001a\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0080\u0001J \u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u00100\u001a\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0080\u0001H\u0002J\u001a\u0010\u0082\u0001\u001a\u00020~2\u0007\u0010\u0083\u0001\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\fR\u001a\u0010\u001b\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\n\"\u0004\b2\u0010\fR\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010H\"\u0004\bM\u0010JR\u001a\u0010N\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010H\"\u0004\bP\u0010JR\u001a\u0010Q\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u001a\u0010W\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010T\"\u0004\bY\u0010VR\u001a\u0010Z\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010`\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u00106\"\u0004\bb\u00108R\u001a\u0010c\u001a\u00020dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR\u001a\u0010i\u001a\u00020jX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u001a\u0010o\u001a\u00020pX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR\u001d\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120v\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010xR\u0013\u0010y\u001a\u0004\u0018\u00010z8F\u00a2\u0006\u0006\u001a\u0004\b{\u0010|\u00a8\u0006\u0085\u0001"}, d2={"Lcom/android/sdklib/internal/avd/AvdBuilder;", "", "metadataIniPath", "Ljava/nio/file/Path;", "avdFolder", "device", "Lcom/android/sdklib/devices/Device;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/android/sdklib/devices/Device;)V", "getMetadataIniPath", "()Ljava/nio/file/Path;", "setMetadataIniPath", "(Ljava/nio/file/Path;)V", "getDevice", "()Lcom/android/sdklib/devices/Device;", "setDevice", "(Lcom/android/sdklib/devices/Device;)V", "name", "", "avdName", "getAvdName", "()Ljava/lang/String;", "setAvdName", "(Ljava/lang/String;)V", "newFolder", "getAvdFolder", "setAvdFolder", "displayName", "getDisplayName", "setDisplayName", "systemImage", "Lcom/android/sdklib/ISystemImage;", "getSystemImage", "()Lcom/android/sdklib/ISystemImage;", "setSystemImage", "(Lcom/android/sdklib/ISystemImage;)V", "sdCard", "Lcom/android/sdklib/internal/avd/SdCard;", "getSdCard", "()Lcom/android/sdklib/internal/avd/SdCard;", "setSdCard", "(Lcom/android/sdklib/internal/avd/SdCard;)V", "skin", "Lcom/android/sdklib/internal/avd/Skin;", "getSkin", "()Lcom/android/sdklib/internal/avd/Skin;", "setSkin", "(Lcom/android/sdklib/internal/avd/Skin;)V", "environment", "getEnvironment", "setEnvironment", "showDeviceFrame", "", "getShowDeviceFrame", "()Z", "setShowDeviceFrame", "(Z)V", "screenOrientation", "Lcom/android/resources/ScreenOrientation;", "getScreenOrientation", "()Lcom/android/resources/ScreenOrientation;", "setScreenOrientation", "(Lcom/android/resources/ScreenOrientation;)V", "cpuCoreCount", "", "getCpuCoreCount", "()I", "setCpuCoreCount", "(I)V", "ram", "Lcom/android/sdklib/devices/Storage;", "getRam", "()Lcom/android/sdklib/devices/Storage;", "setRam", "(Lcom/android/sdklib/devices/Storage;)V", "vmHeap", "getVmHeap", "setVmHeap", "internalStorage", "getInternalStorage", "setInternalStorage", "frontCamera", "Lcom/android/sdklib/internal/avd/AvdCamera;", "getFrontCamera", "()Lcom/android/sdklib/internal/avd/AvdCamera;", "setFrontCamera", "(Lcom/android/sdklib/internal/avd/AvdCamera;)V", "backCamera", "getBackCamera", "setBackCamera", "gpuMode", "Lcom/android/sdklib/internal/avd/GpuMode;", "getGpuMode", "()Lcom/android/sdklib/internal/avd/GpuMode;", "setGpuMode", "(Lcom/android/sdklib/internal/avd/GpuMode;)V", "enableKeyboard", "getEnableKeyboard", "setEnableKeyboard", "networkLatency", "Lcom/android/sdklib/internal/avd/AvdNetworkLatency;", "getNetworkLatency", "()Lcom/android/sdklib/internal/avd/AvdNetworkLatency;", "setNetworkLatency", "(Lcom/android/sdklib/internal/avd/AvdNetworkLatency;)V", "networkSpeed", "Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;", "getNetworkSpeed", "()Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;", "setNetworkSpeed", "(Lcom/android/sdklib/internal/avd/AvdNetworkSpeed;)V", "bootMode", "Lcom/android/sdklib/internal/avd/BootMode;", "getBootMode", "()Lcom/android/sdklib/internal/avd/BootMode;", "setBootMode", "(Lcom/android/sdklib/internal/avd/BootMode;)V", "userSettings", "", "getUserSettings", "()Ljava/util/Map;", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "initializeFromDevice", "", "configProperties", "", "environmentFromConfig", "updateInternalPaths", "oldFolder", "Companion", "android.sdktools.sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdBuilder.kt\ncom/android/sdklib/internal/avd/AvdBuilder\n+ 2 MapBinding.kt\ncom/android/sdklib/internal/avd/MapBindingKt\n*L\n1#1,223:1\n74#2:224\n165#2:225\n70#2:226\n162#2:227\n70#2:228\n162#2:229\n70#2:230\n162#2:231\n70#2:232\n162#2:233\n70#2:234\n162#2:235\n*S KotlinDebug\n*F\n+ 1 AvdBuilder.kt\ncom/android/sdklib/internal/avd/AvdBuilder\n*L\n186#1:224\n186#1:225\n196#1:226\n196#1:227\n197#1:228\n197#1:229\n198#1:230\n198#1:231\n200#1:232\n200#1:233\n201#1:234\n201#1:235\n*E\n"})
public final class AvdBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private Path metadataIniPath;
    @NotNull
    private Device device;
    @NotNull
    private Path avdFolder;
    @NotNull
    private String displayName;
    @Nullable
    private ISystemImage systemImage;
    @Nullable
    private SdCard sdCard;
    @Nullable
    private Skin skin;
    @Nullable
    private Path environment;
    private boolean showDeviceFrame;
    @NotNull
    private ScreenOrientation screenOrientation;
    private int cpuCoreCount;
    @NotNull
    private Storage ram;
    @NotNull
    private Storage vmHeap;
    @NotNull
    private Storage internalStorage;
    @NotNull
    private AvdCamera frontCamera;
    @NotNull
    private AvdCamera backCamera;
    @NotNull
    private GpuMode gpuMode;
    private boolean enableKeyboard;
    @NotNull
    private AvdNetworkLatency networkLatency;
    @NotNull
    private AvdNetworkSpeed networkSpeed;
    @NotNull
    private BootMode bootMode;
    @NotNull
    private final Map<String, String> userSettings;
    @NotNull
    private static final Map<String, String> defaultConfigKeys;
    @NotNull
    private static final CompositeBinding<AvdBuilder> binding;

    public AvdBuilder(@NotNull Path metadataIniPath, @NotNull Path avdFolder, @NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)metadataIniPath, (String)"metadataIniPath");
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.metadataIniPath = metadataIniPath;
        this.device = device;
        this.avdFolder = avdFolder;
        this.displayName = "";
        this.showDeviceFrame = true;
        this.screenOrientation = ScreenOrientation.PORTRAIT;
        this.cpuCoreCount = 1;
        this.ram = new Storage(0L);
        this.vmHeap = new Storage(0L);
        this.internalStorage = new Storage(0L);
        this.frontCamera = AvdCamera.NONE;
        this.backCamera = AvdCamera.NONE;
        this.gpuMode = GpuMode.OFF;
        this.enableKeyboard = true;
        this.networkLatency = AvdNetworkLatency.NONE;
        this.networkSpeed = AvdNetworkSpeed.FULL;
        this.bootMode = QuickBoot.INSTANCE;
        this.userSettings = new LinkedHashMap();
    }

    @NotNull
    public final Path getMetadataIniPath() {
        return this.metadataIniPath;
    }

    public final void setMetadataIniPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.metadataIniPath = path;
    }

    @NotNull
    public final Device getDevice() {
        return this.device;
    }

    public final void setDevice(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"<set-?>");
        this.device = device;
    }

    @NotNull
    public final String getAvdName() {
        return StringsKt.removeSuffix((String)PathsKt.getName((Path)this.metadataIniPath), (CharSequence)".ini");
    }

    public final void setAvdName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = this.metadataIniPath.resolveSibling(name + ".ini");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        this.metadataIniPath = path;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.avdFolder;
    }

    public final void setAvdFolder(@NotNull Path newFolder) {
        Intrinsics.checkNotNullParameter((Object)newFolder, (String)"newFolder");
        Path oldFolder = this.avdFolder;
        this.updateInternalPaths(oldFolder, newFolder);
        this.avdFolder = newFolder;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.displayName = string;
    }

    @Nullable
    public final ISystemImage getSystemImage() {
        return this.systemImage;
    }

    public final void setSystemImage(@Nullable ISystemImage iSystemImage) {
        this.systemImage = iSystemImage;
    }

    @Nullable
    public final SdCard getSdCard() {
        return this.sdCard;
    }

    public final void setSdCard(@Nullable SdCard sdCard) {
        this.sdCard = sdCard;
    }

    @Nullable
    public final Skin getSkin() {
        return this.skin;
    }

    public final void setSkin(@Nullable Skin skin) {
        this.skin = skin;
    }

    @Nullable
    public final Path getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@Nullable Path path) {
        this.environment = path;
    }

    public final boolean getShowDeviceFrame() {
        return this.showDeviceFrame;
    }

    public final void setShowDeviceFrame(boolean bl) {
        this.showDeviceFrame = bl;
    }

    @NotNull
    public final ScreenOrientation getScreenOrientation() {
        return this.screenOrientation;
    }

    public final void setScreenOrientation(@NotNull ScreenOrientation screenOrientation) {
        Intrinsics.checkNotNullParameter((Object)screenOrientation, (String)"<set-?>");
        this.screenOrientation = screenOrientation;
    }

    public final int getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final void setCpuCoreCount(int n) {
        this.cpuCoreCount = n;
    }

    @NotNull
    public final Storage getRam() {
        return this.ram;
    }

    public final void setRam(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.ram = storage;
    }

    @NotNull
    public final Storage getVmHeap() {
        return this.vmHeap;
    }

    public final void setVmHeap(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.vmHeap = storage;
    }

    @NotNull
    public final Storage getInternalStorage() {
        return this.internalStorage;
    }

    public final void setInternalStorage(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.internalStorage = storage;
    }

    @NotNull
    public final AvdCamera getFrontCamera() {
        return this.frontCamera;
    }

    public final void setFrontCamera(@NotNull AvdCamera avdCamera) {
        Intrinsics.checkNotNullParameter((Object)avdCamera, (String)"<set-?>");
        this.frontCamera = avdCamera;
    }

    @NotNull
    public final AvdCamera getBackCamera() {
        return this.backCamera;
    }

    public final void setBackCamera(@NotNull AvdCamera avdCamera) {
        Intrinsics.checkNotNullParameter((Object)avdCamera, (String)"<set-?>");
        this.backCamera = avdCamera;
    }

    @NotNull
    public final GpuMode getGpuMode() {
        return this.gpuMode;
    }

    public final void setGpuMode(@NotNull GpuMode gpuMode) {
        Intrinsics.checkNotNullParameter((Object)gpuMode, (String)"<set-?>");
        this.gpuMode = gpuMode;
    }

    public final boolean getEnableKeyboard() {
        return this.enableKeyboard;
    }

    public final void setEnableKeyboard(boolean bl) {
        this.enableKeyboard = bl;
    }

    @NotNull
    public final AvdNetworkLatency getNetworkLatency() {
        return this.networkLatency;
    }

    public final void setNetworkLatency(@NotNull AvdNetworkLatency avdNetworkLatency) {
        Intrinsics.checkNotNullParameter((Object)avdNetworkLatency, (String)"<set-?>");
        this.networkLatency = avdNetworkLatency;
    }

    @NotNull
    public final AvdNetworkSpeed getNetworkSpeed() {
        return this.networkSpeed;
    }

    public final void setNetworkSpeed(@NotNull AvdNetworkSpeed avdNetworkSpeed) {
        Intrinsics.checkNotNullParameter((Object)avdNetworkSpeed, (String)"<set-?>");
        this.networkSpeed = avdNetworkSpeed;
    }

    @NotNull
    public final BootMode getBootMode() {
        return this.bootMode;
    }

    public final void setBootMode(@NotNull BootMode bootMode) {
        Intrinsics.checkNotNullParameter((Object)bootMode, (String)"<set-?>");
        this.bootMode = bootMode;
    }

    @NotNull
    public final Map<String, String> getUserSettings() {
        return this.userSettings;
    }

    @Nullable
    public final AndroidVersion getAndroidVersion() {
        ISystemImage iSystemImage = this.systemImage;
        return iSystemImage != null ? iSystemImage.getAndroidVersion() : null;
    }

    public final void initializeFromDevice() {
        GenericSkin genericSkin;
        Map<String, String> map = DeviceManager.getHardwareProperties(this.device);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHardwareProperties(...)");
        binding.read(this, map);
        AvdBuilder avdBuilder = this;
        Dimension dimension = this.device.getScreenSize(this.device.getDefaultState().getOrientation());
        if (dimension != null) {
            Dimension it = dimension;
            AvdBuilder avdBuilder2 = avdBuilder;
            boolean bl = false;
            genericSkin = new GenericSkin(it.width, it.height);
            avdBuilder = avdBuilder2;
        } else {
            genericSkin = null;
        }
        avdBuilder.skin = genericSkin;
        this.cpuCoreCount = EmulatedProperties.defaultCpuCount(this.device);
        Storage storage = EmulatedProperties.defaultRamSize(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage, (String)"defaultRamSize(...)");
        this.ram = storage;
        Storage storage2 = EmulatedProperties.defaultVmHeapSize(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage2, (String)"defaultVmHeapSize(...)");
        this.vmHeap = storage2;
        Storage storage3 = EmulatedProperties.defaultInternalStorage(this.device);
        Intrinsics.checkNotNullExpressionValue((Object)storage3, (String)"defaultInternalStorage(...)");
        this.internalStorage = storage3;
    }

    @NotNull
    public final Map<String, String> configProperties() {
        Map properties = new LinkedHashMap();
        properties.putAll(defaultConfigKeys);
        Map<String, String> map = DeviceManager.getHardwareProperties(this.device);
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHardwareProperties(...)");
        properties.putAll(map);
        properties.put("hw.gpu.enabled", this.gpuMode == GpuMode.OFF ? "no" : "yes");
        properties.put("AvdId", this.getAvdName());
        properties.putAll(this.bootMode.properties());
        if (this.environment != null) {
            properties.put("hw.lcd.transparent", "yes");
        }
        binding.write(this, properties);
        return properties;
    }

    @NotNull
    public final Map<String, String> environment() {
        String string;
        Map properties = new LinkedHashMap();
        Object object = this.environment;
        if (object != null && (object = PathsKt.getExtension((Path)object)) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string3 = string;
        Object[] objectArray = new String[]{"png", "jpg", "webp"};
        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)string3)) {
            properties.put("background.image.filename", String.valueOf(this.environment));
        } else {
            objectArray = new String[]{"mov", "mp4", "webm"};
            if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)string3)) {
                properties.put("background.video.filename", String.valueOf(this.environment));
            }
        }
        return properties;
    }

    private final Path environmentFromConfig(Map<String, String> environment) {
        Object[] objectArray = new String[]{"background.image.filename", "background.video.filename"};
        for (String key : CollectionsKt.listOf((Object[])objectArray)) {
            String string = environment.get(key);
            if (string == null) continue;
            String it = string;
            boolean bl = false;
            return this.avdFolder.relativize(this.avdFolder.resolve(it));
        }
        return null;
    }

    private final void updateInternalPaths(Path oldFolder, Path newFolder) {
        SdCard sdCard = this.sdCard;
        if (sdCard instanceof ExternalSdCard && StringsKt.startsWith$default((String)((ExternalSdCard)sdCard).getPath(), (String)((Object)oldFolder).toString(), (boolean)false, (int)2, null)) {
            String string = ((ExternalSdCard)sdCard).getPath().substring(((Object)oldFolder).toString().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.sdCard = new ExternalSdCard(((Object)newFolder.resolve(string)).toString());
        }
    }

    @JvmStatic
    @NotNull
    public static final AvdBuilder createForExistingDevice(@NotNull Device device, @NotNull AvdInfo avdInfo) {
        return Companion.createForExistingDevice(device, avdInfo);
    }

    static {
        KMutableProperty1 $this$bindToKey$iv;
        Companion = new Companion(null);
        defaultConfigKeys = MapsKt.mapOf((Pair)TuplesKt.to((Object)"skin.dynamic", (Object)"yes"));
        MapBinding[] mapBindingArray = new MapBinding[13];
        mapBindingArray[0] = MapBindingKt.bindToKeyString((KMutableProperty1)Companion.binding.1.INSTANCE, "avd.ini.displayname");
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)Companion.binding.2.INSTANCE;
        String key$iv = "hw.initialOrientation";
        boolean $i$f$bindToKeyResourceEnum = false;
        boolean $i$f$resourceEnumConverter = false;
        mapBindingArray[1] = new PropertyMapBinding((ValueConverter)new EnumConverter<ScreenOrientation>(ScreenOrientation.class, MapBindingKt.resourceEnumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        mapBindingArray[2] = MapBindingKt.bindToKeyBoolean((KMutableProperty1)Companion.binding.3.INSTANCE, "showDeviceFrame");
        mapBindingArray[3] = MapBindingKt.bindToKeyInt((KMutableProperty1)Companion.binding.4.INSTANCE, "hw.cpu.ncore");
        mapBindingArray[4] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.5.INSTANCE, new StorageConverter(null, false, 1, null)).toKey("hw.ramSize");
        mapBindingArray[5] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.6.INSTANCE, new StorageConverter(null, false, 1, null)).toKey("vm.heapSize");
        mapBindingArray[6] = MapBindingKt.bindVia((KMutableProperty1)Companion.binding.7.INSTANCE, new StorageConverter(Storage.Unit.B, false, 2, null)).toKey("disk.dataPartition.size");
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.8.INSTANCE;
        key$iv = "hw.camera.front";
        boolean $i$f$bindToKeyConfigEnum = false;
        boolean $i$f$enumConverter = false;
        mapBindingArray[7] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdCamera>(AvdCamera.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.9.INSTANCE;
        key$iv = "hw.camera.back";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[8] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdCamera>(AvdCamera.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.10.INSTANCE;
        key$iv = "hw.gpu.mode";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[9] = new PropertyMapBinding((ValueConverter)new EnumConverter<GpuMode>(GpuMode.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        mapBindingArray[10] = MapBindingKt.bindToKeyBoolean((KMutableProperty1)Companion.binding.11.INSTANCE, "hw.keyboard");
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.12.INSTANCE;
        key$iv = "runtime.network.latency";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[11] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdNetworkLatency>(AvdNetworkLatency.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        $this$bindToKey$iv = (KMutableProperty1)Companion.binding.13.INSTANCE;
        key$iv = "runtime.network.speed";
        $i$f$bindToKeyConfigEnum = false;
        $i$f$enumConverter = false;
        mapBindingArray[12] = new PropertyMapBinding((ValueConverter)new EnumConverter<AvdNetworkSpeed>(AvdNetworkSpeed.class, MapBindingKt.enumConverter.1.INSTANCE), key$iv, $this$bindToKey$iv);
        binding = new CompositeBinding(mapBindingArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/android/sdklib/internal/avd/AvdBuilder$Companion;", "", "<init>", "()V", "defaultConfigKeys", "", "", "getDefaultConfigKeys", "()Ljava/util/Map;", "binding", "Lcom/android/sdklib/internal/avd/CompositeBinding;", "Lcom/android/sdklib/internal/avd/AvdBuilder;", "getBinding$android_sdktools_sdklib", "()Lcom/android/sdklib/internal/avd/CompositeBinding;", "createForExistingDevice", "device", "Lcom/android/sdklib/devices/Device;", "avdInfo", "Lcom/android/sdklib/internal/avd/AvdInfo;", "android.sdktools.sdklib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getDefaultConfigKeys() {
            return defaultConfigKeys;
        }

        @NotNull
        public final CompositeBinding<AvdBuilder> getBinding$android_sdktools_sdklib() {
            return binding;
        }

        @JvmStatic
        @NotNull
        public final AvdBuilder createForExistingDevice(@NotNull Device device, @NotNull AvdInfo avdInfo) {
            AvdBuilder avdBuilder;
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
            AvdBuilder $this$createForExistingDevice_u24lambda_u240 = avdBuilder = new AvdBuilder(avdInfo.getIniFile(), avdInfo.getDataFolderPath(), device);
            boolean bl = false;
            $this$createForExistingDevice_u24lambda_u240.setSystemImage(avdInfo.getSystemImage());
            $this$createForExistingDevice_u24lambda_u240.setSdCard(SdCards.sdCardFromConfig(avdInfo.getProperties()));
            $this$createForExistingDevice_u24lambda_u240.setSkin(Skins.skinFromConfig(avdInfo.getProperties()));
            $this$createForExistingDevice_u24lambda_u240.setEnvironment($this$createForExistingDevice_u24lambda_u240.environmentFromConfig(avdInfo.getEnvironment()));
            $this$createForExistingDevice_u24lambda_u240.setBootMode(BootMode.Companion.fromProperties(avdInfo.getProperties()));
            Companion.getBinding$android_sdktools_sdklib().read($this$createForExistingDevice_u24lambda_u240, avdInfo.getProperties());
            $this$createForExistingDevice_u24lambda_u240.getUserSettings().putAll(avdInfo.getUserSettings());
            $this$createForExistingDevice_u24lambda_u240.getUserSettings().remove("avd.ini.encoding");
            return avdBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

