/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.ImageUtils;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aB\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"paintPanelImage", "", "T", "Lcom/intellij/ui/components/JBPanel;", "g", "Ljava/awt/Graphics;", "image", "Ljava/awt/Image;", "active", "", "highFidelityScaling", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nImagePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePanel.kt\ncom/android/tools/adtui/ui/ImagePanelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class ImagePanelKt {
    public static final <T extends JBPanel<T>> void paintPanelImage(@NotNull JBPanel<T> $this$paintPanelImage, @NotNull Graphics g, @Nullable Image image, boolean active, boolean highFidelityScaling) {
        block5: {
            Graphics2D graphics2D;
            Intrinsics.checkNotNullParameter($this$paintPanelImage, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Insets insets = $this$paintPanelImage.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, $this$paintPanelImage.getWidth() - insets.left - insets.right, $this$paintPanelImage.getHeight() - insets.bottom - insets.top);
            g.setColor($this$paintPanelImage.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            Composite prevComposite = null;
            if (!active) {
                Graphics2D $this$paintPanelImage_u24lambda_u240 = graphics2D = (Graphics2D)g;
                boolean bl = false;
                prevComposite = $this$paintPanelImage_u24lambda_u240.getComposite();
                $this$paintPanelImage_u24lambda_u240.setComposite(AlphaComposite.SrcOver.derive(0.3f));
            }
            Image image2 = image;
            if (image2 != null) {
                Image img = image2;
                boolean bl = false;
                int imageWidth = img.getWidth((ImageObserver)$this$paintPanelImage);
                int imageHeight = img.getHeight((ImageObserver)$this$paintPanelImage);
                if (imageWidth > 0 && imageHeight > 0) {
                    double scale = RangesKt.coerceAtMost((double)(rect.getWidth() / (double)imageWidth), (double)(rect.getHeight() / (double)imageHeight));
                    int w = MathKt.roundToInt((double)((double)imageWidth * scale));
                    int h = MathKt.roundToInt((double)((double)imageHeight * scale));
                    int xOffset = rect.x + (rect.width - w) / 2;
                    int yOffset = rect.y + (rect.height - h) / 2;
                    if (highFidelityScaling) {
                        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)img);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
                        BufferedImage bufferedImage2 = bufferedImage;
                        double graphicsScale = JBUIScale.sysScale((Graphics2D)((Graphics2D)g));
                        double scaleX = graphicsScale * (double)w / (double)imageWidth;
                        double scaleY = graphicsScale * (double)h / (double)imageHeight;
                        BufferedImage bufferedImage3 = ImageUtils.scale(bufferedImage2, scaleX, scaleY);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"scale(...)");
                        BufferedImage scaledImage = bufferedImage3;
                        g.drawImage(scaledImage, xOffset, yOffset, w, h, null);
                    } else {
                        StartupUiUtil.drawImage((Graphics)g, (Image)img, (Rectangle)new Rectangle(xOffset, yOffset, w, h), null, null);
                    }
                }
            }
            Graphics2D $this$paintPanelImage_u24lambda_u243 = graphics2D = (Graphics2D)g;
            boolean bl = false;
            Composite composite = prevComposite;
            if (composite == null) break block5;
            Composite it = composite;
            boolean bl2 = false;
            $this$paintPanelImage_u24lambda_u243.setComposite(it);
        }
    }
}

