/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.stdui.menu.CommonPopupMenuUI;
import com.android.tools.adtui.stdui.menu.CommonSeparatorUI;
import com.intellij.ui.components.JBScrollBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class CommonPopupMenu
extends JPopupMenu {
    @NotNull
    private final JScrollBar myScrollBar;
    @NotNull
    private final MouseWheelListener myListener;

    public CommonPopupMenu() {
        this.setLayout(new ScrollablePopupLayout());
        this.myScrollBar = new JBScrollBar(1);
        this.myScrollBar.setUI((ScrollBarUI)((Object)new RangeScrollBarUI()));
        this.myScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                CommonPopupMenu.this.doLayout();
                CommonPopupMenu.this.repaint();
            }
        });
        this.myListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int scrollAmount = e.getScrollType() == 0 ? e.getUnitsToScroll() * CommonPopupMenu.this.myScrollBar.getUnitIncrement() : (e.getWheelRotation() >= 0 ? 1 : -1) * CommonPopupMenu.this.myScrollBar.getBlockIncrement();
                CommonPopupMenu.this.myScrollBar.setValue(CommonPopupMenu.this.myScrollBar.getValue() + scrollAmount);
                e.consume();
            }
        };
        this.addMouseWheelListener(this.myListener);
        this.add(this.myScrollBar);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new CommonPopupMenuUI());
    }

    @Override
    public void addSeparator() {
        this.add(new CommonSeparator());
    }

    @Override
    public void removeAll() {
        for (int i = this.getComponentCount() - 1; i >= 1; --i) {
            this.remove(i);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        int screenHeight = CommonPopupMenu.getScreenHeight(invoker);
        this.myScrollBar.setVisible(this.getPreferredPopupHeight() > screenHeight);
        if (this.myScrollBar.isVisible()) {
            Insets insets = this.getInsets();
            int height = screenHeight;
            int itemHeight = 0;
            int width = 0;
            int totalHeight = 0;
            for (Component child : this.getComponents()) {
                if (child == this.myScrollBar) continue;
                Dimension preferred = child.getPreferredSize();
                width = Math.max(width, preferred.width);
                totalHeight += preferred.height;
                itemHeight = Math.max(itemHeight, preferred.height);
            }
            this.myScrollBar.setValues(0, height, 0, totalHeight += insets.top + insets.bottom);
            this.myScrollBar.setUnitIncrement(itemHeight);
            this.myScrollBar.setBlockIncrement(height);
            this.setPopupSize(width += insets.left + insets.right + this.myScrollBar.getPreferredSize().width, height);
        }
        super.show(invoker, x, y);
    }

    private int getPreferredPopupHeight() {
        Insets insets = this.getInsets();
        int totalHeight = insets.top + insets.bottom;
        for (Component child : this.getComponents()) {
            if (child == this.myScrollBar) continue;
            totalHeight += child.getPreferredSize().height;
        }
        return totalHeight;
    }

    private static int getScreenHeight(@NotNull Component target) {
        int screenHeight = Integer.MAX_VALUE;
        GraphicsConfiguration config = target.getGraphicsConfiguration();
        if (config != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
            screenHeight = config.getBounds().height - (insets.top + insets.bottom);
        }
        return screenHeight;
    }

    private class ScrollablePopupLayout
    implements LayoutManager2 {
        private ScrollablePopupLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int screenHeight = CommonPopupMenu.getScreenHeight(parent);
            int height = insets.top + insets.bottom;
            int width = 0;
            for (Component child : parent.getComponents()) {
                if (child == CommonPopupMenu.this.myScrollBar) continue;
                Dimension size = child.getPreferredSize();
                height += size.height;
                width = Math.max(width, size.width);
            }
            width += insets.left + insets.right;
            if (CommonPopupMenu.this.myScrollBar.isVisible()) {
                width += CommonPopupMenu.this.myScrollBar.getPreferredSize().width;
            }
            return new Dimension(width, Math.min(height, screenHeight));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int screenHeight = CommonPopupMenu.getScreenHeight(parent);
            int height = insets.top + insets.bottom;
            int width = 0;
            for (Component child : parent.getComponents()) {
                if (child == CommonPopupMenu.this.myScrollBar) continue;
                Dimension size = child.getMinimumSize();
                height += size.height;
                width = Math.max(width, size.width);
            }
            width += insets.left + insets.right;
            if (CommonPopupMenu.this.myScrollBar.isVisible()) {
                width += CommonPopupMenu.this.myScrollBar.getMinimumSize().width;
            }
            return new Dimension(width, Math.min(height, screenHeight));
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int startHeight = CommonPopupMenu.this.myScrollBar.isVisible() ? -CommonPopupMenu.this.myScrollBar.getValue() : insets.top;
            int screenHeight = CommonPopupMenu.getScreenHeight(parent);
            int maxWidth = 0;
            for (Component comp : parent.getComponents()) {
                if (comp == CommonPopupMenu.this.myScrollBar) continue;
                maxWidth = Math.max(maxWidth, comp.getPreferredSize().width);
            }
            for (Component child : parent.getComponents()) {
                Dimension size = child.getPreferredSize();
                if (child == CommonPopupMenu.this.myScrollBar) {
                    if (!child.isVisible()) continue;
                    child.setBounds(insets.left + maxWidth, insets.top, size.width, screenHeight - insets.top - insets.bottom);
                    continue;
                }
                child.setBounds(insets.left, startHeight, maxWidth, size.height);
                startHeight += size.height;
            }
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }
    }

    public static class CommonSeparator
    extends JSeparator {
        @Override
        public void updateUI() {
            super.updateUI();
            this.setUI(new CommonSeparatorUI());
        }
    }
}

