/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public final class TimeAxisFormatter
extends BaseAxisFormatter {
    private static final int[] MULTIPLIERS = new int[]{1000, 1000, 60, 60, 24};
    private static final int[] BASES = new int[]{10, 10, 60, 60, 24};
    private static final int[] MIN_INTERVALS = new int[]{10, 10, 1, 1, 1};
    private static final String[] UNITS = new String[]{"us", "ms", "s", "m", "h"};
    private static final IntList[] BASE_FACTORS;
    public static final TimeAxisFormatter DEFAULT;
    public static final TimeAxisFormatter DEFAULT_WITHOUT_MINOR_TICKS;

    public TimeAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        return TimeFormatter.getSimplifiedClockString((long)value);
    }

    @Override
    protected int getNumUnits() {
        return UNITS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return UNITS[index];
    }

    @Override
    protected int getUnitBase(int index) {
        return BASES[index];
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return MULTIPLIERS[index];
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return MIN_INTERVALS[index];
    }

    @Override
    @NotNull
    protected IntList getUnitBaseFactors(int index) {
        return BASE_FACTORS[index];
    }

    static {
        DEFAULT = new TimeAxisFormatter(5, 10, 5);
        DEFAULT_WITHOUT_MINOR_TICKS = new TimeAxisFormatter(1, 10, 5);
        int size = BASES.length;
        BASE_FACTORS = new IntList[size];
        for (int i = 0; i < size; ++i) {
            TimeAxisFormatter.BASE_FACTORS[i] = TimeAxisFormatter.getMultiplierFactors(BASES[i]);
        }
    }
}

