/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import org.jetbrains.annotations.NotNull;

public class DefaultTimeline
implements Timeline {
    protected static final double DEFAULT_ZOOM_RATIO = 0.75;
    public static final double PADDING_RATIO = 0.1;
    public static final double PAN_RATIO_PER_WHEEL_CLICK = 0.1;
    private final Range myDataRange = new Range();
    private final Range myViewRange = new Range();
    private final Range myTooltipRange = new Range();
    private final Range mySelectionRange = new Range();
    private double myZoomRatio = 0.75;

    @Override
    @NotNull
    public Range getDataRange() {
        return this.myDataRange;
    }

    @Override
    @NotNull
    public Range getViewRange() {
        return this.myViewRange;
    }

    @Override
    @NotNull
    public Range getTooltipRange() {
        return this.myTooltipRange;
    }

    @Override
    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRange;
    }

    public void setZoomRatio(double zoomRatio) {
        this.myZoomRatio = zoomRatio;
    }

    @Override
    public void zoomIn() {
        this.zoomIn(0.5);
    }

    @Override
    public void zoomOut() {
        this.zoomOut(0.5);
    }

    @Override
    public void resetZoom() {
        this.myViewRange.set(this.myDataRange);
    }

    @Override
    public void frameViewToRange(@NotNull Range targetRange) {
        this.myViewRange.set(targetRange.getIntersection(this.myDataRange));
    }

    @Override
    public void handleMouseWheelZoom(double count, double anchor) {
        block3: {
            block2: {
                if (!(count < 0.0)) break block2;
                while (count < 0.0) {
                    this.zoomIn(anchor);
                    count += 1.0;
                }
                break block3;
            }
            if (!(count > 0.0)) break block3;
            while (count > 0.0) {
                this.zoomOut(anchor);
                count -= 1.0;
            }
        }
    }

    @Override
    public void handleMouseWheelPan(double count) {
        this.panView(count * this.myDataRange.getLength() * 0.1);
    }

    private void zoomIn(double ratio) {
        double newMax;
        double max;
        double min = this.myViewRange.getMin();
        double mid = min + ((max = this.myViewRange.getMax()) - min) * ratio;
        double newMin = mid - (mid - min) * this.myZoomRatio;
        if (newMin < (newMax = mid + (max - mid) * this.myZoomRatio)) {
            this.myViewRange.set(newMin, newMax);
        }
    }

    private void zoomOut(double ratio) {
        double min = this.myViewRange.getMin();
        double max = this.myViewRange.getMax();
        double mid = min + (max - min) * ratio;
        double newMin = mid - (mid - min) / this.myZoomRatio;
        double newMax = mid + (max - mid) / this.myZoomRatio;
        this.myViewRange.set(new Range(newMin, newMax).getIntersection(this.myDataRange));
    }
}

