/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class ExpandingEventRenderer<E>
implements EventRenderer<E> {
    private static final int LINE_WIDTH = 12;
    private final Color myLineColor;

    public ExpandingEventRenderer(Color lineColor) {
        this.myLineColor = lineColor;
    }

    @Override
    public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver, EventAction<E> action) {
        Color currentColor = g2d.getColor();
        Stroke currentStroke = g2d.getStroke();
        double xPosition = transform.getTranslateX() - 6.0;
        double yPosition = transform.getTranslateY() + 6.0;
        BasicStroke str = new BasicStroke(12.0f);
        g2d.setStroke(str);
        RoundRectangle2D.Double markerRect = new RoundRectangle2D.Double(xPosition, yPosition, 3.0, 12.0, 1.0, 1.0);
        g2d.setColor(this.myLineColor);
        g2d.fill(markerRect);
        if (isMouseOver) {
            RoundRectangle2D.Double expandedRect = new RoundRectangle2D.Double(xPosition, yPosition, length, 12.0, 1.0, 1.0);
            Color temp = ColorUtil.withAlpha((Color)this.myLineColor, (double)0.8);
            g2d.setColor(temp);
            g2d.fill(expandedRect);
        }
        g2d.setColor(currentColor);
        g2d.setStroke(currentStroke);
    }
}

