/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.common.ProposedFileTreeModelKt;
import com.android.utils.SdkUtils;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010\u0018\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u001a\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010!\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010$\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/adtui/common/ProposedFileTreeModel;", "Ljavax/swing/tree/TreeModel;", "rootNode", "Lcom/android/tools/adtui/common/ProposedFileTreeModel$Node;", "<init>", "(Lcom/android/tools/adtui/common/ProposedFileTreeModel$Node;)V", "rootDir", "Ljava/io/File;", "proposedFileToIcon", "", "Ljavax/swing/Icon;", "(Ljava/io/File;Ljava/util/Map;)V", "proposedFiles", "", "(Ljava/io/File;Ljava/util/Set;)V", "hasConflicts", "", "getRoot", "isLeaf", "node", "", "getChildCount", "", "parent", "getIndexOfChild", "child", "getChild", "index", "valueForPathChanged", "", "path", "Ljavax/swing/tree/TreePath;", "newValue", "removeTreeModelListener", "l", "Ljavax/swing/event/TreeModelListener;", "addTreeModelListener", "getShadowConflictedFiles", "", "Node", "ConflictChecker", "intellij.android.adt.ui"})
public final class ProposedFileTreeModel
implements TreeModel {
    @NotNull
    private final Node rootNode;

    private ProposedFileTreeModel(Node rootNode) {
        this.rootNode = rootNode;
    }

    public ProposedFileTreeModel(@NotNull File rootDir, @NotNull Map<File, ? extends Icon> proposedFileToIcon) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(proposedFileToIcon, (String)"proposedFileToIcon");
        this(Node.Companion.makeTree(rootDir, proposedFileToIcon.keySet(), (Function1<? super File, ? extends Icon>)((Function1)new Function1<File, Icon>(proposedFileToIcon){

            public final Icon invoke(File p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return (Icon)((Map)this.receiver).get(p0);
            }
        })));
    }

    public ProposedFileTreeModel(@NotNull File rootDir, @NotNull Set<? extends File> proposedFiles) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(proposedFiles, (String)"proposedFiles");
        this(Node.Companion.makeTree(rootDir, proposedFiles, (Function1<? super File, ? extends Icon>)((Function1)ProposedFileTreeModel::_init_$lambda$0)));
    }

    public final boolean hasConflicts() {
        return this.rootNode.hasConflicts();
    }

    @Override
    @NotNull
    public Node getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(@Nullable Object node) {
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type com.android.tools.adtui.common.ProposedFileTreeModel.Node");
        return ((Node)node).isLeaf();
    }

    @Override
    public int getChildCount(@Nullable Object parent) {
        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.android.tools.adtui.common.ProposedFileTreeModel.Node");
        return ((Node)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(@Nullable Object parent, @Nullable Object child) {
        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.android.tools.adtui.common.ProposedFileTreeModel.Node");
        Node node = (Node)parent;
        Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type com.android.tools.adtui.common.ProposedFileTreeModel.Node");
        return node.getIndexOfChild((Node)child);
    }

    @Override
    @NotNull
    public Node getChild(@Nullable Object parent, int index) {
        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.android.tools.adtui.common.ProposedFileTreeModel.Node");
        return ((Node)parent).getChild(index);
    }

    @Override
    public void valueForPathChanged(@Nullable TreePath path, @Nullable Object newValue) {
    }

    @Override
    public void removeTreeModelListener(@Nullable TreeModelListener l) {
    }

    @Override
    public void addTreeModelListener(@Nullable TreeModelListener l) {
    }

    @NotNull
    public final List<File> getShadowConflictedFiles() {
        return this.rootNode.getShadowConflictedFiles();
    }

    private static final Icon _init_$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0003H\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/adtui/common/ProposedFileTreeModel$ConflictChecker;", "", "rootDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "directoryContentsCache", "", "", "Lcom/android/tools/adtui/common/ProposedFileTreeModel$ConflictChecker$TypedFile;", "findConflictingFiles", "", "", "file", "Ljava/io/File;", "getChildren", "filesEqual", "", "file1", "file2", "TypedFile", "intellij.android.adt.ui"})
    private static final class ConflictChecker {
        @NotNull
        private final Path rootDir;
        @NotNull
        private final Map<Path, List<TypedFile>> directoryContentsCache;

        public ConflictChecker(@NotNull Path rootDir) {
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            this.rootDir = rootDir;
            this.directoryContentsCache = new LinkedHashMap();
        }

        @NotNull
        public final Set<String> findConflictingFiles(@NotNull File file) {
            Path grandParent;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Set set = CollectionFactory.createFilePathSet((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createFilePathSet(...)");
            Set conflicts = set;
            Path thisFile = file.toPath();
            if (Files.isRegularFile(thisFile, new LinkOption[0])) {
                conflicts.add(file.getPath());
            }
            Path path = thisFile.getParent();
            if (path == null) {
                return conflicts;
            }
            Path parent = path;
            Path path2 = grandParent = parent.getParent();
            if (!this.filesEqual(path2 != null ? path2.getParent() : null, this.rootDir)) {
                return conflicts;
            }
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)PathsKt.getName((Path)parent));
            if (resourceFolderType == null) {
                return conflicts;
            }
            ResourceFolderType thisFolderType = resourceFolderType;
            if (ResourceType.fromFolderName((String)thisFolderType.getName()) == null) {
                return conflicts;
            }
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)PathsKt.getName((Path)parent));
            if (folderConfiguration == null) {
                return conflicts;
            }
            FolderConfiguration thisConfig = folderConfiguration;
            String thisResourceName = SdkUtils.fileNameToResourceName((String)file.getName());
            Intrinsics.checkNotNull((Object)grandParent);
            for (TypedFile child : this.getChildren(grandParent)) {
                FolderConfiguration config;
                ResourceFolderType folderType;
                Path folder;
                String folderName;
                if (!child.isDirectory() || ResourceFolderType.getFolderType((String)(folderName = PathsKt.getName((Path)(folder = child.getFile())))) == null || FolderConfiguration.getConfigForFolder((String)folderName) == null || folderType != thisFolderType || !thisConfig.isMatchFor(config)) continue;
                for (TypedFile peer : this.getChildren(folder)) {
                    Path peerFile;
                    if (peer.isDirectory() || !Intrinsics.areEqual((Object)SdkUtils.fileNameToResourceName((String)PathsKt.getName((Path)(peerFile = peer.getFile()))), (Object)thisResourceName) || this.filesEqual(peerFile, thisFile)) continue;
                    conflicts.add(peerFile.toFile().getPath());
                }
            }
            return conflicts;
        }

        private final List<TypedFile> getChildren(Path $this$getChildren) {
            List list = this.directoryContentsCache.computeIfAbsent($this$getChildren, arg_0 -> ConflictChecker.getChildren$lambda$4(arg_0 -> ConflictChecker.getChildren$lambda$3($this$getChildren, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
            return list;
        }

        private final boolean filesEqual(Path file1, Path file2) {
            Path path = file1;
            Path path2 = file2;
            return FileUtil.pathsEqual((String)(path != null ? ((Object)path).toString() : null), (String)(path2 != null ? ((Object)path2).toString() : null));
        }

        private static final TypedFile getChildren$lambda$3$lambda$2$lambda$0(Path it) {
            Intrinsics.checkNotNull((Object)it);
            return new TypedFile(it, Files.isDirectory(it, new LinkOption[0]));
        }

        private static final TypedFile getChildren$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            return (TypedFile)$tmp0.invoke(p0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final List getChildren$lambda$3(Path $this_getChildren, Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            try {
                List<TypedFile> list;
                AutoCloseable autoCloseable = Files.list($this_getChildren);
                Throwable throwable = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl = false;
                    list = stream.map(arg_0 -> ConflictChecker.getChildren$lambda$3$lambda$2$lambda$1(ConflictChecker::getChildren$lambda$3$lambda$2$lambda$0, arg_0)).toList();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return list;
            }
            catch (NoSuchFileException e) {
                return CollectionsKt.emptyList();
            }
        }

        private static final List getChildren$lambda$4(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/adtui/common/ProposedFileTreeModel$ConflictChecker$TypedFile;", "", "file", "Ljava/nio/file/Path;", "isDirectory", "", "<init>", "(Ljava/nio/file/Path;Z)V", "getFile", "()Ljava/nio/file/Path;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.adt.ui"})
        private static final class TypedFile {
            @NotNull
            private final Path file;
            private final boolean isDirectory;

            public TypedFile(@NotNull Path file, boolean isDirectory) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                this.file = file;
                this.isDirectory = isDirectory;
            }

            @NotNull
            public final Path getFile() {
                return this.file;
            }

            public final boolean isDirectory() {
                return this.isDirectory;
            }

            @NotNull
            public final Path component1() {
                return this.file;
            }

            public final boolean component2() {
                return this.isDirectory;
            }

            @NotNull
            public final TypedFile copy(@NotNull Path file, boolean isDirectory) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new TypedFile(file, isDirectory);
            }

            public static /* synthetic */ TypedFile copy$default(TypedFile typedFile, Path path, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    path = typedFile.file;
                }
                if ((n & 2) != 0) {
                    bl = typedFile.isDirectory;
                }
                return typedFile.copy(path, bl);
            }

            @NotNull
            public String toString() {
                return "TypedFile(file=" + this.file + ", isDirectory=" + this.isDirectory + ")";
            }

            public int hashCode() {
                int result = ((Object)this.file).hashCode();
                result = result * 31 + Boolean.hashCode(this.isDirectory);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TypedFile)) {
                    return false;
                }
                TypedFile typedFile = (TypedFile)other;
                if (!Intrinsics.areEqual((Object)this.file, (Object)typedFile.file)) {
                    return false;
                }
                return this.isDirectory == typedFile.isDirectory;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\f\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0017J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000H\u0002J*\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030#J\u0016\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0002J\u0016\u0010&\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0002J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c2\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c2\u0003J\t\u0010.\u001a\u00020\fH\u00c2\u0003JG\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u00100\u001a\u00020\f2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\u0017H\u00d6\u0001J\t\u00103\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/adtui/common/ProposedFileTreeModel$Node;", "", "file", "Ljava/io/File;", "conflictedFiles", "", "", "icon", "Ljavax/swing/Icon;", "children", "", "conflictedTree", "", "<init>", "(Ljava/io/File;Ljava/util/Set;Ljavax/swing/Icon;Ljava/util/List;Z)V", "getFile", "()Ljava/io/File;", "getConflictedFiles", "()Ljava/util/Set;", "hasConflicts", "getIcon", "isLeaf", "getChildCount", "", "getIndexOfChild", "child", "getChild", "index", "findChildByFile", "childFile", "addChild", "", "childNode", "addDescendant", "relativePath", "", "conflictChecker", "Lcom/android/tools/adtui/common/ProposedFileTreeModel$ConflictChecker;", "getShadowConflictedFiles", "excludeFilesInTree", "conflictedFilePaths", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "Companion", "intellij.android.adt.ui"})
    @SourceDebugExtension(value={"SMAP\nProposedFileTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposedFileTreeModel.kt\ncom/android/tools/adtui/common/ProposedFileTreeModel$Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,337:1\n1#2:338\n1563#3:339\n1634#3,3:340\n*S KotlinDebug\n*F\n+ 1 ProposedFileTreeModel.kt\ncom/android/tools/adtui/common/ProposedFileTreeModel$Node\n*L\n205#1:339\n205#1:340,3\n*E\n"})
    public static final class Node {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final File file;
        @NotNull
        private final Set<String> conflictedFiles;
        @NotNull
        private Icon icon;
        @NotNull
        private final List<Node> children;
        private boolean conflictedTree;

        public Node(@NotNull File file, @NotNull Set<String> conflictedFiles, @NotNull Icon icon, @NotNull List<Node> children, boolean conflictedTree) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(conflictedFiles, (String)"conflictedFiles");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.file = file;
            this.conflictedFiles = conflictedFiles;
            this.icon = icon;
            this.children = children;
            this.conflictedTree = conflictedTree;
        }

        public /* synthetic */ Node(File file, Set set, Icon icon, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list = new ArrayList();
            }
            if ((n & 0x10) != 0) {
                bl = !((Collection)set).isEmpty();
            }
            this(file, set, icon, list, bl);
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final Set<String> getConflictedFiles() {
            return this.conflictedFiles;
        }

        public final boolean hasConflicts() {
            return this.conflictedTree;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final boolean isLeaf() {
            return this.children.isEmpty();
        }

        public final int getChildCount() {
            return this.children.size();
        }

        public final int getIndexOfChild(@NotNull Node child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return this.children.indexOf(child);
        }

        @NotNull
        public final Node getChild(int index) {
            return this.children.get(index);
        }

        private final Node findChildByFile(File childFile) {
            Object v0;
            block1: {
                Iterable iterable = this.children;
                for (Object t : iterable) {
                    Node it = (Node)t;
                    boolean bl = false;
                    if (!FileUtilRt.filesEqual((File)it.file, (File)childFile)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final void addChild(Node childNode) {
            if (Intrinsics.areEqual((Object)this.icon, (Object)ProposedFileTreeModelKt.getDEFAULT_ICON())) {
                this.icon = ProposedFileTreeModelKt.getDIR_ICON();
            }
            this.children.add(childNode);
        }

        private final void addDescendant(List<String> relativePath, Icon icon, ConflictChecker conflictChecker) {
            if (relativePath.isEmpty()) {
                return;
            }
            File childFile = FilesKt.resolve((File)this.file, (String)relativePath.get(0));
            Node childNode = this.findChildByFile(childFile);
            if (relativePath.size() == 1) {
                if (childNode != null) {
                    if (icon != null) {
                        childNode.icon = icon;
                    }
                } else {
                    Set<String> set;
                    Icon nodeIcon;
                    Icon icon2 = icon;
                    if (icon2 == null) {
                        icon2 = nodeIcon = childFile.isDirectory() ? ProposedFileTreeModelKt.getDIR_ICON() : ProposedFileTreeModelKt.getDEFAULT_ICON();
                    }
                    if ((set = conflictChecker) == null || (set = ((ConflictChecker)((Object)set)).findConflictingFiles(childFile)) == null) {
                        set = SetsKt.emptySet();
                    }
                    Set<String> conflicts = set;
                    childNode = new Node(childFile, conflicts, nodeIcon, null, false, 24, null);
                    this.addChild(childNode);
                }
            } else {
                if (childNode == null) {
                    childNode = new Node(childFile, SetsKt.emptySet(), ProposedFileTreeModelKt.getDIR_ICON(), null, false, 24, null);
                    this.addChild(childNode);
                }
                childNode.addDescendant(CollectionsKt.drop((Iterable)relativePath, (int)1), icon, conflictChecker);
            }
            if (childNode.conflictedTree) {
                this.conflictedTree = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> getShadowConflictedFiles() {
            if (this.hasConflicts()) {
                void $this$mapTo$iv$iv;
                Set set = CollectionFactory.createFilePathSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createFilePathSet(...)");
                Set shadowConflicts = set;
                this.getShadowConflictedFiles(shadowConflicts);
                this.excludeFilesInTree(shadowConflicts);
                Iterable $this$map$iv = shadowConflicts;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new File((String)it));
                }
                return (List)destination$iv$iv;
            }
            return CollectionsKt.emptyList();
        }

        private final void excludeFilesInTree(Set<String> conflictedFilePaths) {
            for (Node child : this.children) {
                if (!child.file.isDirectory()) {
                    conflictedFilePaths.remove(child.file.getPath());
                }
                child.excludeFilesInTree(conflictedFilePaths);
            }
        }

        private final void getShadowConflictedFiles(Set<String> conflictedFilePaths) {
            if (this.hasConflicts()) {
                for (String conflict : this.conflictedFiles) {
                    if (FileUtil.pathsEqual((String)conflict, (String)this.file.getPath())) continue;
                    conflictedFilePaths.add(conflict);
                }
                for (Node child : this.children) {
                    child.getShadowConflictedFiles(conflictedFilePaths);
                }
            }
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        @NotNull
        public final Set<String> component2() {
            return this.conflictedFiles;
        }

        private final Icon component3() {
            return this.icon;
        }

        private final List<Node> component4() {
            return this.children;
        }

        private final boolean component5() {
            return this.conflictedTree;
        }

        @NotNull
        public final Node copy(@NotNull File file, @NotNull Set<String> conflictedFiles, @NotNull Icon icon, @NotNull List<Node> children, boolean conflictedTree) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(conflictedFiles, (String)"conflictedFiles");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new Node(file, conflictedFiles, icon, children, conflictedTree);
        }

        public static /* synthetic */ Node copy$default(Node node, File file, Set set, Icon icon, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                file = node.file;
            }
            if ((n & 2) != 0) {
                set = node.conflictedFiles;
            }
            if ((n & 4) != 0) {
                icon = node.icon;
            }
            if ((n & 8) != 0) {
                list = node.children;
            }
            if ((n & 0x10) != 0) {
                bl = node.conflictedTree;
            }
            return node.copy(file, set, icon, list, bl);
        }

        @NotNull
        public String toString() {
            return "Node(file=" + this.file + ", conflictedFiles=" + this.conflictedFiles + ", icon=" + this.icon + ", children=" + this.children + ", conflictedTree=" + this.conflictedTree + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + ((Object)this.conflictedFiles).hashCode();
            result = result * 31 + this.icon.hashCode();
            result = result * 31 + ((Object)this.children).hashCode();
            result = result * 31 + Boolean.hashCode(this.conflictedTree);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)node.file)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.conflictedFiles, node.conflictedFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)node.icon)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.children, node.children)) {
                return false;
            }
            return this.conflictedTree == node.conflictedTree;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/adtui/common/ProposedFileTreeModel$Node$Companion;", "", "<init>", "()V", "makeTree", "Lcom/android/tools/adtui/common/ProposedFileTreeModel$Node;", "rootDir", "Ljava/io/File;", "proposedFiles", "", "getIconForFile", "Lkotlin/Function1;", "Ljavax/swing/Icon;", "getCommonAncestor", "files", "", "intellij.android.adt.ui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Node makeTree(@NotNull File rootDir, @NotNull Set<? extends File> proposedFiles, @NotNull Function1<? super File, ? extends Icon> getIconForFile) {
                Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
                Intrinsics.checkNotNullParameter(proposedFiles, (String)"proposedFiles");
                Intrinsics.checkNotNullParameter(getIconForFile, (String)"getIconForFile");
                File root = this.getCommonAncestor(rootDir, (Collection<? extends File>)proposedFiles);
                Node rootNode = new Node(root, SetsKt.emptySet(), ProposedFileTreeModelKt.getDIR_ICON(), null, false, 24, null);
                Path path = root.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                ConflictChecker conflictChecker = new ConflictChecker(path);
                for (File file : proposedFiles) {
                    Icon icon = (Icon)getIconForFile.invoke((Object)file);
                    File relativeFile = file.isAbsolute() ? FilesKt.relativeTo((File)file, (File)root) : FilesKt.normalize((File)file);
                    String[] stringArray = new String[]{"/"};
                    rootNode.addDescendant(StringsKt.split$default((CharSequence)FilesKt.getInvariantSeparatorsPath((File)relativeFile), (String[])stringArray, (boolean)false, (int)0, (int)6, null), icon, conflictChecker);
                }
                return rootNode;
            }

            private final File getCommonAncestor(File rootDir, Collection<? extends File> files) {
                Path root = rootDir.toPath();
                block0: while (true) {
                    for (File file : files) {
                        if (!file.isAbsolute() || file.toPath().startsWith(root)) continue;
                        if (root.getParent() != null) continue block0;
                        throw new IllegalArgumentException(root + " is not an ancestor of " + file);
                        continue block0;
                    }
                    break;
                }
                File file = root.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                return file;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

