/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001?B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020%H\u0007J*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020%H\u0007J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0'H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0007J \u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\"H\u0007J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007J\b\u00103\u001a\u00020)H\u0007J\b\u00104\u001a\u00020\u001dH\u0007J\b\u00105\u001a\u000206H\u0007J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;H\u0007J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u00109\u001a\u000208H\u0007R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0010\u0010\u0012\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/adtui/common/AdtUiUtils;", "", "<init>", "()V", "DEFAULT_FONT", "Lcom/intellij/util/ui/JBFont;", "Lorg/jetbrains/annotations/NotNull;", "EMPTY_TOOL_WINDOW_FONT", "DEFAULT_FONT_COLOR", "Ljava/awt/Color;", "TITLE_COLOR", "Lcom/intellij/ui/JBColor;", "getTITLE_COLOR", "()Lcom/intellij/ui/JBColor;", "HEADER_COLOR", "getHEADER_COLOR", "HEADER_HOVER_COLOR", "getHEADER_HOVER_COLOR", "DEFAULT_BORDER_COLOR", "DEFAULT_TOP_BORDER", "Ljavax/swing/border/Border;", "DEFAULT_LEFT_BORDER", "DEFAULT_BOTTOM_BORDER", "DEFAULT_RIGHT_BORDER", "DEFAULT_HORIZONTAL_BORDERS", "DEFAULT_VERTICAL_BORDERS", "GBC_FULL", "Ljava/awt/GridBagConstraints;", "shrinkToFit", "", "text", "metrics", "Ljava/awt/FontMetrics;", "availableSpace", "", "spaceThreshold", "direction", "Lcom/android/tools/adtui/common/AdtUiUtils$ShrinkDirection;", "textFitPredicate", "Ljava/util/function/Predicate;", "unscale", "", "i", "overlayColor", "backgroundRgb", "foregroundRbg", "foregroundOpacity", "isActionKeyDown", "", "event", "Ljava/awt/event/InputEvent;", "getActionMask", "getActionKeyText", "createHorizontalSeparator", "Ljavax/swing/JComponent;", "setTooltipCursor", "Ljava/awt/Container;", "container", "cursor", "Ljava/awt/Cursor;", "allComponents", "Lkotlin/sequences/Sequence;", "Ljava/awt/Component;", "ShrinkDirection", "intellij.android.adt.ui"})
public final class AdtUiUtils {
    @NotNull
    public static final AdtUiUtils INSTANCE = new AdtUiUtils();
    @JvmField
    @NotNull
    public static final JBFont DEFAULT_FONT;
    @JvmField
    @NotNull
    public static final JBFont EMPTY_TOOL_WINDOW_FONT;
    @JvmField
    @NotNull
    public static final Color DEFAULT_FONT_COLOR;
    @NotNull
    private static final JBColor TITLE_COLOR;
    @NotNull
    private static final JBColor HEADER_COLOR;
    @NotNull
    private static final JBColor HEADER_HOVER_COLOR;
    @JvmField
    @NotNull
    public static final Color DEFAULT_BORDER_COLOR;
    @JvmField
    @NotNull
    public static final Border DEFAULT_TOP_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_LEFT_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_BOTTOM_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_RIGHT_BORDER;
    @JvmField
    @NotNull
    public static final Border DEFAULT_HORIZONTAL_BORDERS;
    @JvmField
    @NotNull
    public static final Border DEFAULT_VERTICAL_BORDERS;
    @JvmField
    @NotNull
    public static final GridBagConstraints GBC_FULL;

    private AdtUiUtils() {
    }

    @NotNull
    public final JBColor getTITLE_COLOR() {
        return TITLE_COLOR;
    }

    @NotNull
    public final JBColor getHEADER_COLOR() {
        return HEADER_COLOR;
    }

    @NotNull
    public final JBColor getHEADER_HOVER_COLOR() {
        return HEADER_HOVER_COLOR;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, float spaceThreshold, @NotNull ShrinkDirection direction) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        return AdtUiUtils.shrinkToFit(text, direction, arg_0 -> AdtUiUtils.shrinkToFit$lambda$0(availableSpace, spaceThreshold, metrics, arg_0));
    }

    public static /* synthetic */ String shrinkToFit$default(String string, FontMetrics fontMetrics, float f, float f2, ShrinkDirection shrinkDirection, int n, Object object) {
        if ((n & 0x10) != 0) {
            shrinkDirection = ShrinkDirection.TRUNCATE_END;
        }
        return AdtUiUtils.shrinkToFit(string, fontMetrics, f, f2, shrinkDirection);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, @NotNull ShrinkDirection direction) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        return AdtUiUtils.shrinkToFit(text, metrics, availableSpace, 0.0f, direction);
    }

    public static /* synthetic */ String shrinkToFit$default(String string, FontMetrics fontMetrics, float f, ShrinkDirection shrinkDirection, int n, Object object) {
        if ((n & 8) != 0) {
            shrinkDirection = ShrinkDirection.TRUNCATE_END;
        }
        return AdtUiUtils.shrinkToFit(string, fontMetrics, f, shrinkDirection);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull ShrinkDirection direction, @NotNull Predicate<String> textFitPredicate) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(textFitPredicate, (String)"textFitPredicate");
        if (textFitPredicate.test(text)) {
            return text;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            String string2;
            int midLength = smallestLength + (largestLength - smallestLength) / 2;
            if (direction == ShrinkDirection.TRUNCATE_END) {
                String string3 = text.substring(0, midLength);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                String string4 = text.substring(text.length() - 1 - midLength, text.length());
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String substring = string2;
            if (textFitPredicate.test(substring + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        if (direction == ShrinkDirection.TRUNCATE_END) {
            String string5 = text.substring(0, bestLength);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = string5 + "...";
        } else {
            String string6 = text.substring(text.length() - 1 - bestLength, text.length());
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = "..." + string6;
        }
        String result = string;
        return bestLength > 0 ? result : "";
    }

    public static /* synthetic */ String shrinkToFit$default(String string, ShrinkDirection shrinkDirection, Predicate predicate, int n, Object object) {
        if ((n & 2) != 0) {
            shrinkDirection = ShrinkDirection.TRUNCATE_END;
        }
        return AdtUiUtils.shrinkToFit(string, shrinkDirection, predicate);
    }

    @JvmStatic
    public static final int unscale(int i) {
        return MathKt.roundToInt((float)((float)i / JBUIScale.scale((float)1.0f)));
    }

    @JvmStatic
    @NotNull
    public static final Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color foreground = new Color(foregroundRbg);
        return new Color(MathKt.roundToInt((float)((float)background.getRed() * (1.0f - foregroundOpacity) + (float)foreground.getRed() * foregroundOpacity)), MathKt.roundToInt((float)((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)foreground.getGreen() * foregroundOpacity)), MathKt.roundToInt((float)((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)foreground.getBlue() * foregroundOpacity)));
    }

    @JvmStatic
    public static final boolean isActionKeyDown(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return ClientSystemInfo.Companion.isMac() ? event.isMetaDown() : event.isControlDown();
    }

    @JvmStatic
    @JdkConstants.InputEventMask
    public static final int getActionMask() {
        return ClientSystemInfo.Companion.isMac() ? 256 : 128;
    }

    @JvmStatic
    @NotNull
    public static final String getActionKeyText() {
        if (ClientSystemInfo.Companion.isMac()) {
            Font labelFont = StartupUiUtil.getLabelFont();
            return labelFont != null && labelFont.canDisplayUpTo("\u2318") == -1 ? "\u2318" : "Cmd";
        }
        return "Ctrl";
    }

    @JvmStatic
    @NotNull
    public static final JComponent createHorizontalSeparator() {
        JPanel separatorWrapper = new JPanel(new TabularLayout("*", "*,Fit,*"));
        separatorWrapper.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0, 0, 4, null));
        Dimension size = new Dimension(1, 2);
        separatorWrapper.setMinimumSize(size);
        separatorWrapper.setPreferredSize(size);
        separatorWrapper.setOpaque(false);
        return separatorWrapper;
    }

    @JvmStatic
    @Nullable
    public static final Container setTooltipCursor(@NotNull Container container, @NotNull Cursor cursor) {
        Container p;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        for (p = container; p != null; p = p.getParent()) {
            if (!(p instanceof TooltipLayeredPane)) continue;
            ((TooltipLayeredPane)p).setCursor(cursor);
            break;
        }
        return p;
    }

    @JvmStatic
    @NotNull
    public static final Sequence<Component> allComponents(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Component[] componentArray = container.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        return SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])componentArray), AdtUiUtils::allComponents$lambda$1);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, float spaceThreshold) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return AdtUiUtils.shrinkToFit$default(text, metrics, availableSpace, spaceThreshold, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        return AdtUiUtils.shrinkToFit$default(text, metrics, availableSpace, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String shrinkToFit(@NotNull String text, @NotNull Predicate<String> textFitPredicate) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(textFitPredicate, (String)"textFitPredicate");
        return AdtUiUtils.shrinkToFit$default(text, null, textFitPredicate, 2, null);
    }

    private static final boolean shrinkToFit$lambda$0(float $availableSpace, float $spaceThreshold, FontMetrics $metrics, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return $availableSpace > $spaceThreshold && $availableSpace >= (float)$metrics.stringWidth(s);
    }

    private static final Sequence allComponents$lambda$1(Component it) {
        Sequence sequence;
        if (it instanceof Container && ((Container)it).getComponentCount() != 0) {
            Object[] objectArray = new Container[]{it};
            sequence = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), AdtUiUtils.allComponents((Container)it));
        } else {
            Object[] objectArray = new Component[]{it};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    static {
        JBFont jBFont = JBUI.Fonts.label((float)10.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"label(...)");
        DEFAULT_FONT = jBFont;
        JBFont jBFont2 = JBUI.Fonts.label((float)13.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont2, (String)"label(...)");
        EMPTY_TOOL_WINDOW_FONT = jBFont2;
        Color color = JBColor.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        DEFAULT_FONT_COLOR = color;
        TITLE_COLOR = new JBColor(7106686, 13553878);
        HEADER_COLOR = new JBColor(7106686, 14672357);
        HEADER_HOVER_COLOR = new JBColor(5922155, 15790578);
        DEFAULT_BORDER_COLOR = (Color)StudioColorsKt.getBorder();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder, (String)"createMatteBorder(...)");
        DEFAULT_TOP_BORDER = matteBorder;
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder2, (String)"createMatteBorder(...)");
        DEFAULT_LEFT_BORDER = matteBorder2;
        MatteBorder matteBorder3 = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder3, (String)"createMatteBorder(...)");
        DEFAULT_BOTTOM_BORDER = matteBorder3;
        MatteBorder matteBorder4 = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder4, (String)"createMatteBorder(...)");
        DEFAULT_RIGHT_BORDER = matteBorder4;
        MatteBorder matteBorder5 = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder5, (String)"createMatteBorder(...)");
        DEFAULT_HORIZONTAL_BORDERS = matteBorder5;
        MatteBorder matteBorder6 = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)matteBorder6, (String)"createMatteBorder(...)");
        DEFAULT_VERTICAL_BORDERS = matteBorder6;
        GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/adtui/common/AdtUiUtils$ShrinkDirection;", "", "<init>", "(Ljava/lang/String;I)V", "TRUNCATE_START", "TRUNCATE_END", "intellij.android.adt.ui"})
    public static final class ShrinkDirection
    extends Enum<ShrinkDirection> {
        public static final /* enum */ ShrinkDirection TRUNCATE_START = new ShrinkDirection();
        public static final /* enum */ ShrinkDirection TRUNCATE_END = new ShrinkDirection();
        private static final /* synthetic */ ShrinkDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ShrinkDirection[] values() {
            return (ShrinkDirection[])$VALUES.clone();
        }

        public static ShrinkDirection valueOf(String value) {
            return Enum.valueOf(ShrinkDirection.class, value);
        }

        @NotNull
        public static EnumEntries<ShrinkDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = shrinkDirectionArray = new ShrinkDirection[]{ShrinkDirection.TRUNCATE_START, ShrinkDirection.TRUNCATE_END};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

