/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.chart.statechart.StateChartReducer;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultStateChartReducer<T>
implements StateChartReducer<T> {
    @Override
    public void reduce(@NotNull List<Rectangle2D.Float> rectangles, @NotNull List<T> values) {
        int index = 0;
        int keepIndex = 0;
        HashMap<T, Float> occurrenceWidth = new HashMap<T, Float>();
        while (index < rectangles.size()) {
            T value = values.get(index);
            Rectangle2D.Float rect = rectangles.get(index);
            if (Math.floor(rect.x) < Math.floor(rect.x + rect.width)) {
                rectangles.set(keepIndex, rect);
                values.set(keepIndex, value);
                ++keepIndex;
                ++index;
                continue;
            }
            occurrenceWidth.clear();
            float pixelStart = (float)Math.floor(rect.x);
            float pixelEnd = pixelStart + 1.0f;
            float minX = rect.x;
            float maxX = Float.MIN_VALUE;
            float minY = rect.y;
            float height = rect.height;
            while (index < rectangles.size()) {
                rect = rectangles.get(index);
                if (rect.x < pixelStart || rect.x > pixelEnd || rect.x + rect.width > pixelEnd) break;
                maxX = rect.x + rect.width;
                Float width = (Float)occurrenceWidth.get(value = values.get(index));
                occurrenceWidth.put(value, Float.valueOf((width == null ? 0.0f : width.floatValue()) + rect.width));
                ++index;
            }
            Object mostOccurred = null;
            float mostOccurredWidth = -1.0f;
            for (Map.Entry entry2 : occurrenceWidth.entrySet()) {
                if (!(((Float)entry2.getValue()).floatValue() > mostOccurredWidth)) continue;
                mostOccurredWidth = ((Float)entry2.getValue()).floatValue();
                mostOccurred = entry2.getKey();
            }
            if (mostOccurred == null) continue;
            values.set(keepIndex, mostOccurred);
            rectangles.set(keepIndex, new Rectangle2D.Float(minX, minY, maxX - minX, height));
            ++keepIndex;
        }
        rectangles.subList(keepIndex, rectangles.size()).clear();
        values.subList(keepIndex, values.size()).clear();
    }
}

