/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/google/play/policy/insights/HealthConnectPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "policyinsights"})
public final class HealthConnectPolicyDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS;
    @NotNull
    public static final String ID = "HealthConnectPolicy";
    @NotNull
    public static final String DESCRIPTION = "Health Connect Insights";
    @NotNull
    private static final String EXPLANATION;
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888170?hl=en#:~:text=health%20connect%20by";
    @NotNull
    private static final String MESSAGE;
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr nameNode = attr;
        if (PERMISSIONS.contains(nameNode.getValue())) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getLocation((Node)nameNode), (String)MESSAGE, null, (int)16, null);
        }
    }

    static {
        String[] stringArray = new String[]{"android.permission.health.READ_ACTIVE_CALORIES_BURNED", "android.permission.health.READ_ACTIVITY_INTENSITY", "android.permission.health.READ_BASAL_BODY_TEMPERATURE", "android.permission.health.READ_BASAL_METABOLIC_RATE", "android.permission.health.READ_BLOOD_GLUCOSE", "android.permission.health.READ_BLOOD_PRESSURE", "android.permission.health.READ_BODY_FAT", "android.permission.health.READ_BODY_TEMPERATURE", "android.permission.health.READ_BODY_WATER_MASS", "android.permission.health.READ_CERVICAL_MUCUS", "android.permission.health.READ_DISTANCE", "android.permission.health.READ_ELEVATION_GAINED", "android.permission.health.READ_EXERCISE", "android.permission.health.READ_EXERCISE_ROUTES", "android.permission.health.READ_FLOORS_CLIMBED", "android.permission.health.READ_HEALTH_DATA_HISTORY", "android.permission.health.READ_HEALTH_DATA_IN_BACKGROUND", "android.permission.health.READ_HEART_RATE", "android.permission.health.READ_HEART_RATE_VARIABILITY", "android.permission.health.READ_HEIGHT", "android.permission.health.READ_INTERMENSTRUAL_BLEEDING", "android.permission.health.READ_LEAN_BODY_MASS", "android.permission.health.READ_MEDICAL_DATA_ALLERGIES_INTOLERANCES", "android.permission.health.READ_MEDICAL_DATA_CONDITIONS", "android.permission.health.READ_MEDICAL_DATA_LABORATORY_RESULTS", "android.permission.health.READ_MEDICAL_DATA_MEDICATIONS", "android.permission.health.READ_MEDICAL_DATA_PERSONAL_DETAILS", "android.permission.health.READ_MEDICAL_DATA_PRACTITIONER_DETAILS", "android.permission.health.READ_MEDICAL_DATA_PREGNANCY", "android.permission.health.READ_MEDICAL_DATA_PROCEDURES", "android.permission.health.READ_MEDICAL_DATA_SOCIAL_HISTORY", "android.permission.health.READ_MEDICAL_DATA_VACCINES", "android.permission.health.READ_MEDICAL_DATA_VISITS", "android.permission.health.READ_MEDICAL_DATA_VITAL_SIGNS", "android.permission.health.READ_MENSTRUATION", "android.permission.health.READ_MINDFULNESS", "android.permission.health.READ_NUTRITION", "android.permission.health.READ_OVULATION_TEST", "android.permission.health.READ_OXYGEN_SATURATION", "android.permission.health.READ_PLANNED_EXERCISE", "android.permission.health.READ_POWER", "android.permission.health.READ_RESPIRATORY_RATE", "android.permission.health.READ_RESTING_HEART_RATE", "android.permission.health.READ_SEXUAL_ACTIVITY", "android.permission.health.READ_SKIN_TEMPERATURE", "android.permission.health.READ_SLEEP", "android.permission.health.READ_SPEED", "android.permission.health.READ_STEPS", "android.permission.health.READ_TOTAL_CALORIES_BURNED", "android.permission.health.READ_VO2_MAX", "android.permission.health.READ_WEIGHT", "android.permission.health.READ_WHEELCHAIR_PUSHES", "android.permission.health.WRITE_ACTIVE_CALORIES_BURNED", "android.permission.health.WRITE_ACTIVITY_INTENSITY", "android.permission.health.WRITE_BASAL_BODY_TEMPERATURE", "android.permission.health.WRITE_BLOOD_GLUCOSE", "android.permission.health.WRITE_BLOOD_PRESSURE", "android.permission.health.WRITE_BODY_FAT", "android.permission.health.WRITE_BODY_TEMPERATURE", "android.permission.health.WRITE_BODY_WATER_MASS", "android.permission.health.WRITE_BONE_MASS", "android.permission.health.WRITE_CERVICAL_MUCUS", "android.permission.health.WRITE_DISTANCE", "android.permission.health.WRITE_ELEVATION_GAINED", "android.permission.health.WRITE_EXERCISE", "android.permission.health.WRITE_EXERCISE_ROUTE", "android.permission.health.WRITE_FLOORS_CLIMBED", "android.permission.health.WRITE_HEART_RATE", "android.permission.health.WRITE_HEART_RATE_VARIABILITY", "android.permission.health.WRITE_HEIGHT", "android.permission.health.WRITE_HYDRATION", "android.permission.health.WRITE_INTERMENSTRUAL_BLEEDING", "android.permission.health.WRITE_LEAN_BODY_MASS", "android.permission.health.WRITE_MEDICAL_DATA", "android.permission.health.WRITE_MENSTRUATION", "android.permission.health.WRITE_MINDFULNESS", "android.permission.health.WRITE_NUTRITION", "android.permission.health.WRITE_OVULATION_TEST", "android.permission.health.WRITE_OXYGEN_SATURATION", "android.permission.health.WRITE_PLANNED_EXERCISE", "android.permission.health.WRITE_POWER", "android.permission.health.WRITE_RESPIRATORY_RATE", "android.permission.health.WRITE_RESTING_HEART_RATE", "android.permission.health.WRITE_SEXUAL_ACTIVITY", "android.permission.health.WRITE_SKIN_TEMPERATURE", "android.permission.health.WRITE_SLEEP", "android.permission.health.WRITE_SPEED", "android.permission.health.WRITE_STEPS", "android.permission.health.WRITE_TOTAL_CALORIES_BURNED", "android.permission.health.WRITE_VO2_MAX", "android.permission.health.WRITE_WEIGHT", "android.permission.health.WRITE_WHEELCHAIR_PUSHES"};
        PERMISSIONS = CollectionsKt.listOf((Object[])stringArray);
        EXPLANATION = "Access to Health Connect data is restricted to apps with approved health, fitness, medical \\\ncare, or health research core use cases. You must strictly limit data access to the minimum \\\nscope necessary for these approved functions and obtain explicit user consent before sharing \\\nany health data with third parties. Transparency is key, so provide clear disclosures and a \\\ncomprehensive privacy policy explaining data collection, use, management, and deletion. \\\nSecure user data against unauthorized access and comply with all applicable laws and \\\nregulations (e.g., HIPAA, GDPR).\n\n**Dos:**\n\n- Your app must also comply with the Health apps policy if it qualifies as a health app or \\\nhas health-related features and accesses health data including Health Connect data.\n- See Health Connect policy requirement FAQs to request access to Health Connect data types \\\nand other FAQs.\n- Submit a declaration form in your Play Console. For each permission requested, provide a \\\nclear and detailed justification explaining how your app will use the data to benefit the \\\nuser.\n- Request only the minimum necessary data types.\n- Securely handle user data (e.g., use modern cryptography).\n\n**Don'ts:**\n\n- Use Health Connect in high-risk apps (e.g., aviation, control of life-critical systems \\\nsuch as pacemakers) or for children.\n- Sell or transfer user data for advertising, creditworthiness, or data brokers.\n- Use with medical devices without required regulatory compliance/clearances.\n- Access Health Connect data for secondary or unapproved purposes.\n- Request data permissions beyond your app's core functionality.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-health-connect  \nSee Help Center article: https://goo.gle/play-help-health-connect \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
        MESSAGE = "Health Connect permission is restricted to approved core Health or Fitness functions use \\\nonly and requires strict data access and handling, user consent and transparency.";
        stringArray = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(HealthConnectPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)stringArray, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/google/play/policy/insights/HealthConnectPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

