/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/google/play/policy/insights/AdvertisingIdPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableMethodNames", "", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "policyinsights"})
public final class AdvertisingIdPolicyDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS = CollectionsKt.listOf((Object)"com.google.android.gms.permission.AD_ID");
    public static final int MIN_TARGET_SDK_VERSION = 33;
    @NotNull
    public static final String GET_ID = "getId";
    @NotNull
    public static final String AD_ID_CLIENT_INFO = "com.google.android.gms.ads.identifier.AdvertisingIdClient.Info";
    @NotNull
    public static final String ID = "AdvertisingIdPolicy";
    @NotNull
    public static final String DESCRIPTION = "Advertising Id Insights";
    @NotNull
    private static final String EXPLANATION = "The Android advertising identifier (AAID) must only be used for advertising and user \\\nanalytics; although we urge you to instead transition to App Set ID for analytics. You must \\\nrespect users' opt-out selections and acquire explicit user consent if you link the AAID to \\\npersonally identifiable information (PII). It is crucial to be transparent, so disclose any \\\nAAID collection and use in a legally adequate privacy policy. \n\n**Dos:**\n\n- Submit a declaration form in your Play Console for Google Play services permission.\n- Use App Set ID for non-ads use cases (analytics, fraud).\n\n**Don'ts:**\n\n- Use persistent identifiers for advertising instead of AAID.\n- Link AAID to PII for any analytics purposes -even with consent.\n- Allow third-party code in your app to violate this policy.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-advertising-id  \nSee Help Center article: https://goo.gle/play-help-advertising-identifier \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9857753";
    @NotNull
    private static final String MESSAGE = "Use Advertising Identifier only for advertising or user analytics. Respect user choices \\\n(opt-outs), get consent for PII links, and disclose use clearly.";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Attr toolsNode;
            Attr attr2 = toolsNode = element.getAttributeNodeNS("http://schemas.android.com/tools", "node");
            if (Intrinsics.areEqual((Object)(attr2 != null ? attr2.getValue() : null), (Object)"remove")) {
                return;
            }
            Intrinsics.checkNotNull((Object)nameNode);
            context.report(new Incident(ISSUE, (Object)element, context.getLocation((Node)nameNode), MESSAGE), Constraints.targetSdkAtLeast((int)33));
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)GET_ID);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, AD_ID_CLIENT_INFO, false)) {
            return;
        }
        context.report(new Incident(ISSUE, (Object)node, context.getNameLocation((UElement)node), MESSAGE), Constraints.targetSdkAtLeast((int)33));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(AdvertisingIdPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/google/play/policy/insights/AdvertisingIdPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "MIN_TARGET_SDK_VERSION", "", "GET_ID", "AD_ID_CLIENT_INFO", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

