/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.quickfix.QuickFixWithDelegateFactoryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixWithDelegateFactory;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/diagnostic/ReportingClassSubstitutor;", "delegateFactory", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "familyName", "", "text", "startInWriteAction", "", "substitutedClass", "Ljava/lang/Class;", "getSubstitutedClass", "getFamilyName", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "kotlin.idea"})
public class QuickFixWithDelegateFactory
implements IntentionAction,
ReportingClassSubstitutor {
    @NotNull
    private final Function0<IntentionAction> delegateFactory;
    @Nls
    @NotNull
    private final String familyName;
    @Nls
    @NotNull
    private final String text;
    private final boolean startInWriteAction;
    @NotNull
    private final Class<?> substitutedClass;

    public QuickFixWithDelegateFactory(@NotNull Function0<? extends IntentionAction> delegateFactory) {
        Object object;
        Intrinsics.checkNotNullParameter(delegateFactory, (String)"delegateFactory");
        this.delegateFactory = delegateFactory;
        IntentionAction delegate = (IntentionAction)this.delegateFactory.invoke();
        Object object2 = delegate;
        if (object2 == null || (object2 = object2.getFamilyName()) == null) {
            object2 = this.familyName = "";
        }
        if ((object = delegate) == null || (object = object.getText()) == null) {
            object = "";
        }
        this.text = object;
        this.startInWriteAction = delegate != null && delegate.startInWriteAction();
        Object object3 = delegate;
        if (object3 == null || (object3 = object3.getClass()) == null) {
            object3 = this.getClass();
        }
        this.substitutedClass = object3;
    }

    @NotNull
    public Class<?> getSubstitutedClass() {
        return this.substitutedClass;
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionAction intentionAction = (IntentionAction)this.delegateFactory.invoke();
        if (intentionAction == null) {
            return false;
        }
        IntentionAction action2 = intentionAction;
        return action2.isAvailable(project, editor, file);
    }

    public boolean startInWriteAction() {
        return this.startInWriteAction;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        IntentionAction intentionAction = (IntentionAction)this.delegateFactory.invoke();
        if (intentionAction == null) {
            return;
        }
        IntentionAction action2 = intentionAction;
        boolean bl2 = bl = QuickFixWithDelegateFactoryKt.detectPriority(action2) == QuickFixWithDelegateFactoryKt.detectPriority(this);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect priority of QuickFixWithDelegateFactory wrapper for " + action2.getClass().getName();
            throw new AssertionError((Object)string);
        }
        action2.invoke(project, editor, file);
    }
}

