/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.k1.roots;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotifications;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.k1.roots.GradleBuildRootsLocatorImpl;
import org.jetbrains.kotlin.gradle.scripting.k1.roots.GradleScriptingSupport;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleImportHelperKt;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootData;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootDataSerializer;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleScriptInfo;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Legacy;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.New;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.StandaloneScriptsUpdater;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.k1.settings.KotlinScriptingSettingsImpl;
import org.jetbrains.kotlin.idea.core.script.ucache.LightScriptInfo;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J!\u0010\u001d\u001a\u00020\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001e0 \u00a2\u0006\u0002\b\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020$H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001cH\u0016J$\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u00132\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130 H\u0016J\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00105\u001a\u000206H\u0002J\u0016\u00108\u001a\u00020\u001e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001c0:H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleBuildRootsLocatorImpl;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "manager", "Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptConfigurationManager;", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptConfigurationManager;", "updater", "Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater;", "getUpdater", "()Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater;", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "getScriptInfo", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;", "localPath", "", "updateStandaloneScripts", "", "update", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/StandaloneScriptsUpdater;", "Lkotlin/ExtensionFunctionType;", "loadLinkedRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "version", "add", "newRoot", "tryLoadFromFsCache", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/Imported;", "addFromSettings", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "data", "remove", "rootPath", "updateNotifications", "restartAnalyzer", "shouldUpdatePath", "updateFloatingAction", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoReloadScriptConfigurations", "loadStandaloneScriptConfigurations", "files", "", "kotlin.gradle.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleBuildRootsLocatorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1869#2,2:298\n774#2:313\n865#2,2:314\n1869#2,2:316\n11546#3,9:300\n13472#3:309\n13473#3:311\n11555#3:312\n1#4:310\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k1/roots/GradleBuildRootsLocatorImpl\n*L\n66#1:298,2\n149#1:313\n149#1:314,2\n205#1:316,2\n148#1:300,9\n148#1:309\n148#1:311\n148#1:312\n148#1:310\n*E\n"})
public final class GradleBuildRootsLocatorImpl
extends GradleBuildRootsLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private boolean enabled;

    public GradleBuildRootsLocatorImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.enabled = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final ScriptConfigurationManager getManager() {
        return ScriptConfigurationManager.Companion.getInstance(this.project);
    }

    private final ScriptClassRootsUpdater getUpdater() {
        return this.getManager().getUpdater();
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.getRoots().getList());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradleBuildRoot it = (GradleBuildRoot)element$iv;
                boolean bl = false;
                this.reloadBuildRoot(it.getPathPrefix(), null);
            }
        }
    }

    @Override
    @Nullable
    public GradleScriptInfo getScriptInfo(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        LightScriptInfo lightScriptInfo = this.getManager().getLightScriptInfo(localPath);
        return lightScriptInfo instanceof GradleScriptInfo ? (GradleScriptInfo)lightScriptInfo : null;
    }

    @Override
    public void updateStandaloneScripts(@NotNull Function1<? super StandaloneScriptsUpdater, Unit> update2) {
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        StandaloneScriptsUpdater.Changes changes = StandaloneScriptsUpdater.Companion.collectChanges(this.getRoots(), update2);
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocatorImpl.updateStandaloneScripts$lambda$1(changes, arg_0), 1, null);
        this.loadStandaloneScriptConfigurations(changes.getNew());
    }

    @Override
    @NotNull
    public GradleBuildRoot loadLinkedRoot(@NotNull GradleProjectSettings settings2, @NotNull String version) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.enabled) {
            return new Legacy(settings2, null, 2, null);
        }
        boolean supported = UtilsKt.kotlinDslScriptsModelImportSupported(version);
        if (supported) {
            Imported imported = this.tryLoadFromFsCache(settings2, version);
            gradleBuildRoot = imported != null ? (GradleBuildRoot)imported : (GradleBuildRoot)new New(settings2, null, 2, null);
        } else {
            gradleBuildRoot = new Legacy(settings2, null, 2, null);
        }
        return gradleBuildRoot;
    }

    @Override
    public void add(@NotNull GradleBuildRoot newRoot) {
        Intrinsics.checkNotNullParameter((Object)newRoot, (String)"newRoot");
        GradleBuildRoot old = this.getRoots().add(newRoot);
        if (old instanceof Imported && !(newRoot instanceof Imported)) {
            this.removeData(((Imported)old).getPathPrefix());
        }
        if (!(old instanceof Legacy) || !(newRoot instanceof Legacy)) {
            this.getUpdater().invalidateAndCommit();
        }
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocatorImpl.add$lambda$2(newRoot, arg_0), 1, null);
    }

    private final Imported tryLoadFromFsCache(GradleProjectSettings settings2, String version) {
        GradleBuildRootsLocator gradleBuildRootsLocator = this;
        String string = settings2.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
        return GradleBuildRootsLocator.tryCreateImportedRoot$default(gradleBuildRootsLocator, string, null, arg_0 -> GradleBuildRootsLocatorImpl.tryLoadFromFsCache$lambda$4(version, this, settings2, arg_0), 2, null);
    }

    private final GradleBuildRootData addFromSettings(GradleBuildRootData data, GradleProjectSettings settings2) {
        Set set = CollectionsKt.toSet((Iterable)data.getProjectRoots());
        Set set2 = settings2.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getModules(...)");
        return GradleBuildRootData.copy$default(data, 0L, SetsKt.plus((Set)set, (Iterable)set2), null, null, null, 29, null);
    }

    @Override
    public void remove(@NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        GradleBuildRoot removed = this.getRoots().remove(rootPath);
        if (removed instanceof Imported) {
            this.removeData(rootPath);
            this.getUpdater().invalidateAndCommit();
        }
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocatorImpl.remove$lambda$5(rootPath, arg_0), 1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateNotifications(boolean restartAnalyzer, @NotNull Function1<? super String, Boolean> shouldUpdatePath) {
        Intrinsics.checkNotNullParameter(shouldUpdatePath, (String)"shouldUpdatePath");
        if (!this.project.isOpen()) {
            return;
        }
        v0 = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        if (v0 != null && (v0 = v0.getFile()) != null) {
            it = v0;
            $i$a$-let-GradleBuildRootsLocatorImpl$updateNotifications$1 = false;
            v1 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
            if (((Boolean)shouldUpdatePath.invoke((Object)v1)).booleanValue()) {
                v2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                if (this.maybeAffectedGradleProjectFile(v2)) {
                    this.updateFloatingAction((VirtualFile)it);
                }
            }
        }
        v3 = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getSelectedEditors(...)");
        var4_6 = v3;
        $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var12_14 = ((void)$this$forEach$iv$iv$iv).length;
        for (var11_12 = 0; var11_12 < var12_14; ++var11_12) {
            element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var11_12];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            it = (FileEditor)element$iv$iv;
            $i$a$-mapNotNull-GradleBuildRootsLocatorImpl$updateNotifications$openedScripts$1 = false;
            if (it.getFile() == null) continue;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-GradleBuildRootsLocatorImpl$updateNotifications$openedScripts$2 = false;
            v4 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPath(...)");
            if (!((Boolean)shouldUpdatePath.invoke((Object)v4)).booleanValue()) ** GOTO lbl-1000
            v5 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getPath(...)");
            if (this.maybeAffectedGradleProjectFile(v5)) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        openedScripts = (List)destination$iv$iv;
        if (openedScripts.isEmpty()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<? extends VirtualFile>)openedScripts, restartAnalyzer, null){
            int label;
            final /* synthetic */ GradleBuildRootsLocatorImpl this$0;
            final /* synthetic */ List<VirtualFile> $openedScripts;
            final /* synthetic */ boolean $restartAnalyzer;
            {
                this.this$0 = $receiver;
                this.$openedScripts = $openedScripts;
                this.$restartAnalyzer = $restartAnalyzer;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> updateNotifications.2.invokeSuspend$lambda$2(this.this$0, this.$openedScripts, this.$restartAnalyzer), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$2(GradleBuildRootsLocatorImpl this$0, List $openedScripts, boolean $restartAnalyzer) {
                if (this$0.getProject().isDisposed()) {
                    return Unit.INSTANCE;
                }
                Iterable $this$forEach$iv = $openedScripts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (GradleScriptingSupport.Companion.isApplicable(it, this$0.getProject())) {
                        DefaultScriptingSupport.Companion.getInstance(this$0.getProject()).ensureNotificationsRemoved(it);
                    }
                    if ($restartAnalyzer) {
                        Class<?> kotlinCodeBlockModificationListenerClass = Class.forName("org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener");
                        kotlinCodeBlockModificationListenerClass.getMethod("incModificationCount", new Class[0]).invoke(this$0.getProject().getService(kotlinCodeBlockModificationListenerClass), new Object[0]);
                        if (PsiManager.getInstance((Project)this$0.getProject()).findFile(it) != null) {
                            PsiFile ktFile2;
                            boolean bl2 = false;
                            DaemonCodeAnalyzer.getInstance((Project)this$0.getProject()).restart(ktFile2);
                        }
                    }
                    EditorNotifications.getInstance((Project)this$0.getProject()).updateAllNotifications();
                }
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    private final void updateFloatingAction(VirtualFile file) {
        block1: {
            if (!this.isConfigurationOutOfDate(file) || !this.autoReloadScriptConfigurations(this.project, file)) break block1;
            Object object = GradleBuildRootsLocator.Companion.getInstance(this.project).getScriptInfo(file);
            if (object != null && (object = ((GradleScriptInfo)object).getBuildRoot()) != null) {
                Object it = object;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(this.project, (GradleBuildRoot)it);
            }
        }
    }

    private final boolean autoReloadScriptConfigurations(Project project, VirtualFile file) {
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition(file, project);
        if (scriptDefinition == null) {
            return false;
        }
        ScriptDefinition definition = scriptDefinition;
        return KotlinScriptingSettingsImpl.Companion.getInstance(project).autoReloadConfigurations(definition);
    }

    private final void loadStandaloneScriptConfigurations(Set<String> files) {
        ActionsKt.runReadAction(() -> GradleBuildRootsLocatorImpl.loadStandaloneScriptConfigurations$lambda$11(files, this));
    }

    private static final boolean updateStandaloneScripts$lambda$1(StandaloneScriptsUpdater.Changes $changes, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $changes.getNew().contains(it) || $changes.getRemoved().contains(it);
    }

    private static final boolean add$lambda$2(GradleBuildRoot $newRoot, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$newRoot.getPathPrefix(), (boolean)false, (int)2, null);
    }

    private static final GradleBuildRootData tryLoadFromFsCache$lambda$4(String $version, GradleBuildRootsLocatorImpl this$0, GradleProjectSettings $settings, VirtualFile it) {
        GradleBuildRootData gradleBuildRootData;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleBuildRootData gradleBuildRootData2 = GradleBuildRootDataSerializer.Companion.getInstance().read(it);
        if (gradleBuildRootData2 != null) {
            GradleBuildRootData data = gradleBuildRootData2;
            boolean bl = false;
            String gradleHome = data.getGradleHome();
            gradleBuildRootData = !StringsKt.isBlank((CharSequence)gradleHome) && !Intrinsics.areEqual((Object)GradleInstallationManager.Companion.getGradleVersion(Path.of(gradleHome, new String[0])), (Object)$version) ? null : this$0.addFromSettings(data, $settings);
        } else {
            gradleBuildRootData = null;
        }
        return gradleBuildRootData;
    }

    private static final boolean remove$lambda$5(String $rootPath, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$rootPath, (boolean)false, (int)2, null);
    }

    private static final Unit loadStandaloneScriptConfigurations$lambda$11(Set $files, GradleBuildRootsLocatorImpl this$0) {
        Iterable $this$forEach$iv = $files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiFile psiFile;
            KtFile ktFile2;
            String it = (String)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
            if (virtualFile == null || (ktFile2 = (psiFile = PsiManager.getInstance((Project)this$0.project).findFile(virtualFile)) instanceof KtFile ? (KtFile)psiFile : null) == null) continue;
            DefaultScriptingSupport.ensureUpToDatedConfigurationSuggested$default(DefaultScriptingSupport.Companion.getInstance(this$0.project), ktFile2, true, false, 4, null);
        }
        return Unit.INSTANCE;
    }
}

