/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.tests;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslServiceKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangProjectScanStartupActivity;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangdStartupUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/tests/ClangdTestUtilBase;", "", "<init>", "()V", "doSetUp", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "onCrash", "Ljava/lang/Runnable;", "useCommonTarget", "", "runWslToolsSetup", "", "runStartupActivity", "ClangMockUrlConverter", "Companion", "intellij.cidr.clangd"})
public class ClangdTestUtilBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ClangLanguageService doSetUp(@NotNull Project project, @NotNull Disposable disposable, @NotNull Runnable onCrash, boolean useCommonTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)onCrash, (String)"onCrash");
        CidrLogService.LOG.warn("Setting ClangToolsWslService.log level to TRACE");
        ClangToolsWslServiceKt.clangToolsWslTraceOn();
        ClangUtils.forceClangdOn(project);
        ClangUtils.forceClangdShowErrorsOn(project);
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(project);
        if (clangLanguageServiceProvider == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ClangLanguageServiceProvider provider2 = clangLanguageServiceProvider;
        project.putUserData(ClangDaemonContext.URL_CONVERTER_KEY, (Object)new ClangMockUrlConverter());
        if (useCommonTarget) {
            project.putUserData(ClangUtils.CLANGD_ARCHITECTURE, (Object)"x86_64");
            project.putUserData(ClangUtils.CLANGD_OS, (Object)"darwin");
            project.putUserData(ClangUtils.CLANGD_ENVIRONMENT, (Object)"unknown");
        }
        project.putUserData(ClangUtils.CLANGD_C_LANGUAGE_STANDARD, (Object)OCLanguageStandard.C11);
        project.putUserData(ClangUtils.CLANGD_CXX_LANGUAGE_STANDARD, (Object)OCLanguageStandard.CPP14);
        project.putUserData(ClangdBridge.CLANG_CAN_OPEN_FILE, (Object)true);
        if (!(project instanceof ProjectEx) || !((ProjectEx)project).isLight()) {
            ClangProjectScanStartupActivity scanActivity = new ClangProjectScanStartupActivity();
            scanActivity.executeAndWait(project);
        }
        this.runWslToolsSetup(project, disposable);
        this.runStartupActivity(project);
        Disposer.register((Disposable)disposable, () -> ClangdTestUtilBase.doSetUp$lambda$0(provider2, project));
        ClangLanguageService service = provider2.getOrStart();
        if (service == null) {
            return null;
        }
        MessageBusConnection messageBusConnection = service.getMessageBus().connect(disposable);
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ClangServerListener(onCrash){
            final /* synthetic */ Runnable $onCrash;
            {
                this.$onCrash = $onCrash;
            }

            public void onServerFailure() {
                this.$onCrash.run();
            }
        });
        return service;
    }

    protected void runWslToolsSetup(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        CidrLogService.LOG.warn("Waiting for the first WSL tool started...");
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)disposable, () -> ClangdTestUtilBase.runWslToolsSetup$lambda$1(project));
        CidrLogService.LOG.warn("Waiting for the first WSL tool finished");
    }

    protected void runStartupActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClangdStartupUtil.runStartupActivity(project);
    }

    private static final void doSetUp$lambda$0(ClangLanguageServiceProvider $provider, Project $project) {
        ClangStopData clangStopData = $provider.stop();
        Intrinsics.checkNotNullExpressionValue((Object)clangStopData, (String)"stop(...)");
        ClangdTestUtilBase.Companion.ensureStopped(clangStopData);
        ClangStopData clangStopData2 = $provider.stopIndexer();
        Intrinsics.checkNotNullExpressionValue((Object)clangStopData2, (String)"stopIndexer(...)");
        ClangdTestUtilBase.Companion.ensureStopped(clangStopData2);
        ClangUtils.nonForceClangd($project);
        ClangUtils.nonForceClangdShowErrors($project);
    }

    private static final void runWslToolsSetup$lambda$1(Project $project) {
        ClangToolsWslService.Companion.getInstance($project).waitForFirst();
    }

    @JvmStatic
    @NotNull
    public static final String dumpThreads(@NotNull Project project) {
        return Companion.dumpThreads(project);
    }

    @JvmStatic
    @NotNull
    public static final String dumpThreads(@Nullable ClangLanguageService service) {
        return Companion.dumpThreads(service);
    }

    @JvmStatic
    public static final void enableDFA(@NotNull Project project, @NotNull ClionClangDFAConfigParams dfaConfigParams) {
        Companion.enableDFA(project, dfaConfigParams);
    }

    @JvmStatic
    public static final void executeCommandAndWait(@NotNull ClangdIndexerService service, @NotNull ClangIndexerCommand command) throws TimeoutException {
        Companion.executeCommandAndWait(service, command);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/tests/ClangdTestUtilBase$ClangMockUrlConverter;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;", "<init>", "()V", "isAcceptable", "", "url", "", "intellij.cidr.clangd"})
    private static final class ClangMockUrlConverter
    extends ClangUrlConverter {
        @Override
        public boolean isAcceptable(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/tests/ClangdTestUtilBase$Companion;", "", "<init>", "()V", "ensureStopped", "", "stopData", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangStopData;", "dumpThreads", "", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "enableDFA", "dfaConfigParams", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionClangDFAConfigParams;", "executeCommandAndWait", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "command", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIndexerCommand;", "intellij.cidr.clangd"})
    public static final class Companion {
        private Companion() {
        }

        private final void ensureStopped(ClangStopData stopData) {
            try {
                stopData.exitCode.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
            catch (ExecutionException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
            catch (TimeoutException ex) {
                CidrLogService.LOG.warn("Killing clangd");
                stopData.killRunnable.run();
            }
        }

        @JvmStatic
        @NotNull
        public final String dumpThreads(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
            return this.dumpThreads(service);
        }

        @JvmStatic
        @NotNull
        public final String dumpThreads(@Nullable ClangLanguageService service) {
            StringBuilder dump = new StringBuilder();
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            Intrinsics.checkNotNull(stackTraces);
            for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                Thread thread = entry.getKey();
                Object[] elements = entry.getValue();
                dump.append('\"').append(thread.getName()).append("\"\n");
                dump.append("  java.lang.Thread.State: ").append((Object)thread.getState()).append("\n");
                Iterator iterator = ArrayIteratorKt.iterator((Object[])elements);
                while (iterator.hasNext()) {
                    StackTraceElement element = (StackTraceElement)iterator.next();
                    dump.append("    at ").append(element).append("\n");
                }
                dump.append("\n");
            }
            if (service != null) {
                String string = service.getNativeStacktrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNativeStacktrace(...)");
                String nativeStacktrace = string;
                if (!StringUtil.isEmpty((String)nativeStacktrace)) {
                    dump.append("\n\nClangd stacktrace:\n").append(nativeStacktrace);
                }
            }
            String string = dump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        public final void enableDFA(@NotNull Project project, @NotNull ClionClangDFAConfigParams dfaConfigParams) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dfaConfigParams, (String)"dfaConfigParams");
            project.putUserData(ClangIdeFacade.CLANG_DFA_CONFIG, Optional.of(dfaConfigParams));
        }

        @JvmStatic
        public final void executeCommandAndWait(@NotNull ClangdIndexerService service, @NotNull ClangIndexerCommand command) throws TimeoutException {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            try {
                CompletableFuture<Boolean> completableFuture = service.executeCommand(command);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"executeCommand(...)");
                Boolean result = (Boolean)CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture, (long)Duration.ofSeconds(10L).toMillis(), (String)command.getCommand());
                if (!Intrinsics.areEqual((Object)true, (Object)result)) {
                    throw new AssertionError((Object)("Failed to execute " + command.getCommand()));
                }
            }
            catch (ExecutionException ex) {
                ExceptionUtil.rethrow((Throwable)ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

