/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ClangRequestsHelper {
    @NlsSafe
    @NotNull
    private static final String INMEMORY_DIR_PATH = "/clion_clangd_inmemory_directory";
    @NlsSafe
    @NotNull
    private static final String MACRO_PREDEFINES_BASE_PATH = "/clion_clangd_inmemory_directory/macros";

    private ClangRequestsHelper() {
        throw new AssertionError();
    }

    public static boolean isMacroFile(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(1);
        }
        return ClangRequestsHelper.isMacroFile(context.getUrlConverter(), url);
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NlsSafe @NotNull String url) {
        if (converter == null) {
            ClangRequestsHelper.$$$reportNull$$$0(2);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(3);
        }
        return ClangRequestsHelper.isMacroPath(converter.fromUrl(url));
    }

    public static boolean isMacroPath(@NlsSafe @NotNull String path) {
        if (path == null) {
            ClangRequestsHelper.$$$reportNull$$$0(4);
        }
        return path.contains(MACRO_PREDEFINES_BASE_PATH);
    }

    public static boolean isAllowedByGuard(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(5);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(6);
        }
        return !context.getCrashHandler().isBanned(url);
    }

    @NotNull
    public static String getMacrosFileUrl(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(7);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(8);
        }
        return ClangRequestsHelper.getMacrosFileUrl(context.getUrlConverter(), url);
    }

    @NotNull
    public static String getMacrosFileUrl(@NotNull ClangUrlConverter converter, @NlsSafe @NotNull String url) {
        if (converter == null) {
            ClangRequestsHelper.$$$reportNull$$$0(9);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(10);
        }
        String systemIndependentPath = FileUtilRt.toSystemIndependentName((String)ClangRequestsHelper.getMacrosFilePath(converter, url).getPath());
        String string = VirtualFileManager.constructUrl((String)"file", (String)systemIndependentPath);
        if (string == null) {
            ClangRequestsHelper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static File getMacrosFilePath(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(12);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(13);
        }
        return ClangRequestsHelper.getMacrosFilePath(context.getUrlConverter(), url);
    }

    @NlsSafe
    @NotNull
    public static File getMacrosFilePath(@NotNull ClangUrlConverter converter, @NlsSafe @NotNull String url) {
        if (converter == null) {
            ClangRequestsHelper.$$$reportNull$$$0(14);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(15);
        }
        if (!converter.isAcceptable(url)) {
            return new File(SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/macros/__wrong_url_" : "/clion_clangd_inmemory_directory/macros/__wrong_url_");
        }
        Object path = converter.fromUrl(url);
        if (SystemInfo.isWindows) {
            int driveLetterIndex = ClangUrlConverter.findDriveLetter((String)path);
            if (driveLetterIndex >= 0) {
                char driveLetter = ((String)path).charAt(driveLetterIndex);
                path = driveLetter + ":/clion_clangd_inmemory_directory/macros" + (String)(((String)(path = ((String)path).replaceFirst(":", ""))).startsWith("/") ? path : "/" + (String)path);
                return new File((String)path);
            }
            path = "X:/clion_clangd_inmemory_directory/macros" + (String)(((String)path).startsWith("/") ? path : "/" + (String)path);
            return new File((String)path);
        }
        return new File(MACRO_PREDEFINES_BASE_PATH + (String)(((String)path).startsWith("/") ? path : "/" + (String)path));
    }

    public static String getMacrosParentPath() {
        return (SystemInfo.isWindows ? "C:" : "") + MACRO_PREDEFINES_BASE_PATH;
    }

    public static String getQobjectDefsUrl() {
        return "file://" + ClangRequestsHelper.getQobjectDefsPath();
    }

    public static String getQobjectDefsPath() {
        return ClangRequestsHelper.getMacrosParentPath() + "/QtCore/qobjectdefs.h";
    }

    public static boolean containsQtCore(List<String> compileCommand) {
        for (String arg : compileCommand) {
            if (!arg.startsWith("-I") || !arg.contains("QtCore")) continue;
            return true;
        }
        return false;
    }

    public static String getQobjectDefsContent() {
        return "#include_next <qobjectdefs.h>\n#pragma once\n#pragma clang diagnostic push\n#pragma clang diagnostic ignored \"-Wmacro-redefined\"\n#define __CLION_QT_SIGNAL_ANNOTATION __attribute__((annotate(\"signal_from_qt\")))\n#define __CLION_QT_SLOT_ANNOTATION __attribute__((annotate(\"slot_from_qt\")))\n#ifdef signals\n#define signals public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNALS\n#define Q_SIGNALS public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNAL\n#define Q_SIGNAL __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef slots\n#define slots __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOTS\n#define Q_SLOTS __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOT\n#define Q_SLOT __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef SIGNAL\n#define SIGNAL(arg) qFlagLocation(#arg)\n#endif\n#ifdef SLOT\n#define SLOT(arg) qFlagLocation(#arg)\n#endif\n#pragma clang diagnostic pop\n";
    }

    @NotNull
    public static String getArmSveWorkaroundUrl() {
        String string = VirtualFileManager.constructUrl((String)"file", (String)ClangRequestsHelper.getArmSveWorkaroundPath());
        if (string == null) {
            ClangRequestsHelper.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getArmSveWorkaroundPath() {
        String string = (SystemInfo.isWindows ? "C:" : "") + "/clion_clangd_inmemory_directory/clion_arm_sve_workaround.h";
        if (string == null) {
            ClangRequestsHelper.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean containsArmSveWorkaround(@NotNull List<String> compilationCommand) {
        if (compilationCommand == null) {
            ClangRequestsHelper.$$$reportNull$$$0(18);
        }
        for (String arg : compilationCommand) {
            if (!arg.startsWith("-include") || !arg.contains("clion_arm_sve_workaround.h")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getArmSveWorkaroundContent() {
        return "typedef signed char __clion_int8_t;\ntypedef unsigned char __clion_uint8_t;\ntypedef signed short int __clion_int16_t;\ntypedef unsigned short int __clion_uint16_t;\ntypedef signed int __clion_int32_t;\ntypedef unsigned int __clion_uint32_t;\ntypedef signed long int __clion_int64_t;\ntypedef unsigned long int __clion_uint64_t;\ntypedef float __clion_float16_t;\ntypedef float __clion_float32_t;\ntypedef double __clion_float64_t;\n\ntypedef __clion_int8_t __clion_int8x8_t __attribute__((vector_size(8)));\ntypedef __clion_int16_t __clion_int16x4_t __attribute__((vector_size(8)));\ntypedef __clion_int32_t __clion_int32x2_t __attribute__((vector_size(8)));\ntypedef __clion_int64_t __clion_int64x1_t __attribute__((vector_size(8)));\ntypedef __clion_int8_t __clion_int8x16_t __attribute__((vector_size(16)));\ntypedef __clion_int16_t __clion_int16x8_t __attribute__((vector_size(16)));\ntypedef __clion_int32_t __clion_int32x4_t __attribute__((vector_size(16)));\ntypedef __clion_int64_t __clion_int64x2_t __attribute__((vector_size(16)));\n\ntypedef __clion_uint8_t __clion_uint8x8_t __attribute__((vector_size(8)));\ntypedef __clion_uint16_t __clion_uint16x4_t __attribute__((vector_size(8)));\ntypedef __clion_uint32_t __clion_uint32x2_t __attribute__((vector_size(8)));\ntypedef __clion_uint64_t __clion_uint64x1_t __attribute__((vector_size(8)));\ntypedef __clion_uint8_t __clion_uint8x16_t __attribute__((vector_size(16)));\ntypedef __clion_uint16_t __clion_uint16x8_t __attribute__((vector_size(16)));\ntypedef __clion_uint32_t __clion_uint32x4_t __attribute__((vector_size(16)));\ntypedef __clion_uint64_t __clion_uint64x2_t __attribute__((vector_size(16)));\n\n\ntypedef __clion_float16_t __clion_float16x4_t __attribute__((vector_size(8)));\ntypedef __clion_float32_t __clion_float32x2_t __attribute__((vector_size(8)));\ntypedef __clion_float64_t __clion_float64x1_t __attribute__((vector_size(8)));\ntypedef __clion_float16_t __clion_float16x8_t __attribute__((vector_size(16)));\ntypedef __clion_float32_t __clion_float32x4_t __attribute__((vector_size(16)));\ntypedef __clion_float64_t __clion_float64x2_t __attribute__((vector_size(16)));\n\n\n#define __Int8x8_t __clion_int8x8_t\n#define __Int16x4_t __clion_int16x4_t\n#define __Int32x2_t __clion_int32x2_t\n#define __Int64x1_t __clion_int64x1_t\n#define __Int8x16_t __clion_int8x16_t\n#define __Int16x8_t __clion_int16x8_t\n#define __Int32x4_t __clion_int32x4_t\n#define __Int64x2_t __clion_int64x2_t\n\n#define __Float16x4_t __clion_float16x4_t\n#define __Float32x2_t __clion_float32x2_t\n#define __Float64x1_t __clion_float64x1_t\n#define __Float16x8_t __clion_float16x8_t\n#define __Float32x4_t __clion_float32x4_t\n#define __Float64x2_t __clion_float64x2_t\n\n#define __Uint8x8_t __clion_uint8x8_t\n#define __Uint16x4_t __clion_uint16x4_t\n#define __Uint32x2_t __clion_uint32x2_t\n#define __Uint64x1_t __clion_uint64x1_t\n#define __Uint8x16_t __clion_uint8x16_t\n#define __Uint16x8_t __clion_uint16x8_t\n#define __Uint32x4_t __clion_uint32x4_t\n#define __Uint64x2_t __clion_uint64x2_t\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangRequestsHelper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilationCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangRequestsHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacrosFileUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArmSveWorkaroundUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getArmSveWorkaroundPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMacroFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMacroPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedByGuard";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMacrosFileUrl";
                break;
            }
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMacrosFilePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsArmSveWorkaround";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 16, 17 -> new IllegalStateException(string);
        };
    }
}

