/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangToolsWslService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.WslContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClangdLanguageServiceHolder<T extends ClangLanguageService> {
    @NonNls
    private static final String cpp20ModuleMapPath = SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/cpp20/cpp20module.modulemap" : "/clion_clangd_inmemory_directory/cpp20/cpp20module.modulemap";
    @NonNls
    private static final String moduleMapPath = SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/cpp20/module.modulemap" : "/clion_clangd_inmemory_directory/cpp20/module.modulemap";
    private static final Logger LOG = Logger.getInstance(ClangdLanguageServiceProvider.class);
    @NonNls
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myClangdModulesPath;
    @NotNull
    private final File myCpp20ModulesPath;
    private final ClangLanguageService.Kind myKind;
    @NotNull
    private final Object myServiceLock;
    @Nullable
    private Ref<T> myService;

    ClangdLanguageServiceHolder(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, @NotNull File cpp20ModulesPath, ClangLanguageService.Kind kind) {
        if (descriptor == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(1);
        }
        if (clangdModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(2);
        }
        if (cpp20ModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(3);
        }
        this.myServiceLock = new Object();
        this.myService = null;
        this.myDescriptor = descriptor;
        this.myProject = project;
        this.myClangdModulesPath = clangdModulesPath;
        this.myCpp20ModulesPath = cpp20ModulesPath;
        this.myKind = kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getOrStart() {
        if (this.myKind == ClangLanguageService.Kind.Clangd && !ClangUtils.isClangdAllowed(this.myProject)) {
            return null;
        }
        if (this.myKind == ClangLanguageService.Kind.Indexer && !ClangUtils.isClangdIndexerOn(this.myProject)) {
            return null;
        }
        if (this.myKind == ClangLanguageService.Kind.StatelessIndexer && !ClangUtils.isClangdStatelessIndexerOn(this.myProject)) {
            return null;
        }
        Object object = this.myServiceLock;
        synchronized (object) {
            if (this.myService != null) {
                return (T)((ClangLanguageService)this.myService.get());
            }
            this.myService = Ref.create((Object)((ClangLanguageService)ClangdLanguageServiceHolder.startImpl(this.myDescriptor, this.myProject, this.myClangdModulesPath, this.myCpp20ModulesPath, this.myKind)));
            if (!this.myProject.isDisposed() && this.myService.get() != null) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStarted((ClangLanguageService)this.myService.get());
            }
            return (T)((ClangLanguageService)this.myService.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getIfStarted() {
        Object object = this.myServiceLock;
        synchronized (object) {
            return (T)(this.myService != null ? (ClangLanguageService)this.myService.get() : null);
        }
    }

    @Nullable
    private static <T> T startImpl(@NonNls @NotNull String descriptor, @NotNull Project project, @NotNull File clangdModulesPath, @NotNull File cpp20ModulesPath, @NotNull ClangLanguageService.Kind kind) {
        if (descriptor == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(5);
        }
        if (clangdModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(6);
        }
        if (cpp20ModulesPath == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(7);
        }
        if (kind == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(8);
        }
        ClangDaemonContextImpl context = null;
        try {
            ClangToolsWslService wslService;
            WslContext currentWSL;
            ClangUrlConverter urlConverter = (ClangUrlConverter)project.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            if (urlConverter == null) {
                urlConverter = new ClangUrlConverter();
            }
            if ((currentWSL = (wslService = (ClangToolsWslService)project.getService(ClangToolsWslService.class)).getWslContext()) != null) {
                if (kind.isIndexer()) {
                    return null;
                }
                urlConverter.setWslMsId(currentWSL.getId());
                urlConverter.setWslMntRoot(currentWSL.getMountRoot());
            }
            ClangDaemonContextImpl.Builder builder = new ClangDaemonContextImpl.Builder(descriptor, project).setKind(kind).setUrlConverter(urlConverter).setIdeFacade(ClangdBridge.createClangIdeFacade(descriptor, kind)).setClangdModulesPath(clangdModulesPath.getPath()).setCpp20ModulesPath(cpp20ModulesPath.getPath()).setCpp20ModuleMapPath(cpp20ModuleMapPath).setModuleMapPath(moduleMapPath).setKeepAsts(ClangdBridge.getNumberOfASTsToKeep());
            if (kind == ClangLanguageService.Kind.Clangd) {
                builder.setMessageBus(project.getMessageBus());
            }
            context = builder.create();
            return (T)(kind.isIndexer() ? new ClangdIndexerService(context) : new ClangdLanguageService(context));
        }
        catch (Throwable thr) {
            if (context != null) {
                Disposer.dispose(context);
            }
            throw thr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClangStopData stop() {
        ClangLanguageService currentService;
        Object object = this.myServiceLock;
        synchronized (object) {
            if (this.myService == null || this.myService.get() == null) {
                ClangStopData clangStopData = ClangStopData.EMPTY;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl5 : MonitorExitStatement: MONITOREXIT : var2_1
                if (clangStopData == null) {
                    ClangdLanguageServiceHolder.$$$reportNull$$$0(9);
                }
                return clangStopData;
            }
            currentService = (ClangLanguageService)this.myService.get();
            this.myService = null;
        }
        object = currentService.stop();
        Object object2 = object;
        if (object2 == null) {
            ClangdLanguageServiceHolder.$$$reportNull$$$0(10);
        }
        return object2;
        finally {
            if (!this.myProject.isDisposed()) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(currentService);
            }
        }
    }

    public void forceStop() {
        ClangStopData stopData = this.stop();
        try {
            stopData.exitCode.get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdModulesPath";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpp20ModulesPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceHolder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startImpl";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

