/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.documentation;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.documentation.ClangFlavourDescriptor;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\t\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/documentation/ClangFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "htmlSyntaxHighlighter", "com/jetbrains/cidr/lang/daemon/clang/clangd/documentation/ClangFlavourDescriptor$htmlSyntaxHighlighter$1", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/documentation/ClangFlavourDescriptor$htmlSyntaxHighlighter$1;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "intellij.cidr.clangd"})
final class ClangFlavourDescriptor
extends CommonMarkFlavourDescriptor {
    @NotNull
    private final Project project;
    @NotNull
    private final htmlSyntaxHighlighter.1 htmlSyntaxHighlighter;

    public ClangFlavourDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, false, 3, null);
        this.project = project;
        this.htmlSyntaxHighlighter = new HtmlSyntaxHighlighter(this){
            final /* synthetic */ ClangFlavourDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public HtmlChunk color(String language, String rawContent) {
                Language language2;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
                        language2 = this.findRegisteredLanguage(language);
                        if (language2 == null) break block2;
                        Language language3 = language2;
                        ClangFlavourDescriptor clangFlavourDescriptor = this.this$0;
                        Language it = language3;
                        boolean bl = false;
                        HtmlChunk htmlChunk = HtmlSyntaxHighlighter.Companion.colorHtmlChunk(clangFlavourDescriptor.getProject(), it, rawContent);
                        language2 = htmlChunk;
                        if (htmlChunk != null) break block3;
                    }
                    HtmlChunk htmlChunk = HtmlChunk.text((String)rawContent);
                    language2 = htmlChunk;
                    Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
                }
                return language2;
            }

            private final Language findRegisteredLanguage(String language) {
                Language language2;
                String string = language;
                if (Intrinsics.areEqual((Object)string, (Object)"cpp")) {
                    language2 = LanguageUtils.Companion.getInstance().getConfigLanguage();
                } else if (Intrinsics.areEqual((Object)string, (Object)"objective-cpp")) {
                    language2 = LanguageUtils.Companion.getInstance().getConfigLanguage();
                } else {
                    Object v7;
                    block8: {
                        Collection collection = Language.getRegisteredLanguages();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
                        Iterable $this$singleOrNull$iv = collection;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            String string2;
                            Language registeredLanguage = (Language)element$iv;
                            boolean bl = false;
                            String string3 = registeredLanguage.getID();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getID(...)");
                            String string4 = string3.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                            String string5 = language;
                            if (string5 != null) {
                                String string6 = string5.toLowerCase(Locale.ROOT);
                                string2 = string6;
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                            } else {
                                string2 = null;
                            }
                            if (!Intrinsics.areEqual((Object)string4, (Object)string2)) continue;
                            if (found$iv) {
                                v7 = null;
                                break block8;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v7 = !found$iv ? null : single$iv;
                    }
                    language2 = v7;
                }
                return language2;
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Map parentProviders = MapsKt.toMutableMap((Map)super.createHtmlGeneratingProviders(linkMap, baseURI));
        parentProviders.put(MarkdownElementTypes.CODE_FENCE, new CodeFenceSyntaxHighlighterGeneratingProvider((HtmlSyntaxHighlighter)this.htmlSyntaxHighlighter));
        return parentProviders;
    }
}

