/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.completion.ClangdLiveTemplate;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdCompletionUtils {
    @NotNull
    public static String getText(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(0);
        }
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document.getImmutableCharSequence();
            String string = chars.subSequence(Math.min(chars.length(), startOffset), Math.min(chars.length(), endOffset)).toString();
            if (string == null) {
                ClangdCompletionUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String getText(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(2);
        }
        return ClangdCompletionUtils.getText(editor.getDocument(), startOffset, endOffset);
    }

    public static boolean hasMatchingSpaceAfterInsertion(@NotNull Document document, int endOffset) {
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(3);
        }
        return endOffset < document.getTextLength() && ClangdCompletionUtils.getText(document, endOffset, endOffset + 1).equals(" ");
    }

    public static boolean adjustCompletionInLiveTemplateIfNeeded(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull String insertion, int endOffset) {
        Template currentTemplate;
        if (project == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(6);
        }
        if (insertion == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(7);
        }
        if ((currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor)) != null && insertion.endsWith(" ")) {
            document.replaceString(endOffset - 1, endOffset, (CharSequence)"");
            return true;
        }
        return false;
    }

    public static boolean isLiveTemplateNameSegmentCompletion(@NotNull Project project, @NotNull Editor editor) {
        Template currentTemplate;
        if (project == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(9);
        }
        if ((currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor)) == null) {
            return false;
        }
        @Nullable TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return false;
        }
        if (templateState.getCurrentVariableNumber() < 0 || currentTemplate.getSegmentsCount() <= templateState.getCurrentVariableNumber()) {
            return false;
        }
        return currentTemplate.getSegmentName(templateState.getCurrentVariableNumber()).equals("name") && currentTemplate instanceof ClangdLiveTemplate && ((ClangdLiveTemplate)currentTemplate).getDontCompleteName();
    }

    public static void reformatTextIfNotInjected(@NotNull PsiFile source, int offset, int endOffset) {
        Project project;
        if (source == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(10);
        }
        if (!InjectedLanguageManager.getInstance((Project)(project = source.getProject())).isInjectedFragment(source)) {
            PostprocessReformattingAspect.getInstance((Project)project).assertDocumentChangeIsAllowed(source.getViewProvider());
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)source, offset, endOffset, true);
        }
    }

    @Nullable
    public static String indentLineIfNotInjected(@NotNull PsiFile source, int offset) {
        Project project;
        if (source == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(11);
        }
        if (!InjectedLanguageManager.getInstance((Project)(project = source.getProject())).isInjectedFragment(source)) {
            PostprocessReformattingAspect.getInstance((Project)project).assertDocumentChangeIsAllowed(source.getViewProvider());
            return CodeStyleManager.getInstance((Project)project).getLineIndent(source, offset);
        }
        return null;
    }

    public static void reformatCompletion(@NotNull InsertionContext context, int startOffset, int endOffset, int caretOffset) {
        if (context == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(12);
        }
        Document document = context.getDocument();
        Project project = context.getProject();
        @NotNull Editor editor = context.getEditor();
        if (editor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        RangeMarker cursorMarker = document.createRangeMarker(caretOffset, caretOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            int _cursorOffset = cursorMarker.getStartOffset();
            cursorMarker.dispose();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            if (ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile)) {
                ExternalFormatProcessor.formatRangeInFile((PsiFile)psiFile, (TextRange)new TextRange(_startOffset, _endOffset), (boolean)true, (boolean)true, (boolean)false, (int)_cursorOffset);
                return;
            }
            int cursorLine = document.getLineNumber(_cursorOffset);
            String cursorLineText = document.getText(DocumentUtil.getLineTextRange((Document)document, (int)cursorLine));
            if (cursorLineText.trim().isEmpty()) {
                int endLine;
                int startLine = document.getLineNumber(_startOffset);
                for (int line = endLine = document.getLineNumber(_endOffset); line >= startLine; --line) {
                    if (line == cursorLine) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, document.getLineStartOffset(line));
                        editor.getCaretModel().moveToOffset(document.getLineEndOffset(line));
                        continue;
                    }
                    ClangdCompletionUtils.reformatTextIfNotInjected(psiFile, document.getLineStartOffset(line), document.getLineEndOffset(line));
                }
                return;
            }
            ClangdCompletionUtils.reformatTextIfNotInjected(psiFile, _startOffset, _endOffset);
        })));
    }

    public static void reindentCompletion(@NotNull InsertionContext context, int startOffset, int endOffset) {
        if (context == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(13);
        }
        Document document = context.getDocument();
        Project project = context.getProject();
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            int startLine = document.getLineNumber(_startOffset);
            int endLine = document.getLineNumber(_endOffset);
            for (int line = startLine; line <= endLine; ++line) {
                String indent;
                int startOfLineOffset = document.getLineStartOffset(line);
                String string = indent = ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile) ? ExternalFormatProcessor.indentLine((PsiFile)psiFile, (int)startOfLineOffset) : ClangdCompletionUtils.indentLineIfNotInjected(psiFile, startOfLineOffset);
                if (indent == null) continue;
                int startOfTextInLine = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)startOfLineOffset, (String)" \t");
                document.replaceString(startOfLineOffset, startOfTextInLine, (CharSequence)indent);
            }
        })));
    }

    public static String trimKeywordLookup(@NotNull String lookupString) {
        if (lookupString == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(14);
        }
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.trimStart((String)StringUtil.trimStart((String)lookupString.trim(), (String)"@"), (String)"~"), (String)"#"), (String)";"), (String)"}").trim(), (String)"{").trim();
    }

    @Nullable
    public static Caret getCompletionCaret(@NotNull InsertionContext context, int prefixLength) {
        List allCarets;
        if (context == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(15);
        }
        if ((allCarets = context.getEditor().getCaretModel().getAllCarets()).size() == 1) {
            return (Caret)allCarets.get(0);
        }
        for (Caret caret : allCarets) {
            if (caret.getOffset() != context.getStartOffset() + prefixLength) continue;
            return caret;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/completion/ClangdCompletionUtils";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertion";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/completion/ClangdCompletionUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingSpaceAfterInsertion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustCompletionInLiveTemplateIfNeeded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isLiveTemplateNameSegmentCompletion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextIfNotInjected";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indentLineIfNotInjected";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reformatCompletion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reindentCompletion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trimKeywordLookup";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

