/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PostValidator {
    public static void validate(@NotNull XmlDocument xmlDocument, @NotNull MergingReport.Builder mergingReport) {
        Preconditions.checkNotNull((Object)xmlDocument);
        Preconditions.checkNotNull((Object)mergingReport);
        PostValidator.enforceAndroidNamespaceDeclaration(xmlDocument);
        PostValidator.reOrderElements(xmlDocument.getRootNode());
        PostValidator.validate(xmlDocument.getRootNode(), mergingReport.getActionRecorder().build(), mergingReport);
        PostValidator.checkOnlyOneUsesSdk(xmlDocument, mergingReport);
    }

    private static void enforceAndroidNamespaceDeclaration(@NotNull XmlDocument xmlDocument) {
        xmlDocument.getRootNode().enforceNamespaceDeclaration("http://schemas.android.com/apk/res/android", "android");
    }

    protected static void enforceToolsNamespaceDeclaration(@NotNull XmlDocument xmlDocument) {
        Element rootElement = xmlDocument.getRootNode().getXml();
        if ("tools".equals(XmlUtils.lookupNamespacePrefix((Node)rootElement, (String)"http://schemas.android.com/tools", null, (boolean)false))) {
            return;
        }
        if (xmlDocument.getRootNode().elementUsesNamespacePrefix("tools")) {
            XmlUtils.lookupNamespacePrefix((Node)rootElement, (String)"http://schemas.android.com/tools", (String)"tools", (boolean)true);
        }
    }

    private static void reOrderElements(@NotNull XmlElement xmlElement) {
        PostValidator.reOrderActivityAlias(xmlElement);
        PostValidator.reOrderApplication(xmlElement);
        PostValidator.reOrderUsesSdk(xmlElement);
    }

    private static void reOrderActivityAlias(@NotNull XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement applicationElement = element.get();
        ImmutableList<XmlElement> activityAliasElements = applicationElement.getAllNodesByType(ManifestModel.NodeTypes.ACTIVITY_ALIAS);
        for (XmlElement activityAlias : activityAliasElements) {
            String targetActivity;
            Optional<XmlAttribute> attribute = activityAlias.getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "targetActivity"));
            if (!attribute.isPresent() || !(element = applicationElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.ACTIVITY, targetActivity = attribute.get().getValue())).isPresent()) continue;
            XmlElement activity = element.get();
            Node nextSibling = activity.getXml().getNextSibling();
            List<Node> comments = XmlElement.getLeadingComments(activityAlias.getXml());
            if (!comments.isEmpty() && !comments.get(0).equals(nextSibling)) {
                for (Node comment : comments) {
                    applicationElement.removeChild(comment);
                    applicationElement.insertBefore(comment, nextSibling);
                }
            }
            if (activityAlias.getXml().equals(nextSibling) || !comments.isEmpty() && comments.get(0).equals(nextSibling)) continue;
            applicationElement.removeChild(activityAlias);
            applicationElement.insertBefore(activityAlias, nextSibling);
        }
    }

    private static void reOrderApplication(@NotNull XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement applicationElement = element.get();
        List<Node> comments = XmlElement.getLeadingComments(applicationElement.getXml());
        for (Node comment : comments) {
            xmlElement.removeChild(comment);
            xmlElement.appendChild(comment);
        }
        xmlElement.removeChild(applicationElement);
        xmlElement.appendChild(applicationElement);
    }

    private static void reOrderUsesSdk(@NotNull XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement usesSdk = element.get();
        Node firstChild = xmlElement.getXml().getFirstChild();
        if (firstChild == usesSdk.getXml()) {
            return;
        }
        List<Node> comments = XmlElement.getLeadingComments(usesSdk.getXml());
        for (Node comment : comments) {
            xmlElement.removeChild(comment);
            xmlElement.insertBefore(comment, firstChild);
        }
        xmlElement.removeChild(usesSdk);
        xmlElement.insertBefore(usesSdk, firstChild);
    }

    private static void validate(@NotNull XmlElement xmlElement, @NotNull Actions actions, @NotNull MergingReport.Builder mergingReport) {
        NodeOperationType operationType = xmlElement.getOperationType();
        boolean ignoreWarning = PostValidator.checkIgnoreWarning(xmlElement);
        switch (operationType) {
            case REPLACE: {
                if (ignoreWarning || PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to replace another declaration but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                if (ignoreWarning || PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to remove other declarations but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
            }
        }
        PostValidator.validateAttributes(xmlElement, actions, mergingReport, ignoreWarning);
        PostValidator.validateAndroidAttributes(xmlElement, mergingReport);
        for (XmlElement child : xmlElement.getMergeableElements()) {
            PostValidator.validate(child, actions, mergingReport);
        }
    }

    private static void validateAttributes(@NotNull XmlElement xmlElement, @NotNull Actions actions, @NotNull MergingReport.Builder mergingReport, boolean ignoreWarning) {
        @NotNull Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> attributeOperations = xmlElement.getAttributeOperations();
        for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation : attributeOperations) {
            switch (attributeOperation.getValue()) {
                case REMOVE: {
                    if (ignoreWarning || PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to remove other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                    break;
                }
                case REPLACE: {
                    if (ignoreWarning || PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to replace other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                }
            }
        }
    }

    private static boolean isNodeOperationPresent(@NotNull XmlElement xmlElement, @NotNull Actions actions, Actions.ActionType action) {
        for (Actions.NodeRecord nodeRecord : actions.getNodeRecords(xmlElement.getId())) {
            if (nodeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttributeOperationPresent(@NotNull XmlElement xmlElement, @NotNull Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation, @NotNull Actions actions, Actions.ActionType action) {
        for (Actions.AttributeRecord attributeRecord : actions.getAttributeRecords(xmlElement.getId(), attributeOperation.getKey())) {
            if (attributeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static void validateAndroidAttributes(@NotNull XmlElement xmlElement, @NotNull MergingReport.Builder mergingReport) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            AttributeModel.Validator onWriteValidator;
            if (xmlAttribute.getModel() == null || (onWriteValidator = xmlAttribute.getModel().getOnWriteValidator()) == null) continue;
            onWriteValidator.validates(mergingReport, xmlAttribute, xmlAttribute.getValue());
        }
    }

    @VisibleForTesting
    static boolean checkIgnoreWarning(@NotNull XmlElement xmlElement) {
        @NotNull Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> attributeOperations = xmlElement.getAttributeOperations();
        for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation : attributeOperations) {
            if (attributeOperation.getValue() != AttributeOperationType.IGNORE_WARNING) continue;
            return attributeOperation.getKey().toString().equals("tools:true");
        }
        return false;
    }

    private static void checkOnlyOneUsesSdk(@NotNull XmlDocument manifest, @NotNull MergingReport.Builder mergingReport) {
        XmlElement root = manifest.getRootNode();
        Preconditions.checkNotNull((Object)root);
        Actions actions = mergingReport.build().getActions();
        ImmutableList<XmlElement> list = root.getAllNodesByType(ManifestModel.NodeTypes.USES_SDK);
        Map duplicates = list.stream().collect(Collectors.groupingBy(OrphanXmlElement::getId, Collectors.toList())).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).flatMap(entry -> ((List)entry.getValue()).stream().map(element -> Map.entry((XmlNode.NodeKey)entry.getKey(), PostValidator.getElementLocation(element, actions)))).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(entry -> ((XmlNode.NodeKey)entry.getKey()).toString(), Collectors.toSet())));
        if (!duplicates.isEmpty()) {
            mergingReport.addMessage(manifest.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Multiple <uses-sdk>s cannot be present in the merged AndroidManifest.xml. Found duplicates in these manifest files:\n    %1$s", duplicates.entrySet().stream().map(entry -> String.format("%1$s(%2$s)", entry.getKey(), entry.getValue())).collect(Collectors.joining(System.lineSeparator() + "    "))));
            mergingReport.build();
        }
    }

    private static String getElementLocation(XmlElement xmlElement, Actions actions) {
        if (xmlElement.getFeatureFlagAttribute() == null) {
            Actions.NodeRecord nodeRecord = actions.findNodeRecord(xmlElement.getId());
            return nodeRecord != null ? nodeRecord.mActionLocation.getFile().print(true) : "";
        }
        Actions.AttributeRecord attributeRecord = actions.findAttributeRecord(xmlElement.getId(), xmlElement.getFeatureFlagAttribute().getName());
        return attributeRecord != null ? attributeRecord.mActionLocation.getFile().print(true) : "";
    }
}

