/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class MergingReport {
    @NotNull
    private final Map<MergedManifestKind, String> mergedDocuments;
    @NotNull
    private final Map<MergedManifestKind, XmlDocument> mergedXmlDocuments;
    @NotNull
    private final Result result;
    @NotNull
    private final ImmutableList<Record> records;
    @NotNull
    private final ImmutableList<String> intermediaryStages;
    @NotNull
    private final Actions actions;
    @NotNull
    private final boolean isAaptSafeManifestUnchanged;

    private MergingReport(@NotNull Map<MergedManifestKind, String> mergedDocuments, @NotNull Map<MergedManifestKind, XmlDocument> mergedXmlDocuments, @NotNull Result result, @NotNull ImmutableList<Record> records, @NotNull ImmutableList<String> intermediaryStages, @NotNull Actions actions, @NotNull boolean isAaptSafeManifestUnchanged) {
        this.mergedDocuments = mergedDocuments;
        this.mergedXmlDocuments = mergedXmlDocuments;
        this.result = result;
        this.records = records;
        this.intermediaryStages = intermediaryStages;
        this.actions = actions;
        this.isAaptSafeManifestUnchanged = isAaptSafeManifestUnchanged;
    }

    public void log(@NotNull ILogger logger) {
        block5: for (Record record : this.records) {
            switch (record.mSeverity.ordinal()) {
                case 0: {
                    logger.warning(record.toString(), new Object[0]);
                    continue block5;
                }
                case 1: {
                    logger.error(null, record.toString(), new Object[0]);
                    continue block5;
                }
                case 2: {
                    logger.verbose(record.toString(), new Object[0]);
                    continue block5;
                }
            }
            logger.error(null, "Unhandled record type " + String.valueOf((Object)record.mSeverity), new Object[0]);
        }
        this.actions.log(logger);
        if (!this.result.isSuccess()) {
            logger.warning("\nSee https://developer.android.com/r/studio-ui/build/manifest-merger for more information about the manifest merger.\n", new Object[0]);
        }
    }

    @Nullable
    public String getMergedDocument(@NotNull MergedManifestKind state) {
        return this.mergedDocuments.get((Object)state);
    }

    public boolean isAaptSafeManifestUnchanged() {
        return this.isAaptSafeManifestUnchanged;
    }

    @Nullable
    public XmlDocument getMergedXmlDocument(@NotNull MergedManifestKind state) {
        return this.mergedXmlDocuments.get((Object)state);
    }

    @NotNull
    public ImmutableList<String> getIntermediaryStages() {
        return this.intermediaryStages;
    }

    @NotNull
    public Result getResult() {
        return this.result;
    }

    @NotNull
    public ImmutableList<Record> getLoggingRecords() {
        return this.records;
    }

    @NotNull
    public Actions getActions() {
        return this.actions;
    }

    @NotNull
    public String getReportString() {
        switch (this.result.ordinal()) {
            case 0: {
                return "Manifest merger executed successfully";
            }
            case 1: {
                return this.records.size() > 1 ? "Manifest merger exited with warnings, see logs" : "Manifest merger warning : " + ((Record)this.records.get((int)0)).mLog;
            }
            case 2: {
                return this.records.size() > 1 ? "Manifest merger failed with multiple errors, see logs" : "Manifest merger failed : " + ((Record)this.records.get((int)0)).mLog;
            }
        }
        return "Manifest merger returned an invalid result " + String.valueOf((Object)this.result);
    }

    public static enum Result {
        SUCCESS,
        WARNING,
        ERROR;


        public boolean isSuccess() {
            return this == SUCCESS || this == WARNING;
        }

        public boolean isWarning() {
            return this == WARNING;
        }

        public boolean isError() {
            return this == ERROR;
        }
    }

    public static final class Record {
        @NotNull
        private final Severity mSeverity;
        @NotNull
        private final String mLog;
        @NotNull
        private final SourceFilePosition mSourceLocation;

        private Record(@NotNull SourceFilePosition sourceLocation, @NotNull Severity severity, @NotNull String mLog) {
            this.mSourceLocation = sourceLocation;
            this.mSeverity = severity;
            this.mLog = mLog;
        }

        @NotNull
        public Severity getSeverity() {
            return this.mSeverity;
        }

        @NotNull
        public String getMessage() {
            return this.mLog;
        }

        @NotNull
        public SourceFilePosition getSourceLocation() {
            return this.mSourceLocation;
        }

        @NotNull
        public String toString() {
            return this.mSourceLocation.toString() + " " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.mSeverity.toString()) + ":\n\t" + this.mLog;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Record)) {
                return false;
            }
            Record that = (Record)obj;
            return Objects.equals((Object)that.mSeverity, (Object)this.mSeverity) && Objects.equals(that.mSourceLocation, this.mSourceLocation) && Objects.equals(that.mLog, this.mLog);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mSeverity, this.mSourceLocation, this.mLog});
        }

        public static enum Severity {
            WARNING,
            ERROR,
            INFO;

        }
    }

    public static class Builder {
        private Map<MergedManifestKind, String> mergedDocuments = new EnumMap<MergedManifestKind, String>(MergedManifestKind.class);
        private Map<MergedManifestKind, XmlDocument> mergedXmlDocuments = new EnumMap<MergedManifestKind, XmlDocument>(MergedManifestKind.class);
        @NotNull
        private ImmutableSet.Builder<Record> mRecordBuilder = new ImmutableSet.Builder();
        @NotNull
        private ImmutableList.Builder<String> mIntermediaryStages = new ImmutableList.Builder();
        private boolean mHasWarnings = false;
        private boolean mHasErrors = false;
        @NotNull
        private ActionRecorder mActionRecorder = new ActionRecorder();
        @NotNull
        private final ILogger mLogger;
        private boolean isAaptSafeManifestUnchanged = false;

        Builder(@NotNull ILogger logger) {
            this.mLogger = logger;
        }

        Builder setMergedDocument(@NotNull MergedManifestKind mergedManifestKind, @NotNull String mergedDocument) {
            this.mergedDocuments.put(mergedManifestKind, mergedDocument);
            return this;
        }

        Builder setAaptSafeManifestUnchanged(boolean aaptSafeManifestUnchanged) {
            this.isAaptSafeManifestUnchanged = aaptSafeManifestUnchanged;
            return this;
        }

        Builder setMergedXmlDocument(@NotNull XmlDocument mergedDocument) {
            this.mergedXmlDocuments.put(MergedManifestKind.MERGED, mergedDocument);
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder addMessage(@NotNull SourceFile sourceFile, int line, int column, @NotNull Record.Severity severity, @NotNull String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, new SourcePosition(line - 1, column - 1, -1)), severity, message);
        }

        @NotNull
        Builder addMessage(@NotNull SourceFile sourceFile, @NotNull Record.Severity severity, @NotNull String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, SourcePosition.UNKNOWN), severity, message);
        }

        void addMessage(@NotNull XmlElement element, @NotNull Record.Severity severity, @NotNull String message) {
            this.addMessage(element.getSourceFilePosition(), severity, message);
        }

        @NotNull
        Builder addMessage(@NotNull XmlAttribute attribute, @NotNull Record.Severity severity, @NotNull String message) {
            return this.addMessage(attribute, attribute.getPosition(), severity, message);
        }

        @NotNull
        Builder addMessage(@NotNull XmlAttribute attribute, @NotNull SourcePosition position, @NotNull Record.Severity severity, @NotNull String message) {
            return this.addMessage(new SourceFilePosition(attribute.getOwnerElement().getDocument().getSourceFile(), position), severity, message);
        }

        @NotNull
        Builder addMessage(@NotNull SourceFilePosition sourceFilePosition, @NotNull Record.Severity severity, @NotNull String message) {
            switch (severity.ordinal()) {
                case 1: {
                    this.mHasErrors = true;
                    break;
                }
                case 0: {
                    this.mHasWarnings = true;
                }
            }
            this.mRecordBuilder.add((Object)new Record(sourceFilePosition, severity, message));
            return this;
        }

        @NotNull
        Builder addMergingStage(@NotNull String xml) {
            this.mIntermediaryStages.add((Object)xml);
            return this;
        }

        boolean hasErrors() {
            return this.mHasErrors;
        }

        @NotNull
        ActionRecorder getActionRecorder() {
            return this.mActionRecorder;
        }

        @NotNull
        MergingReport build() {
            Result result = this.mHasErrors ? Result.ERROR : (this.mHasWarnings ? Result.WARNING : Result.SUCCESS);
            return new MergingReport(this.mergedDocuments, this.mergedXmlDocuments, result, (ImmutableList<Record>)ImmutableList.copyOf((Collection)this.mRecordBuilder.build()), (ImmutableList<String>)this.mIntermediaryStages.build(), this.mActionRecorder.build(), this.isAaptSafeManifestUnchanged);
        }

        @NotNull
        public ILogger getLogger() {
            return this.mLogger;
        }

        public String blame(XmlDocument document) throws ParserConfigurationException, SAXException, IOException {
            return this.mActionRecorder.build().blame(document);
        }
    }

    public static enum MergedManifestKind {
        AAPT_SAFE,
        BLAME,
        MERGED;

    }
}

