/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.grpc.inprocess;

import com.android.tools.idea.io.grpc.InternalChannelz;
import com.android.tools.idea.io.grpc.InternalInstrumented;
import com.android.tools.idea.io.grpc.ServerStreamTracer;
import com.android.tools.idea.io.grpc.inprocess.AnonymousInProcessSocketAddress;
import com.android.tools.idea.io.grpc.inprocess.InProcessServerBuilder;
import com.android.tools.idea.io.grpc.inprocess.InProcessSocketAddress;
import com.android.tools.idea.io.grpc.inprocess.InProcessTransport;
import com.android.tools.idea.io.grpc.internal.InternalServer;
import com.android.tools.idea.io.grpc.internal.ObjectPool;
import com.android.tools.idea.io.grpc.internal.ServerListener;
import com.android.tools.idea.io.grpc.internal.ServerTransportListener;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InProcessServer
implements InternalServer {
    private static final ConcurrentMap<String, InProcessServer> registry = new ConcurrentHashMap<String, InProcessServer>();
    private final SocketAddress listenAddress;
    private final int maxInboundMetadataSize;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private ServerListener listener;
    private boolean shutdown;
    private final ObjectPool<ScheduledExecutorService> schedulerPool;
    private ScheduledExecutorService scheduler;

    static InProcessServer findServer(SocketAddress addr) {
        if (addr instanceof AnonymousInProcessSocketAddress) {
            return ((AnonymousInProcessSocketAddress)addr).getServer();
        }
        if (addr instanceof InProcessSocketAddress) {
            return (InProcessServer)registry.get(((InProcessSocketAddress)addr).getName());
        }
        return null;
    }

    InProcessServer(InProcessServerBuilder builder, List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.listenAddress = builder.listenAddress;
        this.schedulerPool = builder.schedulerPool;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.streamTracerFactories = Collections.unmodifiableList((List)Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories"));
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        this.scheduler = this.schedulerPool.getObject();
        this.registerInstance();
    }

    private void registerInstance() throws IOException {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).setServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (registry.putIfAbsent(name, this) != null) {
                throw new IOException("name already registered: " + name);
            }
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public SocketAddress getListenSocketAddress() {
        return this.listenAddress;
    }

    @Override
    public List<? extends SocketAddress> getListenSocketAddresses() {
        return Collections.singletonList(this.getListenSocketAddress());
    }

    @Override
    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return null;
    }

    @Override
    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.unregisterInstance();
        this.scheduler = this.schedulerPool.returnObject(this.scheduler);
        InProcessServer inProcessServer = this;
        synchronized (inProcessServer) {
            this.shutdown = true;
            this.listener.serverShutdown();
        }
    }

    private void unregisterInstance() {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).clearServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (!registry.remove(name, this)) {
                throw new AssertionError();
            }
        } else {
            throw new AssertionError();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listenAddress", (Object)this.listenAddress).toString();
    }

    synchronized ServerTransportListener register(InProcessTransport transport) {
        if (this.shutdown) {
            return null;
        }
        return this.listener.transportCreated(transport);
    }

    ObjectPool<ScheduledExecutorService> getScheduledExecutorServicePool() {
        return this.schedulerPool;
    }

    int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    List<ServerStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }
}

