/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AndroidSyncException;
import com.android.tools.idea.gradle.project.sync.AndroidSyncExceptionType;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/AgpVersionIncompatible;", "Lcom/android/tools/idea/gradle/project/sync/AndroidSyncException;", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "latestSupportedVersion", "<init>", "(Lcom/android/ide/common/repository/AgpVersion;Lcom/android/ide/common/repository/AgpVersion;)V", "Companion", "intellij.android.projectSystem.gradle.sync"})
public final class AgpVersionIncompatible
extends AndroidSyncException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String A = "The project is using an incompatible preview version (AGP ";
    @NotNull
    private static final String B = ") of the Android Gradle plugin. Current compatible ";
    @NotNull
    private static final String PREVIEW = "preview ";
    @NotNull
    private static final String C = "version is AGP";
    @NotNull
    private static final List<String> ALWAYS_PRESENT_STRINGS;

    public AgpVersionIncompatible(@NotNull AgpVersion agpVersion, @NotNull AgpVersion latestSupportedVersion) {
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkNotNullParameter((Object)latestSupportedVersion, (String)"latestSupportedVersion");
        super(AndroidSyncExceptionType.AGP_VERSION_INCOMPATIBLE, AgpVersionIncompatible.Companion.generateMessage(agpVersion, latestSupportedVersion), null, null, null, 28, null);
    }

    static {
        Object[] objectArray = new String[]{A, B, C};
        ALWAYS_PRESENT_STRINGS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/project/sync/AgpVersionIncompatible$Companion;", "", "<init>", "()V", "A", "", "B", "PREVIEW", "C", "generateMessage", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "latestKnown", "pattern", "Ljava/util/regex/Pattern;", "latestSupportedVersion", "ALWAYS_PRESENT_STRINGS", "", "getALWAYS_PRESENT_STRINGS", "()Ljava/util/List;", "intellij.android.projectSystem.gradle.sync"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateMessage(AgpVersion agpVersion, AgpVersion latestKnown) {
            return AgpVersionIncompatible.A + agpVersion + AgpVersionIncompatible.B + (latestKnown.isPreview() ? AgpVersionIncompatible.PREVIEW : "") + C + ' ' + latestKnown + '.';
        }

        @NotNull
        public final Pattern pattern(@NotNull AgpVersion latestSupportedVersion) {
            Intrinsics.checkNotNullParameter((Object)latestSupportedVersion, (String)"latestSupportedVersion");
            Pattern pattern = Pattern.compile(Pattern.quote(AgpVersionIncompatible.A) + "(.+)" + Pattern.quote(AgpVersionIncompatible.B) + (latestSupportedVersion.isPreview() ? Pattern.quote(AgpVersionIncompatible.PREVIEW) : "") + Pattern.quote(C + ' ' + latestSupportedVersion + '.'));
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            return pattern;
        }

        @NotNull
        public final List<String> getALWAYS_PRESENT_STRINGS() {
            return ALWAYS_PRESENT_STRINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

