/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroid/databinding/tool/reflection/RecursionTracker;", "T", "", "errorReporter", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "items", "Ljava/util/ArrayDeque;", "pushIfNew", "", "item", "(Ljava/lang/Object;)Z", "popAndCheck", "(Ljava/lang/Object;)V", "db-compiler"})
public final class RecursionTracker<T> {
    @NotNull
    private final Function1<T, Unit> errorReporter;
    @NotNull
    private final ArrayDeque<T> items;

    public RecursionTracker(@NotNull Function1<? super T, Unit> errorReporter) {
        Intrinsics.checkNotNullParameter(errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
        this.items = new ArrayDeque();
    }

    public final boolean pushIfNew(T item) {
        if (this.items.contains(item)) {
            this.errorReporter.invoke(item);
            return false;
        }
        this.items.push(item);
        return true;
    }

    public final void popAndCheck(T item) throws IllegalStateException {
        T removed = this.items.pop();
        if (!Intrinsics.areEqual(item, removed)) {
            boolean bl = false;
            String string = "inconsistent reference stack. received " + removed + " expected " + item;
            throw new IllegalStateException(string.toString());
        }
    }
}

